<link rel="stylesheet" href="{{ asset('Modules\Gdpr\Resources\assets\css\cookies.min.css') }}">

@if (preference('is_gdpr_enable') == '1')
    @php
        $attributes = ['gdpr_message', 'gdpr_policy_button_text', 'gdpr_confirm_button_text'];
        $gdprText = json_decode(preference('gdpr_text_' . App::getLocale()));
        $gdprTextEn = json_decode(preference('gdpr_text_en'));

        $translatedAttributes = [];
        foreach ($attributes as $attribute) {
            $translatedAttributes[$attribute] = $gdprText->$attribute ?? $gdprTextEn->$attribute;
        }
    @endphp

    <div id="cookieConsentBanner"
        class="js-cookie-consent cookie-consent fixed bottom-0 left-0 w-full px-2 py-4 sm:py-2 bg-white flex flex-col sm:flex-row justify-center items-center gap-5 z-50">
       <div>
            <span> {{ $translatedAttributes['gdpr_message'] }}</span>
            <a href="{{ preference('gdpr_policy_link') ?? '#' }}" class="underline ml-1 font-semibold">
                {{ $translatedAttributes['gdpr_policy_button_text'] }}
            </a>
       </div>
        <button
            class="js-cookie-consent-agree cookie-consent__agree accept-btn border border-transparent px-2 py-2 text-center text-xs mx-2 rounded cursor-pointer">
            {{ $translatedAttributes['gdpr_confirm_button_text'] }}
        </button>
    </div>

    <script>
        const COOKIE_VALUE = 1;
        const COOKIE_DOMAIN = '{{ config('session.domain') ?? request()->getHost() }}';
        const COOKIE_LIFE_TIME = '{{ preference('gdpr_life_time') }}';
        const COOKIE_NAME = 'martvill-cookie-consent';
        const SESSION_SECURE = '{{ config('session.secure') ? ';secure' : null }}'
        const SESSION_SAME_SITE = '{{ config('session.same_site') ? ';samesite=' . config('session.same_site') : null }}'
    </script>
    <script src="{{ asset('Modules/Gdpr/Resources/assets/js/app.min.js') }}"></script>
@endif

@if (preference('is_external_gdpr_enable'))
    {!! preference('gdpr_external_script') !!}
@endif
