<?php

namespace Modules\Tawk\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\Preference;

class TawkController extends Controller
{
    /**
     * Display a listing of the resource.
     * @return Renderable
     */
    public function config(Request $request)
    {
        $data = [
            'list_menu' => 'tawk-config'
        ];

        if ($request->isMethod('post')) {

            (new Preference())->set([
                'is_tawk_enable' => $request->input('is_tawk_enable', 'false'),
                'mainHeaderScript' => $request->input('mainHeaderScript', ''),
            ]);

            \Session::flash('success', __('Tawk.to successfully updated.'));

            return redirect('admin/tawk-config');
        }

        return view('tawk::config', $data);
    }
}
