@extends('admin.layouts.app')
@section('page_title', __('Tawk Setup'))
@section('content')
    <!-- Main content -->
    <div class="col-sm-12" id="tawk-container">
        <div class="card">
            <div class="card-body row">
                <div
                    class="col-lg-3 col-12 z-index-10 ltr:ps-md-3 ltr:pe-0 ltr:ps-0 rtl:pe-md-3 rtl:ps-0 rtl:pe-0">
                    @include('admin.layouts.includes.general_settings_menu')
                </div>
                <div class="col-lg-9 col-12 ltr:ps-0 rtl:pe-0">
                    <div class="card card-info shadow-none mb-0">
                        @if (session('errorMgs'))
                            <div class="alert alert-warning fade in alert-dismissable">
                                <strong>{{ __('Warning') }}!</strong> {{ session('errorMgs') }}. <a class="close"
                                    href="#" data-dismiss="alert" aria-label="close" title="close">×</a>
                            </div>
                        @endif
                        <span id="smtp_head">
                            <div class="card-header p-t-20 border-bottom">
                                <h5>{{ __('Tawk Setup') }}</h5>
                            </div>
                        </span>
                        <div class="card-body p-l-15">
                            <form action="{{ route('tawk.config') }}" method="post" class="form-horizontal">
                                @csrf

                                <div class="form-group row">
                                    <label for="is_tawk_enable"
                                        class="col-sm-3 control-label">{{ __('Enable') }}</label>
                                    <div class="col-9 d-flex">
                                        <div class="mr-3">
                                            <div class="switch switch-bg d-inline m-r-10">
                                                <input type="checkbox" name="is_tawk_enable" class="checkActivity"
                                                    id="is_tawk_enable" value="1"
                                                    {{ preference('is_tawk_enable') == 1 ? 'checked' : '' }}>
                                                <label for="is_tawk_enable" class="cr"></label>
                                            </div>
                                        </div>
                                        <div class="mt-12">
                                            <span>{{ __('Enable/Disable to show or hide Tawk.to on site') }}</span>
                                        </div>
                                    </div>
                                </div>
                                <div class="clearfix"></div>

                                <div class="form-group row">
                                    <label for="mainHeaderScript" class="col-sm-3 control-label">{{ __('Widget Code') }}</label>
                                    <div class="col-9 d-flex">
                                        <div class="col-sm-10 editor">
                                            <textarea class="form-control" name="mainHeaderScript" id="mainHeaderScript" cols="30" rows="10">
                                                {{ preference('mainHeaderScript', '') }}
                                            </textarea>
                                            <small id="mainHeaderScript" class="form-text text-muted">
                                                {{ __('Where you find tawk to widget code?') }} 
                                                <a href="https://help.tawk.to/article/adding-a-widget-to-your-website" target="_blank">{{ __('Click here') }}
                                                </a>
                                            </small>
                                        </div>
                                    </div>
                                </div>
                                <div class="clearfix"></div>

                                <div class="card-footer p-0">
                                    <div class="form-group row">
                                        <label for="btn_save" class="col-sm-3 control-label"></label>
                                        <div class="col-sm-12">
                                            <button type="submit" class="btn form-submit custom-btn-submit ltr:float-right rtl:float-left"
                                                id="footer-btn">
                                                {{ __('Save') }}
                                            </button>
                                        </div>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="{{ asset('public/dist/js/custom/validation.min.js') }}"></script>
    <script src="{{ asset('public/dist/js/custom/settings.min.js') }}"></script>
@endsection
