<?php

namespace Modules\SalesCount\Http\Controllers\Product;

use App\Http\Controllers\Controller;
use App\Models\ProductMeta;
use Illuminate\Http\Request;

class SalesCountController extends Controller
{
    /**
     * Store sales count
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function store(Request $request)
    {
        $this->storeProductMeta('is_automate_sales_count', $request->product_id, $request->is_automate);
        
        if (!$request->is_automate) {
            $this->storeProductMeta('manual_sales_count', $request->product_id, $request->sales_count);
        }
        
        return response()->json([
            'status' => 1,
            'message' => __('Product sales count save successfully')
        ]);
    }
    
    /**
     * Store product meta
     */
    private function storeProductMeta(string $key, int $productId, string $value): void
    {
        ProductMeta::updateOrInsert([
            'product_id' => $productId,
            'key' => $key
        ], [
            'product_id' => $productId,
            'key' => $key,
            'value' => $value,
            'type' => 'string',
        ]);
    }
}
