<?php

namespace Modules\SalesCount\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\SalesCount\Entities\SalesCountSetting;

class SettingController extends Controller
{
    /**
     * Store sales count setting
     *
     * @param Request $request
     * @return \Illuminate\Http\RedirectResponse
     */
    public function storeSetting(Request $request)
    {
        SalesCountSetting::upsert([
            ['key' => 'has_seller_permission', 'value' => $request->has_seller_permission],
            ['key' => 'label_title', 'value' => $request->label_title],
            ['key' => 'label_font_size', 'value' => $request->label_font_size],
            ['key' => 'label_text_color', 'value' => $request->label_text_color],
            ['key' => 'label_bg_color', 'value' => $request->label_bg_color],
            ['key' => 'unit_title', 'value' => $request->unit_title],
            ['key' => 'unit_font_size', 'value' => $request->unit_font_size],
            ['key' => 'unit_text_color', 'value' => $request->unit_text_color]
        ], ['key']);
        
        SalesCountSetting::forgetCache();
        
        $this->setSessionValue(['status' => 'success', 'message' => __('Sales count setting saved successfully.')]);
        return back();
    }
    
    /**
     * Edit Setting
     */
    public function editSetting()
    {
        $data['list_menu']    = 'sales_count';
        return view('salescount::admin.setting.form', $data);
    }
}
