"use strict";

const blockElement = (element, _data = {}) => {
    let options = Object.assign(
        {},
        {
            message: `<div class="spinner-border text-warning" role="status"><span class="sr-only">Loading...</span></div>`,
            css: {
                backgroundColor: "transparent",
                border: "none",
            },
        },
        _data
    );
    element.block(options);
};

const unblockEverything = () => {
    $(".blockUI").each(function () {
        $(this).parent().unblock();
    });
};

const triggerNotification = (className, msg) => {
    $(".notification-msg-bar").find(".notification-msg").html(msg);
    $(".notification-msg-bar").removeClass("smoothly-hide");
    setTimeout(() => {
        $(".notification-msg-bar").addClass("smoothly-hide"),
            $(".notification-msg-bar").find(".notification-msg").html("");
    }, 3000);
};

const successNotification = (msg) => {
    triggerNotification("alert-success", msg);
};

const failedNotification = (msg) => {
    triggerNotification("alert-danger", msg);
};

$(function() {
    $('#switch_sales_count').on('change', function() {
        if ($(this).is(':checked')) {
            $('.automate-sales-count ').removeClass('d-none');
            $('.manual-sales-count ').addClass('d-none');
        } else {
            $('.automate-sales-count ').addClass('d-none');
            $('.manual-sales-count ').removeClass('d-none');
        }
    })
    
    $('.save-sales-count-info').on('click', function() {
        const isAutomateSalesCount = $('#switch_sales_count').is(':checked') ? 1 : 0;
        const manualSalesCount = $('#manual_sales_count_input').val();
        const productId = $('#product_id').val();
        
        let block = $(this).closest("#product_sales_count");
        blockElement(block);
        
        $.ajax({
            url: SITE_URL + "/sales-count",
            data: {
                _token: token,
                is_automate: isAutomateSalesCount,
                sales_count: manualSalesCount,
                product_id: productId
            },
            type: "POST",
            success: function (data) {
                console.log(data);
                
                successNotification(jsLang('Sales count save successfully.'));
            },
            error: function (xhr, desc, err) {
                failedNotification(jsLang('Failed to save sales count.'));
            },
            complete: function() {
                unblockEverything();
            }
        });
    })
    
    function preview() {
        const labelTitle = $('#label_title').val();
        const labelFontSize = $('#label_font_size').val();
        const label_text_color = $('#label_text_color').val();
        const label_bg_color = $('#label_bg_color').val();
        
        const unitTitle = $('#unit_title').val();
        const unitFontSize = $('#unit_font_size').val();
        const unit_text_color = $('#unit_text_color').val();
        
        $('.preview .sales-label').text(labelTitle)
        $('.preview .sales-unit').text('x ' + unitTitle)
        $('.preview .sales-label').css({"font-size":labelFontSize+'px',"color":label_text_color,"background":label_bg_color})
        $('.preview .sales-unit').css({"font-size":unitFontSize+'px',"color":unit_text_color})
    }
    
    if ($('#sales-count-settings-container').length) {
        preview();
    }
    
    $('form.sales-counter').on('change, input', function() {
        preview();
    })
})


