@php
    $isAutomate = true;
    
    if ($productForSelector?->is_automate_sales_count === '0') {
        $isAutomate = false;
    }
@endphp
<div class="card mini-form-holder">
    <div class="order-sec-head cursor-pointer d-flex justify-content-between align-items-center px-3 head-click" href="#product_sales_count"
        aria-expanded="false" data-bs-toggle="collapse">
        <span class="add-title text-lg">{{ __('Product Sales') }}</span>
        <span class="icon-collapse mt-0 toggle-btn">
            <svg width="8" height="6" viewBox="0 0 8 6" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path
                    d="M4.18767 0.0921111L7.81732 4.65639C8.24162 5.18994 7.87956 6 7.21678 6L0.783223 6C0.120445 6 -0.241618 5.18994 0.182683 4.65639L3.81233 0.092111C3.91 -0.0307037 4.09 -0.0307036 4.18767 0.0921111Z"
                    fill="#2C2C2C"></path>
            </svg>
        </span>
    </div>

    <div id="product_sales_count" class="form-group mb-0 collapse show blockable border-top pb-4p">
        <div class="mt-20p mx-3 justify-content-between">
            <div>
                <div class="d-flex justify-content-between align-items-center mt-4px ">
                    <p class="d-flex align-items-center m-0">
                        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="#898989" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                            <path d="M19 10h2v6a1 1 0 0 1-1 1H5a1 1 0 0 1-1-1v-6h2" />
                            <rect x="10" y="14" width="4" height="3" />
                            <path d="M8 7V4a4 4 0 0 1 4-4h4a4 4 0 0 1 4 4v3" />
                        </svg>
                        <span class="ml-2 label-title">
                            {{ __('Automate count') }} <div class="tooltips mt-px cursor-pointer">
                                <svg width="14" height="14" viewBox="0 0 14 14" fill="none"
                                     xmlns="http://www.w3.org/2000/svg">
                                    <path fill-rule="evenodd" clip-rule="evenodd"
                                          d="M12 6C12 9.31371 9.31371 12 6 12C2.68629 12 0 9.31371 0 6C0 2.68629 2.68629 0 6 0C9.31371 0 12 2.68629 12 6ZM6.66667 10C6.66667 10.3682 6.36819 10.6667 6 10.6667C5.63181 10.6667 5.33333 10.3682 5.33333 10C5.33333 9.63181 5.63181 9.33333 6 9.33333C6.36819 9.33333 6.66667 9.63181 6.66667 10ZM6 1.33333C4.52724 1.33333 3.33333 2.52724 3.33333 4H4.66667C4.66667 3.26362 5.26362 2.66667 6 2.66667H6.06287C6.76453 2.66667 7.33333 3.23547 7.33333 3.93713V4.27924C7.33333 4.62178 7.11414 4.92589 6.78918 5.03421C5.91976 5.32402 5.33333 6.13765 5.33333 7.05409V8.66667H6.66667V7.05409C6.66667 6.71155 6.88586 6.40744 7.21082 6.29912C8.08024 6.00932 8.66667 5.19569 8.66667 4.27924V3.93713C8.66667 2.49909 7.50091 1.33333 6.06287 1.33333H6Z"
                                          fill="#898989" />
                                </svg>
                                <span
                                    class="tooltiptexts">{{ __('When automated sales count is enabled, it displays the actual sales count on the product details page. If disabled, set the count manually, and it appears on the frontend product details page.') }}</span>
                            </div>
                        </span>
                    </p>
                    
                    <div class="switch switch-bg mt-4px">
                        <input type="hidden" name="product_sales_count" value="0">
                        <input name="product_sales_count" type="checkbox" id="switch_sales_count" value="1"
                            {{ $isAutomate ? 'checked' : '' }}>
                        <label for="switch_sales_count" class="cr cr-bg mb-0 position-static"></label>
                    </div>
                </div>
                
                <input type="hidden" id="product_id" value="{{ $productForSelector?->id }}">
                <div class="form-group mt-3 automate-sales-count {{ $isAutomate ? '' : 'd-none' }}">
                    <label class="mt-2" for="sales">{{ __('Sales count') }}</label>
                    <input type="text" class="form-control" readonly value="{{ $productForSelector?->total_sales }}">
                </div>
                
                <div class="form-group mt-3 manual-sales-count {{ $isAutomate ? 'd-none' : '' }}">
                    <label class="mt-2" for="sales">{{ __('Sales count') }}</label>
                    <input type="text" class="form-control" id="manual_sales_count_input" value="{{ $productForSelector?->manual_sales_count }}">
                </div>
                
                <div class="d-flex align-items-center b-res t-25-res">
                    <a class="btn-confirms save-sales-count-info">{{ __('Save') }}</a>
                </div>
            </div>
        </div>
        <p class="sp-tag mt-14p mx-3"></p>
    </div>
</div>

<script src="{{ asset('Modules/SalesCount/Resources/assets/js/app.min.js') }}"></script>
