@extends('admin.layouts.app')
@section('page_title', __('Sales Manager'))

@section('css')
    <link rel="stylesheet" href="{{ asset('public/datta-able/plugins/mini-color/css/jquery.minicolors.min.css') }}">
@endsection

@section('content')
    <!-- Main content -->
    <div class="col-sm-12" id="sales-count-settings-container">
        <div class="card">
            <div class="card-body row">
                <div class="col-lg-3 col-12 z-index-10  ltr:ps-md-3 ltr:pe-0 ltr:ps-0 rtl:pe-md-3 rtl:ps-0 rtl:pe-0">
                    @include('admin.layouts.includes.general_settings_menu')
                </div>
                <div class="col-lg-9 col-12 ltr:ps-0 rtl:pe-0">
                    <div class="card card-info shadow-none mb-0">
                        @if (session('errorMgs'))
                            <div class="alert alert-warning fade in alert-dismissable">
                                <strong>{{ __('Warning') }}!</strong> {{ session('errorMgs') }}. <a class="close"
                                    href="#" data-dismiss="alert" aria-label="close" title="close">×</a>
                            </div>
                        @endif
                        <span id="smtp_head">
                            <div class="card-header p-t-20 border-bottom">
                                <h5>{{ __('Sales Manager') }}</h5>
                            </div>
                        </span>
                        <div class="col-sm-12 m-t-20 form-tabs">
                            <div class="row">
                                <div class="col-sm-12">
                                    <form action="{{ route('sales_count.store') }}" method="post" class="sales-counter">
                                        @csrf
                                        <div class="card-body p-0">
                                            <div class="form-group row">
                                                <label class="col-sm-3 control-label text-left"
                                                    for="has_seller_permission">{{ __('Allow Seller to set sales count') }}</label>
                                                <div class="col-sm-6">
                                                    <select name="has_seller_permission" class="form-control select2-hide-search">
                                                        <option value="1"
                                                            {{ salesCountPreference('has_seller_permission') == '1' ? 'selected' : '' }}> 
                                                            {{ __('Yes') }}
                                                        </option>
                                                        <option value="0"
                                                            {{ salesCountPreference('has_seller_permission') == '0' ? 'selected' : '' }}>
                                                            {{ __('No') }}
                                                        </option>
                                                    </select>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group row">
                                                <label class="col-sm-3 control-label text-left"
                                                    for="label_title">{{ __('Label Title') }}</label>
                                                <div class="col-sm-6 flex-wrap">
                                                    <div class="form-group mb-0">
                                                        <input class="form-control" type="text" name="label_title" id="label_title"
                                                            value="{{ salesCountPreference('label_title') }}">
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group row">
                                                <label class="col-sm-3 control-label text-left"
                                                    for="label_font_size">{{ __('Label Font Size') }}</label>
                                                <div class="col-sm-6 flex-wrap">
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <span
                                                                class="input-group-text rounded-0 ltr:rounded-start rtl:rounded-end">{{ __('Px') }}</span>
                                                        </div>
                                                        <input class="form-control" type="number" name="label_font_size" id="label_font_size"
                                                            min="0" max="200"
                                                            value="{{ salesCountPreference('label_font_size') }}"
                                                            data-min="{{ __('The value must be :x than or equal to :y', ['x' => __('greater'), 'y' => 0]) }}"
                                                            data-max="{{ __('The value must be :x than or equal to :y', ['x' => __('less'), 'y' => 200]) }}">
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group row">
                                                <label class="col-sm-3 control-label text-left"
                                                    for="label_text_color">{{ __('Label Text Color') }}</label>
                                                <div class="col-sm-6 flex-wrap">
                                                    <div class="form-group mb-0">
                                                        <input class="form-control demo" data-control="hue" type="text" name="label_text_color" id="label_text_color"
                                                            value="{{ salesCountPreference('label_text_color') }}">
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group row">
                                                <label class="col-sm-3 control-label text-left"
                                                    for="label_bg_color">{{ __('Label Bg Color') }}</label>
                                                <div class="col-sm-6 flex-wrap">
                                                    <div class="form-group mb-0">
                                                        <input class="form-control demo" data-control="hue" type="text" name="label_bg_color" id="label_bg_color"
                                                            value="{{ salesCountPreference('label_bg_color') }}">
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group row">
                                                <label class="col-sm-3 control-label text-left"
                                                    for="unit_title">{{ __('Unit Title') }}</label>
                                                <div class="col-sm-6 flex-wrap">
                                                    <div class="form-group mb-0">
                                                        <input class="form-control" type="text" name="unit_title" id="unit_title"
                                                            value="{{ salesCountPreference('unit_title') }}">
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group row">
                                                <label class="col-sm-3 control-label text-left"
                                                    for="unit_font_size">{{ __('Unit Font Size') }}</label>
                                                <div class="col-sm-6 flex-wrap">
                                                    <div class="input-group">
                                                        <div class="input-group-prepend">
                                                            <span
                                                                class="input-group-text rounded-0 ltr:rounded-start rtl:rounded-end">{{ __('Px') }}</span>
                                                        </div>
                                                        <input class="form-control" type="number" name="unit_font_size" id="unit_font_size"
                                                            min="0" max="200"
                                                            value="{{ salesCountPreference('unit_font_size') }}"
                                                            data-min="{{ __('The value must be :x than or equal to :y', ['x' => __('greater'), 'y' => 0]) }}"
                                                            data-max="{{ __('The value must be :x than or equal to :y', ['x' => __('less'), 'y' => 200]) }}">
                                                    </div>
                                                </div>
                                            </div>
                                            
                                            <div class="form-group row">
                                                <label class="col-sm-3 control-label text-left"
                                                    for="unit_text_color">{{ __('Unit Text Color') }}</label>
                                                <div class="col-sm-6 flex-wrap">
                                                    <div class="form-group mb-0">
                                                        <input class="form-control demo" data-control="hue" type="text" name="unit_text_color" id="unit_text_color"
                                                            value="{{ salesCountPreference('unit_text_color') }}">
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        
                                        <div class="card-footer p-0">
                                            <div class="form-group row">
                                                <label for="btn_save" class="col-sm-3 control-label"></label>
                                                <div class="col-sm-12 d-flex justify-content-between">
                                                    <div class="preview mt-2">
                                                        <div class="roboto-medium leading-4 font-medium ltr:ml-1 rtl:mr-1" id="stock_qtyV"> 
                                                            <span class="leading-4 px-4 py-2 text-sm roboto-medium font-medium rounded ltr:mr-2.5 rtl:ml-2.5 sales-label"></span> 
                                                            <span class="ml-1 sales-unit"></span>
                                                        </div>
                                                    </div>
                                                    <button type="submit" class="btn form-submit custom-btn-submit ltr:float-right rtl:float-left" id="footer-btn">
                                                        {{ __('Save') }}
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    </form>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="{{ asset('Modules/SalesCount/Resources/assets/js/app.min.js') }}"></script>
    <script src="{{ asset('public/datta-able/plugins/mini-color/js/jquery.minicolors.min.js') }}"></script>
    <script src="{{ asset('public/datta-able/js/pages/form-picker-custom.min.js') }}"></script>
@endsection





