<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::group(['prefix' => 'admin', 'middleware' => ['auth', 'locale', 'permission', 'web']], function () {
    Route::namespace('Modules\SalesCount\Http\Controllers\Product')->group(function () {
        Route::post('sales-count', 'SalesCountController@store');
    });
    
    Route::namespace('Modules\SalesCount\Http\Controllers')->group(function () {
        Route::post('sales-count/store', 'SettingController@storeSetting')->name('sales_count.store')->middleware('checkForDemoMode');
        Route::get('sales-count/edit', 'SettingController@editSetting')->name('sales_count.edit');
    });
});

