<?php

use App\Models\Permission;

/**
 * Get the specified option value.
 * If field not found default will return
 *
 * @param string $field
 * @param  mixed   $default
 * @return mixed
 */
function salesCountPreference($field = null, $default = null)
{
    $setting = new Modules\SalesCount\Entities\SalesCountSetting();
    if (is_null($field)) {
        return $setting->getAll()->pluck('value', 'key')->toArray();
    }

    $value = $default;
    $settings = $setting->getAll()->pluck('value', 'key')->toArray();
    
    if (array_key_exists($field, $settings)) {
        $value = $settings[$field];
    }

    return $value;
}

add_action('before_signle_product_summary_add_to_cart', function($data) {
    $product = $data['product'];
    if ($data['type'] == 'Grouped Product' 
        || ($data["type"] == 'External/Affiliate Product' &&
           (is_null($product->is_automate_sales_count) || $product->is_automate_sales_count == '1'))
    ) {
        return;
    }
    
    $sales = $data['total_sales'] ?? 0;
    
    if ($product->is_automate_sales_count == '0') {
        $sales = $product->manual_sales_count ? $product->manual_sales_count : 0;
    }
    
    echo '<div class="mt-22p">
            <div class="roboto-medium leading-4 font-medium ltr:ml-1 rtl:mr-1" id="stock_qtyV"> 
                <span style="background:'. salesCountPreference('label_bg_color') .';color:'. salesCountPreference('label_text_color') .';font-size:'. salesCountPreference('label_font_size') .'px" class="leading-4 px-4 py-2 text-sm roboto-medium font-medium rounded ltr:mr-2.5 rtl:ml-2.5">' . salesCountPreference('label_title') . '</span> 
                <span style="color:'. salesCountPreference('unit_text_color') .';font-size:'. salesCountPreference('unit_font_size') .'px" class="ml-1">' . ($sales ?? 0) . ' ' .  salesCountPreference('unit_title') . '</span>
            </div>
        </div>';
});

add_filter('product_editor_sections', function($data) {
    if ((is_null($data['product']) || $data['product']['type'] == 'Grouped Product')
        || (auth()->user()->role()->type == 'vendor' && salesCountPreference('has_seller_permission') != '1')
    ) {
        return $data;
    }
    
    $data['sections']['sales-count'] = [
        'is_left_side' => true,
        'position' => '90',
        'visibility' => true,
        'content' => 'salescount::admin.product.counter',
    ];
    
    return $data;
});

add_filter('admin_sidebar_configuration_general_settings_menu', function($data) {
    $prms = Permission::getAuthUserPermission(auth()->user()->id);
    
    $data[] = [
        'label' => __('Sales Count'),
        'name' => 'sales_count',
        'href' => route('sales_count.edit'),
        'position' => '50',
        'visibility' => in_array('Modules\SalesCount\Http\Controllers\SettingController@editSetting', $prms),
    ];
    
    return $data;
});





