<?php

namespace Modules\Dummy\Database\Seeders\Modules\CMS\Versions\V2_4_0;

use Illuminate\Database\Seeder;
use Modules\CMS\Entities\ComponentProperty;

class ComponentPropertiesTableSeeder extends Seeder
{
    /**
     * Update language
     *
     * @param  string  $label
     * @param  string  $translatedLabel
     * @return void
     */
    private function updateLanguage($label, $translatedLabel)
    {
        ComponentProperty::where('value', $label)->update(['value' => $translatedLabel]);

    }

    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        $this->updateLanguage('BEST DEALS OF THE WEEK', '{"en":"BEST DEALS OF THE WEEK","bn":"সপ্তাহের সেরা অফার","fr":"MEILLEURES OFFRES DE LA SEMAINE","zh":"本周最佳优惠","ar":"أفضل العروض في الأسبوع","be":"ЛЕПШЫЯ ПРАПАНОВЫ ТЫДНЯ","bg":"НАЙ-ДОБРИТЕ ДЕАЛИ НА СЕДМИЦАТА","ca":"MILLORS OFERTES DE LA SETMANA","et":"NÄDALA PARIMAD PAKKUMISED","nl":"BESTE DEALS VAN DE WEEK"}');
        $this->updateLanguage('Flash Sale', '{"en":"Flash Sale","bn":"ফ্ল্যাশ বিক্রয়","fr":"Vente Flash","zh":"闪购","ar":"بيع مفاجئ","be":"ФЛЭШ-ПРОДАЖ","bg":"Флаш Продажба","ca":"Venda Flash","et":"Flash Sale","nl":"Flashverkoop"}');
        $this->updateLanguage('Best in Electronics', '{"en":"Best in Electronics","bn":"ইলেক্ট্রনিক্সে সেরা","fr":"Meilleur en électronique","zh":"电子产品最佳","ar":"الأفضل في الإلكترونيات","be":"ЛЕПШЫЯ ЭЛЕКТРОНІКА","bg":"НАЙ-ДОБРОТО В ЕЛЕКТРОНИКАТА","ca":"El millor en electrònica","et":"Parim elektroonikas","nl":"Beste in elektronica"}');
        $this->updateLanguage('Gadget Town', ' {"en":"Gadget Town","bn":"গ্যাজেট টাউন","fr":"Ville des gadgets","zh":"小工具城","ar":"بلدة الأجهزة","be":"ГАДЖЭТ ГОРАД","bg":"Град Гаджети","ca":"Poble de gadgets","et":"Tehnikalinn","nl":"Gadgetstad"}');
        $this->updateLanguage('Shop Now', '{"en":"Shop Now","bn":"এখন কেনাকাটা করুন","fr":"Achetez maintenant","zh":"现在购物","ar":"تسوق الآن","be":"КУПІЦЬ ЗАРАЗ","bg":"Пазарувайте сега","ca":"Compreu ara","et":"Osta kohe","nl":"Koop nu"}');
        $this->updateLanguage('Popular Departments', '{"en":"Popular Departments","bn":"জনপ্রিয় বিভাগ","fr":"Départements populaires","zh":"热门部门","ar":"الأقسام الشعبية","be":"ПАПУЛЯРНЫЯ АДДЗЕЛЫ","bg":"Популярни отдели","ca":"Departaments populars","et":"Populaarsed osakonnad","nl":"Populaire afdelingen"}');
        $this->updateLanguage('Furniture ZONE', '{"en":"Furniture ZONE","bn":"ফার্নিচার জোন","fr":"ZONE Meubles","zh":"家具区","ar":"منطقة الأثاث","be":"МЕБЛІ ЗОНА","bg":"Зона Мебели","ca":"Zona de mobles","et":"Mööblitsoon","nl":"Meubelzone"}');
        $this->updateLanguage('TOP BRANDS', '{"en":"TOP BRANDS","bn":"শীর্ষ ব্র্যান্ড","fr":"MARQUES PRINCIPALES","zh":"顶级品牌","ar":"أفضل العلامات التجارية","be":"ЛІДЭРСКІЯ БРЭНДЫ","bg":"ТОП МАРКИ","ca":"MARQUES SUPERIORS","et":"TOP BRÄNDID","nl":"TOPMERKEN"}');
        $this->updateLanguage('All Categories', '{"en":"All Categories","bn":"সমস্ত বিভাগ","fr":"Toutes catégories","zh":"所有类别","ar":"جميع الفئات","be":"Усе катэгорыі","bg":"Всички категории","ca":"Totes les categories","et":"Kõik kategooriad","nl":"Alle categorieën"}');
        $this->updateLanguage('NEW ARRIVALS', '{"en":"NEW ARRIVALS","bn":"নতুন আগমন","fr":"NOUVELLES ARRIVÉES","zh":"新品到货","ar":"وصل حديثاً","be":"НОВЫЯ ПАСТУПЛЕННІ","bg":"НОВИ ПРИСТИГНАЛИ","ca":"NOVES ARREPLEGATS","et":"UUED SAABUMISED","nl":"Nieuwkomers"}');
        $this->updateLanguage('JUST FOR MEN', '{"en":"JUST FOR MEN","bn":"পুরুষদের জন্য","fr":"JUSTE POUR LES HOMMES","zh":"专为男士","ar":"للرجال فقط","be":"ТОЛЬКІ ДЛЯ МУЖЧЫН","bg":"САМО ЗА МЪЖЕТЕ","ca":"NOMÉS PER A HOMES","et":"AINULT MEESTELE","nl":"ALLEEN VOOR MANNEN"}');
        $this->updateLanguage('Latest News', '{"en":"Latest News","bn":"সর্বশেষ সংবাদ","fr":"Dernières nouvelles","zh":"最新消息","ar":"آخر الأخبار","be":"АКТУАЛЬНЫЯ НОВАСЦІ","bg":"ПОСЛЕДНИ НОВИНИ","ca":"ÚLTIMES NOTÍCIES","et":"Viimased uudised","nl":"Laatste nieuws"}');
        $this->updateLanguage('Mid Granny’s Bakery', '{"en":"Mid Granny’s Bakery","bn":"মধ্যবয়স্ক দাদিমা পেষ্টরি","fr":"La boulangerie de Granny","zh":"中间奶奶的烘焙店","ar":"مخبز جدة المتوسط","be":"Сярэдняя пякарня бабулі","bg":"Пекарна с баба-баба","ca":"Forn de la àvia Mitjana","et":"Keskmise vanaema pagaritöökoda","nl":"De bakkerij van Middelgrote Oma"}');
        $this->updateLanguage('EXCLUSIVE PRODUCT', '{"en":"EXCLUSIVE PRODUCT","bn":"এক্সক্লুসিভ পণ্য","fr":"PRODUIT EXCLUSIF","zh":"独家产品","ar":"منتج حصري","be":"ЭКСКЛЮЗІЎНЫ ПРАДУКТ","bg":"ЕКСКЛУЗИВЕН ПРОДУКТ","ca":"PRODUCTE EXCLUSIU","et":"EKSKLUSIIVNE TOODE","nl":"EXCLUSIEF PRODUCT"}');

        $this->updateLanguage('New in town', '{"en":"New in town","bn":"নগরে নতুন","fr":"Nouveau en ville","zh":"城市新宠","ar":"جديد في المدينة","be":"НОВАЕ У ГОРАДЗЕ","bg":"НОВ В ГРАДА","ca":"Nou en la ciutat","et":"Uus linnas","nl":"Nieuw in de stad"}');
        $this->updateLanguage('PURE SEASONAL', '{"en":"PURE SEASONAL","bn":"পুরো মৌসুমি","fr":"PURE SAISONNIER","zh":"纯季节性","ar":"موسمي نقي","be":"ЧЫСТА СЕЗОННАСЦЬ","bg":"ЧИСТ СЕЗОН","ca":"PURA ESTACIONAL","et":"PUHAS HOOAJALINE","nl":"PURE SEIZOEN"}');
        $this->updateLanguage('Top Brands / Seller', '{"en":"Top Brands / Seller","bn":"শীর্ষ ব্র্যান্ড / বিক্রেতা","fr":"Meilleures marques / Vendeur","zh":"顶级品牌/卖家","ar":"أفضل العلامات التجارية / البائع","be":"ЛІДЭРСКІЯ БРЭНДЫ / ПРАДАВЕЦ","bg":"ТОП МАРКИ / ПРОДАВАЧ","ca":"Marques superiors / Venedor","et":"Parimad brändid / Müüja","nl":"Topmerken / Verkoper"}');
        $this->updateLanguage('Latest News', '{"en":"Latest News","bn":"সর্বশেষ সংবাদ","fr":"Dernières nouvelles","zh":"最新消息","ar":"آخر الأخبار","be":"АКТУАЛЬНЫЯ НОВАСЦІ","bg":"ПОСЛЕДНИ НОВИНИ","ca":"Últimes notícies","et":"Viimased uudised","nl":"Laatste nieuws"}');
        $this->updateLanguage('PRODUCTS ON SALE', '{"en":"PRODUCTS ON SALE","bn":"বিক্রয়ের জন্য পণ্য","fr":"PRODUITS EN VENTE","zh":"热卖产品","ar":"منتجات للبيع","be":"ПРАДУКТЫ НА ПРАДАЖУ","bg":"ПРОДУКТИ НА ПРОДАЖБА","ca":"PRODUCTES EN VENDA","et":"MÜÜGIL OLEVAD TOOTED","nl":"PRODUCTEN IN DE UITVERKOOP"}');
        $this->updateLanguage('Subscribe to our Newsletter', '{"en":"Subscribe to our Newsletter","bn":"আমাদের সংবাদপত্রে সাবস্ক্রাইব করুন","fr":"Abonnez-vous à notre newsletter","zh":"订阅我们的通讯","ar":"اشترك في النشرة الإخبارية لدينا","be":"ПАДПІСАЦЦА НА НАШУ НАВІНУ","bg":"АБОНИРАЙТЕ СЕ НА НАШИЯ БЮЛЕТИН","ca":"Subscriu-te al nostre butlletí","et":"Tellige meie uudiskiri","nl":"Abonneer op onze nieuwsbrief"}');

        $message = <<<EOT
Get 10% off on your first purchase and stay updated with latest offers,\r
items, news and much more
EOT;

        $this->updateLanguage($message, '{"en":"Get 10% off on your first purchase and stay updated with latest offers, items, news and much more","bn":"আপনার প্রথম কেনার পরে 10% ছাড় পান এবং সর্বশেষ অফার, আইটেম, সংবাদ এবং অন্যান্য জন্য আপডেট থাকুন","fr":"Obtenez 10% de réduction sur votre premier achat et restez informé des dernières offres, articles, nouvelles et bien plus encore","zh":"在您的第一次购买上享受10%的折扣，并随时了解最新的优惠、商品、新闻等等","ar":"احصل على خصم 10٪ على أول عملية شراء لك وابق على اطلاع على أحدث العروض، العناصر، الأخبار وأكثر من ذلك بكثير","be":"АТРЫМАЙТЕ 10% ЗНІЖКУ ПРЫ ПЕРШЫМ ЗАКУПЕ І АБНАЎЛЯЙЦЕСЯ З АКТУАЛЬНЫМІ ПРАПОЗІЦЫЯМІ, ТОВАРАМІ, НАВІНАМІ І МНОГІМ ІНШЫМ","bg":"ВЗЕМЕТЕ 10% ОТСТЪПКА ПРИ ПЪРВАТА СИ ПОРЪЧКА И ОСТАНЕТЕ АКТУАЛНИ С НАЙ-НОВИТЕ ПРЕДЛОЖЕНИЯ, СТОКИ, НОВИНИ И МНОГО ПОВЕЧЕ","ca":"OBTINGUEU UN 10% DE DESCOMPTE EN EL VOSTRE PRIMER COMPRA I MANTENIU-VOS ACTUALITZAT AMB LES ÚLTIMES OFERTES, ARTICLES, NOTÍCIES I MOLTES MÉS","et":"SAAGE 10% ALLAHINDLUST ESIMESELT OSTULT JA JÄÄGE UUENDATUNA VIIMASTE PAKKUMISTE, TOODETE, UUDISTE JA PALJU MUU KOHTA","nl":"ONTVANG 10% KORTING OP UW EERSTE AANKOOP EN BLIJF OP DE HOOGTE VAN DE LAATSTE AANBIEDINGEN, ARTIKELEN, NIEUWS EN VEEL MEER"}');
        $this->updateLanguage('all Categories', '{"en":"all Categories","bn":"সমস্ত বিভাগ","fr":"toutes catégories","zh":"所有类别","ar":"جميع الفئات","be":"ўсе катэгорыі","bg":"всички категории","ca":"totes les categories","et":"kõik kategooriad","nl":"alle categorieën"}');
        $this->updateLanguage('LATEST FROM OUR BLOGS', '{"en":"LATEST FROM OUR BLOGS","bn":"আমাদের ব্লগ থেকে সর্বশেষ","fr":"DERNIERS DE NOS BLOGS","zh":"来自我们博客的最新消息","ar":"آخر من مدوناتنا","be":"АКТУАЛЬНАЕ З НАШЫХ БЛОГАЎ","bg":"НАЙ-НОВОТО ОТ НАШИТЕ БЛОГОВЕ","ca":"ÚLTIMS DELS NOSTRES BLOGS","et":"VIIMANE MEIE BLOGIDEST","nl":"LAATSTE VAN ONZE BLOGS"}');
        $this->updateLanguage('NEW ARRIVALS', '{"en":"NEW ARRIVALS","bn":"নতুন আগমন","fr":"NOUVELLES ARRIVÉES","zh":"新品到货","ar":"وصل حديثاً","be":"новыя паступленні","bg":"нови пристигания","ca":"noves arribades","et":"uued saabumised","nl":"nieuwkomers"}');
        $this->updateLanguage('Best Deals of the Week', '{"en":"Best Deals of the Week","bn":"সপ্তাহের সেরা অফার","fr":"Meilleures offres de la semaine","zh":"本周最佳优惠","ar":"أفضل العروض في الأسبوع","be":"лепшыя пропазіцыі тыдня","bg":"най-добрите сделки на седмицата","ca":"millors ofertes de la setmana","et":"nädala parimad pakkumised","nl":"beste deals van de week"}');
        $this->updateLanguage('FEATURED PRODUCTS', '{"en":"FEATURED PRODUCTS","bn":"বৈশিষ্ট্যযুক্ত পণ্য","fr":"PRODUITS EN VEDETTE","zh":"特色产品","ar":"منتجات مميزة","be":"ўдзельныя прадукты","bg":"избрани продукти","ca":"productes destacats","et":"esiletõstetud tooted","nl":"uitgelichte producten"}');

        $this->updateLanguage('Electronics', '{"en":"Electronics","bn":"ইলেকট্রনিক্স","fr":"Électronique","zh":"电子产品","ar":"الإلكترونيات","be":"Электроніка","bg":"Електроника","ca":"Electrònica","et":"Elektroonika","nl":"Elektronica"}');
        $this->updateLanguage('FLASH SALE', '{"en":"FLASH SALE","bn":"ফ্ল্যাশ বিক্রয়","fr":"VENTE FLASH","zh":"闪购","ar":"بيع مفاجئ","be":"Флэш-продаж","bg":"Флаш Продажба","ca":"Venda Flash","et":"Flash-müük","nl":"Flashverkoop"}');
        $this->updateLanguage('Top Brands', '"en":"Top Brands","bn":"শীর্ষ ব্র্যান্ড","fr":"MARQUES DE PRESTIGE","zh":"顶级品牌","ar":"أفضل العلامات التجارية","be":"Лідэры рынку","bg":"Топ марки","ca":"Principals marques","et":"Tippbrändid","nl":"Topmerken"}');
        $this->updateLanguage('latest from our blogs', '{"en":"latest from our blogs","bn":"আমাদের ব্লগ থেকে সর্বশেষ","fr":"DERNIÈRES DE NOS BLOGS","zh":"我们博客的最新内容","ar":"أحدث من مدوناتنا","be":"Апошнія з нашых блогаў","bg":"Последни от нашите блогове","ca":"Últims dels nostres blogs","et":"Viimane meie blogidest","nl":"Laatste van onze blogs"}');
        $this->updateLanguage('LATEST FROM OUR BLOGS', '{"en":"LATEST FROM OUR BLOGS","bn":"আমাদের ব্লগ থেকে সর্বশেষ","fr":"DERNIERS DE NOS BLOGS","zh":"我们博客的最新内容","ar":"أحدث من مدوناتنا","be":"Апошнія з нашых блогаў","bg":"Последни от нашите блогове","ca":"Últims dels nostres blogs","et":"Viimane meie blogidest","nl":"Laatste van onze blogs"}');
        $this->updateLanguage('EXCLUSIVE PRODUCTS', '{"en":"EXCLUSIVE PRODUCTS","bn":"এক্সক্লুসিভ পণ্য","fr":"PRODUITS EXCLUSIFS","zh":"独家产品","ar":"منتجات حصرية","be":"Эксклюзіўныя прадукты","bg":"Ексклузивни продукти","ca":"Productes exclusius","et":"Eksklusiivsed tooted","nl":"Exclusieve producten"}');
        $this->updateLanguage('Fashions', '{"en":"Fashions","bn":"ফ্যাশন","fr":"Mode","zh":"时尚","ar":"موضة","be":"Моды","bg":"Мода","ca":"Moda","et":"Moed","nl":"Mode"}');
        $this->updateLanguage('READ OUR BLOGS', '{"en":"READ OUR BLOGS","bn":"আমাদের ব্লগ পড়ুন","fr":"LISEZ NOS BLOGS","zh":"阅读我们的博客","ar":"اقرأ مدوناتنا","be":"Чытаць нашыя блогі","bg":"Четете нашите блогове","ca":"Llegeix els nostres blogs","et":"Loe meie blogisid","nl":"Lees onze blogs"}');
        $this->updateLanguage('NEW ARRIVALS', '{"en":"NEW ARRIVALS","bn":"নতুন আগমন","fr":"NOUVELLES ARRIVÉES","zh":"新品到货","ar":"وصل حديثاً","be":"новыя паступленні","bg":"нови пристигания","ca":"noves arribades","et":"uued saabumised","nl":"nieuwkomers"}');
        $this->updateLanguage('Flash Sales', '{"en":"Flash Sales","bn":"ফ্ল্যাশ বিক্রয়","fr":"Ventes flash","zh":"闪卖","ar":"مبيعات فلاش","be":"Флэш-продажы","bg":"Флаш Продажби","ca":"Vendes flash","et":"Välkmüügid","nl":"Flashverkopen"}');
        $this->updateLanguage('Special Offer', '{"en":"Special OfferCTS","bn":"বিশেষ অফারসমূহ","fr":"Offres spéciales","zh":"特别优惠","ar":"عروض خاصة","be":"Асаблівыя прапановы","bg":"Специални оферти","ca":"Ofertes especials","et":"Eripakkumised","nl":"Speciale aanbiedingen"}');
        $this->updateLanguage('DIGITAL PRODUCTS', '{"en":"DIGITAL PRODUCTS","bn":"ডিজিটাল পণ্য","fr":"PRODUITS NUMÉRIQUES","zh":"数字产品","ar":"المنتجات الرقمية","be":"ЦЫФРАВЫЯ ПРАДУКТЫ","bg":"ЦИФРОВИ ПРОДУКТИ","ca":"PRODUCTES DIGITALS","et":"DIGITAALSED TOOTED","nl":"DIGITALE PRODUCTEN"}');
        $this->updateLanguage('Latest News', '{"en":"Latest News","bn":"সর্বশেষ সংবাদ","fr":"Dernières nouvelles","zh":"最新消息","ar":"آخر الأخبار","be":"Актуальныя навіны","bg":"Последни новини","ca":"Últimes notícies","et":"Viimased uudised","nl":"Laatste nieuws"}');
        $this->updateLanguage('Newsletter', '{"en":"Newsletter","bn":"নিউজলেটার","fr":"Bulletin d\'information","zh":"时事通讯","ar":"النشرة الإخبارية","be":"Навінны ліст","bg":"Бюлетин","ca":"Butlletí","et":"Uudiskiri","nl":"Nieuwsbrief"}');
        $this->updateLanguage('FEATURED PRODUCTS', '{"en":"FEATURED PRODUCTS","bn":"বৈশিষ্ট্যযুক্ত পণ্য","fr":"Produits en vedette","zh":"特色产品","ar":"منتجات مميزة","be":"Асаблівыя прадукты","bg":"Избрани продукти","ca":"Productes destacats","et":"Esiletõstetud tooted","nl":"Uitgelichte producten"}');
        $this->updateLanguage('BROWSE CATEGORIES', '{"en":"BROWSE CATEGORIES","bn":"বিভাগ ব্রাউজ করুন","fr":"Parcourir les catégories","zh":"浏览类别","ar":"تصفح الفئات","be":"Праглядзець катэгорыі","bg":"Разглеждане на категории","ca":"Navegueu per categories","et":"Sirvige kategooriaid","nl":"Bladeren door categorieën"}');
        $this->updateLanguage('Feature Product', '{"en":"Feature Product","bn":"বৈশিষ্ট্যযুক্ত পণ্য","fr":"Produit vedette","zh":"特色产品","ar":"منتج مميز","be":"Асаблівы прадукт","bg":"Избран продукт","ca":"Producte destacat","et":"Esiletõstetud toode","nl":"Uitgelicht product"}');
        $this->updateLanguage('EXCLUSIVE PRODUCT', '{"en":"EXCLUSIVE PRODUCT","bn":"এক্সক্লুসিভ পণ্য","fr":"Produit exclusif","zh":"独家产品","ar":"منتج حصري","be":"Эксклюзіўныя прадукты","bg":"Ексклузивни продукти","ca":"Producte exclusiu","et":"Eksklusiivne toode","nl":"Exclusief product"}');

        $this->updateLanguage('{"u_subtitle":"LIVING & LIFESTYLE","l_subtitle":"DECORATE","title":"YOUR HOME","image":"20221123/b05bc24c3a122d465099a05a24d2fa3b.webp","button":"SHOW NOW","link":"http:\/\/google.com"}', json_encode([
            'en' => '{"u_subtitle":"LIVING & LIFESTYLE","l_subtitle":"DECORATE","title":"YOUR HOME","image":"20221123/b05bc24c3a122d465099a05a24d2fa3b.webp","button":"SHOW NOW","link":"http:\/\/google.com"}',
            'bn' => '{"u_subtitle":"জীবনযাপন ও জীবনধারা","l_subtitle":"সাজান","title":"আপনার বাড়ি","image":"20221123/b05bc24c3a122d465099a05a24d2fa3b.webp","button":"এখনই কিনুন","link":"http:\/\/google.com"}',
            'fr' => '{"u_subtitle":"VIE ET STYLE DE VIE","l_subtitle":"DÉCORER","title":"VOTRE MAISON","image":"20221123/b05bc24c3a122d465099a05a24d2fa3b.webp","button":"ACHETEZ MAINTENANT","link":"http:\/\/google.com"}',
            'zh' => '{"u_subtitle":"生活与生活方式","l_subtitle":"装饰","title":"你的家","image":"20221123/b05bc24c3a122d465099a05a24d2fa3b.webp","button":"现在购物","link":"http:\/\/google.com"}',
            'ar' => '{"u_subtitle":"الحياة وأسلوب الحياة","l_subtitle":"زخرف","title":"منزلك","image":"20221123/b05bc24c3a122d465099a05a24d2fa3b.webp","button":"تسوق الآن","link":"http:\/\/google.com"}',
            'be' => '{"u_subtitle":"ЖЫЦЦЁ І ЛАД ЖЫЦЦЯ","l_subtitle":"ДЭКАРАЦЫЯ","title":"ВАША ДОМ","image":"20221123/b05bc24c3a122d465099a05a24d2fa3b.webp","button":"КУПІЦЬ ЗАРАЗ","link":"http:\/\/google.com"}',
            'bg' => '{"u_subtitle":"ЖИВОТ И НАЧИН НА ЖИВОТ","l_subtitle":"ДЕКОРИРАНЕ","title":"ВАШИЯТ ДОМ","image":"20221123/b05bc24c3a122d465099a05a24d2fa3b.webp","button":"ПАЗАРУВАЙТЕ СЕГА","link":"http:\/\/google.com"}',
            'ca' => '{"u_subtitle":"VIDA I ESTIL DE VIDA","l_subtitle":"DECORAR","title":"LA TEVA CASA","image":"20221123/b05bc24c3a122d465099a05a24d2fa3b.webp","button":"COMPRA ARA","link":"http:\/\/google.com"}',
            'et' => '{"u_subtitle":"ELAMINE JA ELUSTIIL","l_subtitle":"DEKOREERI","title":"SINU KODU","image":"20221123/b05bc24c3a122d465099a05a24d2fa3b.webp","button":"OSTA KOHE","link":"http:\/\/google.com"}',
            'nl' => '{"u_subtitle":"LEVEN & LEVENSSTIJL","l_subtitle":"VERSIEREN","title":"JOUW HUIS","image":"20221123/b05bc24c3a122d465099a05a24d2fa3b.webp","button":"KOOP NU","link":"http:\/\/google.com"}',
        ]));

        $this->updateLanguage('[{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\"color: #F81B4D\">ORGANIC<\/span> LIFE ","title":"ADVENTURES","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"Explore Now","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\"color: #F81B4D\">HEALTHY<\/span> LIFE ","title":"ADVENTURES","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Visit","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\"color: #F81B4D\">HEALTHY<\/span> LIFE ","title":"ADVENTURES","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Shop Now","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\"color: #F81B4D\">HEALTHY<\/span> LIFE ","title":"ADVENTURES","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"Buy Now","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]', json_encode([
            'en' => '[{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\"color: #F81B4D\">ORGANIC<\/span> LIFE ","title":"ADVENTURES","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"Explore Now","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\"color: #F81B4D\">HEALTHY<\/span> LIFE ","title":"ADVENTURES","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Visit","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\"color: #F81B4D\">HEALTHY<\/span> LIFE ","title":"ADVENTURES","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Shop Now","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\"color: #F81B4D\">HEALTHY<\/span> LIFE ","title":"ADVENTURES","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"Buy Now","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'bn' => '[{"u_subtitle":"জৈব","l_subtitle":"<span style=\"color: #F81B4D\">জৈব<\/span> জীবন ","title":"অ্যাডভেঞ্চার","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"এখনই অন্বেষণ করুন","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"জৈব","l_subtitle":"<span style=\"color: #F81B4D\">স্বাস্থ্যকর<\/span> জীবন ","title":"অ্যাডভেঞ্চার","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"দেখা","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"জৈব","l_subtitle":"<span style=\"color: #F81B4D\">স্বাস্থ্যকর<\/span> জীবন ","title":"অ্যাডভেঞ্চার","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"এখনই কিনুন","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"জৈব","l_subtitle":"<span style=\"color: #F81B4D\">স্বাস্থ্যকর<\/span> জীবন ","title":"অ্যাডভেঞ্চার","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"এখন কিনুন","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'fr' => '[{"u_subtitle":"BIOLOGIQUE","l_subtitle":"<span style=\"color: #F81B4D\">BIOLOGIQUE<\/span> VIE ","title":"AVENTURES","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"Explorez maintenant","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"BIOLOGIQUE","l_subtitle":"<span style=\"color: #F81B4D\">SAIN<\/span> VIE ","title":"AVENTURES","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Visiter","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"BIOLOGIQUE","l_subtitle":"<span style=\"color: #F81B4D\">SAIN<\/span> VIE ","title":"AVENTURES","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Achetez maintenant","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"BIOLOGIQUE","l_subtitle":"<span style=\"color: #F81B4D\">SAIN<\/span> VIE ","title":"AVENTURES","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"Acheter maintenant","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'zh' => '[{"u_subtitle":"有机","l_subtitle":"<span style=\"color: #F81B4D\">有机<\/span> 生活 ","title":"冒险","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"立即探索","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"有机","l_subtitle":"<span style=\"color: #F81B4D\">健康<\/span> 生活 ","title":"冒险","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"访问","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"有机","l_subtitle":"<span style=\"color: #F81B4D\">健康<\/span> 生活 ","title":"冒险","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"现在购物","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"有机","l_subtitle":"<span style=\"color: #F81B4D\">健康<\/span> 生活 ","title":"冒险","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"立即购买","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'ar' => '[{"u_subtitle":"عضوي","l_subtitle":"<span style=\"color: #F81B4D\">عضوي<\/span> حياة ","title":"مغامرات","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"استكشف الآن","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"عضوي","l_subtitle":"<span style=\"color: #F81B4D\">صحي<\/span> حياة ","title":"مغامرات","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"زيارة","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"عضوي","l_subtitle":"<span style=\"color: #F81B4D\">صحي<\/span> حياة ","title":"مغامرات","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"تسوق الآن","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"عضوي","l_subtitle":"<span style=\"color: #F81B4D\">صحي<\/span> حياة ","title":"مغامرات","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"اشتر الآن","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'be' => '[{"u_subtitle":"АРГАНІЧНЫ","l_subtitle":"<span style=\"color: #F81B4D\">АРГАНІЧНЫ<\/span> ЖЫЦЦЁ ","title":"ПРЫГОДЫ","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"Даследуйце зараз","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"АРГАНІЧНЫ","l_subtitle":"<span style=\"color: #F81B4D\">ЗДАРОВЫ<\/span> ЖЫЦЦЁ ","title":"ПРЫГОДЫ","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Наведаць","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"АРГАНІЧНЫ","l_subtitle":"<span style=\"color: #F81B4D\">ЗДАРОВЫ<\/span> ЖЫЦЦЁ ","title":"ПРЫГОДЫ","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Купіць зараз","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"АРГАНІЧНЫ","l_subtitle":"<span style=\"color: #F81B4D\">ЗДАРОВЫ<\/span> ЖЫЦЦЁ ","title":"ПРЫГОДЫ","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"Купляйце зараз","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'bg' => '[{"u_subtitle":"ОРГАНИЧЕН","l_subtitle":"<span style=\"color: #F81B4D\">ОРГАНИЧЕН<\/span> ЖИВОТ ","title":"ПРИКЛЮЧЕНИЯ","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"Разгледайте сега","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"ОРГАНИЧЕН","l_subtitle":"<span style=\"color: #F81B4D\">ЗДРАВОСЛОВЕН<\/span> ЖИВОТ ","title":"ПРИКЛЮЧЕНИЯ","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Посетете","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"ОРГАНИЧЕН","l_subtitle":"<span style=\"color: #F81B4D\">ЗДРАВОСЛОВЕН<\/span> ЖИВОТ ","title":"ПРИКЛЮЧЕНИЯ","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Пазарувайте сега","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"ОРГАНИЧЕН","l_subtitle":"<span style=\"color: #F81B4D\">ЗДРАВОСЛОВЕН<\/span> ЖИВОТ ","title":"ПРИКЛЮЧЕНИЯ","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"Купете сега","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'ca' => '[{"u_subtitle":"ORGÀNIC","l_subtitle":"<span style=\"color: #F81B4D\">ORGÀNIC<\/span> VIDA ","title":"AVENTURES","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"Explora ara","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"ORGÀNIC","l_subtitle":"<span style=\"color: #F81B4D\">SALUDABLE<\/span> VIDA ","title":"AVENTURES","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Visitar","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"ORGÀNIC","l_subtitle":"<span style=\"color: #F81B4D\">SALUDABLE<\/span> VIDA ","title":"AVENTURES","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Compra ara","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"ORGÀNIC","l_subtitle":"<span style=\"color: #F81B4D\">SALUDABLE<\/span> VIDA ","title":"AVENTURES","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"Compra ara","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'et' => '[{"u_subtitle":"ORGAANILINE","l_subtitle":"<span style=\"color: #F81B4D\">ORGAANILINE<\/span> ELU ","title":"SEIKLUSED","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"Avasta nüüd","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"ORGAANILINE","l_subtitle":"<span style=\"color: #F81B4D\">TERVISLIK<\/span> ELU ","title":"SEIKLUSED","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Külastama","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"ORGAANILINE","l_subtitle":"<span style=\"color: #F81B4D\">TERVISLIK<\/span> ELU ","title":"SEIKLUSED","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Osta kohe","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"ORGAANILINE","l_subtitle":"<span style=\"color: #F81B4D\">TERVISLIK<\/span> ELU ","title":"SEIKLUSED","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"Osta nüüd","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'nl' => '[{"u_subtitle":"BIOLOGISCH","l_subtitle":"<span style=\"color: #F81B4D\">BIOLOGISCH<\/span> LEVEN ","title":"AVONTUREN","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"Verken nu","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"BIOLOGISCH","l_subtitle":"<span style=\"color: #F81B4D\">GEZOND<\/span> LEVEN ","title":"AVONTUREN","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Bezoek","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"BIOLOGISCH","l_subtitle":"<span style=\"color: #F81B4D\">GEZOND<\/span> LEVEN ","title":"AVONTUREN","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Koop nu","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"BIOLOGISCH","l_subtitle":"<span style=\"color: #F81B4D\">GEZOND<\/span> LEVEN ","title":"AVONTUREN","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"Koop nu","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
        ]));

        $this->updateLanguage('{"badge_text":"Deal Of The Day"}', json_encode([
            'en' => '{"badge_text":"Deal Of The Day"}',
            'bn' => '{"badge_text":"দিনের চুক্তি"}',
            'fr' => '{"badge_text":"Offre du jour"}',
            'zh' => '{"badge_text":"今日特惠"}',
            'ar' => '{"badge_text":"صفقة اليوم"}',
            'be' => '{"badge_text":"Здзелка дня"}',
            'bg' => '{"badge_text":"Сделка на деня"}',
            'ca' => '{"badge_text":"Oferta del dia"}',
            'et' => '{"badge_text":"Päeva pakkumine"}',
            'nl' => '{"badge_text":"Aanbieding van de dag"}',
        ]));

        $this->updateLanguage('Starting from only <span style="color: #FA886A">$9.99</span>', json_encode([
            'en' => 'Starting from only <span style="color: #FA886A">$9.99</span>',
            'bn' => 'শুধুমাত্র শুরু হচ্ছে <span style="color: #FA886A">$9.99</span>',
            'fr' => 'À partir de seulement <span style="color: #FA886A">$9.99</span>',
            'zh' => '仅起价 <span style="color: #FA886A">$9.99</span>',
            'ar' => 'ابتداء من فقط <span style="color: #FA886A">$9.99</span>',
            'be' => 'Пачынаючы толькі з <span style="color: #FA886A">$9.99</span>',
            'bg' => 'Започва от само <span style="color: #FA886A">$9.99</span>',
            'ca' => 'A partir de només <span style="color: #FA886A">$9.99</span>',
            'et' => 'Alates ainult <span style="color: #FA886A">$9.99</span>',
            'nl' => 'Beginnend vanaf slechts <span style="color: #FA886A">$9.99</span>',
        ]));

        $this->updateLanguage('[{"upper_st":"ELECTRONICS","lower_st":"ELECTROFY","title":"YOUR LIFW","image":"20220831/ad58f57577ee2331b94298ef8301a918.webp","btn_text":"SHOP NOW","btn_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"},{"upper_st":"SHOES","lower_st":"ADD STYLES TO","title":"YOUR FEET","image":"20220831/138b95f17cd98bb837051dfbe54bf64d.webp","btn_text":"SHOP NOW","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]', json_encode([
            'en' => '[{"upper_st":"ELECTRONICS","lower_st":"ELECTROFY","title":"YOUR LIFE","image":"20220831/ad58f57577ee2331b94298ef8301a918.webp","btn_text":"SHOP NOW","btn_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"},{"upper_st":"SHOES","lower_st":"ADD STYLES TO","title":"YOUR FEET","image":"20220831/138b95f17cd98bb837051dfbe54bf64d.webp","btn_text":"SHOP NOW","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'bn' => '[{"upper_st":"ইলেকট্রনিক্স","lower_st":"বৈদ্যুতিক করুন","title":"আপনার জীবন","image":"20220831/ad58f57577ee2331b94298ef8301a918.webp","btn_text":"এখন কেনাকাটা করুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"},{"upper_st":"জুতা","lower_st":"স্টাইল যোগ করুন","title":"আপনার পা","image":"20220831/138b95f17cd98bb837051dfbe54bf64d.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'fr' => '[{"upper_st":"ÉLECTRONIQUE","lower_st":"ÉLECTRIFIEZ","title":"VOTRE VIE","image":"20220831/ad58f57577ee2331b94298ef8301a918.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"},{"upper_st":"CHAUSSURES","lower_st":"AJOUTEZ DU STYLE À","title":"VOS PIEDS","image":"20220831/138b95f17cd98bb837051dfbe54bf64d.webp","btn_text":"ACHETEZ MAINTENANT","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'zh' => '[{"upper_st":"电子产品","lower_st":"电气化","title":"你的生活","image":"20220831/ad58f57577ee2331b94298ef8301a918.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"},{"upper_st":"鞋子","lower_st":"添加风格到","title":"你的脚","image":"20220831/138b95f17cd98bb837051dfbe54bf64d.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'ar' => '[{"upper_st":"الإلكترونيات","lower_st":"كهرباء","title":"Yحياتك","image":"20220831/ad58f57577ee2331b94298ef8301a918.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"},{"upper_st":"أحذية","lower_st":"أضف أنماط إلى","title":"قدميك","image":"20220831/138b95f17cd98bb837051dfbe54bf64d.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'be' => '[{"upper_st":"ЭЛЕКТРОНІКА","lower_st":"ЭЛЕКТРАФІКАЦЫЯ","title":"ВАША ЖЫЦЦЁ","image":"20220831/ad58f57577ee2331b94298ef8301a918.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"},{"upper_st":"БУЦЬЦЕ","lower_st":"ДАДАЦЬ СТЫЛІ ДА","title":"ВАШЫ НОГІ","image":"20220831/138b95f17cd98bb837051dfbe54bf64d.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'bg' => '[{"upper_st":"ЕЛЕКТРОНИКА","lower_st":"ЕЛЕКТРИФИЦИРАЙТЕ","title":"YВАШИЯТ ЖИВОТ","image":"20220831/ad58f57577ee2331b94298ef8301a918.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"},{"upper_st":"ОБУВКИ","lower_st":"ДОБАВЕТЕ СТИЛОВЕ КЪМ","title":"ВАШИТЕ КРАКА","image":"20220831/138b95f17cd98bb837051dfbe54bf64d.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'ca' => '[{"upper_st":"ELECTRÒNICA","lower_st":"ELECTRIFICA","title":"LA TEVA VIDA","image":"20220831/ad58f57577ee2331b94298ef8301a918.webp","btn_text":"COMPRA ARA","btn_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"},{"upper_st":"SABATES","lower_st":"AFEGEIX ESTILS A","title":"ELS TEUS PEUS","image":"20220831/138b95f17cd98bb837051dfbe54bf64d.webp","btn_text":"COMPRA ARA","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'et' => '[{"upper_st":"ELEKTROONIKA","lower_st":"ELEKTRIFITSEERI","title":"SINU ELU","image":"20220831/ad58f57577ee2331b94298ef8301a918.webp","btn_text":"OSTA KOHE","btn_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"},{"upper_st":"KINGAD","lower_st":"LISA STIILID","title":"SINU JALAD","image":"20220831/138b95f17cd98bb837051dfbe54bf64d.webp","btn_text":"OSTA KOHE","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'nl' => '[{"upper_st":"ELEKTRONICA","lower_st":"ELEKTRIFICEER","title":"JE LEVEN","image":"20220831/ad58f57577ee2331b94298ef8301a918.webp","btn_text":"KOOP NU","btn_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"},{"upper_st":"SCHOENEN","lower_st":"VOEG STIJLEN TOE AAN","title":"JE VOETEN","image":"20220831/138b95f17cd98bb837051dfbe54bf64d.webp","btn_text":"KOOP NU","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
        ]));

        $this->updateLanguage('{"u_subtitle":"Take A Look","l_subtitle":"On Our","title":"Furnitures","image":"20221203/4549648a85ebfff095bba62a585ddf9b.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=categories=Home%20Appliances"}', json_encode([
            'en' => '{"u_subtitle":"Take A Look","l_subtitle":"On Our","title":"Furnitures","image":"20221203/4549648a85ebfff095bba62a585ddf9b.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=categories=Home%20Appliances"}',
            'bn' => '{"u_subtitle":"একবার দেখুন","l_subtitle":"আমাদের উপর","title":"আসবাবপত্র","image":"20221203/4549648a85ebfff095bba62a585ddf9b.webp","button":"এখনই কিনুন","link":"http://localhost/multi-vendor/search-products?categories=categories=Home%20Appliances"}',
            'fr' => '{"u_subtitle":"Jetez un coup d\'œil","l_subtitle":"Sur notre","title":"Meubles","image":"20221203/4549648a85ebfff095bba62a585ddf9b.webp","button":"Achetez maintenant","link":"http://localhost/multi-vendor/search-products?categories=categories=Home%20Appliances"}',
            'zh' => '{"u_subtitle":"看看","l_subtitle":"在我们的","title":"家具","image":"20221203/4549648a85ebfff095bba62a585ddf9b.webp","button":"现在购物","link":"http://localhost/multi-vendor/search-products?categories=categories=Home%20Appliances"}',
            'ar' => '{"u_subtitle":"ألقِ نظرة","l_subtitle":"على موقعنا","title":"الأثاث","image":"20221203/4549648a85ebfff095bba62a585ddf9b.webp","button":"تسوق الآن","link":"http://localhost/multi-vendor/search-products?categories=categories=Home%20Appliances"}',
            'be' => '{"u_subtitle":"Зірніце","l_subtitle":"На нашым","title":"Мэбля","image":"20221203/4549648a85ebfff095bba62a585ddf9b.webp","button":"Купіць зараз","link":"http://localhost/multi-vendor/search-products?categories=categories=Home%20Appliances"}',
            'bg' => '{"u_subtitle":"Хвърли едно око","l_subtitle":"На нашия","title":"Мебели","image":"20221203/4549648a85ebfff095bba62a585ddf9b.webp","button":"Пазарувайте сега","link":"http://localhost/multi-vendor/search-products?categories=categories=Home%20Appliances"}',
            'ca' => '{"u_subtitle":"Fes una ullada","l_subtitle":"En el nostre","title":"Mobles","image":"20221203/4549648a85ebfff095bba62a585ddf9b.webp","button":"Compra ara","link":"http://localhost/multi-vendor/search-products?categories=categories=Home%20Appliances"}',
            'et' => '{"u_subtitle":"Vaata","l_subtitle":"Meie","title":"Mööbel","image":"20221203/4549648a85ebfff095bba62a585ddf9b.webp","button":"Osta kohe","link":"http://localhost/multi-vendor/search-products?categories=categories=Home%20Appliances"}',
            'nl' => '{"u_subtitle":"Neem een kijkje","l_subtitle":"Op onze","title":"Meubels","image":"20221203/4549648a85ebfff095bba62a585ddf9b.webp","button":"Koop nu","link":"http://localhost/multi-vendor/search-products?categories=categories=Home%20Appliances"}',
        ]));

        $this->updateLanguage('[{"u_subtitle":"SPORTS","l_subtitle":"SAFEGUARD YOUR","title":"ADVENTURES","image":"20221123/8aef5c1a8f0cb9c5f4dbf783ee501d47.webp","button_text":"Shop Now","button_link":"#"},{"u_subtitle":"SPORTS","l_subtitle":"SAFEGUARD YOUR","title":"ADVENTURES","image":"20221123/11c41cfbe3e9f892e149b7715a0d9200.webp","button_text":"Shop Now","button_link":"#"}]', json_encode([
            'en' => '[{"u_subtitle":"SPORTS","l_subtitle":"SAFEGUARD YOUR","title":"ADVENTURES","image":"20221123/8aef5c1a8f0cb9c5f4dbf783ee501d47.webp","button_text":"Shop Now","button_link":"#"},{"u_subtitle":"SPORTS","l_subtitle":"SAFEGUARD YOUR","title":"ADVENTURES","image":"20221123/11c41cfbe3e9f892e149b7715a0d9200.webp","button_text":"Shop Now","button_link":"#"}]',
            'bn' => '[{"u_subtitle":"খেলাধুলা","l_subtitle":"আপনার সুরক্ষা","title":"অ্যাডভেঞ্চার","image":"20221123/8aef5c1a8f0cb9c5f4dbf783ee501d47.webp","button_text":"এখনই কিনুন","button_link":"#"},{"u_subtitle":"খেলাধুলা","l_subtitle":"আপনার সুরক্ষা","title":"অ্যাডভেঞ্চার","image":"20221123/11c41cfbe3e9f892e149b7715a0d9200.webp","button_text":"এখনই কিনুন","button_link":"#"}]',
            'fr' => '[{"u_subtitle":"SPORTS","l_subtitle":"PROTÉGEZ VOTRE","title":"AVENTURES","image":"20221123/8aef5c1a8f0cb9c5f4dbf783ee501d47.webp","button_text":"Achetez maintenant","button_link":"#"},{"u_subtitle":"SPORTS","l_subtitle":"PROTÉGEZ VOTRE","title":"AVENTURES","image":"20221123/11c41cfbe3e9f892e149b7715a0d9200.webp","button_text":"Achetez maintenant","button_link":"#"}]',
            'zh' => '[{"u_subtitle":"体育","l_subtitle":"保护您的","title":"冒险","image":"20221123/8aef5c1a8f0cb9c5f4dbf783ee501d47.webp","button_text":"现在购物","button_link":"#"},{"u_subtitle":"体育","l_subtitle":"保护您的","title":"冒险","image":"20221123/11c41cfbe3e9f892e149b7715a0d9200.webp","button_text":"现在购物","button_link":"#"}]',
            'ar' => '[{"u_subtitle":"رياضات","l_subtitle":"احمِ","title":"مغامرات","image":"20221123/8aef5c1a8f0cb9c5f4dbf783ee501d47.webp","button_text":"تسوق الآن","button_link":"#"},{"u_subtitle":"رياضات","l_subtitle":"احمِ","title":"مغامرات","image":"20221123/11c41cfbe3e9f892e149b7715a0d9200.webp","button_text":"تسوق الآن","button_link":"#"}]',
            'be' => '[{"u_subtitle":"СПОРТ","l_subtitle":"АБАРАНІЦЬ ВАШ","title":"ПРЫГОДЫ","image":"20221123/8aef5c1a8f0cb9c5f4dbf783ee501d47.webp","button_text":"Купіць зараз","button_link":"#"},{"u_subtitle":"СПОРТ","l_subtitle":"АБАРАНІЦЬ ВАШ","title":"ПРЫГОДЫ","image":"20221123/11c41cfbe3e9f892e149b7715a0d9200.webp","button_text":"Купіць зараз","button_link":"#"}]',
            'bg' => '[{"u_subtitle":"СПОРТ","l_subtitle":"ЗАЩИТЕТЕ ВАШИЯ","title":"ПРИКЛЮЧЕНИЯ","image":"20221123/8aef5c1a8f0cb9c5f4dbf783ee501d47.webp","button_text":"Пазарувайте сега","button_link":"#"},{"u_subtitle":"СПОРТ","l_subtitle":"ЗАЩИТЕТЕ ВАШИЯ","title":"ПРИКЛЮЧЕНИЯ","image":"20221123/11c41cfbe3e9f892e149b7715a0d9200.webp","button_text":"Пазарувайте сега","button_link":"#"}]',
            'ca' => '[{"u_subtitle":"ESPORTS","l_subtitle":"PROTEGEIX EL TEU","title":"AVENTURES","image":"20221123/8aef5c1a8f0cb9c5f4dbf783ee501d47.webp","button_text":"Compra ara","button_link":"#"},{"u_subtitle":"ESPORTS","l_subtitle":"PROTEGEIX EL TEU","title":"AVENTURES","image":"20221123/11c41cfbe3e9f892e149b7715a0d9200.webp","button_text":"Compra ara","button_link":"#"}]',
            'et' => '[{"u_subtitle":"SPORT","l_subtitle":"KAITSE OMA","title":"SEIKLUSED","image":"20221123/8aef5c1a8f0cb9c5f4dbf783ee501d47.webp","button_text":"Osta kohe","button_link":"#"},{"u_subtitle":"SPORT","l_subtitle":"KAITSE OMA","title":"SEIKLUSED","image":"20221123/11c41cfbe3e9f892e149b7715a0d9200.webp","button_text":"Osta kohe","button_link":"#"}]',
            'nl' => '[{"u_subtitle":"SPORTS","l_subtitle":"BESCHERM UW","title":"AVONTUREN","image":"20221123/8aef5c1a8f0cb9c5f4dbf783ee501d47.webp","button_text":"Koop nu","button_link":"#"},{"u_subtitle":"SPORTS","l_subtitle":"BESCHERM UW","title":"AVONTUREN","image":"20221123/11c41cfbe3e9f892e149b7715a0d9200.webp","button_text":"Koop nu","button_link":"#"}]',
        ]));

        $this->updateLanguage('{"title":"New Here?","sidetext":"Get Coupon","description":"Use coupon <span class=\"primary-text-color font-medium\">\u2018BUYNOW01\u2019<\/span> and get up to $200 on your first purchase."}', json_encode([
            'en' => '{"title":"New Here?","sidetext":"Get Coupon","description":"Use coupon <span class=\\"primary-text-color font-medium\\">\\u2018BUYNOW01\\u2019<\\/span> and get up to $200 on your first purchase."}',
            'bn' => '{"title":"এখানে নতুন?","sidetext":"কুপন পান","description":"কুপন ব্যবহার করুন <span class=\\"primary-text-color font-medium\\">\\u2018BUYNOW01\\u2019<\\/span> এবং আপনার প্রথম কেনার জন্য প্রাপ্ত করুন সর্বোচ্চ $200।"}',
            'fr' => '{"title":"Nouveau ici?","sidetext":"Obtenez un coupon","description":"Utilisez le coupon <span class=\\"primary-text-color font-medium\\">\\u2018BUYNOW01\\u2019<\\/span> et obtenez jusqu\'à 200 $ sur votre premier achat."}',
            'zh' => '{"title":"新来的？","sidetext":"获取优惠券","description":"使用优惠券 <span class=\\"primary-text-color font-medium\\">\\u2018BUYNOW01\\u2019<\\/span> 并在您的首次购买时获得高达200美元。"}',
            'ar' => '{"title":"جديد هنا؟","sidetext":"احصل على كوبون","description":"استخدم الكوبون <span class=\\"primary-text-color font-medium\\">\\u2018BUYNOW01\\u2019<\\/span> واحصل على ما يصل إلى 200 دولار في عملية الشراء الأولى الخاصة بك."}',
            'be' => '{"title":"Новы тут?","sidetext":"Атрымаць купон","description":"Выкарыстоўвайце купон <span class=\\"primary-text-color font-medium\\">\\u2018BUYNOW01\\u2019<\\/span> і атрымаць да $200 на вашым першым пакупкі."}',
            'bg' => '{"title":"Нов тук?","sidetext":"Вземете купон","description":"Използвайте купон <span class=\\"primary-text-color font-medium\\">\\u2018BUYNOW01\\u2019<\\/span> и получете до 200 долара при първата си покупка."}',
            'ca' => '{"title":"Nou aquí?","sidetext":"Obtén un cupó","description":"Utilitzeu el cupó <span class=\\"primary-text-color font-medium\\">\\u2018BUYNOW01\\u2019<\\/span> i obteniu fins a 200 $ en la vostra primera compra."}',
            'et' => '{"title":"Uus siin?","sidetext":"Saage kupong","description":"Kasutage kupongi <span class=\\"primary-text-color font-medium\\">\\u2018BUYNOW01\\u2019<\\/span> ja saate oma esimese ostu eest kuni 200 dollarit."}',
            'nl' => '{"title":"Nieuw hier?","sidetext":"Krijg een coupon","description":"Gebruik coupon <span class=\\"primary-text-color font-medium\\">\\u2018BUYNOW01\\u2019<\\/span> en ontvang tot $200 bij uw eerste aankoop."}',
        ]));

        $this->updateLanguage('[{"image":"20220912/80a6e899c44b684664e32cbc47082f60.webp","title":"Free Shipping Worldwide","subtitle":"For all orders over $350"},{"image":"20220912/7fb4c55cfbf6fbaebeb7f3fcde4536c0.webp","title":"Secured Online Payment","subtitle":"Payment protection guaranteed"},{"image":"20220912/857c4980e5995df0ff3cbddab4a76ef0.webp","title":"Money Back Guarantee","subtitle":"If goods have problems"}]', json_encode([
            'en' => '[{"image":"20220912/80a6e899c44b684664e32cbc47082f60.webp","title":"Free Shipping Worldwide","subtitle":"For all orders over $350"},{"image":"20220912/7fb4c55cfbf6fbaebeb7f3fcde4536c0.webp","title":"Secured Online Payment","subtitle":"Payment protection guaranteed"},{"image":"20220912/857c4980e5995df0ff3cbddab4a76ef0.webp","title":"Money Back Guarantee","subtitle":"If goods have problems"}]',
            'bn' => '[{"image":"20220912/80a6e899c44b684664e32cbc47082f60.webp","title":"সমগ্রে নিশুল্ক শিপিং","subtitle":"$350 এর উপরের সমস্ত আদেশের জন্য"},{"image":"20220912/7fb4c55cfbf6fbaebeb7f3fcde4536c0.webp","title":"নিরাপদ অনলাইন পেমেন্ট","subtitle":"অর্থ সংরক্ষণ নিশ্চিত"},{"image":"20220912/857c4980e5995df0ff3cbddab4a76ef0.webp","title":"অর্থ ফেরত গ্যারান্টি","subtitle":"যদি পণ্যে সমস্যা থাকে"}]',
            'fr' => '[{"image":"20220912/80a6e899c44b684664e32cbc47082f60.webp","title":"Livraison gratuite dans le monde entier","subtitle":"Pour toutes les commandes de plus de 350 $"},{"image":"20220912/7fb4c55cfbf6fbaebeb7f3fcde4536c0.webp","title":"Paiement en ligne sécurisé","subtitle":"Protection des paiements garantie"},{"image":"20220912/857c4980e5995df0ff3cbddab4a76ef0.webp","title":"Garantie de remboursement","subtitle":"Si les marchandises ont des problèmes"}]',
            'zh' => '[{"image":"20220912/80a6e899c44b684664e32cbc47082f60.webp","title":"全球免费送货","subtitle":"所有订单超过$350"},{"image":"20220912/7fb4c55cfbf6fbaebeb7f3fcde4536c0.webp","title":"安全的在线支付","subtitle":"付款保护保证"},{"image":"20220912/857c4980e5995df0ff3cbddab4a76ef0.webp","title":"退款保证","subtitle":"如果商品有问题"}]',
            'ar' => '[{"image":"20220912/80a6e899c44b684664e32cbc47082f60.webp","title":"شحن مجاني لجميع أنحاء العالم","subtitle":"لجميع الطلبات التي تزيد عن 350 دولار"},{"image":"20220912/7fb4c55cfbf6fbaebeb7f3fcde4536c0.webp","title":"الدفع الآمن عبر الإنترنت","subtitle":"ضمان حماية الدفع"},{"image":"20220912/857c4980e5995df0ff3cbddab4a76ef0.webp","title":"ضمان استعادة الأموال","subtitle":"إذا كانت السلع تواجه مشكلة"}]',
            'be' => '[{"image":"20220912/80a6e899c44b684664e32cbc47082f60.webp","title":"Бясплатная дастаўка па ўсім свеце","subtitle":"Для ўсіх заказаў на суму больш за $350"},{"image":"20220912/7fb4c55cfbf6fbaebeb7f3fcde4536c0.webp","title":"Бяспечная анлайн-аплата","subtitle":"Гарантыя абароны плацяжу"},{"image":"20220912/857c4980e5995df0ff3cbddab4a76ef0.webp","title":"Гарантыя вяртання грошай","subtitle":"Калі ёсць праблемы з таварамі"}]',
            'bg' => '[{"image":"20220912/80a6e899c44b684664e32cbc47082f60.webp","title":"Безплатна доставка по целия свят","subtitle":"За всички поръчки над $350"},{"image":"20220912/7fb4c55cfbf6fbaebeb7f3fcde4536c0.webp","title":"Сигурно онлайн плащане","subtitle":"Гарантирана защита на плащането"},{"image":"20220912/857c4980e5995df0ff3cbddab4a76ef0.webp","title":"Гаранция за връщане на парите","subtitle":"Ако стоките имат проблеми"}]',
            'ca' => '[{"image":"20220912/80a6e899c44b684664e32cbc47082f60.webp","title":"Envío gratis a todo el mundo","subtitle":"Per a totes les comandes superiors a 350 $"},{"image":"20220912/7fb4c55cfbf6fbaebeb7f3fcde4536c0.webp","title":"Pagament en línia segur","subtitle":"Garantia de protecció del pagament"},{"image":"20220912/857c4980e5995df0ff3cbddab4a76ef0.webp","title":"Garantia de devolució de diners","subtitle":"Si els productes tenen problemes"}]',
            'et' => '[{"image":"20220912/80a6e899c44b684664e32cbc47082f60.webp","title":"Tasuta kohaletoimetamine üle maailma","subtitle":"Kõigi tellimuste puhul üle $350"},{"image":"20220912/7fb4c55cfbf6fbaebeb7f3fcde4536c0.webp","title":"Turvaline veebimakse","subtitle":"Maksekaitsmise tagatud"},{"image":"20220912/857c4980e5995df0ff3cbddab4a76ef0.webp","title":"Raha tagastamise garantii","subtitle":"Kui kaupadel on probleeme"}]',
            'nl' => '[{"image":"20220912/80a6e899c44b684664e32cbc47082f60.webp","title":"Gratis verzending wereldwijd","subtitle":"Voor alle bestellingen boven $350"},{"image":"20220912/7fb4c55cfbf6fbaebeb7f3fcde4536c0.webp","title":"Veilige online betaling","subtitle":"Betaalbescherming gegarandeerd"},{"image":"20220912/857c4980e5995df0ff3cbddab4a76ef0.webp","title":"Geld-terug-garantie","subtitle":"Als de goederen problemen hebben"}]',
        ]));

        $this->updateLanguage('[{"upper_st":"NEW ARRIVALS","lower_st":"FOR THE <span style=\"color:#E43147\" >HIP HOP<\/span>","title":"HIPSTERS","image":"20221107/e2e47ed6286ed709cde3f1dd21188386.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"WINTER","lower_st":"<span style=\"color:#E43147\" >IMPORTED<\/span> DENIM","title":"JACKETS","image":"20221107/2d8f9415456127a43268173e85fb11d9.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]', json_encode([
            'en' => '[{"upper_st":"NEW ARRIVALS","lower_st":"FOR THE <span style=\\"color:#E43147\\" >HIP HOP<\\/span>","title":"HIPSTERS","image":"20221107/e2e47ed6286ed709cde3f1dd21188386.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"WINTER","lower_st":"<span style=\\"color:#E43147\\" >IMPORTED<\\/span> DENIM","title":"JACKETS","image":"20221107/2d8f9415456127a43268173e85fb11d9.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'bn' => '[{"upper_st":"নতুন আগমন","lower_st":"জন্য <span style=\\"color:#E43147\\" >হিপ হপ<\\/span>","title":"হিপস্টার","image":"20221107/e2e47ed6286ed709cde3f1dd21188386.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"শীতকাল","lower_st":"<span style=\\"color:#E43147\\" >আমদানি<\\/span> ডেনিম","title":"জ্যাকেট","image":"20221107/2d8f9415456127a43268173e85fb11d9.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'fr' => '[{"upper_st":"NOUVEAUTÉS","lower_st":"POUR LES <span style=\\"color:#E43147\\" >HIP HOP<\\/span>","title":"HIPSTERS","image":"20221107/e2e47ed6286ed709cde3f1dd21188386.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"HIVER","lower_st":"<span style=\\"color:#E43147\\" >IMPORTÉ<\\/span> DENIM","title":"VESTES","image":"20221107/2d8f9415456127a43268173e85fb11d9.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'zh' => '[{"upper_st":"新品上市","lower_st":"为了 <span style=\\"color:#E43147\\" >嘻哈<\\/span>","title":"时尚潮人","image":"20221107/e2e47ed6286ed709cde3f1dd21188386.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"冬季","lower_st":"<span style=\\"color:#E43147\\" >进口<\\/span> 牛仔布","title":"夹克","image":"20221107/2d8f9415456127a43268173e85fb11d9.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'ar' => '[{"upper_st":"وصل حديثا","lower_st":"لل <span style=\\"color:#E43147\\" >هيب هوب<\\/span>","title":"هيبسترز","image":"20221107/e2e47ed6286ed709cde3f1dd21188386.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"شتاء","lower_st":"<span style=\\"color:#E43147\\" >مستورد<\\/span> دنيم","title":"جاكيتات","image":"20221107/2d8f9415456127a43268173e85fb11d9.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'be' => '[{"upper_st":"НОВЫЯ ПАСТАЎКІ","lower_st":"ДЛЯ <span style=\\"color:#E43147\\" >ХІП-ХОП<\\/span>","title":"ХІПСТАРЫ","image":"20221107/e2e47ed6286ed709cde3f1dd21188386.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"ЗІМА","lower_st":"<span style=\\"color:#E43147\\" >ІМПОРТ<\\/span> ДЖИНС","title":"КУРТКІ","image":"20221107/2d8f9415456127a43268173e85fb11d9.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'bg' => '[{"upper_st":"НОВИ ПРИБИЖВАНИЯ","lower_st":"ЗА <span style=\\"color:#E43147\\" >ХИП ХОП<\\/span>","title":"ХИПСТЪРИ","image":"20221107/e2e47ed6286ed709cde3f1dd21188386.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"ЗИМА","lower_st":"<span style=\\"color:#E43147\\" >ИМПОРТИРАНИ<\\/span> ДЪНКИ","title":"ЯКЕТА","image":"20221107/2d8f9415456127a43268173e85fb11d9.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'ca' => '[{"upper_st":"NOVES ARREPLEGATS","lower_st":"PER A <span style=\\"color:#E43147\\" >HIP HOP<\\/span>","title":"HIPSTERS","image":"20221107/e2e47ed6286ed709cde3f1dd21188386.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"HIVERN","lower_st":"<span style=\\"color:#E43147\\" >IMPORTAT<\\/span> DENIM","title":"JAQUETES","image":"20221107/2d8f9415456127a43268173e85fb11d9.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'et' => '[{"upper_st":"UUED SAABUMISED","lower_st":"SÜNDMUSTEKS <span style=\\"color:#E43147\\" >HIP HOP<\\/span>","title":"HIPSTERID","image":"20221107/e2e47ed6286ed709cde3f1dd21188386.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"TALV","lower_st":"<span style=\\"color:#E43147\\" >IMPORTEERITUD<\\/span> DENIM","title":"JOPED","image":"20221107/2d8f9415456127a43268173e85fb11d9.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'nl' => '[{"upper_st":"NIEUWE AANKOMSTEN","lower_st":"VOOR DE <span style=\\"color:#E43147\\" >HIP HOP<\\/span>","title":"HIPSTERS","image":"20221107/e2e47ed6286ed709cde3f1dd21188386.webp","btn_text":"Koop nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"WINTER","lower_st":"<span style=\\"color:#E43147\\" >GEÏMPORTEERD<\\/span> DENIM","title":"JASSEN","image":"20221107/2d8f9415456127a43268173e85fb11d9.webp","btn_text":"Koop nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
        ]));

        $this->updateLanguage('[{"upper_st":"<span style=\"color:#ffffff\">EYEWEAR<\/span>","lower_st":"<span style=\"color: #ffffff\">LOOK<\/span><span> <span style=\"color: #fcca19\">COOL<\/span> <span style=\"color:#ffffff\">WITH<\/span> ","title":"<span style=\"color: #ffffff\">SUNGLASSES<\/span>","image":"20221107/d1113f342bf7753ecf8688fd0dbde093.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"FOOTWEAR","lower_st":"MAN ON THE MIRROR","title":"SNEAKERS","image":"20221107/30be31d0d269ece9d671efcacc592d19.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]', json_encode([
            'en' => '[{"upper_st":"<span style=\"color:#ffffff\">EYEWEAR<\/span>","lower_st":"<span style=\"color: #ffffff\">LOOK<\/span><span> <span style=\"color: #fcca19\">COOL<\/span> <span style=\"color:#ffffff\">WITH<\/span> ","title":"<span style=\"color: #ffffff\">SUNGLASSES<\/span>","image":"20221107/d1113f342bf7753ecf8688fd0dbde093.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"FOOTWEAR","lower_st":"MAN ON THE MIRROR","title":"SNEAKERS","image":"20221107/30be31d0d269ece9d671efcacc592d19.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'bn' => '[{"upper_st":"<span style=\"color:#ffffff\">চশমা<\/span>","lower_st":"<span style=\"color: #ffffff\">দেখা<\/span><span> <span style=\"color: #fcca19\">শীতল<\/span> <span style=\"color:#ffffff\">সঙ্গে<\/span> ","title":"<span style=\"color: #ffffff\">সানগ্লাস<\/span>","image":"20221107/d1113f342bf7753ecf8688fd0dbde093.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"পায়ের জুতা","lower_st":"মিররে মানুষ","title":"স্নিকার্স","image":"20221107/30be31d0d269ece9d671efcacc592d19.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'fr' => '[{"upper_st":"<span style=\"color:#ffffff\">LUNETTES<\/span>","lower_st":"<span style=\"color: #ffffff\">REGARDEZ<\/span><span> <span style=\"color: #fcca19\">COOL<\/span> <span style=\"color:#ffffff\">AVEC<\/span> ","title":"<span style=\"color: #ffffff\">LUNETTES DE SOLEIL<\/span>","image":"20221107/d1113f342bf7753ecf8688fd0dbde093.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"CHAUSSURES","lower_st":"L\'HOMME DANS LE MIROIR","title":"BASKETS","image":"20221107/30be31d0d269ece9d671efcacc592d19.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'zh' => '[{"upper_st":"<span style=\"color:#ffffff\">眼镜<\/span>","lower_st":"<span style=\"color: #ffffff\">看<\/span><span> <span style=\"color: #fcca19\">酷<\/span> <span style=\"color:#ffffff\">用<\/span> ","title":"<span style=\"color: #ffffff\">太阳镜<\/span>","image":"20221107/d1113f342bf7753ecf8688fd0dbde093.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"鞋","lower_st":"镜中人","title":"运动鞋","image":"20221107/30be31d0d269ece9d671efcacc592d19.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'ar' => '[{"upper_st":"<span style=\"color:#ffffff\">نظارات<\/span>","lower_st":"<span style=\"color: #ffffff\">انظر<\/span><span> <span style=\"color: #fcca19\">بارد<\/span> <span style=\"color:#ffffff\">مع<\/span> ","title":"<span style=\"color: #ffffff\">نظارات شمسية<\/span>","image":"20221107/d1113f342bf7753ecf8688fd0dbde093.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"أحذية","lower_st":"الرجل في المرآة","title":"حذاء رياضي","image":"20221107/30be31d0d269ece9d671efcacc592d19.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'be' => '[{"upper_st":"<span style=\"color:#ffffff\">АКСЭСУАРЫ ДЛЯ ВАС<\/span>","lower_st":"<span style=\"color: #ffffff\">ГЛЯДЗЕЦЬ<\/span><span> <span style=\"color: #fcca19\">КУЛЬ<\/span> <span style=\"color:#ffffff\">З<\/span> ","title":"<span style=\"color: #ffffff\">СОЛНЦАВЫЯ АКСЭСУАРЫ<\/span>","image":"20221107/d1113f342bf7753ecf8688fd0dbde093.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"АБУВЫ","lower_st":"ЧАЛАВЕК У ЗЯРКАЛЕ","title":"СПОРТШУЗЫ","image":"20221107/30be31d0d269ece9d671efcacc592d19.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'bg' => '[{"upper_st":"<span style=\"color:#ffffff\">ОЧИЛА<\/span>","lower_st":"<span style=\"color: #ffffff\">ГЛЕДАМ<\/span><span> <span style=\"color: #fcca19\">ПРИЛИЧЕН<\/span> <span style=\"color:#ffffff\">С<\/span> ","title":"<span style=\"color: #ffffff\">СЛЪНЧЕВИ ОЧИЛА<\/span>","image":"20221107/d1113f342bf7753ecf8688fd0dbde093.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"ОБУВКИ","lower_st":"ЧОВЕКЪТ В ОГЛЕДАЛОТО","title":"МАРАТОНКИ","image":"20221107/30be31d0d269ece9d671efcacc592d19.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'ca' => '[{"upper_st":"<span style=\"color:#ffffff\">ULLERES<\/span>","lower_st":"<span style=\"color: #ffffff\">MIRA<\/span><span> <span style=\"color: #fcca19\">FRED<\/span> <span style=\"color:#ffffff\">AMB<\/span> ","title":"<span style=\"color: #ffffff\">ULLERES DE SOL<\/span>","image":"20221107/d1113f342bf7753ecf8688fd0dbde093.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"CALÇAT","lower_st":"HOME AL MIRALL","title":"SNEAKERS","image":"20221107/30be31d0d269ece9d671efcacc592d19.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'et' => '[{"upper_st":"<span style=\"color:#ffffff\">PRILLID<\/span>","lower_st":"<span style=\"color: #ffffff\">VAATA<\/span><span> <span style=\"color: #fcca19\">JAHED<\/span> <span style=\"color:#ffffff\">KOOS<\/span> ","title":"<span style=\"color: #ffffff\">PÄIKSEPRILLID<\/span>","image":"20221107/d1113f342bf7753ecf8688fd0dbde093.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"JALANÕUD","lower_st":"MEES PEILIS","title":"JALGRATAS","image":"20221107/30be31d0d269ece9d671efcacc592d19.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
            'nl' => '[{"upper_st":"<span style=\"color:#ffffff\">BRILLEN<\/span>","lower_st":"<span style=\"color: #ffffff\">KIJK<\/span><span> <span style=\"color: #fcca19\">KOEL<\/span> <span style=\"color:#ffffff\">MET<\/span> ","title":"<span style=\"color: #ffffff\">ZONNEBRILLEN<\/span>","image":"20221107/d1113f342bf7753ecf8688fd0dbde093.webp","btn_text":"Koop nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"},{"upper_st":"SCHOEISEL","lower_st":"MAN IN DE SPIEGEL","title":"SNEAKERS","image":"20221107/30be31d0d269ece9d671efcacc592d19.webp","btn_text":"Koop nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Boxing%2C%20Martial%20Arts%20%26%20MMA"}]',
        ]));

        $this->updateLanguage('[{"upper_st":"MOST POPULAR","lower_st":"HEALTHY <span style=\"color: #E43147\">DIET<\/span> ","title":"FRUITS & VEGGIES","image":"20221115/47669d2f2236f1218e924d7c9c443e8c.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"SEAFOOD","lower_st":"<span style=\"color: #E43147\">IMPORTED<\/span> FROM ","title":"AUSTRALIA","image":"20221115/1e6c50bf9437f5cf4f86f9fe025547b8.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]', json_encode([
            'en' => '[{"upper_st":"MOST POPULAR","lower_st":"HEALTHY <span style=\"color: #E43147\">DIET<\/span> ","title":"FRUITS & VEGGIES","image":"20221115/47669d2f2236f1218e924d7c9c443e8c.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"SEAFOOD","lower_st":"<span style=\"color: #E43147\">IMPORTED<\/span> FROM ","title":"AUSTRALIA","image":"20221115/1e6c50bf9437f5cf4f86f9fe025547b8.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'bn' => '[{"upper_st":"সবচেয়ে জনপ্রিয়","lower_st":"সুস্থ <span style=\"color: #E43147\">ডায়েট<\/span> ","title":"ফল এবং শাকসবজি","image":"20221115/47669d2f2236f1218e924d7c9c443e8c.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"সমুদ্রী খাবার","lower_st":"<span style=\"color: #E43147\">আমদানি<\/span> থেকে ","title":"AUSTRALIA","image":"20221115/1e6c50bf9437f5cf4f86f9fe025547b8.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'fr' => '[{"upper_st":"LES PLUS POPULAIRES","lower_st":"SAIN <span style=\"color: #E43147\">RÉGIME<\/span> ","title":"FRUITS ET LÉGUMES","image":"20221115/47669d2f2236f1218e924d7c9c443e8c.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"FRUITS DE MER","lower_st":"<span style=\"color: #E43147\">IMPORTÉ<\/span> DE ","title":"AUSTRALIA","image":"20221115/1e6c50bf9437f5cf4f86f9fe025547b8.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'zh' => '[{"upper_st":"最受欢迎","lower_st":"健康 <span style=\"color: #E43147\">饮食<\/span> ","title":"水果和蔬菜","image":"20221115/47669d2f2236f1218e924d7c9c443e8c.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"海鲜","lower_st":"<span style=\"color: #E43147\">进口<\/span> 从 ","title":"AUSTRALIA","image":"20221115/1e6c50bf9437f5cf4f86f9fe025547b8.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'ar' => '[{"upper_st":"الأكثر شيوعا","lower_st":"صحي <span style=\"color: #E43147\">حمية<\/span> ","title":"فواكه وخضروات","image":"20221115/47669d2f2236f1218e924d7c9c443e8c.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"مأكولات بحرية","lower_st":"<span style=\"color: #E43147\">مستورد<\/span> من ","title":"AUSTRALIA","image":"20221115/1e6c50bf9437f5cf4f86f9fe025547b8.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'be' => '[{"upper_st":"САМЫЯ ПАПУЛЯРНЫЯ","lower_st":"ЗДАРОВАЕ <span style=\"color: #E43147\">ДЫЕТА<\/span> ","title":"ФРУКТЫ І САЛАТЫ","image":"20221115/47669d2f2236f1218e924d7c9c443e8c.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"МОРСКІЯ ПРАДУКЦЫІ","lower_st":"<span style=\"color: #E43147\">ІМПОРТ<\/span> З ","title":"AUSTRALIA","image":"20221115/1e6c50bf9437f5cf4f86f9fe025547b8.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'bg' => '[{"upper_st":"НАЙ-ПОПУЛЯРНИ","lower_st":"ЗДРАВОСЛОВЕН <span style=\"color: #E43147\">ДИЕТА<\/span> ","title":"ПЛОДОВЕ И ЗЕЛЕНЧУЦИ","image":"20221115/47669d2f2236f1218e924d7c9c443e8c.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"МОРСКИ ДАРОВЕ","lower_st":"<span style=\"color: #E43147\">ИМПОРТИРАНИ<\/span> ОТ ","title":"AUSTRALIA","image":"20221115/1e6c50bf9437f5cf4f86f9fe025547b8.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'ca' => '[{"upper_st":"ELS MÉS POPULARS","lower_st":"SALUDABLE <span style=\"color: #E43147\">DIETA<\/span> ","title":"FRUITES I VERDURES","image":"20221115/47669d2f2236f1218e924d7c9c443e8c.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"MARISC","lower_st":"<span style=\"color: #E43147\">IMPORTAT<\/span> DES DE ","title":"AUSTRALIA","image":"20221115/1e6c50bf9437f5cf4f86f9fe025547b8.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'et' => '[{"upper_st":"ENIM POPULAARNE","lower_st":"TERVE <span style=\"color: #E43147\">TOITUMINE<\/span> ","title":"PUUVILJAD JA KÖÖGIVILJAD","image":"20221115/47669d2f2236f1218e924d7c9c443e8c.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"MERETOIDUD","lower_st":"<span style=\"color: #E43147\">IMPORTEERITUD<\/span> ALATES ","title":"AUSTRALIA","image":"20221115/1e6c50bf9437f5cf4f86f9fe025547b8.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'nl' => '[{"upper_st":"MEEST POPULAIR","lower_st":"GEZOND <span style=\"color: #E43147\">DIEET<\/span> ","title":"FRUIT EN GROENTEN","image":"20221115/47669d2f2236f1218e924d7c9c443e8c.webp","btn_text":"Koop nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"ZEEVRUCHTEN","lower_st":"<span style=\"color: #E43147\">GEÏMPORTEERD<\/span> VAN ","title":"AUSTRALIA","image":"20221115/1e6c50bf9437f5cf4f86f9fe025547b8.webp","btn_text":"Koop nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
        ]));

        $this->updateLanguage('[{"image":"20221115/de33eec9500a50ee5d6f714d31e98094.webp","title":"Free Shipping Worldwide","subtitle":"For all orders over $350"},{"image":"20221115/4357b3a08c4e65913301c7a2f57fcaac.webp","title":"Secured Online Payment","subtitle":"Payment protection guaranteed"},{"image":"20221115/343206d91dbb2e9ad17f2d2d38230c75.webp","title":"Money Back Guarantee","subtitle":"If goods have problems"}]', json_encode([
            'en' => '[{"image":"20221115/de33eec9500a50ee5d6f714d31e98094.webp","title":"Free Shipping Worldwide","subtitle":"For all orders over $350"},{"image":"20221115/4357b3a08c4e65913301c7a2f57fcaac.webp","title":"Secured Online Payment","subtitle":"Payment protection guaranteed"},{"image":"20221115/343206d91dbb2e9ad17f2d2d38230c75.webp","title":"Money Back Guarantee","subtitle":"If goods have problems"}]',
            'bn' => '[{"image":"20221115/de33eec9500a50ee5d6f714d31e98094.webp","title":"বিশ্বব্যাপী বিনামূল্যে শিপিং","subtitle":"$350 এর উপরের সমস্ত আদেশের জন্য"},{"image":"20221115/4357b3a08c4e65913301c7a2f57fcaac.webp","title":"নিরাপদ অনলাইন পেমেন্ট","subtitle":"অর্থ সংরক্ষণ নিশ্চিত"},{"image":"20221115/343206d91dbb2e9ad17f2d2d38230c75.webp","title":"অর্থ ফেরত গ্যারান্টি","subtitle":"যদি পণ্যে সমস্যা থাকে"}]',
            'fr' => '[{"image":"20221115/de33eec9500a50ee5d6f714d31e98094.webp","title":"Livraison gratuite dans le monde entier","subtitle":"Pour toutes les commandes de plus de 350 $"},{"image":"20221115/4357b3a08c4e65913301c7a2f57fcaac.webp","title":"Paiement en ligne sécurisé","subtitle":"Protection des paiements garantie"},{"image":"20221115/343206d91dbb2e9ad17f2d2d38230c75.webp","title":"Garantie de remboursement","subtitle":"Si les marchandises ont des problèmes"}]',
            'zh' => '[{"image":"20221115/de33eec9500a50ee5d6f714d31e98094.webp","title":"全球免费送货","subtitle":"所有订单超过$350"},{"image":"20221115/4357b3a08c4e65913301c7a2f57fcaac.webp","title":"安全的在线支付","subtitle":"付款保护保证"},{"image":"20221115/343206d91dbb2e9ad17f2d2d38230c75.webp","title":"退款保证","subtitle":"如果商品有问题"}]',
            'ar' => '[{"image":"20221115/de33eec9500a50ee5d6f714d31e98094.webp","title":"الشحن المجاني في جميع أنحاء العالم","subtitle":"لجميع الطلبات التي تزيد عن 350 دولار"},{"image":"20221115/4357b3a08c4e65913301c7a2f57fcaac.webp","title":"الدفع الآمن عبر الإنترنت","subtitle":"ضمان حماية الدفع"},{"image":"20221115/343206d91dbb2e9ad17f2d2d38230c75.webp","title":"ضمان استعادة الأموال","subtitle":"إذا كانت السلع تواجه مشكلة"}]',
            'be' => '[{"image":"20221115/de33eec9500a50ee5d6f714d31e98094.webp","title":"Бясплатная дастаўка па ўсім свеце","subtitle":"Для ўсіх заказаў на суму больш за $350"},{"image":"20221115/4357b3a08c4e65913301c7a2f57fcaac.webp","title":"Бяспечная анлайн-аплата","subtitle":"Гарантыя абароны плацяжу"},{"image":"20221115/343206d91dbb2e9ad17f2d2d38230c75.webp","title":"Гарантыя вяртання грошай","subtitle":"Калі ёсць праблемы з таварамі"}]',
            'bg' => '[{"image":"20221115/de33eec9500a50ee5d6f714d31e98094.webp","title":"Безплатна доставка по целия свят","subtitle":"За всички поръчки над $350"},{"image":"20221115/4357b3a08c4e65913301c7a2f57fcaac.webp","title":"Сигурно онлайн плащане","subtitle":"Гарантирана защита на плащането"},{"image":"20221115/343206d91dbb2e9ad17f2d2d38230c75.webp","title":"Гаранция за връщане на парите","subtitle":"Ако стоките имат проблеми"}]',
            'ca' => '[{"image":"20221115/de33eec9500a50ee5d6f714d31e98094.webp","title":"Envío gratis a todo el mundo","subtitle":"Per a totes les comandes superiors a 350 $"},{"image":"20221115/4357b3a08c4e65913301c7a2f57fcaac.webp","title":"Pagament en línia segur","subtitle":"Garantia de protecció del pagament"},{"image":"20221115/343206d91dbb2e9ad17f2d2d38230c75.webp","title":"Garantia de devolució de diners","subtitle":"Si els productes tenen problemes"}]',
            'et' => '[{"image":"20221115/de33eec9500a50ee5d6f714d31e98094.webp","title":"Tasuta kohaletoimetamine üle maailma","subtitle":"Kõigi tellimuste puhul üle $350"},{"image":"20221115/4357b3a08c4e65913301c7a2f57fcaac.webp","title":"Turvaline veebimakse","subtitle":"Maksekaitsmise tagatud"},{"image":"20221115/343206d91dbb2e9ad17f2d2d38230c75.webp","title":"Raha tagastamise garantii","subtitle":"Kui kaupadel on probleeme"}]',
            'nl' => '[{"image":"20221115/de33eec9500a50ee5d6f714d31e98094.webp","title":"Gratis verzending wereldwijd","subtitle":"Voor alle bestellingen boven $350"},{"image":"20221115/4357b3a08c4e65913301c7a2f57fcaac.webp","title":"Veilige online betaling","subtitle":"Betaalbescherming gegarandeerd"},{"image":"20221115/343206d91dbb2e9ad17f2d2d38230c75.webp","title":"Geld-terug-garantie","subtitle":"Als de goederen problemen hebben"}]',
        ]));

        $this->updateLanguage('{"title":"New Here?","sidetext":"Get Coupon","description":"Use coupon <strong>\u2018BUYNOW01\u2019<\/strong>\r\nand get up to $200 on your\r\nfirst purchase."}', json_encode([
            'en' => '{"title":"New Here?","sidetext":"Get Coupon","description":"Use coupon <strong>\u2018BUYNOW01\u2019<\/strong>\r\nand get up to $200 on your\r\nfirst purchase."}',
            'bn' => '{"title":"এখানে নতুন?","sidetext":"কুপন পান","description":"কুপন ব্যবহার করুন <strong>\u2018BUYNOW01\u2019<\/strong>\r\nএবং আপনার উপর পৌঁছে যান $200\r\nপ্রথম ক্রয়।"}',
            'fr' => '{"title":"Nouveau ici ?","sidetext":"Obtenez le coupon","description":"Utiliser le coupon <strong>\u2018BUYNOW01\u2019<\/strong>\r\net obtenez jusqu\'à 200 $ sur votre\r\npremier achat."}',
            'zh' => '{"title":"新来的？","sidetext":"获取优惠券","description":"使用优惠券 <strong>\u2018BUYNOW01\u2019<\/strong>\r\n并在您的上获得高达$200\r\n第一次购买。"}',
            'ar' => '{"title":"هل أنت جديد هنا؟","sidetext":"احصل على القسيمة","description":"استخدم القسيمة <strong>\u2018BUYNOW01\u2019<\/strong>\r\nواحصل على ما يصل إلى 200 دولار على\r\nالشراء الأول."}',
            'be' => '{"title":"Новы тут?","sidetext":"Атрымаць купон","description":"Выкарыстоўвайце купон <strong>\u2018BUYNOW01\u2019<\/strong>\r\nі атрымліваць да $200 на ваш\r\nперша пакупка."}',
            'bg' => '{"title":"Нов тук?","sidetext":"Вземете купон","description":"Използвайте купона <strong>\u2018BUYNOW01\u2019<\/strong>\r\nи получете до $200 на вашата\r\nпървата покупка."}',
            'ca' => '{"title":"Nou aquí?","sidetext":"Aconsegueix el cupó","description":"Utilitza el cupó <strong>\u2018BUYNOW01\u2019<\/strong>\r\ni aconsegueix fins a 200 $ en el teu\r\nprimera compra."}',
            'et' => '{"title":"Uus siin?","sidetext":"Saage kupong","description":"Kasutage kupongi <strong>\u2018BUYNOW01\u2019<\/strong>\r\nja saate kuni 200 $ oma\r\nesimene ost."}',
            'nl' => '{"title":"Nieuw hier?","sidetext":"Krijg coupon","description":"Gebruik coupon <strong>\u2018BUYNOW01\u2019<\/strong>\r\nen krijg tot $200 op uw\r\neerste aankoop."}',
        ]));

        $this->updateLanguage('Starting from only <span style="color: #FA886A">$2.99</span>', json_encode([
            'en' => 'Starting from only <span style="color: #FA886A">$2.99<\/span>',
            'bn' => 'শুরু করুন মাত্র <span style="color: #FA886A">$2.99<\/span>',
            'fr' => 'À partir de seulement <span style="color: #FA886A">$2.99<\/span>',
            'zh' => '仅售 <span style="color: #FA886A">$2.99<\/span>',
            'ar' => 'ابتداء من فقط <span style="color: #FA886A">$2.99<\/span>',
            'be' => 'Пачынаючы ад толькі <span style="color: #FA886A">$2.99<\/span>',
            'bg' => 'Започвайки само от <span style="color: #FA886A">$2.99<\/span>',
            'ca' => 'A partir de només <span style="color: #FA886A">$2.99<\/span>',
            'et' => 'Ainult alates <span style="color: #FA886A">$2.99<\/span>',
            'nl' => 'Vanaf slechts <span style="color: #FA886A">$2.99<\/span>',
        ]));

        $this->updateLanguage('[{"upper_st":"<span style=\"color: #ffffff\">CANDY<\/span>","lower_st":"<span style=\"color: #ffffff\">FOR YOUR<\/span> <span style=\"color: #FFDD65\">SWEET TOOTH <\/span>","title":"<span style=\"color: #ffffff\">JAEDO SWEETS<\/span>","image":"20221115/c63276d804ca3ae64d13cf253cd4af2c.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"MEAT","lower_st":"<span style=\"color:#E43147\">ASIA\u2019S<\/span> FAMOUS ","title":"SAOLA BEEF","image":"20221115/9bda56104303d4d958ef32b8543cb31a.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]', json_encode([
            'en' => '[{"upper_st":"<span style=\\"color: #ffffff\\">CANDY<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">FOR YOUR<\\/span> <span style=\\"color: #FFDD65\\">SWEET TOOTH <\\/span>","title":"<span style=\\"color: #ffffff\\">JAEDO SWEETS<\\/span>","image":"20221115/c63276d804ca3ae64d13cf253cd4af2c.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"MEAT","lower_st":"<span style=\\"color:#E43147\\">ASIA\\u2019S<\\/span> FAMOUS ","title":"SAOLA BEEF","image":"20221115/9bda56104303d4d958ef32b8543cb31a.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'bn' => '[{"upper_st":"<span style=\\"color: #ffffff\\">মিষ্টি<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">আপনার জন্য<\\/span> <span style=\\"color: #FFDD65\\">মিষ্টি পচন্দ <\\/span>","title":"<span style=\\"color: #ffffff\\">JAEDO মিষ্টি<\\/span>","image":"20221115/c63276d804ca3ae64d13cf253cd4af2c.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"মাংস","lower_st":"<span style=\\"color:#E43147\\">এশিয়া\\u2019S<\\/span> বিখ্যাত ","title":"SAOLA গরুর মাংস","image":"20221115/9bda56104303d4d958ef32b8543cb31a.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'fr' => '[{"upper_st":"<span style=\\"color: #ffffff\\">BONBON<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">POUR VOTRE<\\/span> <span style=\\"color: #FFDD65\\">GOURMANDISE <\\/span>","title":"<span style=\\"color: #ffffff\\">SUCRERIES JAEDO<\\/span>","image":"20221115/c63276d804ca3ae64d13cf253cd4af2c.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"VIANDE","lower_st":"<span style=\\"color:#E43147\\">ASIE\\u2019S<\\/span> FAMEUX ","title":"SAOLA BOEUF","image":"20221115/9bda56104303d4d958ef32b8543cb31a.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'zh' => '[{"upper_st":"<span style=\\"color: #ffffff\\">糖果<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">为您的<\\/span> <span style=\\"color: #FFDD65\\">甜蜜的牙齿 <\\/span>","title":"<span style=\\"color: #ffffff\\">JAEDO糖果<\\/span>","image":"20221115/c63276d804ca3ae64d13cf253cd4af2c.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"肉","lower_st":"<span style=\\"color:#E43147\\">亚洲\\u2019S<\\/span> 著名的 ","title":"SAOLA 牛肉","image":"20221115/9bda56104303d4d958ef32b8543cb31a.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'ar' => '[{"upper_st":"<span style=\\"color: #ffffff\\">حلوى<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">لك<\\/span> <span style=\\"color: #FFDD65\\">محبوب الحلوى <\\/span>","title":"<span style=\\"color: #ffffff\\">حلوى JAEDO<\\/span>","image":"20221115/c63276d804ca3ae64d13cf253cd4af2c.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"لحوم","lower_st":"<span style=\\"color:#E43147\\">آسيا\\u2019S<\\/span> مشهور ","title":"SAOLA لحم بقري","image":"20221115/9bda56104303d4d958ef32b8543cb31a.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'be' => '[{"upper_st":"<span style=\\"color: #ffffff\\">ЦУКЕРКІ<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">ДЛЯ ТВАЁГА<\\/span> <span style=\\"color: #FFDD65\\">СЛАДКАЯ ЧЭМПІЁН <\\/span>","title":"<span style=\\"color: #ffffff\\">ЦУКЕРКІ JAEDO<\\/span>","image":"20221115/c63276d804ca3ae64d13cf253cd4af2c.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"МЯСА","lower_st":"<span style=\\"color:#E43147\\">АЗІЯ\\u2019S<\\/span> ЗНАМЕНІТЫ ","title":"SAOLA МЯСА","image":"20221115/9bda56104303d4d958ef32b8543cb31a.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'bg' => '[{"upper_st":"<span style=\\"color: #ffffff\\">БОНБОНИ<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">ЗА ТВОЕТО<\\/span> <span style=\\"color: #FFDD65\\">СЛАДКАРСКИ ПРЕДПОЧИТАНИЯ <\\/span>","title":"<span style=\\"color: #ffffff\\">БОНБОНИ JAEDO<\\/span>","image":"20221115/c63276d804ca3ae64d13cf253cd4af2c.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"МЕСО","lower_st":"<span style=\\"color:#E43147\\">АЗИЯ\\u2019S<\\/span> ИЗВЕСТНИ ","title":"SAOLA ГОВЕЖДИНА","image":"20221115/9bda56104303d4d958ef32b8543cb31a.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'ca' => '[{"upper_st":"<span style=\\"color: #ffffff\\">CARAMEL·LA<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">PER A<\\/span> <span style=\\"color: #FFDD65\\">DOLÇA DENT <\\/span>","title":"<span style=\\"color: #ffffff\\">CARAMELS JAEDO<\\/span>","image":"20221115/c63276d804ca3ae64d13cf253cd4af2c.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"CARN","lower_st":"<span style=\\"color:#E43147\\">ÀSIA\\u2019S<\\/span> FAMÓS ","title":"SAOLA BOVÍ","image":"20221115/9bda56104303d4d958ef32b8543cb31a.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'et' => '[{"upper_st":"<span style=\\"color: #ffffff\\">MAIUSTUSED<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">SINULE<\\/span> <span style=\\"color: #FFDD65\\">MAGUS HAMMAS <\\/span>","title":"<span style=\\"color: #ffffff\\">MAGUSAD KOMMID JAEDO<\\/span>","image":"20221115/c63276d804ca3ae64d13cf253cd4af2c.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"LIHA","lower_st":"<span style=\\"color:#E43147\\">AASIA\\u2019S<\\/span> TUNTUD ","title":"SAOLA VEISELIHA","image":"20221115/9bda56104303d4d958ef32b8543cb31a.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'nl' => '[{"upper_st":"<span style=\\"color: #ffffff\\">SNOEP<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">VOOR JE<\\/span> <span style=\\"color: #FFDD65\\">ZOEKTOCHT NAAR ZOETIGHEID <\\/span>","title":"<span style=\\"color: #ffffff\\">JAEDO SNOEPJES<\\/span>","image":"20221115/c63276d804ca3ae64d13cf253cd4af2c.webp","btn_text":"Koop nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"VLEES","lower_st":"<span style=\\"color:#E43147\\">AZIË\\u2019S<\\/span> Beroemd ","title":"SAOLA RUNDVLEES","image":"20221115/9bda56104303d4d958ef32b8543cb31a.webp","btn_text":"Koop nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
        ]));

        $this->updateLanguage('[{"upper_st":"<span style=\"color: #ffffff\">NEW ARRIVALS<\/span>","lower_st":"<span style=\"color: #ffffff\">FOR THE<\/span> <span style=\"color: #FCCA19\">HIP HOP<\/span>","title":"<span style=\"color: #ffffff\">EYE GLASSES<\/span>","image":"20221115/889abd76efd884e3f75378f0eebb8dca.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"WINTER","lower_st":"<span style=\"color:#E43147\">IMPORTED<\/span> DENIM","title":"JACKETS","image":"20221115/4217f404a18a9c0f1d63d6f780c0ffad.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]', json_encode([
            'en' => '[{"upper_st":"<span style=\\"color: #ffffff\\">NEW ARRIVALS<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">FOR THE<\\/span> <span style=\\"color: #FCCA19\\">HIP HOP<\\/span>","title":"<span style=\\"color: #ffffff\\">EYE GLASSES<\\/span>","image":"20221115/889abd76efd884e3f75378f0eebb8dca.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"WINTER","lower_st":"<span style=\\"color:#E43147\\">IMPORTED<\\/span> DENIM","title":"JACKETS","image":"20221115/4217f404a18a9c0f1d63d6f780c0ffad.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'bn' => '[{"upper_st":"<span style=\\"color: #ffffff\\">নতুন আগমন<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">জন্য<\\/span> <span style=\\"color: #FCCA19\\">হিপ হপ<\\/span>","title":"<span style=\\"color: #ffffff\\">চশমা<\\/span>","image":"20221115/889abd76efd884e3f75378f0eebb8dca.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"শীতকাল","lower_st":"<span style=\\"color:#E43147\\">আমদানি<\\/span> ডেনিম","title":"জ্যাকেট","image":"20221115/4217f404a18a9c0f1d63d6f780c0ffad.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'fr' => '[{"upper_st":"<span style=\\"color: #ffffff\\">NOUVEAUTÉS<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">POUR LE<\\/span> <span style=\\"color: #FCCA19\\">HIP HOP<\\/span>","title":"<span style=\\"color: #ffffff\\">LUNETTES<\\/span>","image":"20221115/889abd76efd884e3f75378f0eebb8dca.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"HIVER","lower_st":"<span style=\\"color:#E43147\\">IMPORTÉ<\\/span> DENIM","title":"VESTES","image":"20221115/4217f404a18a9c0f1d63d6f780c0ffad.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'zh' => '[{"upper_st":"<span style=\\"color: #ffffff\\">新品上市<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">为了<\\/span> <span style=\\"color: #FCCA19\\">嘻哈<\\/span>","title":"<span style=\\"color: #ffffff\\">眼镜<\\/span>","image":"20221115/889abd76efd884e3f75378f0eebb8dca.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"冬季","lower_st":"<span style=\\"color:#E43147\\">进口<\\/span> 牛仔布","title":"夹克","image":"20221115/4217f404a18a9c0f1d63d6f780c0ffad.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'ar' => '[{"upper_st":"<span style=\\"color: #ffffff\\">وصل حديثا<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">لل<\\/span> <span style=\\"color: #FCCA19\\">الهيب هوب<\\/span>","title":"<span style=\\"color: #ffffff\\">نظارات<\\/span>","image":"20221115/889abd76efd884e3f75378f0eebb8dca.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"الشتاء","lower_st":"<span style=\\"color:#E43147\\">مستورد<\\/span> الدينيم","title":"سترات","image":"20221115/4217f404a18a9c0f1d63d6f780c0ffad.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'be' => '[{"upper_st":"<span style=\\"color: #ffffff\\">НОВЫЯ ПРЫБЫЦЦІ<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">ДЛЯ<\\/span> <span style=\\"color: #FCCA19\\">ХІП-ХОП<\\/span>","title":"<span style=\\"color: #ffffff\\">АКСЭСУАРЫ ДЛЯ ВАС<\\/span>","image":"20221115/889abd76efd884e3f75378f0eebb8dca.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"ЗІМА","lower_st":"<span style=\\"color:#E43147\\">ІМПОРТ<\\/span> ДЭНІМ","title":"КУРТКІ","image":"20221115/4217f404a18a9c0f1d63d6f780c0ffad.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'bg' => '[{"upper_st":"<span style=\\"color: #ffffff\\">НОВИ ПРИБИЖВАНИЯ<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">ЗА<\\/span> <span style=\\"color: #FCCA19\\">ХИП ХОП<\\/span>","title":"<span style=\\"color: #ffffff\\">ОЧИЛА<\\/span>","image":"20221115/889abd76efd884e3f75378f0eebb8dca.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"ЗИМА","lower_st":"<span style=\\"color:#E43147\\">ИМПОРТИРАНИ<\\/span> ДЪНКИ","title":"ЯКЕТА","image":"20221115/4217f404a18a9c0f1d63d6f780c0ffad.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'ca' => '[{"upper_st":"<span style=\\"color: #ffffff\\">NOVETATS<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">PER A<\\/span> <span style=\\"color: #FCCA19\\">HIP HOP<\\/span>","title":"<span style=\\"color: #ffffff\\">ULLERES<\\/span>","image":"20221115/889abd76efd884e3f75378f0eebb8dca.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"HIVERN","lower_st":"<span style=\\"color:#E43147\\">IMPORTAT<\\/span> DENIM","title":"JACKETS","image":"20221115/4217f404a18a9c0f1d63d6f780c0ffad.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'et' => '[{"upper_st":"<span style=\\"color: #ffffff\\">UUED SAABUMISED<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">JAOKS<\\/span> <span style=\\"color: #FCCA19\\">HIP HOP<\\/span>","title":"<span style=\\"color: #ffffff\\">PRILLID<\\/span>","image":"20221115/889abd76efd884e3f75378f0eebb8dca.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"TALV","lower_st":"<span style=\\"color:#E43147\\">IMPORTEERITUD<\\/span> TEKSAD","title":"JOPED","image":"20221115/4217f404a18a9c0f1d63d6f780c0ffad.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'nl' => '[{"upper_st":"<span style=\\"color: #ffffff\\">NIEUWE AANKOMSTEN<\\/span>","lower_st":"<span style=\\"color: #ffffff\\">VOOR DE<\\/span> <span style=\\"color: #FCCA19\\">HIP HOP<\\/span>","title":"<span style=\\"color: #ffffff\\">BRILLEN<\\/span>","image":"20221115/889abd76efd884e3f75378f0eebb8dca.webp","btn_text":"Koop nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"WINTER","lower_st":"<span style=\\"color:#E43147\\">GEÏMPORTEERD<\\/span> DENIM","title":"JASSEN","image":"20221115/4217f404a18a9c0f1d63d6f780c0ffad.webp","btn_text":"Koop nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
        ]));

        $this->updateLanguage('[{"upper_st":"SPORTS","lower_st":"COMING <span style=\"color: #E43147\">THIS WINTER <span>","title":"X-SPORTS ZONE","image":"20221115/2b7c80046bfaa9c555a878de6da85cbd.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"},{"upper_st":"TOYS","lower_st":"PUT A <span style=\"color: #E43147\">SMILE<\/span> ON ","title":"YOUR CHILD","image":"20221115/f7599dd4257cab7744c95817c5dd055e.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"}]', json_encode([
            'en' => '[{"upper_st":"SPORTS","lower_st":"COMING <span style=\\"color: #E43147\\">THIS WINTER <span>","title":"X-SPORTS ZONE","image":"20221115/2b7c80046bfaa9c555a878de6da85cbd.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"},{"upper_st":"TOYS","lower_st":"PUT A <span style=\\"color: #E43147\\">SMILE<\\/span> ON ","title":"YOUR CHILD","image":"20221115/f7599dd4257cab7744c95817c5dd055e.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"}]',
            'bn' => '[{"upper_st":"SPORTS","lower_st":"আসছে <span style=\\"color: #E43147\\">এই শীতে <span>","title":"এক্স-স্পোর্টস জোন","image":"20221115/2b7c80046bfaa9c555a878de6da85cbd.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"},{"upper_st":"খেলনা","lower_st":"একটি <span style=\\"color: #E43147\\">হাসি<\\/span> উপর ","title":"তোমার শিশু","image":"20221115/f7599dd4257cab7744c95817c5dd055e.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"}]',
            'fr' => '[{"upper_st":"SPORTS","lower_st":"ARRIVÉE <span style=\\"color: #E43147\\">CET HIVER <span>","title":"ZSURE X-SPORTS","image":"20221115/2b7c80046bfaa9c555a878de6da85cbd.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"},{"upper_st":"JOUETS","lower_st":"METTRE UN <span style=\\"color: #E43147\\">SOURIRE<\\/span> SUR ","title":"VOTRE ENFANT","image":"20221115/f7599dd4257cab7744c95817c5dd055e.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"}]',
            'zh' => '[{"upper_st":"SPORTS","lower_st":"即将到来 <span style=\\"color: #E43147\\">这个冬天 <span>","title":"X-运动区","image":"20221115/2b7c80046bfaa9c555a878de6da85cbd.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"},{"upper_st":"玩具","lower_st":"放一个 <span style=\\"color: #E43147\\">微笑<\\/span> 上 ","title":"你的孩子","image":"20221115/f7599dd4257cab7744c95817c5dd055e.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"}]',
            'ar' => '[{"upper_st":"SPORTS","lower_st":"قادم <span style=\\"color: #E43147\\">هذا الشتاء <span>","title":"منطقة الرياضة X","image":"20221115/2b7c80046bfaa9c555a878de6da85cbd.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"},{"upper_st":"الألعاب","lower_st":"وضع <span style=\\"color: #E43147\\">ابتسامة<\\/span> على ","title":"طفلك","image":"20221115/f7599dd4257cab7744c95817c5dd055e.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"}]',
            'be' => '[{"upper_st":"SPORTS","lower_st":"ПРЫЕЗД <span style=\\"color: #E43147\\">ГЭТА ЗІМА <span>","title":"X-ЗОНА СПОРТУ","image":"20221115/2b7c80046bfaa9c555a878de6da85cbd.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"},{"upper_st":"ІГРАШКІ","lower_st":"ПАСТАВІЦЬ <span style=\\"color: #E43147\\">УСМІХ<\\/span> На ","title":"ВАШАЕ ДЗЯЦЯ","image":"20221115/f7599dd4257cab7744c95817c5dd055e.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"}]',
            'bg' => '[{"upper_st":"SPORTS","lower_st":"ПРИШЕЛЕЦ <span style=\\"color: #E43147\\">ТОЗИ ЗИМА <span>","title":"X-СПОРТНА ЗОНА","image":"20221115/2b7c80046bfaa9c555a878de6da85cbd.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"},{"upper_st":"ИГРАЧКИ","lower_st":"ПОСТАВЕТЕ ЕДИН <span style=\\"color: #E43147\\">УСМИВКА<\\/span> ВЪРХУ ","title":"ТВОЕТО ДЕТЕ","image":"20221115/f7599dd4257cab7744c95817c5dd055e.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"}]',
            'ca' => '[{"upper_st":"SPORTS","lower_st":"VENINT <span style=\\"color: #E43147\\">AQUEST HIVERN <span>","title":"ZENA D\'ESPORTS X","image":"20221115/2b7c80046bfaa9c555a878de6da85cbd.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"},{"upper_st":"JUGUETS","lower_st":"POSAR UN <span style=\\"color: #E43147\\">Somriure<\\/span> EN ","title":"EL TEU FIL","image":"20221115/f7599dd4257cab7744c95817c5dd055e.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"}]',
            'et' => '[{"upper_st":"SPORTS","lower_st":"TULEMAS <span style=\\"color: #E43147\\">SEE TALV <span>","title":"X-SPORDI TSOPEALE","image":"20221115/2b7c80046bfaa9c555a878de6da85cbd.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"},{"upper_st":"MÄNGUASJAD","lower_st":"PANE <span style=\\"color: #E43147\\">NAERATUS<\\/span> PEALE ","title":"SINU LAPSE","image":"20221115/f7599dd4257cab7744c95817c5dd055e.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"}]',
            'nl' => '[{"upper_st":"SPORTS","lower_st":"KOMT ERAAN <span style=\\"color: #E43147\\">DEZE WINTER <span>","title":"X-SPORTZOPE","image":"20221115/2b7c80046bfaa9c555a878de6da85cbd.webp","btn_text":"Koop nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"},{"upper_st":"SPEELGOED","lower_st":"ZET EEN <span style=\\"color: #E43147\\">GLIMLACH<\\/span> OP ","title":"JE KIND","image":"20221115/f7599dd4257cab7744c95817c5dd055e.webp","btn_text":"Koop nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Sports%20%26%20Outdoor"}]',
        ]));

        $this->updateLanguage('{"u_subtitle":"SALES","l_subtitle":"<span style=\"color: #E43147\">DISCOUNT<\/span>  UP TO","title":"50% OFF","image":"20221123/57f19d8d2afae6da03b1c11642fda166.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}', json_encode([
            'en' => '{"u_subtitle":"SALES","l_subtitle":"<span style=\\"color: #E43147\\">DISCOUNT<\\/span>  UP TO","title":"50% OFF","image":"20221123/57f19d8d2afae6da03b1c11642fda166.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'bn' => '{"u_subtitle":"বিক্রয়","l_subtitle":"<span style=\\"color: #E43147\\">ডিসকাউন্ট<\\/span>  পর্যন্ত","title":"50% ছাড়","image":"20221123/57f19d8d2afae6da03b1c11642fda166.webp","button":"এখনই কিনুন","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'fr' => '{"u_subtitle":"VENTES","l_subtitle":"<span style=\\"color: #E43147\\">RÉDUCTION<\\/span>  JUSQU\'À","title":"50% DE RÉDUCTION","image":"20221123/57f19d8d2afae6da03b1c11642fda166.webp","button":"Achetez maintenant","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'zh' => '{"u_subtitle":"销售","l_subtitle":"<span style=\\"color: #E43147\\">折扣<\\/span>  最高达","title":"50%折扣","image":"20221123/57f19d8d2afae6da03b1c11642fda166.webp","button":"现在购物","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'ar' => '{"u_subtitle":"مبيعات","l_subtitle":"<span style=\\"color: #E43147\\">خصم<\\/span>  حتى","title":"خصم 50%","image":"20221123/57f19d8d2afae6da03b1c11642fda166.webp","button":"تسوق الآن","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'be' => '{"u_subtitle":"ПРОДАЖЫ","l_subtitle":"<span style=\\"color: #E43147\\">СКІДКА<\\/span>  ДА","title":"ЗНІЖКА 50%","image":"20221123/57f19d8d2afae6da03b1c11642fda166.webp","button":"КУПІЦЬ ЗАРАЗ","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'bg' => '{"u_subtitle":"ПРОДАЖБИ","l_subtitle":"<span style=\\"color: #E43147\\">ОТСТЪПКА<\\/span>  ДО","title":"50% ОТСТЪПКА","image":"20221123/57f19d8d2afae6da03b1c11642fda166.webp","button":"ПАЗАРУВАЙТЕ СЕГА","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'ca' => '{"u_subtitle":"VENDES","l_subtitle":"<span style=\\"color: #E43147\\">DESCOMPTE<\\/span>  FINS A","title":"DESCOMPTE DEL 50%","image":"20221123/57f19d8d2afae6da03b1c11642fda166.webp","button":"Compra ara","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'et' => '{"u_subtitle":"MÜÜK","l_subtitle":"<span style=\\"color: #E43147\\">ALLAHINDLUS<\\/span>  KUNI","title":"50% ALLAHINDLUS","image":"20221123/57f19d8d2afae6da03b1c11642fda166.webp","button":"Osta kohe","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'nl' => '{"u_subtitle":"VERKOOP","l_subtitle":"<span style=\\"color: #E43147\\">KORTING<\\/span>  TOT","title":"50% KORTING","image":"20221123/57f19d8d2afae6da03b1c11642fda166.webp","button":"Koop nu","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
        ]));

        $this->updateLanguage('[{"image":"20221115/1ca14385d26b77fde54795e153171f43.webp","title":"Free Shipping <br> Worldwide","subtitle":"For all orders over $350"},{"image":"20221115/ffd9701a8c39fd929f2425cef82f3182.webp","title":"Secured Online <br> Payment","subtitle":"Payment protection guaranteed"},{"image":"20221115/25bc0b939a75406c6e341f55936ff5d1.webp","title":"Money Back <br> Guarantee","subtitle":"If goods have problems"}]', json_encode([
            'en' => '[{"image":"20221115/1ca14385d26b77fde54795e153171f43.webp","title":"Free Shipping <br> Worldwide","subtitle":"For all orders over $350"},{"image":"20221115/ffd9701a8c39fd929f2425cef82f3182.webp","title":"Secured Online <br> Payment","subtitle":"Payment protection guaranteed"},{"image":"20221115/25bc0b939a75406c6e341f55936ff5d1.webp","title":"Money Back <br> Guarantee","subtitle":"If goods have problems"}]',
            'bn' => '[{"image":"20221115/1ca14385d26b77fde54795e153171f43.webp","title":"বিনামূল্যে শিপিং <br> বিশ্বব্যাপী","subtitle":"সমস্ত অর্ডারের জন্য প্রযোজ্য $350 এর উপরে"},{"image":"20221115/ffd9701a8c39fd929f2425cef82f3182.webp","title":"নিরাপদ অনলাইনে <br> Payment","subtitle":"অর্থ প্রদান সুরক্ষা নিশ্চিত"},{"image":"20221115/25bc0b939a75406c6e341f55936ff5d1.webp","title":"টাকা পিছনে দিন <br> গ্যারান্টি","subtitle":"যদি মাল সমস্যা থাকে"}]',
            'fr' => '[{"image":"20221115/1ca14385d26b77fde54795e153171f43.webp","title":"Livraison gratuite <br> Mondial","subtitle":"Pour toutes les commandes de plus de 350 $"},{"image":"20221115/ffd9701a8c39fd929f2425cef82f3182.webp","title":"En ligne sécurisé <br> Payment","subtitle":"Protection de paiement garantie"},{"image":"20221115/25bc0b939a75406c6e341f55936ff5d1.webp","title":"Argent remis <br> Garantie","subtitle":"Si les produits ont des problèmes"}]',
            'zh' => '[{"image":"20221115/1ca14385d26b77fde54795e153171f43.webp","title":"免费运送 <br> 全球","subtitle":"所有订单满350美元免邮费"},{"image":"20221115/ffd9701a8c39fd929f2425cef82f3182.webp","title":"在线保护 <br> Payment","subtitle":"支付保护有保障"},{"image":"20221115/25bc0b939a75406c6e341f55936ff5d1.webp","title":"退款 <br> 保证","subtitle":"如果商品有问题"}]',
            'ar' => '[{"image":"20221115/1ca14385d26b77fde54795e153171f43.webp","title":"الشحن مجانا <br> عالمي","subtitle":"لجميع الطلبات التي تزيد عن 350 دولارًا"},{"image":"20221115/ffd9701a8c39fd929f2425cef82f3182.webp","title":"عبر الإنترنت بأمان <br> Payment","subtitle":"ضمان حماية الدفع"},{"image":"20221115/25bc0b939a75406c6e341f55936ff5d1.webp","title":"استرداد الأموال <br> ضمان","subtitle":"إذا كانت السلع لديها مشاكل"}]',
            'be' => '[{"image":"20221115/1ca14385d26b77fde54795e153171f43.webp","title":"Бясплатная дастаўка <br> Па ўсім свеце","subtitle":"Для ўсіх заказаў па $350 і больш"},{"image":"20221115/ffd9701a8c39fd929f2425cef82f3182.webp","title":"Бяспечнае онлайн <br> Payment","subtitle":"Гарантаваная абарона аплаты"},{"image":"20221115/25bc0b939a75406c6e341f55936ff5d1.webp","title":"Грошы назад <br> Гарантыя","subtitle":"Калі тавары маюць праблемы"}]',
            'bg' => '[{"image":"20221115/1ca14385d26b77fde54795e153171f43.webp","title":"Безплатна доставка <br> Световен","subtitle":"За всички поръчки над $350"},{"image":"20221115/ffd9701a8c39fd929f2425cef82f3182.webp","title":"Онлайн защитено <br> Payment","subtitle":"Гарантирана защита на плащането"},{"image":"20221115/25bc0b939a75406c6e341f55936ff5d1.webp","title":"Връщане на пари <br> Гаранция","subtitle":"Ако стоките имат проблеми"}]',
            'ca' => '[{"image":"20221115/1ca14385d26b77fde54795e153171f43.webp","title":"Enviament gratuït <br> A nivell mundial","subtitle":"Per a totes les comandes superiors a 350 $"},{"image":"20221115/ffd9701a8c39fd929f2425cef82f3182.webp","title":"En línia segura <br> Payment","subtitle":"Protecció del pagament garantida"},{"image":"20221115/25bc0b939a75406c6e341f55936ff5d1.webp","title":"Devolució de diners <br> Garantia","subtitle":"Si els productes tenen problemes"}]',
            'et' => '[{"image":"20221115/1ca14385d26b77fde54795e153171f43.webp","title":"Tasuta kohaletoimetamine <br> Kogu maailmas","subtitle":"Kõigi tellimuste eest üle 350 dollari"},{"image":"20221115/ffd9701a8c39fd929f2425cef82f3182.webp","title":"Turvaline veebis <br> Payment","subtitle":"Makse kaitse tagatud"},{"image":"20221115/25bc0b939a75406c6e341f55936ff5d1.webp","title":"Raha tagasi <br> Garantii","subtitle":"Kui kaubad on probleeme"}]',
            'nl' => '[{"image":"20221115/1ca14385d26b77fde54795e153171f43.webp","title":"Gratis verzending <br> Wereldwijd","subtitle":"Voor alle bestellingen van meer dan $350"},{"image":"20221115/ffd9701a8c39fd929f2425cef82f3182.webp","title":"Veilig online <br> Payment","subtitle":"Betalingbescherming gegarandeerd"},{"image":"20221115/25bc0b939a75406c6e341f55936ff5d1.webp","title":"Geld terug <br> Garantie","subtitle":"Als er problemen zijn met de goederen"}]',
        ]));

        $this->updateLanguage('[{"upper_st":"NEW ARRIVALS","lower_st":"FOR THE <span style=\"color:#E43147\">LITTLE<\/span> ","title":"GENERATION","image":"20221117/8bb982bae02e596721bad953fd608a88.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"MOST POPULAR","lower_st":"<span style=\"color:#E43147\">WINTER<\/span> IMPORTED ","title":"JACKETS","image":"20221117/3da9cf6e2d7830531e5fd19f488bb7ce.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]', json_encode([
            'en' => '[{"upper_st":"NEW ARRIVALS","lower_st":"FOR THE <span style=\\"color:#E43147\\">LITTLE<\\/span> ","title":"GENERATION","image":"20221117/8bb982bae02e596721bad953fd608a88.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"MOST POPULAR","lower_st":"<span style=\\"color:#E43147\\">WINTER<\\/span> IMPORTED ","title":"JACKETS","image":"20221117/3da9cf6e2d7830531e5fd19f488bb7ce.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'bn' => '[{"upper_st":"নতুন আগমন","lower_st":"জন্য <span style=\\"color:#E43147\\">ছোট<\\/span> ","title":"প্রজন্ম","image":"20221117/8bb982bae02e596721bad953fd608a88.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"সবচেয়ে জনপ্রিয়","lower_st":"<span style=\\"color:#E43147\\">শীতকাল<\\/span> আমদানি ","title":"জ্যাকেট","image":"20221117/3da9cf6e2d7830531e5fd19f488bb7ce.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'fr' => '[{"upper_st":"NOUVEAUTÉS","lower_st":"POUR LE <span style=\\"color:#E43147\\">PETIT<\\/span> ","title":"GÉNÉRATION","image":"20221117/8bb982bae02e596721bad953fd608a88.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"LE PLUS POPULAIRE","lower_st":"<span style=\\"color:#E43147\\">HIVER<\\/span> IMPORTÉ ","title":"VESTES","image":"20221117/3da9cf6e2d7830531e5fd19f488bb7ce.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'zh' => '[{"upper_st":"新品上市","lower_st":"为了 <span style=\\"color:#E43147\\">小<\\/span> ","title":"代","image":"20221117/8bb982bae02e596721bad953fd608a88.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"最受欢迎","lower_st":"<span style=\\"color:#E43147\\">冬季<\\/span> 进口 ","title":"夹克","image":"20221117/3da9cf6e2d7830531e5fd19f488bb7ce.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'ar' => '[{"upper_st":"وصل حديثا","lower_st":"لل <span style=\\"color:#E43147\\">قليل<\\/span> ","title":"جيل","image":"20221117/8bb982bae02e596721bad953fd608a88.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"الأكثر شعبية","lower_st":"<span style=\\"color:#E43147\\">الشتاء<\\/span> مستورد ","title":"سترات","image":"20221117/3da9cf6e2d7830531e5fd19f488bb7ce.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'be' => '[{"upper_st":"НОВЫЯ ПРЫБЫЦЦІ","lower_st":"ДЛЯ <span style=\\"color:#E43147\\">МАЛЕНЬКІ<\\/span> ","title":"ПАКАЛЕННЕ","image":"20221117/8bb982bae02e596721bad953fd608a88.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"НАЙПАПУЛЯРНІШЫ","lower_st":"<span style=\\"color:#E43147\\">ЗІМА<\\/span> ІМПОРТ ","title":"КУРТКІ","image":"20221117/3da9cf6e2d7830531e5fd19f488bb7ce.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'bg' => '[{"upper_st":"НОВИ ПРИБИЖВАНИЯ","lower_st":"ЗА <span style=\\"color:#E43147\\">МАЛЪК<\\/span> ","title":"ПОКОЛЕНИЕ","image":"20221117/8bb982bae02e596721bad953fd608a88.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"НАЙ-ПОПУЛЯРЕН","lower_st":"<span style=\\"color:#E43147\\">ЗИМА<\\/span> ИМПОРТИРАНИ ","title":"ЯКЕТА","image":"20221117/3da9cf6e2d7830531e5fd19f488bb7ce.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'ca' => '[{"upper_st":"NOVETATS","lower_st":"PER A <span style=\\"color:#E43147\\">PEU<\\/span> ","title":"GENERACIÓ","image":"20221117/8bb982bae02e596721bad953fd608a88.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"MÉS POPULAR","lower_st":"<span style=\\"color:#E43147\\">HIVERN<\\/span> IMPORTAT ","title":"JACKETS","image":"20221117/3da9cf6e2d7830531e5fd19f488bb7ce.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'et' => '[{"upper_st":"UUED SAABUMISED","lower_st":"JAOKS <span style=\\"color:#E43147\\">VÄIKE<\\/span> ","title":"PÕLVKOND","image":"20221117/8bb982bae02e596721bad953fd608a88.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"ENIM LEVINUD","lower_st":"<span style=\\"color:#E43147\\">TALV<\\/span> IMPORTEERITUD ","title":"JOPED","image":"20221117/3da9cf6e2d7830531e5fd19f488bb7ce.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'nl' => '[{"upper_st":"NIEUWE AANKOMSTEN","lower_st":"VOOR DE <span style=\\"color:#E43147\\">KLEIN<\\/span> ","title":"GENERATIE","image":"20221117/8bb982bae02e596721bad953fd608a88.webp","btn_text":"Koop nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"MEEST POPULAIR","lower_st":"<span style=\\"color:#E43147\\">WINTER<\\/span> GEÏMPORTEERD ","title":"JASSEN","image":"20221117/3da9cf6e2d7830531e5fd19f488bb7ce.webp","btn_text":"Koop nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
        ]));

        $this->updateLanguage('[{"image":"20221117/9f816dddcdedacc18c5ed3b39cefc5bf.webp","title":"Free Shipping <br> Worldwide","subtitle":"For all orders over $350"},{"image":"20221117/05a073d480ed4ccaa7407b408291a633.webp","title":"Secured Online <br> Payment","subtitle":"Payment protection guaranteed"},{"image":"20221117/c2ef7099bd48eb02a90d73d8d988107e.webp","title":"Money Back <br> Guarantee","subtitle":"If goods have problems"}]', json_encode([
            'en' => '[{"image":"20221117/9f816dddcdedacc18c5ed3b39cefc5bf.webp","title":"Free Shipping <br> Worldwide","subtitle":"For all orders over $350"},{"image":"20221117/05a073d480ed4ccaa7407b408291a633.webp","title":"Secured Online <br> Payment","subtitle":"Payment protection guaranteed"},{"image":"20221117/c2ef7099bd48eb02a90d73d8d988107e.webp","title":"Money Back <br> Guarantee","subtitle":"If goods have problems"}]',
            'bn' => '[{"image":"20221117/9f816dddcdedacc18c5ed3b39cefc5bf.webp","title":"বিনামূল্যে শিপিং <br> বিশ্বব্যাপী","subtitle":"সমস্ত অর্ডারের জন্য প্রযোজ্য $350 এর উপরে"},{"image":"20221117/05a073d480ed4ccaa7407b408291a633.webp","title":"নিরাপদ অনলাইনে <br> পেমেন্ট","subtitle":"পেমেন্ট protection guaranteed"},{"image":"20221117/c2ef7099bd48eb02a90d73d8d988107e.webp","title":"টাকা পিছনে দিন <br> গ্যারান্টি","subtitle":"যদি মাল সমস্যা থাকে"}]',
            'fr' => '[{"image":"20221117/9f816dddcdedacc18c5ed3b39cefc5bf.webp","title":"Livraison gratuite <br> Mondial","subtitle":"Pour toutes les commandes de plus de 350 $"},{"image":"20221117/05a073d480ed4ccaa7407b408291a633.webp","title":"En ligne sécurisé <br> Paiement","subtitle":"Paiement protection guaranteed"},{"image":"20221117/c2ef7099bd48eb02a90d73d8d988107e.webp","title":"Argent remis <br> Garantie","subtitle":"Si les produits ont des problèmes"}]',
            'zh' => '[{"image":"20221117/9f816dddcdedacc18c5ed3b39cefc5bf.webp","title":"免费运送 <br> 全球","subtitle":"所有订单满350美元免邮费"},{"image":"20221117/05a073d480ed4ccaa7407b408291a633.webp","title":"在线保护 <br> 付款","subtitle":"付款 protection guaranteed"},{"image":"20221117/c2ef7099bd48eb02a90d73d8d988107e.webp","title":"退款 <br> 保证","subtitle":"如果商品有问题"}]',
            'ar' => '[{"image":"20221117/9f816dddcdedacc18c5ed3b39cefc5bf.webp","title":"الشحن مجانا <br> عالمي","subtitle":"لجميع الطلبات التي تزيد عن 350 دولارًا"},{"image":"20221117/05a073d480ed4ccaa7407b408291a633.webp","title":"عبر الإنترنت بأمان <br> الدفع","subtitle":"الدفع protection guaranteed"},{"image":"20221117/c2ef7099bd48eb02a90d73d8d988107e.webp","title":"استرداد الأموال <br> ضمان","subtitle":"إذا كانت السلع لديها مشاكل"}]',
            'be' => '[{"image":"20221117/9f816dddcdedacc18c5ed3b39cefc5bf.webp","title":"Бясплатная дастаўка <br> Па ўсім свеце","subtitle":"Для ўсіх заказаў па $350 і больш"},{"image":"20221117/05a073d480ed4ccaa7407b408291a633.webp","title":"Бяспечнае онлайн <br> ПЛАТА","subtitle":"ПЛАТА protection guaranteed"},{"image":"20221117/c2ef7099bd48eb02a90d73d8d988107e.webp","title":"Грошы назад <br> Гарантыя","subtitle":"Калі тавары маюць праблемы"}]',
            'bg' => '[{"image":"20221117/9f816dddcdedacc18c5ed3b39cefc5bf.webp","title":"Безплатна доставка <br> Световен","subtitle":"За всички поръчки над $350"},{"image":"20221117/05a073d480ed4ccaa7407b408291a633.webp","title":"Онлайн защитено <br> ПЛАЩАНЕ","subtitle":"ПЛАЩАНЕ protection guaranteed"},{"image":"20221117/c2ef7099bd48eb02a90d73d8d988107e.webp","title":"Връщане на пари <br> Гаранция","subtitle":"Ако стоките имат проблеми"}]',
            'ca' => '[{"image":"20221117/9f816dddcdedacc18c5ed3b39cefc5bf.webp","title":"Enviament gratuït <br> A nivell mundial","subtitle":"Per a totes les comandes superiors a 350 $"},{"image":"20221117/05a073d480ed4ccaa7407b408291a633.webp","title":"En línia segura <br> Pagament","subtitle":"Pagament protection guaranteed"},{"image":"20221117/c2ef7099bd48eb02a90d73d8d988107e.webp","title":"Devolució de diners <br> Garantia","subtitle":"Si els productes tenen problemes"}]',
            'et' => '[{"image":"20221117/9f816dddcdedacc18c5ed3b39cefc5bf.webp","title":"Tasuta kohaletoimetamine <br> Kogu maailmas","subtitle":"Kõigi tellimuste eest üle 350 dollari"},{"image":"20221117/05a073d480ed4ccaa7407b408291a633.webp","title":"Turvaline veebis <br> Makse","subtitle":"Makse protection guaranteed"},{"image":"20221117/c2ef7099bd48eb02a90d73d8d988107e.webp","title":"Raha tagasi <br> Garantii","subtitle":"Kui kaubad on probleeme"}]',
            'nl' => '[{"image":"20221117/9f816dddcdedacc18c5ed3b39cefc5bf.webp","title":"Gratis verzending <br> Wereldwijd","subtitle":"Voor alle bestellingen van meer dan $350"},{"image":"20221117/05a073d480ed4ccaa7407b408291a633.webp","title":"Veilig online <br> Betaling","subtitle":"Betaling protection guaranteed"},{"image":"20221117/c2ef7099bd48eb02a90d73d8d988107e.webp","title":"Geld terug <br> Garantie","subtitle":"Als er problemen zijn met de goederen"}]',
        ]));

        $this->updateLanguage('Be the first to get the latest news about trends, promotions, and much more!', '{"en":"Be the first to get the latest news about trends, promotions, and much more!","bn":"প্রথমে ট্রেন্ড, প্রমোশন এবং অনেক আরও সম্পর্কে সর্বশেষ সংবাদ পেতে হন!","fr":"Soyez le premier à obtenir les dernières nouvelles sur les tendances, les promotions et bien plus encore!","zh":"第一时间获取有关趋势、促销等最新资讯！","ar":"كن الأول في الحصول على آخر الأخبار حول الاتجاهات والعروض الترويجية وأكثر من ذلك بكثير!","be":"Будзьце першымі, хто атрымае апошнія навіны пра тэндэнцыі, прамацыі і шмат іншага!","bg":"Бъдете първият, който ще получи най-новите новини за тенденциите, промоции и още много други неща!","ca":"Sigui el primer a obtenir les últimes notícies sobre tendències, promocions i molt més!","et":"Ole esimene, kes saab viimaseid uudiseid suundumuste, reklaamide ja palju muu kohta!","nl":"Wees de eerste om het laatste nieuws te krijgen over trends, promoties en nog veel meer!"}');
        $this->updateLanguage('Welcome to Store', '{"en":"Welcome to Store","bn":"স্টোরে আপনাকে স্বাগতম","fr":"Bienvenue au magasin","zh":"欢迎来到商店","ar":"مرحبًا بك في المتجر","be":"Сардэчна запрашаем у краму","bg":"Добре дошли в магазина","ca":"Benvingut a la botiga","et":"Tere tulemast poodi","nl":"Welkom in de winkel"}');
        $this->updateLanguage('ALL OUR PRODUCTS', '{"en":"ALL OUR PRODUCTS","bn":"সমস্ত আমাদের পণ্য","fr":"TOUS NOS PRODUITS","zh":"我们的所有产品","ar":"كل منتجاتنا","be":"УСЕ НАШЫ ПРАДУКЦЫІ","bg":"ВСИЧКИ НАШИ ПРОДУКТИ","ca":"TOTS ELS NOSTRES PRODUCTES","et":"KÕIK MEIE TOOTED","nl":"AL ONZE PRODUCTEN"}');
        $this->updateLanguage('Top Categories of the Month', '{"en":"Top Categories of the Month","bn":"মাসের শীর্ষ বিভাগ","fr":"Top catégories du mois","zh":"本月热门分类","ar":"أفضل الفئات للشهر","be":"Лепшыя катэгорыі месяца","bg":"Най-добрите категории на месеца","ca":"Principals categories del mes","et":"Kuu peamised kategooriad","nl":"Topcategorieën van de maand"}');

        $this->updateLanguage('[{"upper_st":"SMALL & MINIMAL","lower_st":"<span style=\"color: #FF693A\">FURNITURE<\/span> FOR ","title":"BOOKWORMS","image":"20221122/47eadab8eb9dbe8488be6c064c690a66.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"FANCY SOFAS","lower_st":"<span style=\"color: #FF693A\">LUXURIOUS<\/span> ","title":"COMFORT","image":"20221122/49bb66273ff65064402ae5caebc6a5d7.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]', json_encode([
            'en' => '[{"upper_st":"SMALL & MINIMAL","lower_st":"<span style=\\"color: #FF693A\\">FURNITURE<\\/span> FOR ","title":"BOOKWORMS","image":"20221122/47eadab8eb9dbe8488be6c064c690a66.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"FANCY SOFAS","lower_st":"<span style=\\"color: #FF693A\\">LUXURIOUS<\\/span> ","title":"COMFORT","image":"20221122/49bb66273ff65064402ae5caebc6a5d7.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'bn' => '[{"upper_st":"ছোট এবং সামান্য","lower_st":"<span style=\\"color: #FF693A\\">ফার্নিচার<\\/span> জন্য ","title":"বইপাঠক","image":"20221122/47eadab8eb9dbe8488be6c064c690a66.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"ফ্যান্সি সোফা","lower_st":"<span style=\\"color: #FF693A\\">প্রভাবশালী<\\/span> ","title":"COMজন্যT","image":"20221122/49bb66273ff65064402ae5caebc6a5d7.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'fr' => '[{"upper_st":"PETIT & MINIMAL","lower_st":"<span style=\\"color: #FF693A\\">MEUBLES<\\/span> POUR ","title":"LIVRES","image":"20221122/47eadab8eb9dbe8488be6c064c690a66.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"CANAPÉS DE LUXE","lower_st":"<span style=\\"color: #FF693A\\">LUXUEUX<\\/span> ","title":"COMPOURT","image":"20221122/49bb66273ff65064402ae5caebc6a5d7.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'zh' => '[{"upper_st":"小巧简约","lower_st":"<span style=\\"color: #FF693A\\">家具<\\/span> 为 ","title":"爱书之人","image":"20221122/47eadab8eb9dbe8488be6c064c690a66.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"花哨沙发","lower_st":"<span style=\\"color: #FF693A\\">奢华的<\\/span> ","title":"COM为T","image":"20221122/49bb66273ff65064402ae5caebc6a5d7.webp","btn_text":"现在购物","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'ar' => '[{"upper_st":"صغيرة وأنيقة","lower_st":"<span style=\\"color: #FF693A\\">أثاث<\\/span> لـ ","title":"مدمني الكتب","image":"20221122/47eadab8eb9dbe8488be6c064c690a66.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"أرائك فاخرة","lower_st":"<span style=\\"color: #FF693A\\">فخمة<\\/span> ","title":"COMلـT","image":"20221122/49bb66273ff65064402ae5caebc6a5d7.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'be' => '[{"upper_st":"МАЛЕНЬКІ І МІНІМАЛЬНЫ","lower_st":"<span style=\\"color: #FF693A\\">МЕБЛІ<\\/span> ДЛЯ ","title":"КНІГАЛАЗЫ","image":"20221122/47eadab8eb9dbe8488be6c064c690a66.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"ФАНТАЗІЙНЫЯ КАНАПЫ","lower_st":"<span style=\\"color: #FF693A\\">РАСКАШЭЛІ<\\/span> ","title":"COMДЛЯT","image":"20221122/49bb66273ff65064402ae5caebc6a5d7.webp","btn_text":"КУПІЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'bg' => '[{"upper_st":"МАЛКО И МИНИМАЛИСТИЧНО","lower_st":"<span style=\\"color: #FF693A\\">МЕБЕЛИ<\\/span> ЗА ","title":"КНИЖОВНИЦИ","image":"20221122/47eadab8eb9dbe8488be6c064c690a66.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"ФАНТАЗИЙНИ СОФИ","lower_st":"<span style=\\"color: #FF693A\\">РАЗКОШЕН<\\/span> ","title":"COMЗАT","image":"20221122/49bb66273ff65064402ae5caebc6a5d7.webp","btn_text":"ПАЗАРУВАЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'ca' => '[{"upper_st":"PETIT I MINIMALISTA","lower_st":"<span style=\\"color: #FF693A\\">MOBLES<\\/span> PER ","title":"VERNACLE","image":"20221122/47eadab8eb9dbe8488be6c064c690a66.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"SOFÀS DE FANTASIA","lower_st":"<span style=\\"color: #FF693A\\">LUXOSOS<\\/span> ","title":"COMPERT","image":"20221122/49bb66273ff65064402ae5caebc6a5d7.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'et' => '[{"upper_st":"VÄIKE & MINIMAALNE","lower_st":"<span style=\\"color: #FF693A\\">MÖÖBEL<\\/span> JAOKS ","title":"RAAMATULUGEJAD","image":"20221122/47eadab8eb9dbe8488be6c064c690a66.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"EKSKLUSIIVSED SOFAD","lower_st":"<span style=\\"color: #FF693A\\">LUKSUSLIK<\\/span> ","title":"COMJAOKST","image":"20221122/49bb66273ff65064402ae5caebc6a5d7.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'nl' => '[{"upper_st":"KLEIN & MINIMAAL","lower_st":"<span style=\\"color: #FF693A\\">MEUBELS<\\/span> VOOR ","title":"BOEKENWORMEN","image":"20221122/47eadab8eb9dbe8488be6c064c690a66.webp","btn_text":"Koop nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"CHIQUE BANKEN","lower_st":"<span style=\\"color: #FF693A\\">LUXUEUS<\\/span> ","title":"COMVOORT","image":"20221122/49bb66273ff65064402ae5caebc6a5d7.webp","btn_text":"Koop nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
        ]));

        $this->updateLanguage('[{"upper_st":"NEW ARRIVALS","lower_st":"ALL ABOUT <span style=\"color: #FF693A\">MINIMAL<\/span> ","title":"WOODS","image":"20221122/62e53a0d5a8eec51d190eafbcfec7cba.webp","btn_text":"Visit Shop","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"LIGHTS","lower_st":"<span style=\"color: #FF693A\">BRIGHTEN<\/span> YOUR ","title":"SWEET HOME","image":"20221122/d5b1f9096b507899efbf1255afc4cb7e.webp","btn_text":"Visit Shop","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]', json_encode([
            'en' => '[{"upper_st":"NEW ARRIVALS","lower_st":"ALL ABOUT <span style=\\"color: #FF693A\\">MINIMAL<\\/span> ","title":"WOODS","image":"20221122/62e53a0d5a8eec51d190eafbcfec7cba.webp","btn_text":"Visit Shop","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"LIGHTS","lower_st":"<span style=\\"color: #FF693A\\">BRIGHTEN<\\/span> YOUR ","title":"SWEET HOME","image":"20221122/d5b1f9096b507899efbf1255afc4cb7e.webp","btn_text":"Visit Shop","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'bn' => '[{"upper_st":"নতুন আগমন","lower_st":"সম্পর্কে সব <span style=\\"color: #FF693A\\">সামান্য<\\/span> ","title":"বন","image":"20221122/62e53a0d5a8eec51d190eafbcfec7cba.webp","btn_text":"দোকান দেখুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"রোশনি","lower_st":"<span style=\\"color: #FF693A\\">উজ্জ্বল করা<\\/span> আপনার ","title":"মিষ্টি বাড়ি","image":"20221122/d5b1f9096b507899efbf1255afc4cb7e.webp","btn_text":"দোকান দেখুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'fr' => '[{"upper_st":"NOUVEAUTÉS","lower_st":"TOUT SUR <span style=\\"color: #FF693A\\">MINIMAL<\\/span> ","title":"BOIS","image":"20221122/62e53a0d5a8eec51d190eafbcfec7cba.webp","btn_text":"Visitez la boutique","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"LUMIÈRES","lower_st":"<span style=\\"color: #FF693A\\">ÉCLAIRER<\\/span> VOTRE ","title":"DOUCE MAISON","image":"20221122/d5b1f9096b507899efbf1255afc4cb7e.webp","btn_text":"Visitez la boutique","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'zh' => '[{"upper_st":"新品上市","lower_st":"所有关于 <span style=\\"color: #FF693A\\">极简<\\/span> ","title":"木材","image":"20221122/62e53a0d5a8eec51d190eafbcfec7cba.webp","btn_text":"访问商店","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"灯光","lower_st":"<span style=\\"color: #FF693A\\">照亮<\\/span> 您的 ","title":"甜蜜的家","image":"20221122/d5b1f9096b507899efbf1255afc4cb7e.webp","btn_text":"访问商店","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'ar' => '[{"upper_st":"وصل حديثا","lower_st":"كل شيء حول <span style=\\"color: #FF693A\\">حد أدنى<\\/span> ","title":"الغابات","image":"20221122/62e53a0d5a8eec51d190eafbcfec7cba.webp","btn_text":"زيارة المتجر","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"أضواء","lower_st":"<span style=\\"color: #FF693A\\">تحول إلى السطوع<\\/span> لك ","title":"منزل حلو","image":"20221122/d5b1f9096b507899efbf1255afc4cb7e.webp","btn_text":"زيارة المتجر","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'be' => '[{"upper_st":"НОВЫЯ ПРЫБЫЦЦІ","lower_st":"УСЁ АБ <span style=\\"color: #FF693A\\">МІНІМАЛЬНЫ<\\/span> ","title":"ЛЯСЫ","image":"20221122/62e53a0d5a8eec51d190eafbcfec7cba.webp","btn_text":"НАВЕСЦІ МАГАЗІН","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"СВЕТ","lower_st":"<span style=\\"color: #FF693A\\">СВЕТЛЕЙ<\\/span> ВАШ ","title":"СЛАДКІ ДОМ","image":"20221122/d5b1f9096b507899efbf1255afc4cb7e.webp","btn_text":"НАВЕСЦІ МАГАЗІН","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'bg' => '[{"upper_st":"НОВИ ПРИБИЖВАНИЯ","lower_st":"ВСИЧКО ЗА <span style=\\"color: #FF693A\\">МИНИМАЛЕН<\\/span> ","title":"ДЪРВЕТА","image":"20221122/62e53a0d5a8eec51d190eafbcfec7cba.webp","btn_text":"ПОСЕТЕТЕ МАГАЗИНА","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"СВЕТЛИНИ","lower_st":"<span style=\\"color: #FF693A\\">ПРОСВЕТЛЕТЕ<\\/span> ТВОЙ ","title":"СЛАДЪК ДОМ","image":"20221122/d5b1f9096b507899efbf1255afc4cb7e.webp","btn_text":"ПОСЕТЕТЕ МАГАЗИНА","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'ca' => '[{"upper_st":"NOVETATS","lower_st":"TOT SOBRE <span style=\\"color: #FF693A\\">MINIMALISTA<\\/span> ","title":"BOSCOS","image":"20221122/62e53a0d5a8eec51d190eafbcfec7cba.webp","btn_text":"VISITA LA BOTIGA","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"LLUMS","lower_st":"<span style=\\"color: #FF693A\\">IL·LUMINAR<\\/span> TEU ","title":"DOLÇA CASA","image":"20221122/d5b1f9096b507899efbf1255afc4cb7e.webp","btn_text":"VISITA LA BOTIGA","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'et' => '[{"upper_st":"UUED SAABUMISED","lower_st":"KÕIK UMBES <span style=\\"color: #FF693A\\">MINIMAALNE<\\/span> ","title":"PUIT","image":"20221122/62e53a0d5a8eec51d190eafbcfec7cba.webp","btn_text":"KÜLASTA KAUPA","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"VALGUSTUS","lower_st":"<span style=\\"color: #FF693A\\">VALGUSTAGE<\\/span> SINU ","title":"MAGUS KODU","image":"20221122/d5b1f9096b507899efbf1255afc4cb7e.webp","btn_text":"KÜLASTA KAUPA","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'nl' => '[{"upper_st":"NIEUWE AANKOMSTEN","lower_st":"ALLES OVER <span style=\\"color: #FF693A\\">MINIMAAL<\\/span> ","title":"HOUT","image":"20221122/62e53a0d5a8eec51d190eafbcfec7cba.webp","btn_text":"BEZOEK WINKEL","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"LICHTEN","lower_st":"<span style=\\"color: #FF693A\\">VERLICHTEN<\\/span> JOuw ","title":"Zoet Huis","image":"20221122/d5b1f9096b507899efbf1255afc4cb7e.webp","btn_text":"BEZOEK WINKEL","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
        ]));

        $this->updateLanguage('[{"upper_st":"","lower_st":"<span style=\"font-size: 24px\">Complete Your Look<\/span> <br>","title":"<p style=\"margin-bottom: 350px; color: #444; margin-top: 10px; font-size: 18px;\">The world\'s most stylish <br> women are buying right <br> now<\/p>","image":"20221127/e2db8acd9877f20ec050a62c64b91fc2.webp","btn_text":"","btn_link":""},{"upper_st":"","lower_st":"<span style=\"color: #fff; font-size: 24px;\">TOP TRENDING  Product <\/span><br>","title":"<p style=\"margin-bottom: 350px; color: #ddd; margin-top: 10px; font-size: 18px;\">The world\'s most stylish <br> women are buying right <br> now<\/p>","image":"20221127/fab76bf50492b107744b371a8719d9f4.webp","btn_text":"","btn_link":""}]', json_encode([
            'en' => '[{"upper_st":"","lower_st":"<span style=\\"font-size: 24px\\">Complete Your Look<\\/span> <br>","title":"<p style=\\"margin-bottom: 350px; color: #444; margin-top: 10px; font-size: 18px;\\">The world\'s most stylish <br> women are buying right <br> now<\\/p>","image":"20221127/e2db8acd9877f20ec050a62c64b91fc2.webp","btn_text":"","btn_link":""},{"upper_st":"","lower_st":"<span style=\\"color: #fff; font-size: 24px;\\">TOP TRENDING  Product <\\/span><br>","title":"<p style=\\"margin-bottom: 350px; color: #ddd; margin-top: 10px; font-size: 18px;\\">The world\'s most stylish <br> women are buying right <br> now<\\/p>","image":"20221127/fab76bf50492b107744b371a8719d9f4.webp","btn_text":"","btn_link":""}]',
            'bn' => '[{"upper_st":"","lower_st":"<span style=\\"font-size: 24px\\">আপনার দেখাশেষ করুন<\\/span> <br>","title":"<p style=\\"margin-bottom: 350px; color: #444; margin-top: 10px; font-size: 18px;\\">বিশ্বের সবচেয়ে স্টাইলিশ <br> নারীরা এখন কিনছে <br> এখন<\\/p>","image":"20221127/e2db8acd9877f20ec050a62c64b91fc2.webp","btn_text":"","btn_link":""},{"upper_st":"","lower_st":"<span style=\\"color: #fff; font-size: 24px;\\">শীর্ষ ট্রেন্ডিং প্রোডাক্ট <\\/span><br>","title":"<p style=\\"margin-bottom: 350px; color: #ddd; margin-top: 10px; font-size: 18px;\\">বিশ্বের সবচেয়ে স্টাইলিশ <br> নারীরা এখন কিনছে <br> এখন<\\/p>","image":"20221127/fab76bf50492b107744b371a8719d9f4.webp","btn_text":"","btn_link":""}]',
            'fr' => '[{"upper_st":"","lower_st":"<span style=\\"font-size: 24px\\">Complétez votre look<\\/span> <br>","title":"<p style=\\"margin-bottom: 350px; color: #444; margin-top: 10px; font-size: 18px;\\">Les plus élégants du monde <br> les femmes achètent en ce moment <br> maintenant<\\/p>","image":"20221127/e2db8acd9877f20ec050a62c64b91fc2.webp","btn_text":"","btn_link":""},{"upper_st":"","lower_st":"<span style=\\"color: #fff; font-size: 24px;\\">PRODUIT EN HAUSSE EN HAUT <\\/span><br>","title":"<p style=\\"margin-bottom: 350px; color: #ddd; margin-top: 10px; font-size: 18px;\\">Les plus élégants du monde <br> les femmes achètent en ce moment <br> maintenant<\\/p>","image":"20221127/fab76bf50492b107744b371a8719d9f4.webp","btn_text":"","btn_link":""}]',
            'zh' => '[{"upper_st":"","lower_st":"<span style=\\"font-size: 24px\\">完善您的造型<\\/span> <br>","title":"<p style=\\"margin-bottom: 350px; color: #444; margin-top: 10px; font-size: 18px;\\">世界上最时尚的 <br> 女性正在购买 <br> 现在<\\/p>","image":"20221127/e2db8acd9877f20ec050a62c64b91fc2.webp","btn_text":"","btn_link":""},{"upper_st":"","lower_st":"<span style=\\"color: #fff; font-size: 24px;\\">热门产品 <\\/span><br>","title":"<p style=\\"margin-bottom: 350px; color: #ddd; margin-top: 10px; font-size: 18px;\\">世界上最时尚的 <br> 女性正在购买 <br> 现在<\\/p>","image":"20221127/fab76bf50492b107744b371a8719d9f4.webp","btn_text":"","btn_link":""}]',
            'ar' => '[{"upper_st":"","lower_st":"<span style=\\"font-size: 24px\\">أكملي مظهرك<\\/span> <br>","title":"<p style=\\"margin-bottom: 350px; color: #444; margin-top: 10px; font-size: 18px;\\">الأكثر أناقة في العالم <br> النساء يشترين الآن <br> الآن<\\/p>","image":"20221127/e2db8acd9877f20ec050a62c64b91fc2.webp","btn_text":"","btn_link":""},{"upper_st":"","lower_st":"<span style=\\"color: #fff; font-size: 24px;\\">أعلى المنتجات الشائعة <\\/span><br>","title":"<p style=\\"margin-bottom: 350px; color: #ddd; margin-top: 10px; font-size: 18px;\\">الأكثر أناقة في العالم <br> النساء يشترين الآن <br> الآن<\\/p>","image":"20221127/fab76bf50492b107744b371a8719d9f4.webp","btn_text":"","btn_link":""}]',
            'be' => '[{"upper_st":"","lower_st":"<span style=\\"font-size: 24px\\">ПОБУДУЙЦЕ СВАЙ АБРАЗ<\\/span> <br>","title":"<p style=\\"margin-bottom: 350px; color: #444; margin-top: 10px; font-size: 18px;\\">САМЫ МАДНЫЯ І СВЕТУ <br> жанчыны зараз купліваюць <br> цяпер<\\/p>","image":"20221127/e2db8acd9877f20ec050a62c64b91fc2.webp","btn_text":"","btn_link":""},{"upper_st":"","lower_st":"<span style=\\"color: #fff; font-size: 24px;\\">ТАПАВАЯ ПРОДУКЦЫЯ <\\/span><br>","title":"<p style=\\"margin-bottom: 350px; color: #ddd; margin-top: 10px; font-size: 18px;\\">САМЫ МАДНЫЯ І СВЕТУ <br> жанчыны зараз купліваюць <br> цяпер<\\/p>","image":"20221127/fab76bf50492b107744b371a8719d9f4.webp","btn_text":"","btn_link":""}]',
            'bg' => '[{"upper_st":"","lower_st":"<span style=\\"font-size: 24px\\">ЗАВЪРШЕТЕ СВОЯ ВИД<\\/span> <br>","title":"<p style=\\"margin-bottom: 350px; color: #444; margin-top: 10px; font-size: 18px;\\">Най-стилните в света <br> жените в момента купуват <br> сега<\\/p>","image":"20221127/e2db8acd9877f20ec050a62c64b91fc2.webp","btn_text":"","btn_link":""},{"upper_st":"","lower_st":"<span style=\\"color: #fff; font-size: 24px;\\">ТОП ТРЕНДОВИ ПРОДУКТИ <\\/span><br>","title":"<p style=\\"margin-bottom: 350px; color: #ddd; margin-top: 10px; font-size: 18px;\\">Най-стилните в света <br> жените в момента купуват <br> сега<\\/p>","image":"20221127/fab76bf50492b107744b371a8719d9f4.webp","btn_text":"","btn_link":""}]',
            'ca' => '[{"upper_st":"","lower_st":"<span style=\\"font-size: 24px\\">Complementeu el vostre look<\\/span> <br>","title":"<p style=\\"margin-bottom: 350px; color: #444; margin-top: 10px; font-size: 18px;\\">els més estilosos del món <br> les dones estan comprant ara <br> ara<\\/p>","image":"20221127/e2db8acd9877f20ec050a62c64b91fc2.webp","btn_text":"","btn_link":""},{"upper_st":"","lower_st":"<span style=\\"color: #fff; font-size: 24px;\\">PRODUCTE MÉS TENDÈNCIA <\\/span><br>","title":"<p style=\\"margin-bottom: 350px; color: #ddd; margin-top: 10px; font-size: 18px;\\">els més estilosos del món <br> les dones estan comprant ara <br> ara<\\/p>","image":"20221127/fab76bf50492b107744b371a8719d9f4.webp","btn_text":"","btn_link":""}]',
            'et' => '[{"upper_st":"","lower_st":"<span style=\\"font-size: 24px\\">Täiendage oma välimust<\\/span> <br>","title":"<p style=\\"margin-bottom: 350px; color: #444; margin-top: 10px; font-size: 18px;\\">maailma kõige stiilsemad <br> naised ostavad praegu <br> praegu<\\/p>","image":"20221127/e2db8acd9877f20ec050a62c64b91fc2.webp","btn_text":"","btn_link":""},{"upper_st":"","lower_st":"<span style=\\"color: #fff; font-size: 24px;\\">KÕRGEIM TÕUSEV TOODE <\\/span><br>","title":"<p style=\\"margin-bottom: 350px; color: #ddd; margin-top: 10px; font-size: 18px;\\">maailma kõige stiilsemad <br> naised ostavad praegu <br> praegu<\\/p>","image":"20221127/fab76bf50492b107744b371a8719d9f4.webp","btn_text":"","btn_link":""}]',
            'nl' => '[{"upper_st":"","lower_st":"<span style=\\"font-size: 24px\\">Maak je look compleet<\\/span> <br>","title":"<p style=\\"margin-bottom: 350px; color: #444; margin-top: 10px; font-size: 18px;\\">De meest stijlvolle ter wereld <br> vrouwen zijn nu aan het kopen <br> nu<\\/p>","image":"20221127/e2db8acd9877f20ec050a62c64b91fc2.webp","btn_text":"","btn_link":""},{"upper_st":"","lower_st":"<span style=\\"color: #fff; font-size: 24px;\\">TOP TRENDING Product <\\/span><br>","title":"<p style=\\"margin-bottom: 350px; color: #ddd; margin-top: 10px; font-size: 18px;\\">De meest stijlvolle ter wereld <br> vrouwen zijn nu aan het kopen <br> nu<\\/p>","image":"20221127/fab76bf50492b107744b371a8719d9f4.webp","btn_text":"","btn_link":""}]',
        ]));

        $this->updateLanguage('[{"upper_st":"<span style=\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\">COMPLETE YOUR LOOK<\/span>","lower_st":"<span style=\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\">Kid\u2019s<\/span>","title":"<span style=\"font-size: 18px; color: #777;font-family: monospace;\" >Here to bring your life style<\/span>","image":"20221127/77e9e64017e9afadce542d07a7d4c2b3.webp","btn_text":"DISCOVER NOW","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"<span style=\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\">TOP TRENDING STYLES<\/span>","lower_st":"<span style=\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\">Women\'s<\/span>","title":"<span style=\"font-size: 18px; color: #777; line-height: 24px;font-family: monospace;\">Distinguished. Individual.<\/span>","image":"20221127/a54efc1c8d9e94c19070456dca2a78b9.webp","btn_text":"DISCOVER NOW","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]', json_encode([
            'en' => '[{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">COMPLETE YOUR LOOK<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">Kid\\u2019s<\\/span>","title":"<span style=\\"font-size: 18px; color: #777;font-family: monospace;\\" >Here to bring your life style<\\/span>","image":"20221127/77e9e64017e9afadce542d07a7d4c2b3.webp","btn_text":"DISCOVER NOW","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">TOP TRENDING STYLES<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">Women\'s<\\/span>","title":"<span style=\\"font-size: 18px; color: #777; line-height: 24px;font-family: monospace;\\">Distinguished. Individual.<\\/span>","image":"20221127/a54efc1c8d9e94c19070456dca2a78b9.webp","btn_text":"DISCOVER NOW","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'bn' => '[{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">আপনার দেখাশেষ করুন<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">শিশু\\u2019s<\\/span>","title":"<span style=\\"font-size: 18px; color: #777;font-family: monospace;\\" >আপনার জীবনযাপন আনতে এখানে<\\/span>","image":"20221127/77e9e64017e9afadce542d07a7d4c2b3.webp","btn_text":"এখন আবিষ্কার করুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">শীর্ষ ট্রেন্ডিং স্টাইল<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">মহিলাদের<\\/span>","title":"<span style=\\"font-size: 18px; color: #777; line-height: 24px;font-family: monospace;\\">বিভিন্ন। ব্যক্তিগত।<\\/span>","image":"20221127/a54efc1c8d9e94c19070456dca2a78b9.webp","btn_text":"এখন আবিষ্কার করুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'fr' => '[{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">COMPLÉTEZ VOTRE LOOK<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">ENFANT\\u2019s<\\/span>","title":"<span style=\\"font-size: 18px; color: #777;font-family: monospace;\\" >Ici pour apporter votre style de vie<\\/span>","image":"20221127/77e9e64017e9afadce542d07a7d4c2b3.webp","btn_text":"DÉCOUVREZ MAINTENANT","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">STYLES LES PLUS TENDANCES<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">FEMMES<\\/span>","title":"<span style=\\"font-size: 18px; color: #777; line-height: 24px;font-family: monospace;\\">Distingué. Individuel.<\\/span>","image":"20221127/a54efc1c8d9e94c19070456dca2a78b9.webp","btn_text":"DÉCOUVREZ MAINTENANT","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'zh' => '[{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">完善您的造型<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">孩子\\u2019s<\\/span>","title":"<span style=\\"font-size: 18px; color: #777;font-family: monospace;\\" >在这里带来您的生活方式<\\/span>","image":"20221127/77e9e64017e9afadce542d07a7d4c2b3.webp","btn_text":"立即发现","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">热门时尚风格<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">女性的<\\/span>","title":"<span style=\\"font-size: 18px; color: #777; line-height: 24px;font-family: monospace;\\">杰出的。个人。<\\/span>","image":"20221127/a54efc1c8d9e94c19070456dca2a78b9.webp","btn_text":"立即发现","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'ar' => '[{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">أكملي مظهرك<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">طفل\\u2019s<\\/span>","title":"<span style=\\"font-size: 18px; color: #777;font-family: monospace;\\" >هنا لنقل نمط حياتك<\\/span>","image":"20221127/77e9e64017e9afadce542d07a7d4c2b3.webp","btn_text":"اكتشف الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">أهم أنماط الاتجاهات<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">للنساء<\\/span>","title":"<span style=\\"font-size: 18px; color: #777; line-height: 24px;font-family: monospace;\\">متميزة. فردية.<\\/span>","image":"20221127/a54efc1c8d9e94c19070456dca2a78b9.webp","btn_text":"اكتشف الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'be' => '[{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">ПОБУДУЙЦЕ СВАЙ АБРАЗ<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">ДЗЕЦІ\\u2019s<\\/span>","title":"<span style=\\"font-size: 18px; color: #777;font-family: monospace;\\" >ТУТ, КАБ ПРЫНЯЦЬ СВАЙ СТАЙЛ ЖЫЦЦЯ<\\/span>","image":"20221127/77e9e64017e9afadce542d07a7d4c2b3.webp","btn_text":"АБАВЯЗАЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">ТАПАВЫЯ ТЭНДЭНЦЫЯНЫЯ СТЫЛІ<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">ЖАНЧЫН<\\/span>","title":"<span style=\\"font-size: 18px; color: #777; line-height: 24px;font-family: monospace;\\">Выдатны. Індывідуальны.<\\/span>","image":"20221127/a54efc1c8d9e94c19070456dca2a78b9.webp","btn_text":"АБАВЯЗАЦЬ ЗАРАЗ","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'bg' => '[{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">ЗАВЪРШЕТЕ СВОЯ ВИД<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">ДЕТЕ\\u2019s<\\/span>","title":"<span style=\\"font-size: 18px; color: #777;font-family: monospace;\\" >ТУК, ЗА ДА ДОНЕСЕ ВАШИЯТ ЖИВОТОСТИЛ<\\/span>","image":"20221127/77e9e64017e9afadce542d07a7d4c2b3.webp","btn_text":"ОТКРИЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">НАЙ-ТРЕНДОВИ СТИЛОВЕ<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">ЗА ЖЕНИ<\\/span>","title":"<span style=\\"font-size: 18px; color: #777; line-height: 24px;font-family: monospace;\\">Изискан. Индивидуален.<\\/span>","image":"20221127/a54efc1c8d9e94c19070456dca2a78b9.webp","btn_text":"ОТКРИЙТЕ СЕГА","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'ca' => '[{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">COMPLEMENTA EL TEU LOOK<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">NEN\\u2019s<\\/span>","title":"<span style=\\"font-size: 18px; color: #777;font-family: monospace;\\" >Aquí per portar el vostre estil de vida<\\/span>","image":"20221127/77e9e64017e9afadce542d07a7d4c2b3.webp","btn_text":"DESCOBREIX-LO ARA","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">ESTILS MÉS TENDÈNCIA<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">DE DONES<\\/span>","title":"<span style=\\"font-size: 18px; color: #777; line-height: 24px;font-family: monospace;\\">Distingit. Individual.<\\/span>","image":"20221127/a54efc1c8d9e94c19070456dca2a78b9.webp","btn_text":"DESCOBREIX-LO ARA","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'et' => '[{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">TÄIENDAGE OMA VÄLIMUST<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">LAPS\\u2019s<\\/span>","title":"<span style=\\"font-size: 18px; color: #777;font-family: monospace;\\" >Siin, et tuua teie elustiil<\\/span>","image":"20221127/77e9e64017e9afadce542d07a7d4c2b3.webp","btn_text":"AVASTA KOHE","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">TOP TRENDIKAD STIILID<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">NAISTE<\\/span>","title":"<span style=\\"font-size: 18px; color: #777; line-height: 24px;font-family: monospace;\\">Eripärane. Individuaalne.<\\/span>","image":"20221127/a54efc1c8d9e94c19070456dca2a78b9.webp","btn_text":"AVASTA KOHE","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
            'nl' => '[{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">MAAK JE LOOK COMPLEET<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">KIND\\u2019s<\\/span>","title":"<span style=\\"font-size: 18px; color: #777;font-family: monospace;\\" >Hier om je levensstijl te brengen<\\/span>","image":"20221127/77e9e64017e9afadce542d07a7d4c2b3.webp","btn_text":"ONTDEK NU","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"},{"upper_st":"<span style=\\"margin-top: -250px; display:block; font-size: 18px; font-weight: 800;\\">TOP TRENDING STIJLEN<\\/span>","lower_st":"<span style=\\"display: block; font-size: 36px; margin-top: 18px;margin-bottom: 8px;\\">VROUWEN<\\/span>","title":"<span style=\\"font-size: 18px; color: #777; line-height: 24px;font-family: monospace;\\">Onderscheiden. Individueel.<\\/span>","image":"20221127/a54efc1c8d9e94c19070456dca2a78b9.webp","btn_text":"ONTDEK NU","btn_link":"http://localhost/multi-vendor/search-products?categories=Fashion"}]',
        ]));

        $this->updateLanguage('[{"upper_st":"<span style=\"color: #fff\">MOBILE<\/span>","lower_st":"<span style=\"color: #fff\">CUSTOMIZED<\/span>","title":"<span style=\"color: #fff\">IOS APPS<\/span>","image":"20221127/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\"color: #fff\">DESIGN<\/span>","lower_st":"<span style=\"color: #fff\">DECORATE YOUR <\/span>","title":"<span style=\"color: #fff\">SYSTEM<\/span>","image":"20221127/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\"color: #fff\">AWARDS<\/span>","lower_st":"<span style=\"color: #fff\">HEART WINNING <\/span>","title":"<span style=\"color: #fff\">PRODUCTS<\/span>","image":"20221127/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]', json_encode([
            'en' => '[{"upper_st":"<span style=\\"color: #fff\\">MOBILE<\\/span>","lower_st":"<span style=\\"color: #fff\\">CUSTOMIZED<\\/span>","title":"<span style=\\"color: #fff\\">IOS APPS<\\/span>","image":"20221127/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">DESIGN<\\/span>","lower_st":"<span style=\\"color: #fff\\">DECORATE YOUR <\\/span>","title":"<span style=\\"color: #fff\\">SYSTEM<\\/span>","image":"20221127/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">AWARDS<\\/span>","lower_st":"<span style=\\"color: #fff\\">HEART WINNING <\\/span>","title":"<span style=\\"color: #fff\\">PRODUCTS<\\/span>","image":"20221127/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'bn' => '[{"upper_st":"<span style=\\"color: #fff\\">মোবাইল<\\/span>","lower_st":"<span style=\\"color: #fff\\">কাস্টমাইজড<\\/span>","title":"<span style=\\"color: #fff\\">IOS অ্যাপ<\\/span>","image":"20221127/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">ডিজাইন<\\/span>","lower_st":"<span style=\\"color: #fff\\">আপনার সাজানো <\\/span>","title":"<span style=\\"color: #fff\\">সিস্টেম<\\/span>","image":"20221127/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">পুরস্কার<\\/span>","lower_st":"<span style=\\"color: #fff\\">হার্ট জয় করা <\\/span>","title":"<span style=\\"color: #fff\\">পণ্য<\\/span>","image":"20221127/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'fr' => '[{"upper_st":"<span style=\\"color: #fff\\">MOBILE<\\/span>","lower_st":"<span style=\\"color: #fff\\">PERSONNALISÉ<\\/span>","title":"<span style=\\"color: #fff\\">APPLICATIONS IOS<\\/span>","image":"20221127/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">CONCEPTION<\\/span>","lower_st":"<span style=\\"color: #fff\\">DÉCOREZ VOTRE <\\/span>","title":"<span style=\\"color: #fff\\">SYSTÈME<\\/span>","image":"20221127/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">PRIX<\\/span>","lower_st":"<span style=\\"color: #fff\\">GAGNANT DE CŒUR <\\/span>","title":"<span style=\\"color: #fff\\">PRODUITS<\\/span>","image":"20221127/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'zh' => '[{"upper_st":"<span style=\\"color: #fff\\">手机<\\/span>","lower_st":"<span style=\\"color: #fff\\">定制<\\/span>","title":"<span style=\\"color: #fff\\">IOS 应用<\\/span>","image":"20221127/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">设计<\\/span>","lower_st":"<span style=\\"color: #fff\\">装饰您的 <\\/span>","title":"<span style=\\"color: #fff\\">系统<\\/span>","image":"20221127/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">奖<\\/span>","lower_st":"<span style=\\"color: #fff\\">心获胜 <\\/span>","title":"<span style=\\"color: #fff\\">制品<\\/span>","image":"20221127/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'ar' => '[{"upper_st":"<span style=\\"color: #fff\\">الهاتف المحمول<\\/span>","lower_st":"<span style=\\"color: #fff\\">مخصص<\\/span>","title":"<span style=\\"color: #fff\\">تطبيقات IOS<\\/span>","image":"20221127/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">تصميم<\\/span>","lower_st":"<span style=\\"color: #fff\\">زيني الخاص بك <\\/span>","title":"<span style=\\"color: #fff\\">نظام<\\/span>","image":"20221127/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">جوائز<\\/span>","lower_st":"<span style=\\"color: #fff\\">فوز بالقلب <\\/span>","title":"<span style=\\"color: #fff\\">منتجات<\\/span>","image":"20221127/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'be' => '[{"upper_st":"<span style=\\"color: #fff\\">МАБІЛЬНЫ<\\/span>","lower_st":"<span style=\\"color: #fff\\">КАСТАМІЗАВАНЫ<\\/span>","title":"<span style=\\"color: #fff\\">IOS ПРЫЛОЖЕННІ<\\/span>","image":"20221127/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">ДЗЯРЖАВА<\\/span>","lower_st":"<span style=\\"color: #fff\\">УЗДЗЕЛЬНІЦЬ СВАЙ <\\/span>","title":"<span style=\\"color: #fff\\">СІСТЭМА<\\/span>","image":"20221127/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">НАГРАДЫ<\\/span>","lower_st":"<span style=\\"color: #fff\\">СЕРЦА ВІН <\\/span>","title":"<span style=\\"color: #fff\\">ПРОДУКЦЫЯ<\\/span>","image":"20221127/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'bg' => '[{"upper_st":"<span style=\\"color: #fff\\">МОБИЛЕН<\\/span>","lower_st":"<span style=\\"color: #fff\\">ПЕРСОНАЛИЗИРАН<\\/span>","title":"<span style=\\"color: #fff\\">ПРИЛОЖЕНИЯ IOS<\\/span>","image":"20221127/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">ДИЗАЙН<\\/span>","lower_st":"<span style=\\"color: #fff\\">УКРАСЯВАЙТЕ СИ <\\/span>","title":"<span style=\\"color: #fff\\">СИСТЕМА<\\/span>","image":"20221127/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">НАГРАДИ<\\/span>","lower_st":"<span style=\\"color: #fff\\">СЪРЦЕ ПОБЕДИТЕЛ <\\/span>","title":"<span style=\\"color: #fff\\">ПРОДУКТИ<\\/span>","image":"20221127/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'ca' => '[{"upper_st":"<span style=\\"color: #fff\\">MÒBIL<\\/span>","lower_st":"<span style=\\"color: #fff\\">PERSONALITZAT<\\/span>","title":"<span style=\\"color: #fff\\">APLICACIONS IOS<\\/span>","image":"20221127/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">DISSENY<\\/span>","lower_st":"<span style=\\"color: #fff\\">DECORA EL TEU <\\/span>","title":"<span style=\\"color: #fff\\">SISTEMA<\\/span>","image":"20221127/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">PREMIS<\\/span>","lower_st":"<span style=\\"color: #fff\\">GUANYADOR DEL COR <\\/span>","title":"<span style=\\"color: #fff\\">PRODUCTES<\\/span>","image":"20221127/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'et' => '[{"upper_st":"<span style=\\"color: #fff\\">MOBIIL<\\/span>","lower_st":"<span style=\\"color: #fff\\">KOHANDATUD<\\/span>","title":"<span style=\\"color: #fff\\">IOS RAKENDUSED<\\/span>","image":"20221127/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">DISAIN<\\/span>","lower_st":"<span style=\\"color: #fff\\">KAUNISTA OMA <\\/span>","title":"<span style=\\"color: #fff\\">SÜSTEEM<\\/span>","image":"20221127/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">AUHINNAD<\\/span>","lower_st":"<span style=\\"color: #fff\\">SÜDAME VÕITMINE <\\/span>","title":"<span style=\\"color: #fff\\">TOOTED<\\/span>","image":"20221127/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'nl' => '[{"upper_st":"<span style=\\"color: #fff\\">MOBIEL<\\/span>","lower_st":"<span style=\\"color: #fff\\">AANGEPAST<\\/span>","title":"<span style=\\"color: #fff\\">IOS-APPS<\\/span>","image":"20221127/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">ONTWERP<\\/span>","lower_st":"<span style=\\"color: #fff\\">DECOREER UW <\\/span>","title":"<span style=\\"color: #fff\\">SYSTEEM<\\/span>","image":"20221127/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">PRIJZEN<\\/span>","lower_st":"<span style=\\"color: #fff\\">HARTWINS <\\/span>","title":"<span style=\\"color: #fff\\">PRODUCTEN<\\/span>","image":"20221127/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
        ]));

        $this->updateLanguage('<span style="color: #fff">Subscribe to our Newsletter</span>', json_encode([
            'en' => '<span style="color: #fff">Subscribe to our Newsletter</span>',
            'bn' => '<span style="color: #fff">আমাদের নিউজলেটার সাবস্ক্রাইব করুন</span>',
            'fr' => '<span style="color: #fff">Abonnez-vous à notre newsletter</span>',
            'zh' => '<span style="color: #fff">订阅我们的新闻通讯</span>',
            'ar' => '<span style="color: #fff">اشترك في نشرتنا الإخبارية</span>',
            'be' => '<span style="color: #fff">Падпішыцеся на нашу рассылку</span>',
            'bg' => '<span style="color: #fff">Абонирайте се за нашия бюлетин</span>',
            'ca' => '<span style="color: #fff">Subscriu-te al nostre butlletí</span>',
            'et' => '<span style="color: #fff">Telli meie uudiskiri</span>',
            'nl' => '<span style="color: #fff">Abonneer je op onze nieuwsbrief</span>',
        ]));

        $message = <<<EOT
<span style="color: #fff">Get 10% off on your first purchase and stay updated with latest offers,\r
items, news and much more</span>
EOT;
        $this->updateLanguage($message, json_encode([
            'en' => '<span style="color: #fff">Get 10% off on your first purchase and stay updated with latest offers, items, news and much more</span>',
            'bn' => '<span style="color: #fff">প্রথম কেনার সময়ে 10% ছাড় পেতে এবং সর্বশেষ অফার, আইটেম, সংবাদ এবং অনেক আরও সাথে আপডেট থাকুন</span>',
            'fr' => '<span style="color: #fff">Obtenez 10% de réduction sur votre premier achat et restez informé des dernières offres, articles, nouvelles et bien plus encore</span>',
            'zh' => '<span style="color: #fff">首次购买即可享受10%的折扣，并随时了解最新优惠、商品、新闻等信息</span>',
            'ar' => '<span style="color: #fff">احصل على خصم 10٪ على عمليتك الشرائية الأولى وابق على اطلاع دائم بأحدث العروض، المنتجات، الأخبار والمزيد</span>',
            'be' => '<span style="color: #fff">Атрымайце 10% зніжкі на вашы першы пакупка і заставайцеся ў курсе апошніх прапановаў, тавараў, навін і многага іншага</span>',
            'bg' => '<span style="color: #fff">Вземете 10% отстъпка при първата си покупка и останете информирани за най-новите оферти, артикули, новини и много други</span>',
            'ca' => '<span style="color: #fff">Obtingueu un 10% de descompte en la vostra primera compra i mantingueu-vos actualitzat amb les últimes ofertes, articles, notícies i molt més</span>',
            'et' => '<span style="color: #fff">Saage oma esimeselt ostult 10% soodustust ja püsige kursis uusimate pakkumiste, esemete, uudiste ja palju muuga</span>',
            'nl' => '<span style="color: #fff">Ontvang 10% korting op uw eerste aankoop en blijf op de hoogte van de nieuwste aanbiedingen, items, nieuws en nog veel meer</span>',
        ]));

        $this->updateLanguage('{"u_subtitle":"<span style=\"color: #000;\">Visit<\/span>","l_subtitle":"Electronic","title":"Accessories","image":"20221205/cba5deddcae3205d94259425a9ff5bbe.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}', json_encode([
            'en' => '{"u_subtitle":"<span style=\\"color: #000;\\">Visit<\\/span>","l_subtitle":"Electronic","title":"Accessories","image":"20221205/cba5deddcae3205d94259425a9ff5bbe.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}',
            'bn' => '{"u_subtitle":"<span style=\\"color: #000;\\">পরিদর্শন করুন<\\/span>","l_subtitle":"ইলেকট্রনিক","title":"উপকরণ","image":"20221205/cba5deddcae3205d94259425a9ff5bbe.webp","button":"এখনই কিনুন","link":"http://localhost/multi-vendor/search-products?categories=ইলেকট্রনিক%20Devices"}',
            'fr' => '{"u_subtitle":"<span style=\\"color: #000;\\">Visitez<\\/span>","l_subtitle":"Électronique","title":"Accessoires","image":"20221205/cba5deddcae3205d94259425a9ff5bbe.webp","button":"Achetez maintenant","link":"http://localhost/multi-vendor/search-products?categories=Électronique%20Devices"}',
            'zh' => '{"u_subtitle":"<span style=\\"color: #000;\\">访问<\\/span>","l_subtitle":"电子","title":"配件","image":"20221205/cba5deddcae3205d94259425a9ff5bbe.webp","button":"立即购买","link":"http://localhost/multi-vendor/search-products?categories=电子%20Devices"}',
            'ar' => '{"u_subtitle":"<span style=\\"color: #000;\\">زيارة<\\/span>","l_subtitle":"إلكتروني","title":"ملحقات","image":"20221205/cba5deddcae3205d94259425a9ff5bbe.webp","button":"تسوق الآن","link":"http://localhost/multi-vendor/search-products?categories=إلكتروني%20Devices"}',
            'be' => '{"u_subtitle":"<span style=\\"color: #000;\\">Наведаць<\\/span>","l_subtitle":"Электронны","title":"Аксэсуары","image":"20221205/cba5deddcae3205d94259425a9ff5bbe.webp","button":"Купляйце зараз","link":"http://localhost/multi-vendor/search-products?categories=Электронны%20Devices"}',
            'bg' => '{"u_subtitle":"<span style=\\"color: #000;\\">Посетете<\\/span>","l_subtitle":"Електронен","title":"Аксесоари","image":"20221205/cba5deddcae3205d94259425a9ff5bbe.webp","button":"Пазарувайте сега","link":"http://localhost/multi-vendor/search-products?categories=Електронен%20Devices"}',
            'ca' => '{"u_subtitle":"<span style=\\"color: #000;\\">Visita<\\/span>","l_subtitle":"Electrònic","title":"Accessoris","image":"20221205/cba5deddcae3205d94259425a9ff5bbe.webp","button":"Compra ara","link":"http://localhost/multi-vendor/search-products?categories=Electrònic%20Devices"}',
            'et' => '{"u_subtitle":"<span style=\\"color: #000;\\">Külastage<\\/span>","l_subtitle":"Elektrooniline","title":"Tarvikud","image":"20221205/cba5deddcae3205d94259425a9ff5bbe.webp","button":"Osta kohe","link":"http://localhost/multi-vendor/search-products?categories=Elektrooniline%20Devices"}',
            'nl' => '{"u_subtitle":"<span style=\\"color: #000;\\">Bezoek<\\/span>","l_subtitle":"Elektronisch","title":"Accessoires","image":"20221205/cba5deddcae3205d94259425a9ff5bbe.webp","button":"Winkel nu","link":"http://localhost/multi-vendor/search-products?categories=Elektronisch%20Devices"}',
        ]));

        $this->updateLanguage('{"u_subtitle":"<span style=\"margin-top: 400px; display: block;\">SALES<\/span>","l_subtitle":"DISCOUNT UP TO","title":"50% OFF","image":"20221120\/8dbc149374c1046c5177438df2a021c7.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}', json_encode([
            'en' => '{"u_subtitle":"<span style=\\"margin-top: 400px; display: block;\\">SALES<\\/span>","l_subtitle":"DISCOUNT UP TO","title":"50% OFF","image":"20221120\\/8dbc149374c1046c5177438df2a021c7.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'bn' => '{"u_subtitle":"<span style=\\"margin-top: 400px; display: block;\\">বিক্রয়<\\/span>","l_subtitle":"ছাড় পর্যন্ত","title":"৫০% ছাড়","image":"20221120\\/8dbc149374c1046c5177438df2a021c7.webp","button":"এখনই কিনুন","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'fr' => '{"u_subtitle":"<span style=\\"margin-top: 400px; display: block;\\">VENTES<\\/span>","l_subtitle":"REMISE JUSQU\'À","title":"50% DE RÉDUCTION","image":"20221120\\/8dbc149374c1046c5177438df2a021c7.webp","button":"Achetez maintenant","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'zh' => '{"u_subtitle":"<span style=\\"margin-top: 400px; display: block;\\">销售<\\/span>","l_subtitle":"折扣高达","title":"5折优惠","image":"20221120\\/8dbc149374c1046c5177438df2a021c7.webp","button":"立即购买","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'ar' => '{"u_subtitle":"<span style=\\"margin-top: 400px; display: block;\\">مبيعات<\\/span>","l_subtitle":"خصم يصل إلى","title":"خصم 50٪","image":"20221120\\/8dbc149374c1046c5177438df2a021c7.webp","button":"تسوق الآن","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'be' => '{"u_subtitle":"<span style=\\"margin-top: 400px; display: block;\\">ПРОДАЖЫ<\\/span>","l_subtitle":"ЗНІЖКА ДА","title":"50% ЗНІЖКІ","image":"20221120\\/8dbc149374c1046c5177438df2a021c7.webp","button":"Купляйце зараз","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'bg' => '{"u_subtitle":"<span style=\\"margin-top: 400px; display: block;\\">ПРОДАЖБИ<\\/span>","l_subtitle":"ОТСТЪПКА ДО","title":"50% ОТСТЪПКА","image":"20221120\\/8dbc149374c1046c5177438df2a021c7.webp","button":"Пазарувайте сега","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'ca' => '{"u_subtitle":"<span style=\\"margin-top: 400px; display: block;\\">VENDES<\\/span>","l_subtitle":"DESCOMPTE FINS A","title":"50% DE DESCOMPTE","image":"20221120\\/8dbc149374c1046c5177438df2a021c7.webp","button":"Compra ara","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'et' => '{"u_subtitle":"<span style=\\"margin-top: 400px; display: block;\\">MÜÜK<\\/span>","l_subtitle":"SOODUSTUS KUNI","title":"50% ALLAHINDLUS","image":"20221120\\/8dbc149374c1046c5177438df2a021c7.webp","button":"Osta kohe","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'nl' => '{"u_subtitle":"<span style=\\"margin-top: 400px; display: block;\\">VERKOOP<\\/span>","l_subtitle":"KORTING TOT","title":"50% KORTING","image":"20221120\\/8dbc149374c1046c5177438df2a021c7.webp","button":"Winkel nu","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
        ]));

        $this->updateLanguage('[{"upper_st":"<span style=\"color: #fff\">MOBILE<\/span>","lower_st":"<span style=\"color: #fff\">CUSTOMIZED<\/span>","title":"<span style=\"color: #fff\">IOS APPS<\/span>","image":"20221127\/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\"color: #fff\">DESIGN<\/span>","lower_st":"<span style=\"color: #fff\">DECORATE YOUR <\/span>","title":"<span style=\"color: #fff\">SYSTEM<\/span>","image":"20221127\/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\"color: #fff\">AWARDS<\/span>","lower_st":"<span style=\"color: #fff\">HEART WINNING <\/span>","title":"<span style=\"color: #fff\">PRODUCTS<\/span>","image":"20221127\/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]', json_encode([
            'en' => '[{"upper_st":"<span style=\\"color: #fff\\">MOBILE<\\/span>","lower_st":"<span style=\\"color: #fff\\">CUSTOMIZED<\\/span>","title":"<span style=\\"color: #fff\\">IOS APPS<\\/span>","image":"20221127\\/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">DESIGN<\\/span>","lower_st":"<span style=\\"color: #fff\\">DECORATE YOUR <\\/span>","title":"<span style=\\"color: #fff\\">SYSTEM<\\/span>","image":"20221127\\/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">AWARDS<\\/span>","lower_st":"<span style=\\"color: #fff\\">HEART WINNING <\\/span>","title":"<span style=\\"color: #fff\\">PRODUCTS<\\/span>","image":"20221127\\/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'bn' => '[{"upper_st":"<span style=\\"color: #fff\\">মোবাইল<\\/span>","lower_st":"<span style=\\"color: #fff\\">কাস্টমাইজড<\\/span>","title":"<span style=\\"color: #fff\\">আইওএস অ্যাপস<\\/span>","image":"20221127\\/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">DESIGN<\\/span>","lower_st":"<span style=\\"color: #fff\\">আপনার সাজান <\\/span>","title":"<span style=\\"color: #fff\\">সিস্টেম<\\/span>","image":"20221127\\/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">পুরস্কার<\\/span>","lower_st":"<span style=\\"color: #fff\\">মনের জয় <\\/span>","title":"<span style=\\"color: #fff\\">পণ্য<\\/span>","image":"20221127\\/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'fr' => '[{"upper_st":"<span style=\\"color: #fff\\">MOBILE<\\/span>","lower_st":"<span style=\\"color: #fff\\">PERSONNALISÉ<\\/span>","title":"<span style=\\"color: #fff\\">APPLICATIONS IOS<\\/span>","image":"20221127\\/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">DESIGN<\\/span>","lower_st":"<span style=\\"color: #fff\\">DÉCOREZ VOTRE <\\/span>","title":"<span style=\\"color: #fff\\">SYSTÈME<\\/span>","image":"20221127\\/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">RÉCOMPENSES<\\/span>","lower_st":"<span style=\\"color: #fff\\">COEUR GAGNANT <\\/span>","title":"<span style=\\"color: #fff\\">PRODUITS<\\/span>","image":"20221127\\/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'zh' => '[{"upper_st":"<span style=\\"color: #fff\\">手机<\\/span>","lower_st":"<span style=\\"color: #fff\\">定制<\\/span>","title":"<span style=\\"color: #fff\\">iOS 应用程序<\\/span>","image":"20221127\\/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">DESIGN<\\/span>","lower_st":"<span style=\\"color: #fff\\">装饰你的 <\\/span>","title":"<span style=\\"color: #fff\\">系统<\\/span>","image":"20221127\\/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">奖项<\\/span>","lower_st":"<span style=\\"color: #fff\\">打动人心的 <\\/span>","title":"<span style=\\"color: #fff\\">产品<\\/span>","image":"20221127\\/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'ar' => '[{"upper_st":"<span style=\\"color: #fff\\">الهاتف المحمول<\\/span>","lower_st":"<span style=\\"color: #fff\\">مخصص<\\/span>","title":"<span style=\\"color: #fff\\">تطبيقات IOS<\\/span>","image":"20221127\\/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">DESIGN<\\/span>","lower_st":"<span style=\\"color: #fff\\">زخرف <\\/span>","title":"<span style=\\"color: #fff\\">نظام<\\/span>","image":"20221127\\/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">الجوائز<\\/span>","lower_st":"<span style=\\"color: #fff\\">الفوز بالقلوب <\\/span>","title":"<span style=\\"color: #fff\\">المنتجات<\\/span>","image":"20221127\\/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'be' => '[{"upper_st":"<span style=\\"color: #fff\\">МАБІЛЬНЫ<\\/span>","lower_st":"<span style=\\"color: #fff\\">КАСТАМІЗАВАНЫ<\\/span>","title":"<span style=\\"color: #fff\\">IOS ДАДАТКІ<\\/span>","image":"20221127\\/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">DESIGN<\\/span>","lower_st":"<span style=\\"color: #fff\\">УПРЫГОДЬЦЕ СВАЕ <\\/span>","title":"<span style=\\"color: #fff\\">СІСТЭМА<\\/span>","image":"20221127\\/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">УЗНАГАРОДЫ<\\/span>","lower_st":"<span style=\\"color: #fff\\">СЭРЦА ВЫГРАВАЕ <\\/span>","title":"<span style=\\"color: #fff\\">ПРАДУКТЫ<\\/span>","image":"20221127\\/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'bg' => '[{"upper_st":"<span style=\\"color: #fff\\">МОБИЛЕН<\\/span>","lower_st":"<span style=\\"color: #fff\\">ПЕРСОНАЛИЗИРАН<\\/span>","title":"<span style=\\"color: #fff\\">ПРИЛОЖЕНИЯ ЗА IOS<\\/span>","image":"20221127\\/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">DESIGN<\\/span>","lower_st":"<span style=\\"color: #fff\\">УКРАСЕТЕ ВАШИЯ <\\/span>","title":"<span style=\\"color: #fff\\">СИСТЕМА<\\/span>","image":"20221127\\/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">НАГРАДИ<\\/span>","lower_st":"<span style=\\"color: #fff\\">СПЕЧЕЛВАНЕ НА СЪРЦЕ <\\/span>","title":"<span style=\\"color: #fff\\">ПРОДУКТИ<\\/span>","image":"20221127\\/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'ca' => '[{"upper_st":"<span style=\\"color: #fff\\">MÒBIL<\\/span>","lower_st":"<span style=\\"color: #fff\\">PERSONALITZAT<\\/span>","title":"<span style=\\"color: #fff\\">APLICACIONS IOS<\\/span>","image":"20221127\\/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">DESIGN<\\/span>","lower_st":"<span style=\\"color: #fff\\">DECOREU EL VOSTRE <\\/span>","title":"<span style=\\"color: #fff\\">SISTEMA<\\/span>","image":"20221127\\/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">PREMIS<\\/span>","lower_st":"<span style=\\"color: #fff\\">COR GUANYADOR <\\/span>","title":"<span style=\\"color: #fff\\">PRODUCTES<\\/span>","image":"20221127\\/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'et' => '[{"upper_st":"<span style=\\"color: #fff\\">MOBIIL<\\/span>","lower_st":"<span style=\\"color: #fff\\">KOHANDATUD<\\/span>","title":"<span style=\\"color: #fff\\">IOS RAKENDUSED<\\/span>","image":"20221127\\/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">DESIGN<\\/span>","lower_st":"<span style=\\"color: #fff\\">KAUNISTA OMA <\\/span>","title":"<span style=\\"color: #fff\\">SÜSTEEM<\\/span>","image":"20221127\\/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">AUHINNAD<\\/span>","lower_st":"<span style=\\"color: #fff\\">SÜDAME VÕITMINE <\\/span>","title":"<span style=\\"color: #fff\\">TOOTED<\\/span>","image":"20221127\\/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
            'nl' => '[{"upper_st":"<span style=\\"color: #fff\\">MOBIEL<\\/span>","lower_st":"<span style=\\"color: #fff\\">AANGEPAST<\\/span>","title":"<span style=\\"color: #fff\\">IOS-APPS<\\/span>","image":"20221127\\/ae16685af1c819def9c014d01a6b3b91.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">DESIGN<\\/span>","lower_st":"<span style=\\"color: #fff\\">DECOREER UW <\\/span>","title":"<span style=\\"color: #fff\\">SYSTEEM<\\/span>","image":"20221127\\/490cad1f920ffcb3f6bb097224231d30.webp","btn_text":"","btn_link":""},{"upper_st":"<span style=\\"color: #fff\\">PRIJZEN<\\/span>","lower_st":"<span style=\\"color: #fff\\">HARTWINNEND <\\/span>","title":"<span style=\\"color: #fff\\">PRODUCTEN<\\/span>","image":"20221127\\/763ba674d3346b48c4f308c6413bdf39.webp","btn_text":"","btn_link":""}]',
        ]));

        $this->updateLanguage('[{"image":"20230508\\\\72911ed50cb98c54b7dd269a763d788d.png","title":"Free Shipping Worldwide","subtitle":"For all orders over $350"},{"image":"20230508\\\\9b51a4ca185894d42c25cc22db2e2b78.png","title":"Secured Online Payment","subtitle":"Payment protection guaranteed"},{"image":"20230508\\\\e28c3efa16347662b4f3f3877dc49741.png","title":"Money Back Guarantee","subtitle":"If goods have problems"}]', json_encode([
            'en' => '[{"image":"20230508\\\\72911ed50cb98c54b7dd269a763d788d.png","title":"Free Shipping Worldwide","subtitle":"For all orders over $350"},{"image":"20230508\\\\9b51a4ca185894d42c25cc22db2e2b78.png","title":"Secured Online Payment","subtitle":"Payment protection guaranteed"},{"image":"20230508\\\\e28c3efa16347662b4f3f3877dc49741.png","title":"Money Back Guarantee","subtitle":"If goods have problems"}]',
            'bn' => '[{"image":"20230508\\\\72911ed50cb98c54b7dd269a763d788d.png","title":"বিশ্বব্যাপী বিনামূল্যে শিপিং","subtitle":"সমস্ত অর্ডারের জন্য $350-এর বেশি"},{"image":"20230508\\\\9b51a4ca185894d42c25cc22db2e2b78.png","title":"নিরাপদ অনলাইন পেমেন্ট","subtitle":"পেমেন্ট সুরক্ষা নিশ্চিত"},{"image":"20230508\\\\e28c3efa16347662b4f3f3877dc49741.png","title":"টাকা ফেরত গ্যারান্টি","subtitle":"যদি পণ্যের সমস্যা হয়"}]',
            'fr' => '[{"image":"20230508\\\\72911ed50cb98c54b7dd269a763d788d.png","title":"Livraison gratuite dans le monde entier","subtitle":"Pour toutes les commandes de plus de 350 $"},{"image":"20230508\\\\9b51a4ca185894d42c25cc22db2e2b78.png","title":"Paiement en ligne sécurisé","subtitle":"Protection des paiements garantie"},{"image":"20230508\\\\e28c3efa16347662b4f3f3877dc49741.png","title":"Garantie de remboursement","subtitle":"Si les marchandises ont des problèmes"}]',
            'zh' => '[{"image":"20230508\\\\72911ed50cb98c54b7dd269a763d788d.png","title":"全球免费送货","subtitle":"所有超过350美元的订单"},{"image":"20230508\\\\9b51a4ca185894d42c25cc22db2e2b78.png","title":"安全的在线支付","subtitle":"付款保护有保障"},{"image":"20230508\\\\e28c3efa16347662b4f3f3877dc49741.png","title":"退款保证","subtitle":"如果商品有问题"}]',
            'ar' => '[{"image":"20230508\\\\72911ed50cb98c54b7dd269a763d788d.png","title":"شحن مجاني في جميع أنحاء العالم","subtitle":"لكل الطلبات التي تزيد عن 350 دولارًا"},{"image":"20230508\\\\9b51a4ca185894d42c25cc22db2e2b78.png","title":"دفع آمن عبر الإنترنت","subtitle":"حماية الدفع مضمونة"},{"image":"20230508\\\\e28c3efa16347662b4f3f3877dc49741.png","title":"ضمان استعادة الاموال","subtitle":"إذا كانت البضائع بها مشاكل"}]',
            'be' => '[{"image":"20230508\\\\72911ed50cb98c54b7dd269a763d788d.png","title":"Бясплатная дастаўка па ўсім свеце","subtitle":"Для ўсіх заказаў на суму больш за 350 долараў"},{"image":"20230508\\\\9b51a4ca185894d42c25cc22db2e2b78.png","title":"Бяспечная аплата онлайн","subtitle":"Гарантаваная абарона плацяжоў"},{"image":"20230508\\\\e28c3efa16347662b4f3f3877dc49741.png","title":"Гарантыя вяртання грошай","subtitle":"Калі ёсць праблемы з таварам"}]',
            'bg' => '[{"image":"20230508\\\\72911ed50cb98c54b7dd269a763d788d.png","title":"Безплатна доставка по целия свят","subtitle":"За всички поръчки над 350 долара"},{"image":"20230508\\\\9b51a4ca185894d42c25cc22db2e2b78.png","title":"Защитено онлайн плащане","subtitle":"Гарантирана защита на плащанията"},{"image":"20230508\\\\e28c3efa16347662b4f3f3877dc49741.png","title":"Гаранция за връщане на парите","subtitle":"Ако стоките имат проблеми"}]',
            'ca' => '[{"image":"20230508\\\\72911ed50cb98c54b7dd269a763d788d.png","title":"Enviament gratuït a tot el món","subtitle":"Per a totes les comandes superiors a 350 $"},{"image":"20230508\\\\9b51a4ca185894d42c25cc22db2e2b78.png","title":"Pagament en línia segur","subtitle":"Protecció de pagament garantida"},{"image":"20230508\\\\e28c3efa16347662b4f3f3877dc49741.png","title":"Garantia de devolució de diners","subtitle":"Si els productes tenen problemes"}]',
            'et' => '[{"image":"20230508\\\\72911ed50cb98c54b7dd269a763d788d.png","title":"Tasuta saatmine üle maailma","subtitle":"Kõigi üle 350-dollariliste tellimuste puhul"},{"image":"20230508\\\\9b51a4ca185894d42c25cc22db2e2b78.png","title":"Turvaline veebimakse","subtitle":"Maksekaitse garanteeritud"},{"image":"20230508\\\\e28c3efa16347662b4f3f3877dc49741.png","title":"Raha tagasi garantii","subtitle":"Kui kaupadega on probleeme"}]',
            'nl' => '[{"image":"20230508\\\\72911ed50cb98c54b7dd269a763d788d.png","title":"Gratis verzending wereldwijd","subtitle":"Voor alle bestellingen boven de $350"},{"image":"20230508\\\\9b51a4ca185894d42c25cc22db2e2b78.png","title":"Beveiligde online betaling","subtitle":"Betalingsbescherming gegarandeerd"},{"image":"20230508\\\\e28c3efa16347662b4f3f3877dc49741.png","title":"Geld-terug-garantie","subtitle":"Als er problemen zijn met goederen"}]',
        ]));

        $this->updateLanguage('[{"upper_st":"<p style=\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\">On Sale This Week<\/p>","lower_st":"<span style=\"font-size: 20px;\">Stay Active and <br> Connected<\/span>","title":"","image":"20240319\\\\31c1b66368166e8a196561ad96bffec5.png","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/products\/smart-bracelet-sports-bracelet-d13-color-screen-bracelet-sports-pedometer-bluetooth-reminder-heart-rate-blood-pressure"},{"upper_st":"<p style=\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\">On Sale This Week<\/p>","lower_st":"<span style=\"font-size: 20px;\">Enhanced Gaming <br> Experience <\/span>","title":"","image":"20240319\\\\14a0cd1cb520e380c38bffca9329fec9.jpg","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/products\/wireless-game-controller-for-switch-pro-lite-olde-gamepad-joystick-for-pc-game-controller"},{"upper_st":"<p style=\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\">On Sale This Week<\/p>","lower_st":"<span style=\"font-size: 20px;\">Fast Charging <br> Data Cable<\/span>","title":"","image":"20240319\\\\731ba00c478644c7b71124ff75fb1514.png","btn_text":"Show Now","btn_link":"http://localhost/multi-vendor/products\/usb-type-c-cable-2-in-1-fast-charging-cord-data-sync-charger-line-speed-transfer"}]', json_encode([
            'en' => '[{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">On Sale This Week<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Stay Active and <br> Connected<\\\\/span>","title":"","image":"20240319\\\\31c1b66368166e8a196561ad96bffec5.png","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/products\\\\/smart-bracelet-sports-bracelet-d13-color-screen-bracelet-sports-pedometer-bluetooth-reminder-heart-rate-blood-pressure"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">On Sale This Week<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Enhanced Gaming <br> Experience <\\\\/span>","title":"","image":"20240319\\\\14a0cd1cb520e380c38bffca9329fec9.jpg","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/products\\\\/wireless-game-controller-for-switch-pro-lite-olde-gamepad-joystick-for-pc-game-controller"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">On Sale This Week<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Fast Charging <br> Data Cable<\\\\/span>","title":"","image":"20240319\\\\731ba00c478644c7b71124ff75fb1514.png","btn_text":"Show Now","btn_link":"http://localhost/multi-vendor/products\\\\/usb-type-c-cable-2-in-1-fast-charging-cord-data-sync-charger-line-speed-transfer"}]',
            'bn' => '[{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">এই সপ্তাহে বিক্রিতে<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">সক্রিয় থাকুন এবং <br> সংযুক্ত<\\\\/span>","title":"","image":"20240319\\\\31c1b66368166e8a196561ad96bffec5.png","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/products\\\\/smart-bracelet-sports-bracelet-d13-color-screen-bracelet-sports-pedometer-bluetooth-reminder-heart-rate-blood-pressure"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">এই সপ্তাহে বিক্রিতে<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">উন্নত গেমিং <br> অভিজ্ঞতা <\\\\/span>","title":"","image":"20240319\\\\14a0cd1cb520e380c38bffca9329fec9.jpg","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/products\\\\/wireless-game-controller-for-switch-pro-lite-olde-gamepad-joystick-for-pc-game-controller"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">এই সপ্তাহে বিক্রিতে<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">দ্রুত চার্জিং <br> ডেটা কেবল<\\\\/span>","title":"","image":"20240319\\\\731ba00c478644c7b71124ff75fb1514.png","btn_text":"এখন দেখান","btn_link":"http://localhost/multi-vendor/products\\\\/usb-type-c-cable-2-in-1-fast-charging-cord-data-sync-charger-line-speed-transfer"}]',
            'fr' => '[{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">En vente cette semaine<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Restez actif et <br> Connecté<\\\\/span>","title":"","image":"20240319\\\\31c1b66368166e8a196561ad96bffec5.png","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/products\\\\/smart-bracelet-sports-bracelet-d13-color-screen-bracelet-sports-pedometer-bluetooth-reminder-heart-rate-blood-pressure"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">En vente cette semaine<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Jeu amélioré <br> Expérience <\\\\/span>","title":"","image":"20240319\\\\14a0cd1cb520e380c38bffca9329fec9.jpg","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/products\\\\/wireless-game-controller-for-switch-pro-lite-olde-gamepad-joystick-for-pc-game-controller"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">En vente cette semaine<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Charge rapide <br> Câble de données<\\\\/span>","title":"","image":"20240319\\\\731ba00c478644c7b71124ff75fb1514.png","btn_text":"Afficher maintenant","btn_link":"http://localhost/multi-vendor/products\\\\/usb-type-c-cable-2-in-1-fast-charging-cord-data-sync-charger-line-speed-transfer"}]',
            'zh' => '[{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">本周特卖<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">保持活跃并且 <br> 连接的<\\\\/span>","title":"","image":"20240319\\\\31c1b66368166e8a196561ad96bffec5.png","btn_text":"立即购买","btn_link":"http://localhost/multi-vendor/products\\\\/smart-bracelet-sports-bracelet-d13-color-screen-bracelet-sports-pedometer-bluetooth-reminder-heart-rate-blood-pressure"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">本周特卖<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">增强的游戏 <br> 体验 <\\\\/span>","title":"","image":"20240319\\\\14a0cd1cb520e380c38bffca9329fec9.jpg","btn_text":"立即购买","btn_link":"http://localhost/multi-vendor/products\\\\/wireless-game-controller-for-switch-pro-lite-olde-gamepad-joystick-for-pc-game-controller"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">本周特卖<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">快速充电 <br> 数据线<\\\\/span>","title":"","image":"20240319\\\\731ba00c478644c7b71124ff75fb1514.png","btn_text":"立即显示","btn_link":"http://localhost/multi-vendor/products\\\\/usb-type-c-cable-2-in-1-fast-charging-cord-data-sync-charger-line-speed-transfer"}]',
            'ar' => '[{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">للبيع هذا الأسبوع<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">ابق نشيطا و <br> متصل<\\\\/span>","title":"","image":"20240319\\\\31c1b66368166e8a196561ad96bffec5.png","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/products\\\\/smart-bracelet-sports-bracelet-d13-color-screen-bracelet-sports-pedometer-bluetooth-reminder-heart-rate-blood-pressure"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">للبيع هذا الأسبوع<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">ألعاب محسّنة <br> تجربة <\\\\/span>","title":"","image":"20240319\\\\14a0cd1cb520e380c38bffca9329fec9.jpg","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/products\\\\/wireless-game-controller-for-switch-pro-lite-olde-gamepad-joystick-for-pc-game-controller"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">للبيع هذا الأسبوع<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">شحن سريع <br> كابل بيانات<\\\\/span>","title":"","image":"20240319\\\\731ba00c478644c7b71124ff75fb1514.png","btn_text":"اعرض الآن","btn_link":"http://localhost/multi-vendor/products\\\\/usb-type-c-cable-2-in-1-fast-charging-cord-data-sync-charger-line-speed-transfer"}]',
            'be' => '[{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">На продажы на гэтым тыдні<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Заставайцеся актыўнымі і <br> Падключаны<\\\\/span>","title":"","image":"20240319\\\\31c1b66368166e8a196561ad96bffec5.png","btn_text":"Купляйце зараз","btn_link":"http://localhost/multi-vendor/products\\\\/smart-bracelet-sports-bracelet-d13-color-screen-bracelet-sports-pedometer-bluetooth-reminder-heart-rate-blood-pressure"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">На продажы на гэтым тыдні<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Палепшаная гульня <br> Вопыт <\\\\/span>","title":"","image":"20240319\\\\14a0cd1cb520e380c38bffca9329fec9.jpg","btn_text":"Купляйце зараз","btn_link":"http://localhost/multi-vendor/products\\\\/wireless-game-controller-for-switch-pro-lite-olde-gamepad-joystick-for-pc-game-controller"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">На продажы на гэтым тыдні<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Хуткая зарадка <br> Дадатковы кабель<\\\\/span>","title":"","image":"20240319\\\\731ba00c478644c7b71124ff75fb1514.png","btn_text":"Паказаць зараз","btn_link":"http://localhost/multi-vendor/products\\\\/usb-type-c-cable-2-in-1-fast-charging-cord-data-sync-charger-line-speed-transfer"}]',
            'bg' => '[{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">В продажба тази седмица<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Останете активни и <br> Свързан<\\\\/span>","title":"","image":"20240319\\\\31c1b66368166e8a196561ad96bffec5.png","btn_text":"Пазарувайте сега","btn_link":"http://localhost/multi-vendor/products\\\\/smart-bracelet-sports-bracelet-d13-color-screen-bracelet-sports-pedometer-bluetooth-reminder-heart-rate-blood-pressure"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">В продажба тази седмица<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Подобрена игра <br> Опит <\\\\/span>","title":"","image":"20240319\\\\14a0cd1cb520e380c38bffca9329fec9.jpg","btn_text":"Пазарувайте сега","btn_link":"http://localhost/multi-vendor/products\\\\/wireless-game-controller-for-switch-pro-lite-olde-gamepad-joystick-for-pc-game-controller"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">В продажба тази седмица<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Бързо зареждане <br> Кабел за данни<\\\\/span>","title":"","image":"20240319\\\\731ba00c478644c7b71124ff75fb1514.png","btn_text":"Покажи сега","btn_link":"http://localhost/multi-vendor/products\\\\/usb-type-c-cable-2-in-1-fast-charging-cord-data-sync-charger-line-speed-transfer"}]',
            'ca' => '[{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">En venda aquesta setmana<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Mantingueu-vos actius i <br> Connectat<\\\\/span>","title":"","image":"20240319\\\\31c1b66368166e8a196561ad96bffec5.png","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/products\\\\/smart-bracelet-sports-bracelet-d13-color-screen-bracelet-sports-pedometer-bluetooth-reminder-heart-rate-blood-pressure"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">En venda aquesta setmana<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Joc millorat <br> Experiència <\\\\/span>","title":"","image":"20240319\\\\14a0cd1cb520e380c38bffca9329fec9.jpg","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/products\\\\/wireless-game-controller-for-switch-pro-lite-olde-gamepad-joystick-for-pc-game-controller"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">En venda aquesta setmana<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Càrrega ràpida <br> Cable de dades<\\\\/span>","title":"","image":"20240319\\\\731ba00c478644c7b71124ff75fb1514.png","btn_text":"Mostrar ara","btn_link":"http://localhost/multi-vendor/products\\\\/usb-type-c-cable-2-in-1-fast-charging-cord-data-sync-charger-line-speed-transfer"}]',
            'et' => '[{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">Müügil sel nädalal<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Olge aktiivne ja <br> Ühendatud<\\\\/span>","title":"","image":"20240319\\\\31c1b66368166e8a196561ad96bffec5.png","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/products\\\\/smart-bracelet-sports-bracelet-d13-color-screen-bracelet-sports-pedometer-bluetooth-reminder-heart-rate-blood-pressure"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">Müügil sel nädalal<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Tõhustatud mängimine <br> Kogemus <\\\\/span>","title":"","image":"20240319\\\\14a0cd1cb520e380c38bffca9329fec9.jpg","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/products\\\\/wireless-game-controller-for-switch-pro-lite-olde-gamepad-joystick-for-pc-game-controller"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">Müügil sel nädalal<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Kiire laadimine <br> Andmekaabel<\\\\/span>","title":"","image":"20240319\\\\731ba00c478644c7b71124ff75fb1514.png","btn_text":"Kuva kohe","btn_link":"http://localhost/multi-vendor/products\\\\/usb-type-c-cable-2-in-1-fast-charging-cord-data-sync-charger-line-speed-transfer"}]',
            'nl' => '[{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">Deze week te koop<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Blijf actief en <br> Verbonden<\\\\/span>","title":"","image":"20240319\\\\31c1b66368166e8a196561ad96bffec5.png","btn_text":"Winkel nu","btn_link":"http://localhost/multi-vendor/products\\\\/smart-bracelet-sports-bracelet-d13-color-screen-bracelet-sports-pedometer-bluetooth-reminder-heart-rate-blood-pressure"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">Deze week te koop<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Verbeterd gamen <br> Ervaring <\\\\/span>","title":"","image":"20240319\\\\14a0cd1cb520e380c38bffca9329fec9.jpg","btn_text":"Winkel nu","btn_link":"http://localhost/multi-vendor/products\\\\/wireless-game-controller-for-switch-pro-lite-olde-gamepad-joystick-for-pc-game-controller"},{"upper_st":"<p style=\\\\"color: #fff;background: #ef233c;display: inline-block;padding: 2px 8px;border-radius: 5px;font-size: 12px;font-weight: bold;margin-bottom: 20px;\\\\">Deze week te koop<\\\\/p>","lower_st":"<span style=\\\\"font-size: 20px;\\\\">Snel opladen <br> Datakabel<\\\\/span>","title":"","image":"20240319\\\\731ba00c478644c7b71124ff75fb1514.png","btn_text":"Nu laten zien","btn_link":"http://localhost/multi-vendor/products\\\\/usb-type-c-cable-2-in-1-fast-charging-cord-data-sync-charger-line-speed-transfer"}]',
        ]));

        $this->updatelanguage('Search And Order All Your Phone <br> Parts  In One Location ', json_encode([
            'en' => 'Search And Order All Your Phone <br> Parts  In One Location ',
            'bn' => 'আপনার সমস্ত ফোন অনুসন্ধান করুন এবং অর্ডার করুন <br> Parts  In One Location ',
            'fr' => 'Recherchez et commandez tous vos téléphones <br> Parts  In One Location ',
            'zh' => '搜索并订购您的所有手机 <br> Parts  In One Location ',
            'ar' => 'ابحث واطلب جميع هواتفك <br> Parts  In One Location ',
            'be' => 'Шукайце і заказвайце ўсе вашыя тэлефоны <br> Parts  In One Location ',
            'bg' => 'Търсете и поръчайте всички ваши телефони <br> Parts  In One Location ',
            'ca' => 'Cerca i demana tots els teus telèfons <br> Parts  In One Location ',
            'et' => 'Otsi ja telli kõik oma telefonid <br> Parts  In One Location ',
            'nl' => 'Zoek en bestel al je telefoons <br> Parts  In One Location ',
        ]));

        $this->updateLanguage('<p class="text-lg font-medium text-gray-10 dm-sans" style="color: red; margin-bottom: 20px; ">On Sale This Week</p>', json_encode([
            'en' => '<p class="text-lg font-medium text-gray-10 dm-sans" style="color: red; margin-bottom: 20px; ">On Sale This Week</p>',
            'bn' => '<p class="text-lg font-medium text-gray-10 dm-sans" style="color: red; margin-bottom: 20px; ">এই সপ্তাহে বিক্রি</p>',
            'fr' => '<p class="text-lg font-medium text-gray-10 dm-sans" style="color: red; margin-bottom: 20px; ">En vente cette semaine</p>',
            'zh' => '<p class="text-lg font-medium text-gray-10 dm-sans" style="color: red; margin-bottom: 20px; ">本周特卖</p>',
            'ar' => '<p class="text-lg font-medium text-gray-10 dm-sans" style="color: red; margin-bottom: 20px; ">للبيع هذا الأسبوع</p>',
            'be' => '<p class="text-lg font-medium text-gray-10 dm-sans" style="color: red; margin-bottom: 20px; ">На продажы на гэтым тыдні</p>',
            'bg' => '<p class="text-lg font-medium text-gray-10 dm-sans" style="color: red; margin-bottom: 20px; ">В продажба тази седмица</p>',
            'ca' => '<p class="text-lg font-medium text-gray-10 dm-sans" style="color: red; margin-bottom: 20px; ">En venda aquesta setmana</p>',
            'et' => '<p class="text-lg font-medium text-gray-10 dm-sans" style="color: red; margin-bottom: 20px; ">Müügil sel nädalal</p>',
            'nl' => '<p class="text-lg font-medium text-gray-10 dm-sans" style="color: red; margin-bottom: 20px; ">Deze week te koop</p>',
        ]));

        $this->updateLanguage('[{"upper_st":"SMALL & MINIMAL","lower_st":"<span style=\"color: #FF693A\">FURNITURE<\/span> FOR ","title":"BOOKWORMS","image":"20240319\\\\dc65b5a163000b416d3e29baaf0e026e.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"FANCY SOFAS","lower_st":"<span style=\"color: #FF693A\">LUXURIOUS<\/span> ","title":"COMFORT","image":"20240319\\\\cba7b005cb23101f7eeafcb15c3b49f6.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]', json_encode([
            'en' => '[{"upper_st":"SMALL & MINIMAL","lower_st":"<span style=\\\\"color: #FF693A\\\\">FURNITURE<\\\\/span> FOR ","title":"BOOKWORMS","image":"20240319\\\\dc65b5a163000b416d3e29baaf0e026e.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"FANCY SOFAS","lower_st":"<span style=\\\\"color: #FF693A\\\\">LUXURIOUS<\\\\/span> ","title":"COMFORT","image":"20240319\\\\cba7b005cb23101f7eeafcb15c3b49f6.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'bn' => '[{"upper_st":"ছোট এবং নিরলম্ব","lower_st":"<span style=\\\\"color: #FF693A\\\\">ফার্নিচার<\\\\/span> জন্য ","title":"বইমানুষ","image":"20240319\\\\dc65b5a163000b416d3e29baaf0e026e.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"লক্ষীয় সোফা","lower_st":"<span style=\\\\"color: #FF693A\\\\">প্রাধান্যপূর্ণ<\\\\/span> ","title":"COMজন্যT","image":"20240319\\\\cba7b005cb23101f7eeafcb15c3b49f6.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'fr' => '[{"upper_st":"PETIT ET MINIMALISTE","lower_st":"<span style=\\\\"color: #FF693A\\\\">MEUBLES<\\\\/span> POUR ","title":"BIBLIOPHILES","image":"20240319\\\\dc65b5a163000b416d3e29baaf0e026e.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"CANAPÉS CHICS","lower_st":"<span style=\\\\"color: #FF693A\\\\">LUXUEUX<\\\\/span> ","title":"COMPOURT","image":"20240319\\\\cba7b005cb23101f7eeafcb15c3b49f6.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'zh' => '[{"upper_st":"小而简约","lower_st":"<span style=\\\\"color: #FF693A\\\\">家具<\\\\/span> 为 ","title":"书虫","image":"20240319\\\\dc65b5a163000b416d3e29baaf0e026e.webp","btn_text":"立即购买","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"花哨的沙发","lower_st":"<span style=\\\\"color: #FF693A\\\\">豪华的<\\\\/span> ","title":"COM为T","image":"20240319\\\\cba7b005cb23101f7eeafcb15c3b49f6.webp","btn_text":"立即购买","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'ar' => '[{"upper_st":"صغيرة وبسيطة","lower_st":"<span style=\\\\"color: #FF693A\\\\">أثاث<\\\\/span> من أجل ","title":"دودة الكتب","image":"20240319\\\\dc65b5a163000b416d3e29baaf0e026e.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"أرائك فاخرة","lower_st":"<span style=\\\\"color: #FF693A\\\\">فخم<\\\\/span> ","title":"COMمن أجلT","image":"20240319\\\\cba7b005cb23101f7eeafcb15c3b49f6.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'be' => '[{"upper_st":"МАЛЕНКІ І МІНІМАЛЬНЫ","lower_st":"<span style=\\\\"color: #FF693A\\\\">МЕБЛІ<\\\\/span> ДЛЯ ","title":"КНІЖНЫЯ ЧЭРВІ","image":"20240319\\\\dc65b5a163000b416d3e29baaf0e026e.webp","btn_text":"Купляйце зараз","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"ФАНТАЗІЙНЫЯ ДІВАНЫ","lower_st":"<span style=\\\\"color: #FF693A\\\\">РАЗКАШАНЫ<\\\\/span> ","title":"COMДЛЯT","image":"20240319\\\\cba7b005cb23101f7eeafcb15c3b49f6.webp","btn_text":"Купляйце зараз","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'bg' => '[{"upper_st":"МАЛЪК И МИНИМАЛИСТИЧЕН","lower_st":"<span style=\\\\"color: #FF693A\\\\">МЕБЕЛИ<\\\\/span> ЗА ","title":"КНИЖОМРЪСТИ","image":"20240319\\\\dc65b5a163000b416d3e29baaf0e026e.webp","btn_text":"Пазарувайте сега","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"ФАНСИДНИ ДИВАНИ","lower_st":"<span style=\\\\"color: #FF693A\\\\">РАЗКОШЕН<\\\\/span> ","title":"COMЗАT","image":"20240319\\\\cba7b005cb23101f7eeafcb15c3b49f6.webp","btn_text":"Пазарувайте сега","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'ca' => '[{"upper_st":"PETIT I MINIMALISTA","lower_st":"<span style=\\\\"color: #FF693A\\\\">MOBLES<\\\\/span> PER ","title":"VERMELLÓ DE LLIBRES","image":"20240319\\\\dc65b5a163000b416d3e29baaf0e026e.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"SOFA DE FANTASIA","lower_st":"<span style=\\\\"color: #FF693A\\\\">LUXURIOSO<\\\\/span> ","title":"COMPERT","image":"20240319\\\\cba7b005cb23101f7eeafcb15c3b49f6.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'et' => '[{"upper_st":"VÄIKE JA MINIMAALNE","lower_st":"<span style=\\\\"color: #FF693A\\\\">MÖÖBEL<\\\\/span> JAOKS ","title":"RAAMATUTÜÜR","image":"20240319\\\\dc65b5a163000b416d3e29baaf0e026e.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"FANTAASIA SOFAD","lower_st":"<span style=\\\\"color: #FF693A\\\\">LUKSUSLIK<\\\\/span> ","title":"COMJAOKST","image":"20240319\\\\cba7b005cb23101f7eeafcb15c3b49f6.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'nl' => '[{"upper_st":"KLEIN EN MINIMAAL","lower_st":"<span style=\\\\"color: #FF693A\\\\">MEUBILAIR<\\\\/span> VOOR ","title":"BOEKENWURMEN","image":"20240319\\\\dc65b5a163000b416d3e29baaf0e026e.webp","btn_text":"Winkel nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"FANTASIEVE SOFA\'S","lower_st":"<span style=\\\\"color: #FF693A\\\\">LUXUEUS<\\\\/span> ","title":"COMVOORT","image":"20240319\\\\cba7b005cb23101f7eeafcb15c3b49f6.webp","btn_text":"Winkel nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
        ]));

        $this->updateLanguage('[{"upper_st":"NEW ARRIVALS","lower_st":"ALL ABOUT <span style=\"color: #FF693A\">MINIMAL<\/span> ","title":"WOODS","image":"20240319\\\\1ce486fbf78225853056d8159a3d8648.webp","btn_text":"Visit Shop","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"LIGHTS","lower_st":"<span style=\"color: #FF693A\">BRIGHTEN<\/span> YOUR ","title":"SWEET HOME","image":"20240319\\\\e3ebce6984437aee1fd4635b3733fc7f.webp","btn_text":"Visit Shop","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]', json_encode([
            'en' => '[{"upper_st":"NEW ARRIVALS","lower_st":"ALL ABOUT <span style=\\\\"color: #FF693A\\\\">MINIMAL<\\\\/span> ","title":"WOODS","image":"20240319\\\\1ce486fbf78225853056d8159a3d8648.webp","btn_text":"Visit Shop","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"LIGHTS","lower_st":"<span style=\\\\"color: #FF693A\\\\">BRIGHTEN<\\\\/span> YOUR ","title":"SWEET HOME","image":"20240319\\\\e3ebce6984437aee1fd4635b3733fc7f.webp","btn_text":"Visit Shop","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'bn' => '[{"upper_st":"নতুন আগমন","lower_st":"সব সম্পর্কে <span style=\\\\"color: #FF693A\\\\">সারল<\\\\/span> ","title":"কাঠের","image":"20240319\\\\1ce486fbf78225853056d8159a3d8648.webp","btn_text":"দোকান দেখুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"আলো","lower_st":"<span style=\\\\"color: #FF693A\\\\">উজ্জ্বল করা<\\\\/span> আপনার ","title":"মিষ্টি বাড়ি","image":"20240319\\\\e3ebce6984437aee1fd4635b3733fc7f.webp","btn_text":"দোকান দেখুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'fr' => '[{"upper_st":"NOUVEAUTÉS","lower_st":"TOUT SUR <span style=\\\\"color: #FF693A\\\\">MINIMALISTE<\\\\/span> ","title":"BOIS","image":"20240319\\\\1ce486fbf78225853056d8159a3d8648.webp","btn_text":"Visitez la boutique","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"LUMIÈRES","lower_st":"<span style=\\\\"color: #FF693A\\\\">ÉCLAIRER<\\\\/span> VOTRE ","title":"DOUX FOYER","image":"20240319\\\\e3ebce6984437aee1fd4635b3733fc7f.webp","btn_text":"Visitez la boutique","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'zh' => '[{"upper_st":"新到货","lower_st":"一切关于 <span style=\\\\"color: #FF693A\\\\">极简<\\\\/span> ","title":"木材","image":"20240319\\\\1ce486fbf78225853056d8159a3d8648.webp","btn_text":"访问商店","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"灯","lower_st":"<span style=\\\\"color: #FF693A\\\\">发亮<\\\\/span> 你的 ","title":"甜蜜的家","image":"20240319\\\\e3ebce6984437aee1fd4635b3733fc7f.webp","btn_text":"访问商店","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'ar' => '[{"upper_st":"وافدات جديدة","lower_st":"كل شيء عن <span style=\\\\"color: #FF693A\\\\">حد الأدنى<\\\\/span> ","title":"خشب","image":"20240319\\\\1ce486fbf78225853056d8159a3d8648.webp","btn_text":"زيارة المتجر","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"أضواء","lower_st":"<span style=\\\\"color: #FF693A\\\\">إضاءة<\\\\/span> لك ","title":"منزل حلو","image":"20240319\\\\e3ebce6984437aee1fd4635b3733fc7f.webp","btn_text":"زيارة المتجر","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'be' => '[{"upper_st":"НОВЫЯ ПРЫБЫЛІ","lower_st":"УСЁ ПРА <span style=\\\\"color: #FF693A\\\\">МІНІМАЛЬНЫ<\\\\/span> ","title":"ДРЭВА","image":"20240319\\\\1ce486fbf78225853056d8159a3d8648.webp","btn_text":"НАВЕСЦІ ДЗЕРЖАВУ","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"СВЕТ","lower_st":"<span style=\\\\"color: #FF693A\\\\">СВЕТЛА<\\\\/span> ВАШ ","title":"СЛАДКІ ДОМ","image":"20240319\\\\e3ebce6984437aee1fd4635b3733fc7f.webp","btn_text":"НАВЕСЦІ ДЗЕРЖАВУ","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'bg' => '[{"upper_st":"НОВИ ПРИШЕСТВИЯ","lower_st":"ВСИЧКО ЗА <span style=\\\\"color: #FF693A\\\\">МИНИМАЛЕН<\\\\/span> ","title":"ДРЪВЦЕ","image":"20240319\\\\1ce486fbf78225853056d8159a3d8648.webp","btn_text":"ПОСЕТЕТЕ МАГАЗИНА","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"СВЕТЛИНИ","lower_st":"<span style=\\\\"color: #FF693A\\\\">ОСВЕТЛЕНИЕ<\\\\/span> ТВОЙ ","title":"СЛАДЪК ДОМ","image":"20240319\\\\e3ebce6984437aee1fd4635b3733fc7f.webp","btn_text":"ПОСЕТЕТЕ МАГАЗИНА","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'ca' => '[{"upper_st":"NOVES ARREPLEGATS","lower_st":"TOT SOBRE <span style=\\\\"color: #FF693A\\\\">MINIMAL<\\\\/span> ","title":"BOSC","image":"20240319\\\\1ce486fbf78225853056d8159a3d8648.webp","btn_text":"VISITEU LA BOTIGA","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"LLUMS","lower_st":"<span style=\\\\"color: #FF693A\\\\">BRILLANT<\\\\/span> TEU ","title":"DOLÇ HOGAR","image":"20240319\\\\e3ebce6984437aee1fd4635b3733fc7f.webp","btn_text":"VISITEU LA BOTIGA","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'et' => '[{"upper_st":"UUED SAABUMISED","lower_st":"KÕIK KOHTA <span style=\\\\"color: #FF693A\\\\">MINIMAALNE<\\\\/span> ","title":"PUUD","image":"20240319\\\\1ce486fbf78225853056d8159a3d8648.webp","btn_text":"KÜLASTA POODI","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"TULED","lower_st":"<span style=\\\\"color: #FF693A\\\\">HELEDAMAKS<\\\\/span> SINU ","title":"MAGUS KODU","image":"20240319\\\\e3ebce6984437aee1fd4635b3733fc7f.webp","btn_text":"KÜLASTA POODI","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'nl' => '[{"upper_st":"NIEUWE AANKOMSTEN","lower_st":"ALLES OVER <span style=\\\\"color: #FF693A\\\\">MINIMAAL<\\\\/span> ","title":"HOUT","image":"20240319\\\\1ce486fbf78225853056d8159a3d8648.webp","btn_text":"BEZOEK DE WINKEL","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"upper_st":"LICHTEN","lower_st":"<span style=\\\\"color: #FF693A\\\\">VERLICHTEN<\\\\/span> JE ","title":"ZOET HUIS","image":"20240319\\\\e3ebce6984437aee1fd4635b3733fc7f.webp","btn_text":"BEZOEK DE WINKEL","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
        ]));

        $this->updateLanguage('[{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\"color: #F81B4D\">HEALTHY<\/span> LIFE ","title":"ADVENTURES","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"Explore Now","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\"color: #F81B4D\">HEALTHY<\/span> LIFE ","title":"ADVENTURES","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Visit","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\"color: #F81B4D\">HEALTHY<\/span> LIFE ","title":"ADVENTURES","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Shop Now","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\"color: #F81B4D\">HEALTHY<\/span> LIFE ","title":"ADVENTURES","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"Buy Now","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]', json_encode([
            'en' => '[{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\\"color: #F81B4D\\">HEALTHY<\\/span> LIFE ","title":"ADVENTURES","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"Explore Now","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\\"color: #F81B4D\\">HEALTHY<\\/span> LIFE ","title":"ADVENTURES","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Visit","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\\"color: #F81B4D\\">HEALTHY<\\/span> LIFE ","title":"ADVENTURES","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Shop Now","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\\"color: #F81B4D\\">HEALTHY<\\/span> LIFE ","title":"ADVENTURES","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"Buy Now","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'bn' => '[{"u_subtitle":"জৈব","l_subtitle":"<span style=\\"color: #F81B4D\\">সুস্থ<\\/span> জীবন ","title":"অভিযান","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"এখনই অন্বেষণ করুন","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"জৈব","l_subtitle":"<span style=\\"color: #F81B4D\\">সুস্থ<\\/span> জীবন ","title":"অভিযান","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Visit","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"জৈব","l_subtitle":"<span style=\\"color: #F81B4D\\">সুস্থ<\\/span> জীবন ","title":"অভিযান","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Shop Now","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"জৈব","l_subtitle":"<span style=\\"color: #F81B4D\\">সুস্থ<\\/span> জীবন ","title":"অভিযান","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"এখনই কেনুন","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'fr' => '[{"u_subtitle":"BIOLOGIQUE","l_subtitle":"<span style=\\"color: #F81B4D\\">SAINE<\\/span> VIE ","title":"AVENTURES","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"Explorez maintenant","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"BIOLOGIQUE","l_subtitle":"<span style=\\"color: #F81B4D\\">SAINE<\\/span> VIE ","title":"AVENTURES","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Visit","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"BIOLOGIQUE","l_subtitle":"<span style=\\"color: #F81B4D\\">SAINE<\\/span> VIE ","title":"AVENTURES","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Shop Now","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"BIOLOGIQUE","l_subtitle":"<span style=\\"color: #F81B4D\\">SAINE<\\/span> VIE ","title":"AVENTURES","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"Achetez maintenant","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'zh' => '[{"u_subtitle":"有机","l_subtitle":"<span style=\\"color: #F81B4D\\">健康<\\/span> 生活 ","title":"冒险","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"立即探索","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"有机","l_subtitle":"<span style=\\"color: #F81B4D\\">健康<\\/span> 生活 ","title":"冒险","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Visit","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"有机","l_subtitle":"<span style=\\"color: #F81B4D\\">健康<\\/span> 生活 ","title":"冒险","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Shop Now","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"有机","l_subtitle":"<span style=\\"color: #F81B4D\\">健康<\\/span> 生活 ","title":"冒险","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"立即购买","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'ar' => '[{"u_subtitle":"عضوي","l_subtitle":"<span style=\\"color: #F81B4D\\">صحي<\\/span> حياة ","title":"مغامرات","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"استكشاف الآن","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"عضوي","l_subtitle":"<span style=\\"color: #F81B4D\\">صحي<\\/span> حياة ","title":"مغامرات","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Visit","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"عضوي","l_subtitle":"<span style=\\"color: #F81B4D\\">صحي<\\/span> حياة ","title":"مغامرات","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Shop Now","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"عضوي","l_subtitle":"<span style=\\"color: #F81B4D\\">صحي<\\/span> حياة ","title":"مغامرات","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"اشتري الآن","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'be' => '[{"u_subtitle":"ОРГАНІЧНЫ","l_subtitle":"<span style=\\"color: #F81B4D\\">ЗДАРОЎ<\\/span> ЖЫЦЦЁ ","title":"АДВЕНТЫ","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"Даследаваць зараз","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"ОРГАНІЧНЫ","l_subtitle":"<span style=\\"color: #F81B4D\\">ЗДАРОЎ<\\/span> ЖЫЦЦЁ ","title":"АДВЕНТЫ","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Visit","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"ОРГАНІЧНЫ","l_subtitle":"<span style=\\"color: #F81B4D\\">ЗДАРОЎ<\\/span> ЖЫЦЦЁ ","title":"АДВЕНТЫ","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Shop Now","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"ОРГАНІЧНЫ","l_subtitle":"<span style=\\"color: #F81B4D\\">ЗДАРОЎ<\\/span> ЖЫЦЦЁ ","title":"АДВЕНТЫ","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"Купляйце зараз","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'bg' => '[{"u_subtitle":"ОРГАНИЧЕН","l_subtitle":"<span style=\\"color: #F81B4D\\">ЗДРАВОСЛОВЕН<\\/span> ЖИВОТ ","title":"ПРИКЛЮЧЕНИЯ","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"Изследвайте сега","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"ОРГАНИЧЕН","l_subtitle":"<span style=\\"color: #F81B4D\\">ЗДРАВОСЛОВЕН<\\/span> ЖИВОТ ","title":"ПРИКЛЮЧЕНИЯ","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Visit","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"ОРГАНИЧЕН","l_subtitle":"<span style=\\"color: #F81B4D\\">ЗДРАВОСЛОВЕН<\\/span> ЖИВОТ ","title":"ПРИКЛЮЧЕНИЯ","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Shop Now","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"ОРГАНИЧЕН","l_subtitle":"<span style=\\"color: #F81B4D\\">ЗДРАВОСЛОВЕН<\\/span> ЖИВОТ ","title":"ПРИКЛЮЧЕНИЯ","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"Купете сега","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'ca' => '[{"u_subtitle":"ORGÀNIC","l_subtitle":"<span style=\\"color: #F81B4D\\">SALUDABLE<\\/span> VIDA ","title":"AVENTURES","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"Explora ara","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"ORGÀNIC","l_subtitle":"<span style=\\"color: #F81B4D\\">SALUDABLE<\\/span> VIDA ","title":"AVENTURES","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Visit","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"ORGÀNIC","l_subtitle":"<span style=\\"color: #F81B4D\\">SALUDABLE<\\/span> VIDA ","title":"AVENTURES","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Shop Now","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"ORGÀNIC","l_subtitle":"<span style=\\"color: #F81B4D\\">SALUDABLE<\\/span> VIDA ","title":"AVENTURES","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"Compra ara","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'et' => '[{"u_subtitle":"ORGANILINE","l_subtitle":"<span style=\\"color: #F81B4D\\">TERVE<\\/span> ELU ","title":"SEIKLUSED","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"Uuri kohe","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"ORGANILINE","l_subtitle":"<span style=\\"color: #F81B4D\\">TERVE<\\/span> ELU ","title":"SEIKLUSED","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Visit","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"ORGANILINE","l_subtitle":"<span style=\\"color: #F81B4D\\">TERVE<\\/span> ELU ","title":"SEIKLUSED","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Shop Now","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"ORGANILINE","l_subtitle":"<span style=\\"color: #F81B4D\\">TERVE<\\/span> ELU ","title":"SEIKLUSED","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"Osta kohe","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
            'nl' => '[{"u_subtitle":"BIOLOGISCH","l_subtitle":"<span style=\\"color: #F81B4D\\">GEZOND<\\/span> LEVEN ","title":"AVONTUREN","image":"20221205/bdf1b2983bbb8fdd1660117bad20b550.webp","button_text":"Verken nu","button_link":"http://localhost/multi-vendor/search-products?categories=Woman%20Fashion"},{"u_subtitle":"BIOLOGISCH","l_subtitle":"<span style=\\"color: #F81B4D\\">GEZOND<\\/span> LEVEN ","title":"AVONTUREN","image":"20221205/b54581f3631b4160ebca1b7abdd43615.webp","button_text":"Visit","button_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"},{"u_subtitle":"BIOLOGISCH","l_subtitle":"<span style=\\"color: #F81B4D\\">GEZOND<\\/span> LEVEN ","title":"AVONTUREN","image":"20221205/df0c8982b5edc94493c84fe23c95c5e2.webp","button_text":"Shop Now","button_link":"http://localhost/multi-vendor/search-products?categories=Man%20Fashion"},{"u_subtitle":"BIOLOGISCH","l_subtitle":"<span style=\\"color: #F81B4D\\">GEZOND<\\/span> LEVEN ","title":"AVONTUREN","image":"20221205/3701e828742af4336f96019823e8faba.webp","button_text":"Koop nu","button_link":"http://localhost/multi-vendor/search-products?categories=Electronic%20Devices"}]',
        ]));

        $this->updateLanguage('{"u_subtitle":"<span style=\"color:#2c2c2c\">For Men<\/span>","l_subtitle":"SPREAD <span style=\"color:red\">Handsome<\/span> ","title":"Outfit","image":"20221123/a032be4f9f09a82934d28c9879b1e156.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}', json_encode([
            'en' => '{"u_subtitle":"<span style=\\"color:#2c2c2c\\">For Men<\\/span>","l_subtitle":"SPREAD <span style=\\"color:red\\">Handsome<\\/span> ","title":"Outfit","image":"20221123/a032be4f9f09a82934d28c9879b1e156.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'bn' => '{"u_subtitle":"<span style=\\"color:#2c2c2c\\">পুরুষদের জন্য<\\/span>","l_subtitle":"ছড়ান <span style=\\"color:red\\">সুন্দর<\\/span> ","title":"আউটফিট","image":"20221123/a032be4f9f09a82934d28c9879b1e156.webp","button":"এখনই কিনুন","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'fr' => '{"u_subtitle":"<span style=\\"color:#2c2c2c\\">Pour les hommes<\\/span>","l_subtitle":"ÉTALER <span style=\\"color:red\\">Beau<\\/span> ","title":"Tenue","image":"20221123/a032be4f9f09a82934d28c9879b1e156.webp","button":"Achetez maintenant","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'zh' => '{"u_subtitle":"<span style=\\"color:#2c2c2c\\">男士<\\/span>","l_subtitle":"展开 <span style=\\"color:red\\">英俊<\\/span> ","title":"装备","image":"20221123/a032be4f9f09a82934d28c9879b1e156.webp","button":"立即购买","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'ar' => '{"u_subtitle":"<span style=\\"color:#2c2c2c\\">للرجال<\\/span>","l_subtitle":"انتشار <span style=\\"color:red\\">وسيم<\\/span> ","title":"زي","image":"20221123/a032be4f9f09a82934d28c9879b1e156.webp","button":"تسوق الآن","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'be' => '{"u_subtitle":"<span style=\\"color:#2c2c2c\\">ДЛЯ МУЖЧЫН<\\/span>","l_subtitle":"РАСПАЎСЦІ <span style=\\"color:red\\">СЦІШАНЫ<\\/span> ","title":"ВОДЗЕННЕ","image":"20221123/a032be4f9f09a82934d28c9879b1e156.webp","button":"Купляйце зараз","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'bg' => '{"u_subtitle":"<span style=\\"color:#2c2c2c\\">ЗА МЪЖЕ<\\/span>","l_subtitle":"РАЗПРОСТРАНЕНИЕ <span style=\\"color:red\\">КРАСИВ<\\/span> ","title":"ОБЛЕКЛО","image":"20221123/a032be4f9f09a82934d28c9879b1e156.webp","button":"Пазарувайте сега","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'ca' => '{"u_subtitle":"<span style=\\"color:#2c2c2c\\">Per als homes<\\/span>","l_subtitle":"ESTENDRE <span style=\\"color:red\\">GUAP<\\/span> ","title":"CONJUNT","image":"20221123/a032be4f9f09a82934d28c9879b1e156.webp","button":"Compra ara","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'et' => '{"u_subtitle":"<span style=\\"color:#2c2c2c\\">Mehed<\\/span>","l_subtitle":"LAOTUS <span style=\\"color:red\\">KENA<\\/span> ","title":"RIIETUS","image":"20221123/a032be4f9f09a82934d28c9879b1e156.webp","button":"Osta kohe","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
            'nl' => '{"u_subtitle":"<span style=\\"color:#2c2c2c\\">Voor mannen<\\/span>","l_subtitle":"VERSPREIDEN <span style=\\"color:red\\">Knap<\\/span> ","title":"Outfit","image":"20221123/a032be4f9f09a82934d28c9879b1e156.webp","button":"Winkel nu","link":"http://localhost/multi-vendor/search-products?categories=Fashion"}',
        ]));

        $this->updateLanguage('[{"upper_st":"<span style=\"font-size: 18px;\">Organic<\/span>","lower_st":"<span style=\"font-size: 33px;\">Coconut Oil from Sri Lanka<\/span>","title":"<span style=\"font-size: 16px; text-transform:none;\">Starting from only <span style=\"color: #FA886A\">$12.49<\/span><\/span>","image":"20221115/cbf367882d17b2df4f93572aa4b4e2f1.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]', json_encode([
            'en' => '[{"upper_st":"<span style=\\"font-size: 18px;\\">Organic<\\/span>","lower_st":"<span style=\\"font-size: 33px;\\">Coconut Oil from Sri Lanka<\\/span>","title":"<span style=\\"font-size: 16px; text-transform:none;\\">Starting from only <span style=\\"color: #FA886A\\">$12.49<\\/span><\\/span>","image":"20221115/cbf367882d17b2df4f93572aa4b4e2f1.webp","btn_text":"Shop Now","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'bn' => '[{"upper_st":"<span style=\\"font-size: 18px;\\">জৈব<\\/span>","lower_st":"<span style=\\"font-size: 33px;\\">শ্রীলঙ্কা থেকে নারিকেলের তেল<\\/span>","title":"<span style=\\"font-size: 16px; text-transform:none;\\">শুরু করে কেবল <span style=\\"color: #FA886A\\">$12.49<\\/span><\\/span>","image":"20221115/cbf367882d17b2df4f93572aa4b4e2f1.webp","btn_text":"এখনই কিনুন","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'fr' => '[{"upper_st":"<span style=\\"font-size: 18px;\\">Bio<\\/span>","lower_st":"<span style=\\"font-size: 33px;\\">Huile de noix de coco du Sri Lanka<\\/span>","title":"<span style=\\"font-size: 16px; text-transform:none;\\">À partir de seulement <span style=\\"color: #FA886A\\">$12.49<\\/span><\\/span>","image":"20221115/cbf367882d17b2df4f93572aa4b4e2f1.webp","btn_text":"Achetez maintenant","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'zh' => '[{"upper_st":"<span style=\\"font-size: 18px;\\">有机<\\/span>","lower_st":"<span style=\\"font-size: 33px;\\">斯里兰卡椰子油<\\/span>","title":"<span style=\\"font-size: 16px; text-transform:none;\\">仅售 <span style=\\"color: #FA886A\\">$12.49<\\/span><\\/span>","image":"20221115/cbf367882d17b2df4f93572aa4b4e2f1.webp","btn_text":"立即购买","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'ar' => '[{"upper_st":"<span style=\\"font-size: 18px;\\">عضوي<\\/span>","lower_st":"<span style=\\"font-size: 33px;\\">زيت جوز الهند من سري لانكا<\\/span>","title":"<span style=\\"font-size: 16px; text-transform:none;\\">ابتداء من فقط <span style=\\"color: #FA886A\\">$12.49<\\/span><\\/span>","image":"20221115/cbf367882d17b2df4f93572aa4b4e2f1.webp","btn_text":"تسوق الآن","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'be' => '[{"upper_st":"<span style=\\"font-size: 18px;\\">Органічны<\\/span>","lower_st":"<span style=\\"font-size: 33px;\\">Какосавае масла з Шры-Ланкі<\\/span>","title":"<span style=\\"font-size: 16px; text-transform:none;\\">Пачынаючы толькі ад <span style=\\"color: #FA886A\\">$12.49<\\/span><\\/span>","image":"20221115/cbf367882d17b2df4f93572aa4b4e2f1.webp","btn_text":"Купляйце зараз","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'bg' => '[{"upper_st":"<span style=\\"font-size: 18px;\\">Органичен<\\/span>","lower_st":"<span style=\\"font-size: 33px;\\">Кокосово масло от Шри Ланка<\\/span>","title":"<span style=\\"font-size: 16px; text-transform:none;\\">Започвайки само от <span style=\\"color: #FA886A\\">$12.49<\\/span><\\/span>","image":"20221115/cbf367882d17b2df4f93572aa4b4e2f1.webp","btn_text":"Пазарувайте сега","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'ca' => '[{"upper_st":"<span style=\\"font-size: 18px;\\">Orgànic<\\/span>","lower_st":"<span style=\\"font-size: 33px;\\">Oli de coco del Sri Lanka<\\/span>","title":"<span style=\\"font-size: 16px; text-transform:none;\\">Començant només per <span style=\\"color: #FA886A\\">$12.49<\\/span><\\/span>","image":"20221115/cbf367882d17b2df4f93572aa4b4e2f1.webp","btn_text":"Compra ara","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'et' => '[{"upper_st":"<span style=\\"font-size: 18px;\\">Orgaaniline<\\/span>","lower_st":"<span style=\\"font-size: 33px;\\">Kookosõli Sri Lankalt<\\/span>","title":"<span style=\\"font-size: 16px; text-transform:none;\\">Alustades ainult <span style=\\"color: #FA886A\\">$12.49<\\/span><\\/span>","image":"20221115/cbf367882d17b2df4f93572aa4b4e2f1.webp","btn_text":"Osta kohe","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
            'nl' => '[{"upper_st":"<span style=\\"font-size: 18px;\\">Biologisch<\\/span>","lower_st":"<span style=\\"font-size: 33px;\\">Kokosolie uit Sri Lanka<\\/span>","title":"<span style=\\"font-size: 16px; text-transform:none;\\">Alleen vanaf <span style=\\"color: #FA886A\\">$12.49<\\/span><\\/span>","image":"20221115/cbf367882d17b2df4f93572aa4b4e2f1.webp","btn_text":"Winkel nu","btn_link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}]',
        ]));

        $this->updateLanguage('{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\"color: #F81B4D\">HEALTHY<\/span> LIFE ","title":"ADVENTURES","image":"20221123/70fe548781b9bc65fba1f565a4b9852b.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}', json_encode([
            'en' => '{"u_subtitle":"ORGANIC","l_subtitle":"<span style=\\"color: #F81B4D\\">HEALTHY<\\/span> LIFE ","title":"ADVENTURES","image":"20221123/70fe548781b9bc65fba1f565a4b9852b.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}',
            'bn' => '{"u_subtitle":"জৈব","l_subtitle":"<span style=\\"color: #F81B4D\\">সুস্থ<\\/span> জীবন ","title":"অভিযান","image":"20221123/70fe548781b9bc65fba1f565a4b9852b.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}',
            'fr' => '{"u_subtitle":"BIO","l_subtitle":"<span style=\\"color: #F81B4D\\">SAIN<\\/span> VIE ","title":"AVENTURES","image":"20221123/70fe548781b9bc65fba1f565a4b9852b.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}',
            'zh' => '{"u_subtitle":"有机","l_subtitle":"<span style=\\"color: #F81B4D\\">健康<\\/span> 生活 ","title":"冒险","image":"20221123/70fe548781b9bc65fba1f565a4b9852b.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}',
            'ar' => '{"u_subtitle":"عضوي","l_subtitle":"<span style=\\"color: #F81B4D\\">صحي<\\/span> حياة ","title":"مغامرات","image":"20221123/70fe548781b9bc65fba1f565a4b9852b.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}',
            'be' => '{"u_subtitle":"ОРГАНІЧНЫ","l_subtitle":"<span style=\\"color: #F81B4D\\">ЗДАРОЎ<\\/span> ЖЫЦЦЁ ","title":"АДВЕНТЫ","image":"20221123/70fe548781b9bc65fba1f565a4b9852b.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}',
            'bg' => '{"u_subtitle":"ОРГАНИЧЕН","l_subtitle":"<span style=\\"color: #F81B4D\\">ЗДРАВОСЛОВЕН<\\/span> ЖИВОТ ","title":"ПРИКЛЮЧЕНИЯ","image":"20221123/70fe548781b9bc65fba1f565a4b9852b.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}',
            'ca' => '{"u_subtitle":"ORGÀNIC","l_subtitle":"<span style=\\"color: #F81B4D\\">SALUDABLE<\\/span> VIDA ","title":"AVENTURES","image":"20221123/70fe548781b9bc65fba1f565a4b9852b.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}',
            'et' => '{"u_subtitle":"ORGANILINE","l_subtitle":"<span style=\\"color: #F81B4D\\">TERVE<\\/span> ELU ","title":"SEIKLUSED","image":"20221123/70fe548781b9bc65fba1f565a4b9852b.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}',
            'nl' => '{"u_subtitle":"BIOLOGISCH","l_subtitle":"<span style=\\"color: #F81B4D\\">GEZOND<\\/span> LEVEN ","title":"AVONTUREN","image":"20221123/70fe548781b9bc65fba1f565a4b9852b.webp","button":"Shop Now","link":"http://localhost/multi-vendor/search-products?categories=Home%20Appliances"}',
        ]));

        $message = <<<EOT
<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">\r
<div class="relative">\r
<div  class="w-full h-80 overflow-hidden">\r
<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/jacket.jpg" alt="">\r
<span class="absolute -mt-12 ml-5">\r
<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Jacket</span></a>\r
</span>\r
</div>\r
</div>\r
<div  class="w-full h-80 overflow-hidden">\r
<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/men.jpg" alt="">\r
<span class="absolute -mt-12 ml-5">\r
<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Man</span></a>\r
</span>\r
</div>\r
<div  class="w-full h-80 overflow-hidden">\r
<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/women.jpg" alt="">\r
\r
<span class="absolute -mt-12 ml-5">\r
<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Women</span></a>\r
</span>\r
</div>\r
</div>
EOT;

        $this->updateLanguage($message, json_encode([
            'en' => '<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">'
                . '<div class="relative">'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/jacket.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Jacket</span></a>'
                . '</span>'
                . '</div>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/men.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Man</span></a>'
                . '</span>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/women.jpg" alt="">'

                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Women</span></a>'
                . '</span>'
                . '</div>'
                . '</div>',
            'bn' => '<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">'
                . '<div class="relative">'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/jacket.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">জ্যাকেট</span></a>'
                . '</span>'
                . '</div>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/men.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">পুরুষ</span></a>'
                . '</span>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/women.jpg" alt="">'

                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">মহিলা</span></a>'
                . '</span>'
                . '</div>'
                . '</div>',
            'fr' => '<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">'
                . '<div class="relative">'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/jacket.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Veste</span></a>'
                . '</span>'
                . '</div>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/men.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Homme</span></a>'
                . '</span>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/women.jpg" alt="">'

                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Femmes</span></a>'
                . '</span>'
                . '</div>'
                . '</div>',
            'zh' => '<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">'
                . '<div class="relative">'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/jacket.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">夹克</span></a>'
                . '</span>'
                . '</div>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/men.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">男人</span></a>'
                . '</span>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/women.jpg" alt="">'

                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">女人</span></a>'
                . '</span>'
                . '</div>'
                . '</div>',
            'ar' => '<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">'
                . '<div class="relative">'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/jacket.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">سترة</span></a>'
                . '</span>'
                . '</div>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/men.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">رجل</span></a>'
                . '</span>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/women.jpg" alt="">'

                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">نساء</span></a>'
                . '</span>'
                . '</div>'
                . '</div>',
            'be' => '<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">'
                . '<div class="relative">'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/jacket.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Куртка</span></a>'
                . '</span>'
                . '</div>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/men.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Мужчына</span></a>'
                . '</span>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/women.jpg" alt="">'

                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Жанчыны</span></a>'
                . '</span>'
                . '</div>'
                . '</div>',
            'bg' => '<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">'
                . '<div class="relative">'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/jacket.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Яке</span></a>'
                . '</span>'
                . '</div>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/men.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Мъж</span></a>'
                . '</span>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/women.jpg" alt="">'

                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Жени</span></a>'
                . '</span>'
                . '</div>'
                . '</div>',
            'ca' => '<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">'
                . '<div class="relative">'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/jacket.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Jaqueta</span></a>'
                . '</span>'
                . '</div>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/men.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Home</span></a>'
                . '</span>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/women.jpg" alt="">'

                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Dones</span></a>'
                . '</span>'
                . '</div>'
                . '</div>',
            'et' => '<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">'
                . '<div class="relative">'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/jacket.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Jakk</span></a>'
                . '</span>'
                . '</div>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/men.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Mees</span></a>'
                . '</span>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/women.jpg" alt="">'

                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Naised</span></a>'
                . '</span>'
                . '</div>'
                . '</div>',
            'nl' => '<div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-3">'
                . '<div class="relative">'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/jacket.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Jas</span></a>'
                . '</span>'
                . '</div>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/men.jpg" alt="">'
                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Man</span></a>'
                . '</span>'
                . '</div>'
                . '<div  class="w-full h-80 overflow-hidden">'
                . '<img class="transition-all delay-150 transform h-full w-full object-cover ease-in-out cursor-pointer  hover:translate-y-1 hover:scale-125 duration-1000" src="https://rovercrm-codecanyan-description.techvill.org/martvill/women.jpg" alt="">'

                . '<span class="absolute -mt-12 ml-5">'
                . '<a  href="#"><span class="font-mono capitalize font-medium text-xl leading-5 hover:text-green-500">Vrouwen</span></a>'
                . '</span>'
                . '</div>'
                . '</div>',
        ]));
    }
}
