<?php

namespace Modules\Dummy\Database\Seeders\Modules\Shipping\Versions\V2_4_0;

use Illuminate\Database\Seeder;

class ShippingProvidersTableSeeder extends Seeder
{
    /**
     * Auto generated seed file
     *
     * @return void
     */
    public function run()
    {
        \DB::statement('SET FOREIGN_KEY_CHECKS=0;');

        \DB::table('shipping_providers')->delete();

        \DB::table('shipping_providers')->insert([
            0 => [
                'id' => 1,
                'name' => 'Australia Post',
                'slug' => 'australia-post',
                'country_id' => 15,
                'tracking_base_url' => 'https://auspost.com.au/mypost/track/details/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            1 => [
                'id' => 2,
                'name' => 'CouriersPlease',
                'slug' => 'couriersplease',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.couriersplease.com.au/tools-track?no=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            2 => [
                'id' => 3,
                'name' => 'Dai Post',
                'slug' => 'dai-post',
                'country_id' => 15,
                'tracking_base_url' => 'https://daiglobaltrack.com/tracking.aspx?custtracknbr=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            3 => [
                'id' => 4,
                'name' => 'StarTrack',
                'slug' => 'startrack',
                'country_id' => 15,
                'tracking_base_url' => 'https://startrack.com.au/track/details/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            4 => [
                'id' => 6,
                'name' => 'DPD Austria',
                'slug' => 'dpd-at',
                'country_id' => 16,
                'tracking_base_url' => 'http://www.mydpd.at/?f=parcel.load&amp;p=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            5 => [
                'id' => 7,
                'name' => 'post.at',
                'slug' => 'post-at',
                'country_id' => 16,
                'tracking_base_url' => 'http://www.post.at/sendungsverfolgung.php?pnum1=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            6 => [
                'id' => 10,
                'name' => 'Canada Post',
                'slug' => 'canada-post',
                'country_id' => 2,
                'tracking_base_url' => 'https://www.canadapost.ca/track-reperage/en#/search?searchFor=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            7 => [
                'id' => 11,
                'name' => 'Canpar',
                'slug' => 'canpar',
                'country_id' => 2,
                'tracking_base_url' => 'https://www.canpar.ca/en/tracking/track.htm?barcode=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            8 => [
                'id' => 12,
                'name' => 'Correos Chile',
                'slug' => 'correos-chile',
                'country_id' => 44,
                'tracking_base_url' => 'https://www.correos.cl/web/guest/seguimiento-en-linea?codigos=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            9 => [
                'id' => 13,
                'name' => 'China Post',
                'slug' => 'china-post',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.ems.com.cn/english',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            10 => [
                'id' => 14,
                'name' => 'EMS',
                'slug' => 'ems',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.ems.post/en/global-network/tracking',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            11 => [
                'id' => 17,
                'name' => 'Correos Costa Rica',
                'slug' => 'correos-costa-rica',
                'country_id' => 52,
                'tracking_base_url' => 'https://correos.go.cr/rastreo/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            12 => [
                'id' => 19,
                'name' => 'DPD Czech Republic',
                'slug' => 'dpd-cz',
                'country_id' => 56,
                'tracking_base_url' => 'https://tracking.dpd.de/parcelstatus?locale=cs_CZ&query=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            13 => [
                'id' => 20,
                'name' => 'Chronopost',
                'slug' => 'chronopost',
                'country_id' => 74,
                'tracking_base_url' => 'https://www.chronopost.fr/fr/chrono_suivi_search?listeNumerosLT=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            14 => [
                'id' => 21,
                'name' => 'Colis Privé',
                'slug' => 'colis-prive',
                'country_id' => 74,
                'tracking_base_url' => 'https://www.colisprive.com/moncolis/pages/detailColis.aspx?numColis=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            15 => [
                'id' => 22,
                'name' => 'Colissimo',
                'slug' => 'colissimo',
                'country_id' => 74,
                'tracking_base_url' => 'https://www.laposte.fr/outils/suivre-vos-envois?code=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            16 => [
                'id' => 23,
                'name' => 'La Poste',
                'slug' => 'la-poste',
                'country_id' => 74,
                'tracking_base_url' => 'https://www.laposte.fr/outils/suivre-vos-envois?code=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            17 => [
                'id' => 24,
                'name' => 'Mondial Relay',
                'slug' => 'mondial-relay',
                'country_id' => 74,
                'tracking_base_url' => 'https://www.mondialrelay.fr/suivi-de-colis?numeroExpedition=%number%&CodePostal=%postal_code%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            18 => [
                'id' => 25,
                'name' => 'Deutsche Post',
                'slug' => 'deutsche-post',
                'country_id' => 82,
                'tracking_base_url' => 'https://www.deutschepost.de/en/s/shipment-tracking.html?piececode=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            19 => [
                'id' => 28,
                'name' => 'DPD Germany',
                'slug' => 'dpd-de',
                'country_id' => 82,
                'tracking_base_url' => 'https://tracking.dpd.de/parcelstatus?query=%number%&amp;amp;locale=en_DE',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            20 => [
                'id' => 29,
                'name' => 'Hermes Germany',
                'slug' => 'hermes-de',
                'country_id' => 82,
                'tracking_base_url' => 'https://www.myhermes.de/empfangen/sendungsverfolgung/?suche=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            21 => [
                'id' => 30,
                'name' => 'UPS Germany',
                'slug' => 'ups-germany',
                'country_id' => 82,
                'tracking_base_url' => 'https://wwwapps.ups.com/WebTracking/processInputRequest?sort_by=status&tracknums_displayed=1&TypeOfInquiryNumber=T&loc=de_DE&InquiryNumber1=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            22 => [
                'id' => 31,
                'name' => 'Hong Kong Post',
                'slug' => 'hong-kong-post',
                'country_id' => 97,
                'tracking_base_url' => 'https://www.hongkongpost.hk/en/mail_tracking/index.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            23 => [
                'id' => 33,
                'name' => 'Delhivery',
                'slug' => 'delhivery',
                'country_id' => 100,
                'tracking_base_url' => 'https://www.delhivery.com/track/package/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            24 => [
                'id' => 34,
                'name' => 'Ukraine EMS',
                'slug' => 'ukraine-ems',
                'country_id' => 224,
                'tracking_base_url' => 'http://dpsz.ua/en/track/ems',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            25 => [
                'id' => 35,
                'name' => 'Swiss Post',
                'slug' => 'swiss-post',
                'country_id' => 208,
                'tracking_base_url' => 'https://www.post.ch/swisspost-tracking?formattedParcelCodes=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            26 => [
                'id' => 36,
                'name' => 'Ecom Express',
                'slug' => 'ecom-express',
                'country_id' => 100,
                'tracking_base_url' => 'https://ecomexpress.in/tracking/?awb_field=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            27 => [
                'id' => 37,
                'name' => 'India Post',
                'slug' => 'india-post',
                'country_id' => 100,
                'tracking_base_url' => 'https://www.indiapost.gov.in/_layouts/15/dop.portal.tracking/trackconsignment.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            28 => [
                'id' => 38,
                'name' => 'Israel Post',
                'slug' => 'israel-post',
                'country_id' => 105,
                'tracking_base_url' => 'https://mypost.israelpost.co.il/itemtrace?itemcode=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            29 => [
                'id' => 39,
                'name' => 'DHL se',
                'slug' => 'dhl-se',
                'country_id' => 207,
                'tracking_base_url' => 'https://www.dhl.com/se-sv/home/tracking/tracking-freight.html?tracking-id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            30 => [
                'id' => 40,
                'name' => 'JP Post',
                'slug' => 'jp-post',
                'country_id' => 109,
                'tracking_base_url' => 'https://trackings.post.japanpost.jp/services/srv/search/direct?reqCodeNo1=%number%&searchKind=S002&locale=ja',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            31 => [
                'id' => 41,
                'name' => 'Latvia Post',
                'slug' => 'latvijas-pasts',
                'country_id' => 119,
                'tracking_base_url' => 'https://track.pasts.lv/consignment/tracking?type=pasts&ampid=&lttrackid=&gt=&id=%number%&type=pasts&button=Track',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            32 => [
                'id' => 42,
                'name' => 'South African Post Office',
                'slug' => 'south-african-post-office',
                'country_id' => 197,
                'tracking_base_url' => 'http://www.southafricanpostoffice.post/index.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            33 => [
                'id' => 43,
                'name' => 'DPD Netherlands',
                'slug' => 'dpd-nl',
                'country_id' => 152,
                'tracking_base_url' => 'https://tracking.dpd.de/status/nl_NL/parcel/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            34 => [
                'id' => 44,
                'name' => 'PostNL',
                'slug' => 'postnl',
                'country_id' => 152,
                'tracking_base_url' => 'https://tracking.postnl.nl/track-and-trace/%number%-%country_code%-%postal_code%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            35 => [
                'id' => 45,
                'name' => 'DPD Romania',
                'slug' => 'dpd-romania',
                'country_id' => 178,
                'tracking_base_url' => 'https://tracking.dpd.ro/?shipmentNumber=%number%&language=ro',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            36 => [
                'id' => 47,
                'name' => 'Ninja Van',
                'slug' => 'ninja-van',
                'country_id' => 192,
                'tracking_base_url' => 'https://www.ninjavan.co/en-sg/?tracking_id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            37 => [
                'id' => 48,
                'name' => 'Singapore Post',
                'slug' => 'singapore-post',
                'country_id' => 192,
                'tracking_base_url' => 'https://www.singpost.com/track-items?trackingid=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            38 => [
                'id' => 49,
                'name' => 'Portugal Post - CTT',
                'slug' => 'portugal-post-ctt',
                'country_id' => 173,
                'tracking_base_url' => 'https://www.ctt.pt/feapl_2/app/open/objectSearch/objectSearch.jspx?objects=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            39 => [
                'id' => 50,
                'name' => 'PostNord Sverige AB',
                'slug' => 'postnord-sverige-ab',
                'country_id' => 207,
                'tracking_base_url' => 'https://www.postnord.se/vara-verktyg/spara-brev-paket-och-pall?shipmentId=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            40 => [
                'id' => 51,
                'name' => 'UPS.se',
                'slug' => 'ups-se',
                'country_id' => 207,
                'tracking_base_url' => 'https://wwwapps.ups.com/WebTracking/track?track=yes&loc=sv_SE&trackNums=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            41 => [
                'id' => 52,
                'name' => 'Aramex NZ',
                'slug' => 'aramex-nz',
                'country_id' => 155,
                'tracking_base_url' => 'https://www.fastway.co.nz/tools/track?l=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            42 => [
                'id' => 53,
                'name' => 'Ukrposhta',
                'slug' => 'ukrposhta',
                'country_id' => 224,
                'tracking_base_url' => 'https://track.ukrposhta.ua/tracking_EN.html?barcode=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            43 => [
                'id' => 55,
                'name' => 'DHLParcel NL',
                'slug' => 'dhlparcel-nl',
                'country_id' => 152,
                'tracking_base_url' => 'https://www.dhlparcel.nl/en/follow-your-shipment?tc=%number%&pc=%postal_code%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            44 => [
                'id' => 62,
                'name' => 'Monaco EMS',
                'slug' => 'monaco-ems',
                'country_id' => 143,
                'tracking_base_url' => 'http://www.lapostemonaco.mc',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            45 => [
                'id' => 70,
                'name' => 'Direct Link',
                'slug' => 'direct-link',
                'country_id' => 82,
                'tracking_base_url' => 'https://tracking.directlink.com/?itemNumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            46 => [
                'id' => 75,
                'name' => 'TNT Italy',
                'slug' => 'tnt-italy',
                'country_id' => 106,
                'tracking_base_url' => 'https://www.tnt.it/tracking/getTrack.html?wt=1&consigNos=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            47 => [
                'id' => 76,
                'name' => 'TNT Click',
                'slug' => 'tnt-click',
                'country_id' => 106,
                'tracking_base_url' => 'https://www.tnt-click.it/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            48 => [
                'id' => 77,
                'name' => 'DPD Ireland',
                'slug' => 'dpd-ie',
                'country_id' => 104,
                'tracking_base_url' => 'https://dpd.ie/tracking?deviceType=5&consignmentNumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            49 => [
                'id' => 78,
                'name' => 'An Post',
                'slug' => 'an-post',
                'country_id' => 104,
                'tracking_base_url' => 'https://www.anpost.com/Post-Parcels/Track/History?item=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            50 => [
                'id' => 79,
                'name' => 'DTDC',
                'slug' => 'dtdc',
                'country_id' => 100,
                'tracking_base_url' => 'https://tracking.dtdc.com/ctbs-tracking/customerInterface.tr?submitName=showCITrackingDetails&cType=Consignment&cnNo=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            51 => [
                'id' => 80,
                'name' => 'DTDC Plus',
                'slug' => 'dtdc-plus',
                'country_id' => 100,
                'tracking_base_url' => 'https://tracking.dtdc.com/ctbs-tracking/customerInterface.tr?submitName=showCITrackingDetails&cnNo=%number%&cType=Consignment',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            52 => [
                'id' => 81,
                'name' => 'Deutsche Post DHL',
                'slug' => 'deutsche-post-dhl',
                'country_id' => 82,
                'tracking_base_url' => 'https://www.deutschepost.de/sendung/simpleQueryResult.html?form.sendungsnummer=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            53 => [
                'id' => 82,
                'name' => 'DHL Germany',
                'slug' => 'dhl-de',
                'country_id' => 82,
                'tracking_base_url' => 'https://www.dhl.de/de/privatkunden/pakete-empfangen/verfolgen.html?piececode=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            54 => [
                'id' => 83,
                'name' => 'Overseas Territory FR EMS',
                'slug' => 'overseas-territory-fr-ems',
                'country_id' => 74,
                'tracking_base_url' => 'https://www.chronopost.fr/tracking-no-cms/suivi-page?listeNumerosLT=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            55 => [
                'id' => 84,
                'name' => 'TNT France',
                'slug' => 'tnt-france',
                'country_id' => 74,
                'tracking_base_url' => 'https://www.tnt.fr/public/suivi_colis/recherche/visubontransport.do',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            56 => [
                'id' => 85,
                'name' => 'Estonia Post',
                'slug' => 'estonia-post',
                'country_id' => 68,
                'tracking_base_url' => 'https://www.omniva.ee/private/track_and_trace',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            57 => [
                'id' => 86,
                'name' => 'Denmark Post',
                'slug' => 'denmark-post',
                'country_id' => 58,
                'tracking_base_url' => 'https://www.postnord.dk/en/track-and-trace#dynamicloading=true&shipmentid=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            58 => [
                'id' => 87,
                'name' => 'DHL cz',
                'slug' => 'dhl-cz',
                'country_id' => 56,
                'tracking_base_url' => 'https://www.dhl.com/cz-cs/home/tracking.html?tracking-id=%number%&submit=1',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            59 => [
                'id' => 88,
                'name' => 'Cyprus Post',
                'slug' => 'cyprus-post',
                'country_id' => 55,
                'tracking_base_url' => 'https://ips.cypruspost.gov.cy/ipswebtrack/IPSWeb_item_events.aspx?itemid=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            60 => [
                'id' => 90,
                'name' => 'Ivory Coast EMS',
                'slug' => 'ivory-coast-ems',
                'country_id' => 107,
                'tracking_base_url' => 'https://laposte.ci.post/tracking-colis?identifiant=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            61 => [
                'id' => 91,
                'name' => 'Costa Rica Post',
                'slug' => 'costa-rica-post',
                'country_id' => 52,
                'tracking_base_url' => 'https://correos.go.cr/rastreo/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            62 => [
                'id' => 92,
                'name' => 'Colombia Post',
                'slug' => 'colombia-post',
                'country_id' => 48,
                'tracking_base_url' => 'http://www.4-72.com.co/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            63 => [
                'id' => 93,
                'name' => 'ePacket',
                'slug' => 'epacket',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.ems.com.cn',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            64 => [
                'id' => 94,
                'name' => 'SF Express',
                'slug' => 'sf-express',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.sf-express.com/cn/en/dynamic_function/waybill/#search/bill-number/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            65 => [
                'id' => 95,
                'name' => 'Brazil Correios',
                'slug' => 'brazil-correios',
                'country_id' => 32,
                'tracking_base_url' => 'https://www2.correios.com.br/sistemas/rastreamento/default.cfm',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            66 => [
                'id' => 96,
                'name' => 'Bpost',
                'slug' => 'belgium-post',
                'country_id' => 23,
                'tracking_base_url' => 'https://track.bpost.cloud/btr/web/#/search?lang=en&itemCode=%number%&postalCode=%postal_code%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            67 => [
                'id' => 97,
                'name' => 'Bangladesh EMS',
                'slug' => 'bangladesh-ems',
                'country_id' => 20,
                'tracking_base_url' => 'http://www.bangladeshpost.gov.bd/tracking.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            68 => [
                'id' => 98,
                'name' => 'DHL at',
                'slug' => 'dhl-at',
                'country_id' => 16,
                'tracking_base_url' => 'https://www.dhl.com/at-en/home/tracking/tracking-parcel.html?submit=1&tracking-id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            69 => [
                'id' => 99,
                'name' => 'Australia EMS',
                'slug' => 'australia-ems',
                'country_id' => 15,
                'tracking_base_url' => 'https://auspost.com.au/mypost/track/details/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            70 => [
                'id' => 100,
                'name' => 'TNT Australia',
                'slug' => 'tnt-australia',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.tntexpress.com.au/interaction/Trackntrace.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            71 => [
                'id' => 102,
                'name' => 'Sendle',
                'slug' => 'sendle',
                'country_id' => 15,
                'tracking_base_url' => 'https://track.sendle.com/tracking?ref=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            72 => [
                'id' => 104,
                'name' => 'Deppon',
                'slug' => 'deppon',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.deppon.com/en/toTrack.action',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            73 => [
                'id' => 105,
                'name' => 'GLS Italy',
                'slug' => 'gls-italy',
                'country_id' => 106,
                'tracking_base_url' => 'https://gls-group.com/IT/it/servizi-online/ricerca-spedizioni.html?match=%number%&type=NAT',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            74 => [
                'id' => 107,
                'name' => 'Poslaju National',
                'slug' => 'malaysia-post',
                'country_id' => 131,
                'tracking_base_url' => 'https://tracking.pos.com.my/tracking/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            75 => [
                'id' => 108,
                'name' => 'Yun Express',
                'slug' => 'yunexpress',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.yuntrack.com/parcelTracking?id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            76 => [
                'id' => 111,
                'name' => 'Xpressbees',
                'slug' => 'xpressbees',
                'country_id' => 100,
                'tracking_base_url' => 'https://www.xpressbees.com/shipment/tracking?awbNo=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            77 => [
                'id' => 113,
                'name' => 'Yanwen',
                'slug' => 'yanwen',
                'country_id' => 45,
                'tracking_base_url' => 'https://track.yw56.com.cn/en/querydel?nums=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            78 => [
                'id' => 115,
                'name' => 'Vietnam Post',
                'slug' => 'vietnam-post',
                'country_id' => 233,
                'tracking_base_url' => 'https://vnpost.vn/ca-nhan/chuyen-phat/chuyen-phat-trong-nuoc?code=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            79 => [
                'id' => 116,
                'name' => 'Correos España',
                'slug' => 'correos-spain',
                'country_id' => 199,
                'tracking_base_url' => 'https://www.correos.es/ss/Satellite/site/aplicacion-4000003383089-herramientas_y_apps/detalle_app-sidioma=es_ES?numero=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            80 => [
                'id' => 117,
                'name' => 'DHL Spain',
                'slug' => 'dhl-es',
                'country_id' => 199,
                'tracking_base_url' => 'https://www.dhl.com/es-es/home/tracking/tracking-express.html?submit=1&tracking-id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            81 => [
                'id' => 118,
                'name' => 'Redur Spain',
                'slug' => 'redur-es',
                'country_id' => 199,
                'tracking_base_url' => 'https://redur.es/track-trace/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            82 => [
                'id' => 123,
                'name' => 'Bluedart',
                'slug' => 'bluedart',
                'country_id' => 100,
                'tracking_base_url' => 'https://www.bluedart.com/web/guest/trackdartresultthirdparty?trackFor=0&trackNo=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            83 => [
                'id' => 124,
                'name' => 'ELTA Courier',
                'slug' => 'elta-courier',
                'country_id' => 85,
                'tracking_base_url' => 'https://www.elta-courier.gr/search?br=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            84 => [
                'id' => 127,
                'name' => 'Purolator',
                'slug' => 'purolator',
                'country_id' => 2,
                'tracking_base_url' => 'https://www.purolator.com/en/app-tracker.page?pins=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            85 => [
                'id' => 128,
                'name' => 'Turkey Post',
                'slug' => 'turkey-post',
                'country_id' => 219,
                'tracking_base_url' => 'https://track.ptt.gov.tr/Track/Verify?q=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            86 => [
                'id' => 129,
                'name' => 'ACS Courier',
                'slug' => 'acs-courier',
                'country_id' => 85,
                'tracking_base_url' => 'https://www.acscourier.net/el/web/greece/track-and-trace?action=getTracking&generalCode=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            87 => [
                'id' => 130,
                'name' => 'The Professional Couriers',
                'slug' => 'the-professional-couriers',
                'country_id' => 100,
                'tracking_base_url' => 'https://www.tpcindia.com/Default.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            88 => [
                'id' => 131,
                'name' => 'SDA',
                'slug' => 'sda',
                'country_id' => 106,
                'tracking_base_url' => 'https://www.sda.it/wps/portal/Servizi_online/dettaglio-spedizione?locale=it&tracing.letteraVettura=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            89 => [
                'id' => 133,
                'name' => 'CourierPost',
                'slug' => 'courierpost',
                'country_id' => 155,
                'tracking_base_url' => 'http://trackandtrace.courierpost.co.nz/search/%number%?tracks',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            90 => [
                'id' => 134,
                'name' => 'New Zealand Post',
                'slug' => 'new-zealand-post',
                'country_id' => 155,
                'tracking_base_url' => 'https://www.nzpost.co.nz/tools/tracking/item/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            91 => [
                'id' => 135,
                'name' => 'Naqel',
                'slug' => 'naqel',
                'country_id' => 187,
                'tracking_base_url' => 'https://www.naqelexpress.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            92 => [
                'id' => 136,
                'name' => 'SMSA Express',
                'slug' => 'smsa-express',
                'country_id' => 225,
                'tracking_base_url' => 'https://www.smsaexpress.com/sa/trackingdetails?tracknumbers0=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            93 => [
                'id' => 137,
                'name' => 'Poste Maroc',
                'slug' => 'poste-maroc',
                'country_id' => 146,
                'tracking_base_url' => 'http://www.poste.ma/wps/portal/GPM/Accueil',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            94 => [
                'id' => 138,
                'name' => 'Posten Norge',
                'slug' => 'posten-norge',
                'country_id' => 162,
                'tracking_base_url' => 'https://sporing.posten.no/sporing/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            95 => [
                'id' => 139,
                'name' => 'Emirates Post',
                'slug' => 'emirates-post',
                'country_id' => 225,
                'tracking_base_url' => 'https://www.emiratespost.ae/all-services/track-a-package/step-two?q=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            96 => [
                'id' => 140,
                'name' => '7-ELEVEN',
                'slug' => 'qi-eleven',
                'country_id' => 210,
                'tracking_base_url' => 'https://eservice.7-11.com.tw/E-Tracking/search.aspx/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            97 => [
                'id' => 141,
                'name' => 'Ceska Posta',
                'slug' => 'ceska-posta',
                'country_id' => 56,
                'tracking_base_url' => 'https://www.postaonline.cz/trackandtrace/-/zasilka/cislo?parcelNumbers=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            98 => [
                'id' => 143,
                'name' => 'DHL Paket',
                'slug' => 'dhl-paket',
                'country_id' => 82,
                'tracking_base_url' => 'https://www.dhl.de/de/privatkunden/pakete-empfangen/verfolgen.html?idc=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            99 => [
                'id' => 145,
                'name' => 'TOLL',
                'slug' => 'toll',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.myteamge.com/web/guest/search-shipment',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            100 => [
                'id' => 146,
                'name' => 'Loomis Express',
                'slug' => 'loomis-express',
                'country_id' => 2,
                'tracking_base_url' => 'https://www.loomisexpress.com/loomship/Track/TrackStatus?wbs=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            101 => [
                'id' => 147,
                'name' => 'Ethiopia Post',
                'slug' => 'ethiopia-post',
                'country_id' => 69,
                'tracking_base_url' => 'http://globaltracktrace.ptc.post/gtt.web/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            102 => [
                'id' => 149,
                'name' => 'GLS Spain',
                'slug' => 'gls-spain',
                'country_id' => 199,
                'tracking_base_url' => 'https://m.gls-spain.es/e/%number%/%postal_code%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            103 => [
                'id' => 150,
                'name' => 'Sagawa',
                'slug' => 'sagawa',
                'country_id' => 109,
                'tracking_base_url' => 'https://k2k.sagawa-exp.co.jp/p/web/okurijosearch.do?okurijoNo=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            104 => [
                'id' => 151,
                'name' => 'Citi Sprint',
                'slug' => 'citi-sprint',
                'country_id' => 197,
                'tracking_base_url' => 'https://www.citisprint.co.za/track-your-parcel',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            105 => [
                'id' => 154,
                'name' => 'Lithuania Post',
                'slug' => 'lietuvos-pasta',
                'country_id' => 125,
                'tracking_base_url' => 'https://www.post.lt/siuntu-sekimas',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            106 => [
                'id' => 155,
                'name' => 'CJPacket',
                'slug' => 'cj-packet',
                'country_id' => 45,
                'tracking_base_url' => 'https://cjpacket.com/?trackingNumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            107 => [
                'id' => 156,
                'name' => 'Trackon',
                'slug' => 'trackon',
                'country_id' => 100,
                'tracking_base_url' => 'https://trackon.in/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            108 => [
                'id' => 157,
                'name' => 'Serbia Post',
                'slug' => 'serbia-post',
                'country_id' => 189,
                'tracking_base_url' => 'https://www.posta.rs/cir/alati/pracenje-posiljke.aspx?broj=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            109 => [
                'id' => 158,
                'name' => 'Magyar Posta',
                'slug' => 'magyar-posta',
                'country_id' => 98,
                'tracking_base_url' => 'https://www.posta.hu/nyomkovetes/nyitooldal?searchvalue=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            110 => [
                'id' => 159,
                'name' => 'Ekart',
                'slug' => 'ekart',
                'country_id' => 100,
                'tracking_base_url' => 'https://www.ekartlogistics.com/shipmenttrack/%number%/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            111 => [
                'id' => 160,
                'name' => 'Poste Italiane',
                'slug' => 'poste-italiane',
                'country_id' => 106,
                'tracking_base_url' => 'https://www.poste.it/cerca/index.html#/risultati-spedizioni/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            112 => [
                'id' => 161,
                'name' => 'Thailand Post',
                'slug' => 'thailand-post',
                'country_id' => 213,
                'tracking_base_url' => 'https://track.thailandpost.co.th/?trackNumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            113 => [
                'id' => 164,
                'name' => 'Saudi Post',
                'slug' => 'saudi-post',
                'country_id' => 187,
                'tracking_base_url' => 'https://sp.com.sa/ar/tracktrace/?tid=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            114 => [
                'id' => 165,
                'name' => 'BRT',
                'slug' => 'brt',
                'country_id' => 106,
                'tracking_base_url' => 'https://services.brt.it/it/tracking?OP=N&CD=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            115 => [
                'id' => 167,
                'name' => 'Lion Parcel',
                'slug' => 'lion-parcel',
                'country_id' => 101,
                'tracking_base_url' => 'http://lionparcel.com/track/stt?q=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            116 => [
                'id' => 168,
                'name' => 'Shadowfax',
                'slug' => 'shadowfax',
                'country_id' => 100,
                'tracking_base_url' => 'https://track.shadowfax.in/track?order=new&trackingId=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            117 => [
                'id' => 170,
                'name' => 'JCEX',
                'slug' => 'jcex',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.jcex.com/EN/Track_DetailNumber_J_%number%.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            118 => [
                'id' => 171,
                'name' => 'Toll IPEC',
                'slug' => 'toll-ipec',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.myteamge.com/web/guest/search-shipment',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            119 => [
                'id' => 172,
                'name' => 'Ontime',
                'slug' => 'ontime',
                'country_id' => 199,
                'tracking_base_url' => 'http://www.ontime.es/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            120 => [
                'id' => 174,
                'name' => 'Redpack',
                'slug' => 'redpack',
                'country_id' => 140,
                'tracking_base_url' => 'https://www.redpack.com.mx/es/rastreo/?guias=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            121 => [
                'id' => 175,
                'name' => 'DPD France',
                'slug' => 'dpd-fr',
                'country_id' => 74,
                'tracking_base_url' => 'https://www.dpd.fr/trace/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            122 => [
                'id' => 176,
                'name' => 'GLS Denmark',
                'slug' => 'gls-denmark',
                'country_id' => 58,
                'tracking_base_url' => 'https://gls-group.eu/DK/da/find-pakke.html?match=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            123 => [
                'id' => 177,
                'name' => 'HFD',
                'slug' => 'hfd',
                'country_id' => 105,
                'tracking_base_url' => 'https://www.hfd.co.il/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            124 => [
                'id' => 178,
                'name' => 'JNE Express',
                'slug' => 'jne',
                'country_id' => 101,
                'tracking_base_url' => 'https://www.jne.co.id/id/tracking/trace',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            125 => [
                'id' => 179,
                'name' => 'TIKI',
                'slug' => 'tiki',
                'country_id' => 101,
                'tracking_base_url' => 'https://www.tiki.id/id/tracking',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            126 => [
                'id' => 180,
                'name' => 'J&T ID',
                'slug' => 'j-t',
                'country_id' => 101,
                'tracking_base_url' => 'http://www.jet.co.id/track',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            127 => [
                'id' => 181,
                'name' => 'Ninja Express',
                'slug' => 'ninja-express',
                'country_id' => 101,
                'tracking_base_url' => 'https://www.ninjaxpress.co/id-id/tracking?id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            128 => [
                'id' => 182,
                'name' => 'Wahana',
                'slug' => 'rides',
                'country_id' => 101,
                'tracking_base_url' => 'https://www.wahana.com/lacak-kiriman?noresi=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            129 => [
                'id' => 183,
                'name' => 'Pos Indonesia',
                'slug' => 'pos-indonesia',
                'country_id' => 101,
                'tracking_base_url' => 'https://www.posindonesia.co.id/id/tracking/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            130 => [
                'id' => 184,
                'name' => 'Sicepat',
                'slug' => 'sicepat',
                'country_id' => 101,
                'tracking_base_url' => 'http://sicepat.com/checkAwb',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            131 => [
                'id' => 185,
                'name' => 'JET Express',
                'slug' => 'jet-express',
                'country_id' => 101,
                'tracking_base_url' => 'http://www.jetexpress.co.id/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            132 => [
                'id' => 186,
                'name' => 'Shree Maruti Courier',
                'slug' => 'shree-maruti-courier',
                'country_id' => 100,
                'tracking_base_url' => 'https://shreemaruti.com/track-shipment',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            133 => [
                'id' => 187,
                'name' => 'Gig Logistics',
                'slug' => 'gig-logistics',
                'country_id' => 158,
                'tracking_base_url' => 'https://portal.gigagilitysystems.com/public/track',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            134 => [
                'id' => 188,
                'name' => 'MRW',
                'slug' => 'mrw',
                'country_id' => 199,
                'tracking_base_url' => 'https://mrw.es/seguimiento_envios/MRW_resultados_consultas.asp?modo=nacional&envio=%number%&',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            135 => [
                'id' => 189,
                'name' => 'Yamato',
                'slug' => 'yamato',
                'country_id' => 109,
                'tracking_base_url' => 'http://jizen.kuronekoyamato.co.jp/jizen/servlet/crjz.b.NQ0010?id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            136 => [
                'id' => 190,
                'name' => 'Luxembourg Post',
                'slug' => 'luxembourg-post',
                'country_id' => 126,
                'tracking_base_url' => 'http://www.trackandtrace.lu/homepage.htm',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            137 => [
                'id' => 191,
                'name' => 'Shree Tirupati Courier',
                'slug' => 'shree-tirupati-courier',
                'country_id' => 100,
                'tracking_base_url' => 'http://www.shreetirupaticourier.net/Frm_DocTrack.aspx?docno=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            138 => [
                'id' => 193,
                'name' => 'Skynet',
                'slug' => 'skynet',
                'country_id' => 131,
                'tracking_base_url' => 'http://www.skynet.com.my/track#TrackingResult',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            139 => [
                'id' => 194,
                'name' => 'CNE Express',
                'slug' => 'cne-express',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.cne.com/track/?no=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            140 => [
                'id' => 195,
                'name' => 'Chit Chats',
                'slug' => 'chit-chats',
                'country_id' => 2,
                'tracking_base_url' => 'https://chitchats.com/tracking/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            141 => [
                'id' => 196,
                'name' => 'Tipsa',
                'slug' => 'tip-sa',
                'country_id' => 199,
                'tracking_base_url' => 'https://www.tip-sa.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            142 => [
                'id' => 197,
                'name' => 'DPD Portugal',
                'slug' => 'dpd-pt',
                'country_id' => 173,
                'tracking_base_url' => 'https://dpd.pt/track-and-trace?reference=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            143 => [
                'id' => 198,
                'name' => 'Dicom',
                'slug' => 'dicom',
                'country_id' => 2,
                'tracking_base_url' => 'https://www.dicom.com/en/express/tracking',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            144 => [
                'id' => 199,
                'name' => 'Correos Express',
                'slug' => 'correos-express',
                'country_id' => 199,
                'tracking_base_url' => 'https://s.correosexpress.com/SeguimientoSinCP/search?shippingNumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            145 => [
                'id' => 200,
                'name' => 'Dotzot',
                'slug' => 'dotzot',
                'country_id' => 100,
                'tracking_base_url' => 'https://dotzot.in/index.php',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            146 => [
                'id' => 201,
                'name' => 'Gati',
                'slug' => 'gati',
                'country_id' => 100,
                'tracking_base_url' => 'https://www.gati.com/track-by-docket',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            147 => [
                'id' => 202,
                'name' => 'NZ Couriers',
                'slug' => 'nz-couriers',
                'country_id' => 155,
                'tracking_base_url' => 'https://tools.nzcouriers.co.nz/nzc/servlet/ITNG_TAndTServlet?page=1&VCCA=Enabled&Key_Type=Ticket&product_code=%number2%&serial_number=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            148 => [
                'id' => 203,
                'name' => 'Border Express',
                'slug' => 'border-express',
                'country_id' => 15,
                'tracking_base_url' => 'https://bexonline.borderexpress.com.au/bxo/track?consignmentNumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            149 => [
                'id' => 204,
                'name' => 'Finland Post',
                'slug' => 'finland-post',
                'country_id' => 73,
                'tracking_base_url' => 'https://www.posti.fi/fi/seuranta#/lahetys/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            150 => [
                'id' => 205,
                'name' => 'TNT Sweden',
                'slug' => 'tnt-sweden',
                'country_id' => 207,
                'tracking_base_url' => 'https://www.tnt.com/express/sv_se/site/shipping-tools/tracking.html?searchType=con&cons=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            151 => [
                'id' => 206,
                'name' => 'Mrw Portugal',
                'slug' => 'mrw-portugal',
                'country_id' => 173,
                'tracking_base_url' => 'https://www.mrw.pt/seguimiento_envios/MRW_paqueteria_nacional_multiple.asp',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            152 => [
                'id' => 207,
                'name' => 'Nacex',
                'slug' => 'nacex',
                'country_id' => 199,
                'tracking_base_url' => 'https://www.nacex.es/seguimientoFormularioExterno.do?intcli=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            153 => [
                'id' => 208,
                'name' => 'Post Haste',
                'slug' => 'post-haste',
                'country_id' => 155,
                'tracking_base_url' => 'https://www.posthaste.co.nz/phl/servlet/ITNG_TAndTServlet?page=1&Key_Type=Ticket&VCCA=Enabled&product_code=%number2%&serial_number=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            154 => [
                'id' => 209,
                'name' => 'Castle Parcels',
                'slug' => 'castle-parcels',
                'country_id' => 155,
                'tracking_base_url' => 'https://www.castleparcels.co.nz/cpl/servlet/ITNG_TAndTServlet?page=1&VCCA=Enabled&Key_Type=Ticket&product_code=%number2%&serial_number=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            155 => [
                'id' => 210,
                'name' => 'Now Couriers',
                'slug' => 'now-couriers',
                'country_id' => 155,
                'tracking_base_url' => 'https://www.nowcouriers.co.nz/now/servlet/ITNG_TAndTServlet?page=1&VCCA=Enabled&Key_Type=Ticket&product_code=%number2%&serial_number=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            156 => [
                'id' => 211,
                'name' => 'Dx Mail',
                'slug' => 'dx-mail',
                'country_id' => 155,
                'tracking_base_url' => 'https://www.dxmail.co.nz/nzdx/servlet/ITNG_TAndTServlet?page=1&Key_Type=Ticket&VCCA=Disabled&product_code=%number2%&serial_number=%number%&Submit=Check+Status',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            157 => [
                'id' => 214,
                'name' => 'GLS France',
                'slug' => 'gls-france',
                'country_id' => 74,
                'tracking_base_url' => 'https://gls-group.eu/FR/fr/suivi-colis?match=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            158 => [
                'id' => 217,
                'name' => 'UBI Smart Parcel',
                'slug' => 'ubi-smart-parcel',
                'country_id' => 45,
                'tracking_base_url' => 'https://en.ubismartparcel.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            159 => [
                'id' => 218,
                'name' => 'Dawn Wing',
                'slug' => 'dawn-wing',
                'country_id' => 197,
                'tracking_base_url' => 'http://www.dawnwing.co.za/business-tools/online-parcel-tracking/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            160 => [
                'id' => 219,
                'name' => 'GLS Paket',
                'slug' => 'gls-paket',
                'country_id' => 82,
                'tracking_base_url' => 'https://www.gls-pakete.de/sendungsverfolgung?match=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            161 => [
                'id' => 220,
                'name' => 'Fastway Ireland',
                'slug' => 'fastway-ireland',
                'country_id' => 104,
                'tracking_base_url' => 'https://fastway.ie/courier-services/track-your-parcel/?l=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            162 => [
                'id' => 223,
                'name' => 'GLS Slovenia',
                'slug' => 'gls-slovenia',
                'country_id' => 194,
                'tracking_base_url' => 'https://gls-group.eu/SI/sl/sledenje-posiljki?match=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            163 => [
                'id' => 224,
                'name' => 'DPD Slovenia',
                'slug' => 'dpd-si',
                'country_id' => 194,
                'tracking_base_url' => 'https://tracking.dpd.de/status/sl_SI/parcel/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            164 => [
                'id' => 225,
                'name' => 'Bulgaria Post',
                'slug' => 'bulgaria-post',
                'country_id' => 35,
                'tracking_base_url' => 'https://www.bgpost.bg/IPSWebTracking/IPSWeb_item_events.asp?itemid=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            165 => [
                'id' => 226,
                'name' => 'Poczta Polska',
                'slug' => 'poland-post',
                'country_id' => 172,
                'tracking_base_url' => 'https://emonitoring.poczta-polska.pl/?numer=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            166 => [
                'id' => 227,
                'name' => 'DHL Poland',
                'slug' => 'dhl-pl',
                'country_id' => 172,
                'tracking_base_url' => 'https://www.dhl.com/pl-en/home/tracking/tracking-parcel.html?submit=1&tracking-id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            167 => [
                'id' => 228,
                'name' => 'FedEx Poland',
                'slug' => 'fedex-pl',
                'country_id' => 172,
                'tracking_base_url' => 'https://www.fedex.com/apps/fedextrack/index.html?tracknumbers=%number%&cntry_code=pl',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            168 => [
                'id' => 229,
                'name' => 'DPD Poland',
                'slug' => 'dpd-pl',
                'country_id' => 172,
                'tracking_base_url' => 'https://tracktrace.dpd.com.pl/parcelDetails?typ=1&p1=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            169 => [
                'id' => 230,
                'name' => 'GLS Netherlands',
                'slug' => 'gls-netherlands',
                'country_id' => 152,
                'tracking_base_url' => 'https://www.gls-info.nl/tracking/ttlink?parcelNo=%number%&zipCode=%postal_code%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            170 => [
                'id' => 231,
                'name' => 'Yurtiçi Kargo',
                'slug' => 'yurtici-kargo',
                'country_id' => 219,
                'tracking_base_url' => 'https://www.yurticikargo.com/tr/online-servisler/gonderi-sorgula?code=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            171 => [
                'id' => 232,
                'name' => 'Aras Kargo',
                'slug' => 'aras-kargo',
                'country_id' => 219,
                'tracking_base_url' => 'https://kargotakip.araskargo.com.tr/mainpage.aspx?code=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            172 => [
                'id' => 233,
                'name' => 'MNG Kargo',
                'slug' => 'mng-kargo',
                'country_id' => 219,
                'tracking_base_url' => 'https://kargotakip.mngkargo.com.tr/?takipNo=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            173 => [
                'id' => 234,
                'name' => 'PTT Kargo',
                'slug' => 'ptt-kargo',
                'country_id' => 219,
                'tracking_base_url' => 'https://gonderitakip.ptt.gov.tr/Track/Verify?q=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            174 => [
                'id' => 235,
                'name' => 'PTT Posta',
                'slug' => 'ptt-posta',
                'country_id' => 219,
                'tracking_base_url' => 'https://track.ptt.gov.tr/Track/Verify?q=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            175 => [
                'id' => 237,
                'name' => 'FastWay South Africa',
                'slug' => 'fastway-za',
                'country_id' => 197,
                'tracking_base_url' => 'https://www.fastway.co.za/our-services/track-your-parcel?l=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            176 => [
                'id' => 240,
                'name' => 'Jadlog',
                'slug' => 'jadlog',
                'country_id' => 32,
                'tracking_base_url' => 'https://www.jadlog.com.br/tracking?cte=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            177 => [
                'id' => 241,
                'name' => 'Geniki Taxydromiki',
                'slug' => 'taxydromiki',
                'country_id' => 85,
                'tracking_base_url' => 'https://www.taxydromiki.com/track/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            178 => [
                'id' => 242,
                'name' => 'Ninja Van Malaysia',
                'slug' => 'ninjavan-my',
                'country_id' => 131,
                'tracking_base_url' => 'https://www.ninjavan.co/en-my/tracking?id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            179 => [
                'id' => 245,
                'name' => 'LBC Express',
                'slug' => 'lbc-express',
                'country_id' => 170,
                'tracking_base_url' => 'https://www.lbcexpress.com',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            180 => [
                'id' => 246,
                'name' => 'XPOST',
                'slug' => 'xpost',
                'country_id' => 170,
                'tracking_base_url' => 'https://www.xpost.ph/track',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            181 => [
                'id' => 247,
                'name' => 'Ninja Van Philippines',
                'slug' => 'ninjavan-ph',
                'country_id' => 170,
                'tracking_base_url' => 'https://www.ninjavan.co/en-ph/tracking?id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            182 => [
                'id' => 248,
                'name' => 'T Cat',
                'slug' => 't-cat',
                'country_id' => 210,
                'tracking_base_url' => 'https://www.t-cat.com.tw/Inquire/TraceDetail.aspx?BillID=%number%&ReturnUrl=Trace.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            183 => [
                'id' => 250,
                'name' => 'Singapore Speedpost',
                'slug' => 'singapore-speedpost',
                'country_id' => 192,
                'tracking_base_url' => 'https://www.speedpost.com.sg/track-and-trace#t%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            184 => [
                'id' => 251,
                'name' => 'Servientrega',
                'slug' => 'servientrega',
                'country_id' => 48,
                'tracking_base_url' => 'https://www.servientrega.com/wps/portal/rastreo-envio/detalle?id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            185 => [
                'id' => 252,
                'name' => 'RPX Indonesia',
                'slug' => 'rpx',
                'country_id' => 101,
                'tracking_base_url' => 'https://rpx.co.id/tracking?tracking_number[]=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            186 => [
                'id' => 253,
                'name' => 'Direct Freight',
                'slug' => 'direct-freight',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.directfreight.com.au/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            187 => [
                'id' => 255,
                'name' => 'Franch Express',
                'slug' => 'franch-express',
                'country_id' => 100,
                'tracking_base_url' => 'http://erpfranchexpress.com/awb_tracking2.php?keyword=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            188 => [
                'id' => 256,
                'name' => 'ST couriers',
                'slug' => 'st-couriers',
                'country_id' => 100,
                'tracking_base_url' => 'https://www.erpstcourier.com/awb_tracking2.php?keyword=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            189 => [
                'id' => 257,
                'name' => 'Atlantic Courier',
                'slug' => 'atlantic-courier',
                'country_id' => 100,
                'tracking_base_url' => 'https://atlanticcourier.net/track.php?awbno=%number%&search=A',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            190 => [
                'id' => 258,
                'name' => 'Tapuz delivery',
                'slug' => 'tapuz-delivery',
                'country_id' => 105,
                'tracking_base_url' => 'https://crm.tapuzdelivery.co.il/Baldar/deliverystatus.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            191 => [
                'id' => 259,
                'name' => 'Chita delivery',
                'slug' => 'chita-delivery',
                'country_id' => 105,
                'tracking_base_url' => 'https://chita-il.com/run_public1/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            192 => [
                'id' => 260,
                'name' => 'mylerz',
                'slug' => 'mylerz',
                'country_id' => 64,
                'tracking_base_url' => 'https://mylerz.net/trackShipment',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            193 => [
                'id' => 262,
                'name' => 'Janio',
                'slug' => 'janio',
                'country_id' => 192,
                'tracking_base_url' => 'https://tracker.janio.asia/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            194 => [
                'id' => 263,
                'name' => 'TCS express',
                'slug' => 'tcs-express',
                'country_id' => 164,
                'tracking_base_url' => 'https://www.tcsexpress.com/Tracking',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            195 => [
                'id' => 264,
                'name' => 'Pakistan Post',
                'slug' => 'pakistan-post',
                'country_id' => 164,
                'tracking_base_url' => 'https://ep.gov.pk/emtts/EPTrack_Live.aspx?ArticleIDz=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            196 => [
                'id' => 266,
                'name' => 'InPost Paczkomaty',
                'slug' => 'inpost-paczkomaty',
                'country_id' => 172,
                'tracking_base_url' => 'https://inpost.pl/sledzenie-przesylek?number=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            197 => [
                'id' => 267,
                'name' => '247 Express',
                'slug' => '247express',
                'country_id' => 233,
                'tracking_base_url' => 'https://247express.vn/dinh-vi-buu-pham/%number%?',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            198 => [
                'id' => 268,
                'name' => 'hunter-express',
                'slug' => 'hunter-express',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.hunterexpress.com.au/tracking',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            199 => [
                'id' => 271,
                'name' => 'The Courier Guy',
                'slug' => 'the-courier-guy',
                'country_id' => 197,
                'tracking_base_url' => 'https://portal.thecourierguy.co.za/track?ref=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            200 => [
                'id' => 272,
                'name' => 'PostNord Denmark',
                'slug' => 'post-nord-denmark',
                'country_id' => 58,
                'tracking_base_url' => 'https://www.postnord.dk/varktojer/track-trace?shipmentId=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            201 => [
                'id' => 275,
                'name' => 'Teleport',
                'slug' => 'teleport',
                'country_id' => 131,
                'tracking_base_url' => 'https://teleport.delivery/track?tracking_number=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            202 => [
                'id' => 278,
                'name' => 'DPEX',
                'slug' => 'dpex',
                'country_id' => 192,
                'tracking_base_url' => 'https://tracking.frontierforce.com/tracking.aspx?stid=dpexwwe&cn=%number%&option=,8,',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            203 => [
                'id' => 279,
                'name' => 'Israel Post He',
                'slug' => 'ilpost-he',
                'country_id' => 105,
                'tracking_base_url' => 'https://mypost.israelpost.co.il/itemtrace_he?itemcode=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            204 => [
                'id' => 280,
                'name' => 'City-Link Express',
                'slug' => 'city-link-express',
                'country_id' => 131,
                'tracking_base_url' => 'https://www.citylinkexpress.com/MY/Tracking.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            205 => [
                'id' => 283,
                'name' => 'Chilexpress',
                'slug' => 'chilexpress',
                'country_id' => 44,
                'tracking_base_url' => 'https://centrodeayuda.chilexpress.cl/seguimiento/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            206 => [
                'id' => 284,
                'name' => 'BOXIT',
                'slug' => 'boxit',
                'country_id' => 105,
                'tracking_base_url' => 'http://portal.fcx.co.il/he/Track?shipmentNumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            207 => [
                'id' => 285,
                'name' => 'Slovakia Post',
                'slug' => 'slovakia-post',
                'country_id' => 193,
                'tracking_base_url' => 'https://tandt.posta.sk/en/items/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            208 => [
                'id' => 287,
                'name' => 'GDEX',
                'slug' => 'gdex',
                'country_id' => 131,
                'tracking_base_url' => 'https://www.gdexpress.com/malaysia/e-tracking/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            209 => [
                'id' => 288,
                'name' => 'Speedex Greece',
                'slug' => 'speedex-greece',
                'country_id' => 85,
                'tracking_base_url' => 'http://www.speedex.gr/isapohi.asp?voucher_code=%number%&searcggo=Submit',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            210 => [
                'id' => 289,
                'name' => 'J&T PH',
                'slug' => 'jt-express-ph',
                'country_id' => 170,
                'tracking_base_url' => 'https://www.jtexpress.ph/index/query/gzquery.html?bills=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            211 => [
                'id' => 290,
                'name' => 'Estafeta',
                'slug' => 'estafeta',
                'country_id' => 140,
                'tracking_base_url' => 'https://www.estafeta.com/Herramientas/Rastreo',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            212 => [
                'id' => 291,
                'name' => 'Nampost',
                'slug' => 'nampost',
                'country_id' => 149,
                'tracking_base_url' => 'http://globaltracktrace.ptc.post/gtt.web/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            213 => [
                'id' => 292,
                'name' => 'ENVIALIA',
                'slug' => 'envialia',
                'country_id' => 199,
                'tracking_base_url' => 'https://www.envialia.com/tracking/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            214 => [
                'id' => 293,
                'name' => 'wanbexpress',
                'slug' => 'wanbexpress',
                'country_id' => 45,
                'tracking_base_url' => 'https://tracking.wanbexpress.com/?trackingNumbers=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            215 => [
                'id' => 294,
                'name' => '99minutos',
                'slug' => '99minutos',
                'country_id' => 140,
                'tracking_base_url' => 'https://tracking.99minutos.com/search/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            216 => [
                'id' => 297,
                'name' => 'DPD Latvia',
                'slug' => 'dpd-lv',
                'country_id' => 119,
                'tracking_base_url' => 'https://tracking.dpd.de/status/lv_LV/parcel/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            217 => [
                'id' => 300,
                'name' => 'Cargoboard',
                'slug' => 'cargoboard',
                'country_id' => 82,
                'tracking_base_url' => 'https://cargoboard.customer.cepra.de/Track/None?cRef=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            218 => [
                'id' => 301,
                'name' => 'Zeleris',
                'slug' => 'zeleris',
                'country_id' => 199,
                'tracking_base_url' => 'https://www.zeleris.com',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            219 => [
                'id' => 302,
                'name' => 'Chunghwa Post',
                'slug' => 'taiwan-post',
                'country_id' => 210,
                'tracking_base_url' => 'https://postserv.post.gov.tw/pstmail/main_mail.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            220 => [
                'id' => 303,
                'name' => 'Nexive',
                'slug' => 'nexive',
                'country_id' => 106,
                'tracking_base_url' => 'https://tracking.nexive.it/?&b=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            221 => [
                'id' => 304,
                'name' => 'Speedy',
                'slug' => 'speedy',
                'country_id' => 35,
                'tracking_base_url' => 'https://www.speedy.bg/en/track-shipment?shipmentNumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            222 => [
                'id' => 305,
                'name' => 'GEODIS',
                'slug' => 'geodis',
                'country_id' => 74,
                'tracking_base_url' => 'https://espace-client.geodis.com/services/destinataires/#/%number%/home',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            223 => [
                'id' => 307,
                'name' => 'Orian',
                'slug' => 'orian',
                'country_id' => 105,
                'tracking_base_url' => 'https://www.orian.com/OrianBarcodeTracking/?barcode=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            224 => [
                'id' => 308,
                'name' => 'Sri Lanka Post',
                'slug' => 'sri-lanka-post',
                'country_id' => 200,
                'tracking_base_url' => 'https://globaltracktrace.ptc.post/gtt.web/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            225 => [
                'id' => 309,
                'name' => 'DHL Parcel Spain',
                'slug' => 'dhl-parcel-se',
                'country_id' => 199,
                'tracking_base_url' => 'https://clientesparcel.dhl.es/LiveTracking/ModificarEnvio/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            226 => [
                'id' => 310,
                'name' => 'BEST Express',
                'slug' => 'best-my',
                'country_id' => 131,
                'tracking_base_url' => 'https://www.best-inc.my/track?bills=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            227 => [
                'id' => 313,
                'name' => 'Udaan Express',
                'slug' => 'udaan-express',
                'country_id' => 100,
                'tracking_base_url' => 'https://udaanexpress.com/track/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            228 => [
                'id' => 314,
                'name' => 'JS EXPRESS',
                'slug' => 'js-express',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.js-exp.com/index.php?page=19',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            229 => [
                'id' => 315,
                'name' => 'HCT Logistics',
                'slug' => 'hct',
                'country_id' => 210,
                'tracking_base_url' => 'https://www.hct.com.tw/Search/SearchGoods_n.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            230 => [
                'id' => 316,
                'name' => 'Kerry Express TH',
                'slug' => 'kerry-express-th',
                'country_id' => 213,
                'tracking_base_url' => 'https://th.kerryexpress.com/en/track/?track=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            231 => [
                'id' => 317,
                'name' => 'Kerry Express VN',
                'slug' => 'kerry-express-vn',
                'country_id' => 233,
                'tracking_base_url' => 'https://kerryexpress.com.vn/trang-thai-don-hang?trackingid=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            232 => [
                'id' => 319,
                'name' => 'Sunyou',
                'slug' => 'sunyou',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.sypost.net/search?orderNo=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            233 => [
                'id' => 320,
                'name' => 'J&T SG',
                'slug' => 'jt-express-sg',
                'country_id' => 192,
                'tracking_base_url' => 'https://www.jtexpress.sg/trackmyparcel',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            234 => [
                'id' => 321,
                'name' => 'J&T CN',
                'slug' => 'jt-express-cn',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.jtexpress.com.cn/service.html?indexIpt=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            235 => [
                'id' => 322,
                'name' => 'J&T TH',
                'slug' => 'jt-express-th',
                'country_id' => 213,
                'tracking_base_url' => 'https://www.jtexpress.co.th/index/query/gzquery.html?bills=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            236 => [
                'id' => 323,
                'name' => 'J&T VN',
                'slug' => 'jt-express-vn',
                'country_id' => 233,
                'tracking_base_url' => 'https://jtexpress.vn/track?billcodes=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            237 => [
                'id' => 324,
                'name' => 'SFC Service',
                'slug' => 'sfc-service',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.sfcservice.com/track',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            238 => [
                'id' => 325,
                'name' => 'Royale International',
                'slug' => 'royale-international',
                'country_id' => 197,
                'tracking_base_url' => 'https://royaleinternational.pperfect.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            239 => [
                'id' => 326,
                'name' => 'Flash Express',
                'slug' => 'flash-express',
                'country_id' => 213,
                'tracking_base_url' => 'https://www.flashexpress.co.th/en/tracking/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            240 => [
                'id' => 327,
                'name' => 'PostNord Norge',
                'slug' => 'postnord-norge',
                'country_id' => 162,
                'tracking_base_url' => 'https://www.postnord.no/pakkesporing?shipmentId=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            241 => [
                'id' => 328,
                'name' => 'Pgeon',
                'slug' => 'pgeon',
                'country_id' => 131,
                'tracking_base_url' => 'https://www.pgeon.delivery/track-parcel?awb_no=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            242 => [
                'id' => 331,
                'name' => 'RTT Logistics',
                'slug' => 'rtt-logistics',
                'country_id' => 197,
                'tracking_base_url' => 'https://www.rtt.co.za/tracking/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            243 => [
                'id' => 332,
                'name' => 'GAP AKIS EXPRESS',
                'slug' => 'gap-akis-express',
                'country_id' => 55,
                'tracking_base_url' => 'https://gapakisexpress.com/track-your-packages/?tracking_num=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            244 => [
                'id' => 333,
                'name' => 'CJ Logistics Malaysia',
                'slug' => 'cj-logistics-my',
                'country_id' => 131,
                'tracking_base_url' => 'https://mysgnexs.cjlogistics-global.com/web/g_tracking_eng.jsp?slipno=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            245 => [
                'id' => 334,
                'name' => 'Envia',
                'slug' => 'envia',
                'country_id' => 48,
                'tracking_base_url' => 'https://envia.co/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            246 => [
                'id' => 335,
                'name' => 'Coordinadora',
                'slug' => 'coordinadora',
                'country_id' => 48,
                'tracking_base_url' => 'https://www.coordinadora.com/portafolio-de-servicios/servicios-en-linea/rastrear-guias/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            247 => [
                'id' => 336,
                'name' => 'TCC',
                'slug' => 'tcc',
                'country_id' => 48,
                'tracking_base_url' => 'https://tcc.com.co/courier/mensajeria/rastrear-envio/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            248 => [
                'id' => 337,
                'name' => 'GLS Ireland',
                'slug' => 'gls-ireland',
                'country_id' => 104,
                'tracking_base_url' => 'https://gls-group.eu/IE/en/parcel-tracking.html?match=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            249 => [
                'id' => 338,
                'name' => 'Spoton',
                'slug' => 'spoton',
                'country_id' => 100,
                'tracking_base_url' => 'https://web1.spoton.co.in/spotoncontracker.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            250 => [
                'id' => 339,
                'name' => 'Safexpress',
                'slug' => 'safexpress',
                'country_id' => 100,
                'tracking_base_url' => 'http://www.safexpress.com/index.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            251 => [
                'id' => 340,
                'name' => 'TCI Express',
                'slug' => 'tci-express',
                'country_id' => 100,
                'tracking_base_url' => 'https://www.tciexpress.in/trackingdocket.aspx?trackshipment=%number%&dwb=dwb',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            252 => [
                'id' => 341,
                'name' => 'J&T MY',
                'slug' => 'jtexpress-my',
                'country_id' => 131,
                'tracking_base_url' => 'https://www.jtexpress.my/tracking/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            253 => [
                'id' => 342,
                'name' => 'Famiport',
                'slug' => 'famiport',
                'country_id' => 210,
                'tracking_base_url' => 'https://www.famiport.com.tw/Web_Famiport/page/process.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            254 => [
                'id' => 343,
                'name' => 'PosLaju',
                'slug' => 'poslaju',
                'country_id' => 131,
                'tracking_base_url' => 'https://tracking.pos.com.my/tracking/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            255 => [
                'id' => 344,
                'name' => 'Giao Hàng Nhanh',
                'slug' => 'ghn',
                'country_id' => 233,
                'tracking_base_url' => 'https://donhang.ghn.vn/?order_code=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            256 => [
                'id' => 346,
                'name' => 'RIVIGO',
                'slug' => 'rivigo',
                'country_id' => 100,
                'tracking_base_url' => 'https://zoom-ops.rivigo.com/#/trackconsignment/%number%?redirectedFromRivigo=true',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            257 => [
                'id' => 347,
                'name' => 'GoJavas',
                'slug' => 'gojavas',
                'country_id' => 100,
                'tracking_base_url' => 'http://gojavas.com/docket_details.php?pop=docno&docno=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            258 => [
                'id' => 348,
                'name' => 'First Flight',
                'slug' => 'first-flight',
                'country_id' => 100,
                'tracking_base_url' => 'https://www.firstflight.net/tracking.php',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            259 => [
                'id' => 349,
                'name' => 'Bombino Express',
                'slug' => 'bombino-express',
                'country_id' => 100,
                'tracking_base_url' => 'https://www.bombinoexp.com/track.aspx?AwbNo=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            260 => [
                'id' => 350,
                'name' => 'Overseas Logistics',
                'slug' => 'overseas-logistics',
                'country_id' => 100,
                'tracking_base_url' => 'http://www.overseaslogistics.in/tracking.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            261 => [
                'id' => 351,
                'name' => 'Airwings',
                'slug' => 'airwings-india',
                'country_id' => 100,
                'tracking_base_url' => 'http://www.airwingsindia.com/tracking.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            262 => [
                'id' => 352,
                'name' => 'Shree Mahabali Express',
                'slug' => 'shree-mahabali-express',
                'country_id' => 100,
                'tracking_base_url' => 'http://www.shreemahabaliexpress.com/Frm_DocTrack.aspx?No=%number%&Tmp=1630996767218',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            263 => [
                'id' => 353,
                'name' => 'Grand Slam Express',
                'slug' => 'grand-slam-express',
                'country_id' => 100,
                'tracking_base_url' => 'http://grandslamexpress.in/Web/Track?AwbNo=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            264 => [
                'id' => 354,
                'name' => 'SAP Express',
                'slug' => 'sap-express',
                'country_id' => 101,
                'tracking_base_url' => 'https://www.sap-express.id/layanan/tracking/track',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            265 => [
                'id' => 355,
                'name' => 'V-Xpress',
                'slug' => 'v-xpress',
                'country_id' => 100,
                'tracking_base_url' => 'https://www.vxpress.in/track',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            266 => [
                'id' => 356,
                'name' => 'Lexship',
                'slug' => 'lexship',
                'country_id' => 100,
                'tracking_base_url' => 'https://track.lexship.com/track?tracking_id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            267 => [
                'id' => 357,
                'name' => 'Pushpak Courier',
                'slug' => 'pushpak-courier',
                'country_id' => 100,
                'tracking_base_url' => 'https://www.pushpakcourier.net/query.php?trackcode',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            268 => [
                'id' => 358,
                'name' => 'Madhur Couriers',
                'slug' => 'madhur-couriers',
                'country_id' => 100,
                'tracking_base_url' => 'https://www.madhurcouriers.in/(S(jfqtmkzwgkgu5gktywfgklws))/CNoteTracking',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            269 => [
                'id' => 359,
                'name' => 'Bombax',
                'slug' => 'bombax',
                'country_id' => 100,
                'tracking_base_url' => 'https://bombax.in/booking/Tracking?OrderNo=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            270 => [
                'id' => 360,
                'name' => 'CTT Express',
                'slug' => 'ctt-express',
                'country_id' => 173,
                'tracking_base_url' => 'https://www.ctt.pt/feapl_2/app/open/objectSearch/objectSearch.jspx?objects=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            271 => [
                'id' => 361,
                'name' => 'Amazon IN',
                'slug' => 'amazon-in',
                'country_id' => 100,
                'tracking_base_url' => 'https://track.amazon.in/tracking/%number%?trackingId=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            272 => [
                'id' => 362,
                'name' => 'DPD South Africa',
                'slug' => 'dpd-sa',
                'country_id' => 197,
                'tracking_base_url' => 'https://my.dpdl.co.za/quicktrack/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            273 => [
                'id' => 363,
                'name' => 'Internet Express Couriers',
                'slug' => 'internet-express',
                'country_id' => 197,
                'tracking_base_url' => 'https://ie.shiplogic.com/track?ref=%number%/1',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            274 => [
                'id' => 364,
                'name' => 'DAO',
                'slug' => 'dao',
                'country_id' => 58,
                'tracking_base_url' => 'https://www.dao.as/privat/find-din-pakke?stregkode=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            275 => [
                'id' => 366,
                'name' => 'Zajil Express',
                'slug' => 'zajil-express',
                'country_id' => 187,
                'tracking_base_url' => 'https://zajil-express.com',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            276 => [
                'id' => 368,
                'name' => 'IQfulfillment',
                'slug' => 'iq-fulfillment',
                'country_id' => 225,
                'tracking_base_url' => 'https://track.iqfulfillment.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            277 => [
                'id' => 371,
                'name' => 'Dachser',
                'slug' => 'dachser',
                'country_id' => 131,
                'tracking_base_url' => 'https://elogistics.dachser.com/shp2s/ShpApplicationPage?4',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            278 => [
                'id' => 372,
                'name' => 'TopYou',
                'slug' => 'topyou',
                'country_id' => 131,
                'tracking_base_url' => 'http://track.szty56.com/?track=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            279 => [
                'id' => 373,
                'name' => 'Redpack Mexico',
                'slug' => 'redpack-mexico',
                'country_id' => 131,
                'tracking_base_url' => 'https://www.redpack.com.mx/es/rastreo',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            280 => [
                'id' => 375,
                'name' => '360lion Express',
                'slug' => '360lion',
                'country_id' => 45,
                'tracking_base_url' => 'https://customer.360lion.com/track/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            281 => [
                'id' => 377,
                'name' => 'Relais Colis',
                'slug' => 'relais-colis',
                'country_id' => 74,
                'tracking_base_url' => 'https://www.relaiscolis.com/suivi-de-colis',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            282 => [
                'id' => 378,
                'name' => 'Shree Anjani Courier',
                'slug' => 'shree-anjani-courier',
                'country_id' => 100,
                'tracking_base_url' => 'http://shreeanjanicourier.com/awb.php',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            283 => [
                'id' => 379,
                'name' => 'Paquet Express',
                'slug' => 'paquet',
                'country_id' => 140,
                'tracking_base_url' => 'https://www.paquetexpress.com.mx/rastreo/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            284 => [
                'id' => 380,
                'name' => 'Correos de Cuba',
                'slug' => 'correos-de-cuba',
                'country_id' => 54,
                'tracking_base_url' => 'https://www.correos.cu/rastreador-de-envios/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            285 => [
                'id' => 382,
                'name' => 'BH Posta',
                'slug' => 'bh-posta',
                'country_id' => 29,
                'tracking_base_url' => 'https://bhpwebout.posta.ba/trackwebapp/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            286 => [
                'id' => 383,
                'name' => 'Iceland Post',
                'slug' => 'iceland-post',
                'country_id' => 99,
                'tracking_base_url' => 'https://posturinn.is/en/individuals/receive/track-shipment/?q=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            287 => [
                'id' => 384,
                'name' => 'Malta Post',
                'slug' => 'malta-post',
                'country_id' => 134,
                'tracking_base_url' => 'https://www.maltapost.com/tracking#/tracking',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            288 => [
                'id' => 386,
                'name' => 'Gibraltar Post',
                'slug' => 'gibraltar-post',
                'country_id' => 84,
                'tracking_base_url' => 'https://post.gi/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            289 => [
                'id' => 387,
                'name' => 'Liechtenstein Post',
                'slug' => 'liechtenstein-post',
                'country_id' => 124,
                'tracking_base_url' => 'https://www.post.li/privatkunden/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            290 => [
                'id' => 388,
                'name' => 'Faroe Islands Post',
                'slug' => 'faroe-islands',
                'country_id' => 71,
                'tracking_base_url' => 'https://www.posta.fo/search?cc=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            291 => [
                'id' => 390,
                'name' => 'Greenland Post',
                'slug' => 'tele-post',
                'country_id' => 86,
                'tracking_base_url' => 'https://www.tusass.gl/en/track-and-trace/#%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            292 => [
                'id' => 391,
                'name' => 'Kerry TJ Logistics',
                'slug' => 'kerry-tj',
                'country_id' => 210,
                'tracking_base_url' => 'http://www.kerrytj.com/zh/search/search_track.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            293 => [
                'id' => 392,
                'name' => 'CH EXPRESS',
                'slug' => 'ch-express',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.hzchgj.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            294 => [
                'id' => 393,
                'name' => 'FMX',
                'slug' => 'fmx',
                'country_id' => 131,
                'tracking_base_url' => 'http://www.freightmark.com.my/fmx/result/resultdetail.php?conno=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            295 => [
                'id' => 394,
                'name' => 'Sürat Kargo',
                'slug' => 'surat-kargo',
                'country_id' => 219,
                'tracking_base_url' => 'http://suratkargo.com.tr/KargoTakip/?kargotakipno=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            296 => [
                'id' => 396,
                'name' => 'GESWL Express',
                'slug' => 'geswl',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.geswl.com/home/en/index.asp',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            297 => [
                'id' => 397,
                'name' => 'DPD Hungary',
                'slug' => 'dpd-hu',
                'country_id' => 98,
                'tracking_base_url' => 'https://tracking.dpd.de/status/en_EN/parcel/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            298 => [
                'id' => 398,
                'name' => 'DPD Slovakia',
                'slug' => 'dpd-sk',
                'country_id' => 193,
                'tracking_base_url' => 'https://tracking.dpd.de/status/sk_SK/parcel/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            299 => [
                'id' => 399,
                'name' => 'FBA Swiship ES',
                'slug' => 'swiship-es',
                'country_id' => 199,
                'tracking_base_url' => 'https://www.swiship.es/track?id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            300 => [
                'id' => 401,
                'name' => 'FBA Swiship JP',
                'slug' => 'swiship-jp',
                'country_id' => 109,
                'tracking_base_url' => 'https://www.swiship.jp/track',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            301 => [
                'id' => 402,
                'name' => 'FBA Swiship CA',
                'slug' => 'swiship-ca',
                'country_id' => 2,
                'tracking_base_url' => 'https://www.swiship.ca/track?id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            302 => [
                'id' => 403,
                'name' => 'FBA Swiship FR',
                'slug' => 'swiship-fr',
                'country_id' => 74,
                'tracking_base_url' => 'https://www.swiship.fr/track?id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            303 => [
                'id' => 404,
                'name' => 'FBA Swiship AU',
                'slug' => 'swiship-au',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.swiship.com.au/track?id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            304 => [
                'id' => 405,
                'name' => 'FBA Swiship IT',
                'slug' => 'swiship-it',
                'country_id' => 106,
                'tracking_base_url' => 'https://www.swiship.it/track?id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            305 => [
                'id' => 406,
                'name' => 'FBA Swiship DE',
                'slug' => 'swiship-de',
                'country_id' => 82,
                'tracking_base_url' => 'https://www.swiship.de/track?id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            306 => [
                'id' => 408,
                'name' => 'J&T KH',
                'slug' => 'jtexpress-kh',
                'country_id' => 38,
                'tracking_base_url' => 'https://www.jtexpress.com.kh/index/query/gzquery.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            307 => [
                'id' => 409,
                'name' => 'GOGO Xpress',
                'slug' => 'gogo-xpress',
                'country_id' => 170,
                'tracking_base_url' => 'https://app.gogoxpress.com/track/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            308 => [
                'id' => 410,
                'name' => 'Zip',
                'slug' => 'zip-ph',
                'country_id' => 170,
                'tracking_base_url' => 'https://zip-ph.com/tracking?no=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            309 => [
                'id' => 411,
                'name' => 'RAF Philippines',
                'slug' => 'raf',
                'country_id' => 170,
                'tracking_base_url' => 'https://tracking.frontierforce.com/tracking.aspx?stid=raf&cn=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            310 => [
                'id' => 412,
                'name' => 'PHL Post',
                'slug' => 'phlpost',
                'country_id' => 170,
                'tracking_base_url' => 'https://www.phlpost.gov.ph/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            311 => [
                'id' => 413,
                'name' => 'Airpak Express',
                'slug' => 'airpak-express',
                'country_id' => 192,
                'tracking_base_url' => 'https://tracking.airpak-express.com/tracking.aspx?stid=airpak&cn=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            312 => [
                'id' => 414,
                'name' => 'Aramex AU',
                'slug' => 'aramex-au',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.aramex.com.au/tools/track/?l=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            313 => [
                'id' => 415,
                'name' => 'Amalgamated',
                'slug' => 'Amalgamated',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.amaldist.com.au/track.php',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            314 => [
                'id' => 416,
                'name' => 'City Express',
                'slug' => 'city-express',
                'country_id' => 189,
                'tracking_base_url' => 'https://www.cityexpress.rs/pracenje-posiljaka/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            315 => [
                'id' => 438,
                'name' => 'Day & Ross',
                'slug' => 'dayross',
                'country_id' => 2,
                'tracking_base_url' => 'https://dayross.com/en/track-shipments',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            316 => [
                'id' => 439,
                'name' => 'Greyhound',
                'slug' => 'greyhound',
                'country_id' => 2,
                'tracking_base_url' => 'https://greyhound.shiptrackapp.com/view.aspx?tracking=%number%&x=14&y=15&lng=en&company=2addc85e-5a32-4d40-9888-b2dcf53eca56',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            317 => [
                'id' => 441,
                'name' => 'JoeyCo',
                'slug' => 'joeyco',
                'country_id' => 2,
                'tracking_base_url' => 'https://www.joeyco.com/track-order/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            318 => [
                'id' => 442,
                'name' => 'PFC Express',
                'slug' => 'pfcexpress',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.pfcexpress.com/Manage/WebManage/Inquire.aspx?txtID=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            319 => [
                'id' => 443,
                'name' => 'DHL Benelux',
                'slug' => 'dhl-be',
                'country_id' => 23,
                'tracking_base_url' => 'https://www.dhl.com/nl-nl/home/traceren.html?tracking-id=%number%&submit=1',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            320 => [
                'id' => 444,
                'name' => 'Post One',
                'slug' => 'postone',
                'country_id' => 35,
                'tracking_base_url' => 'https://postone.eu/track?code=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            321 => [
                'id' => 445,
                'name' => 'Czech Post',
                'slug' => 'czech-post',
                'country_id' => 56,
                'tracking_base_url' => 'https://www.postaonline.cz/trackandtrace/-/zasilka/cislo?parcelNumbers=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            322 => [
                'id' => 446,
                'name' => 'PPL CZ',
                'slug' => 'ppl-cz',
                'country_id' => 56,
                'tracking_base_url' => 'https://www.ppl.cz/en/track-a-shipment?shipmentId=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            323 => [
                'id' => 447,
                'name' => 'Geis CZ',
                'slug' => 'geis-cz',
                'country_id' => 56,
                'tracking_base_url' => 'https://www.geis-group.cz/cs/detail-zasilky?packNumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            324 => [
                'id' => 448,
                'name' => 'Matkahuolto',
                'slug' => 'matkahuolto',
                'country_id' => 73,
                'tracking_base_url' => 'https://www.matkahuolto.fi/seuranta?parcelNumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            325 => [
                'id' => 449,
                'name' => 'Asendia Germany',
                'slug' => 'asendia-de',
                'country_id' => 82,
                'tracking_base_url' => 'https://tracking.asendia.com/tracking/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            326 => [
                'id' => 450,
                'name' => 'GEL Express',
                'slug' => 'gel-express',
                'country_id' => 82,
                'tracking_base_url' => 'https://srv4.thalmaier.de/gel/send/DE-de/Sendungssuche.aspx?snr=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            327 => [
                'id' => 451,
                'name' => 'GmbH',
                'slug' => 'my-austrianpost',
                'country_id' => 82,
                'tracking_base_url' => 'https://www.austrianpost.de/suche/?search=%number%&erw_suchbereich=&menuid_search=141',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            328 => [
                'id' => 452,
                'name' => 'Easy Mail',
                'slug' => 'easy-mail',
                'country_id' => 85,
                'tracking_base_url' => 'https://www.easymail.gr/web-tracking',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            329 => [
                'id' => 453,
                'name' => 'Comet Hellas',
                'slug' => 'cometcourier',
                'country_id' => 85,
                'tracking_base_url' => 'https://www.comethellas.gr',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            330 => [
                'id' => 454,
                'name' => 'Nightline',
                'slug' => 'nightline',
                'country_id' => 104,
                'tracking_base_url' => 'https://www.nightline-delivers.com/SmartShip.Online/Tracking/Actions/Default?TrackingNumbers=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            331 => [
                'id' => 455,
                'name' => 'Wiseloads',
                'slug' => 'wiseloads',
                'country_id' => 104,
                'tracking_base_url' => 'https://wiseloads.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            332 => [
                'id' => 456,
                'name' => 'LP Express',
                'slug' => 'lpexpress',
                'country_id' => 125,
                'tracking_base_url' => 'https://www.post.lt/siuntu-sekimas?parcels=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            333 => [
                'id' => 457,
                'name' => 'Venipak',
                'slug' => 'venipak',
                'country_id' => 125,
                'tracking_base_url' => 'https://venipak.lt/tracking/track/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            334 => [
                'id' => 458,
                'name' => 'Timelytitan',
                'slug' => 'timelytitan',
                'country_id' => 152,
                'tracking_base_url' => 'https://www.timelytitan.com/tracking.html?number=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            335 => [
                'id' => 459,
                'name' => 'Allekurier',
                'slug' => 'allekurier',
                'country_id' => 172,
                'tracking_base_url' => 'https://allekurier.pl/sledzenie',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            336 => [
                'id' => 460,
                'name' => 'Romania Post',
                'slug' => 'posta-romana',
                'country_id' => 178,
                'tracking_base_url' => 'https://www.posta-romana.ro/track-trace.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            337 => [
                'id' => 461,
                'name' => 'Slovenia Post',
                'slug' => 'slovenia-post',
                'country_id' => 194,
                'tracking_base_url' => 'https://www.posta.si/zasebno',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            338 => [
                'id' => 462,
                'name' => 'Packlink',
                'slug' => 'packlink',
                'country_id' => 199,
                'tracking_base_url' => 'https://www.packlink.es/cms/static/tracking/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            339 => [
                'id' => 463,
                'name' => 'CBL Logistics',
                'slug' => 'cbl-logistica',
                'country_id' => 199,
                'tracking_base_url' => 'https://www.cbl-logistica.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            340 => [
                'id' => 464,
                'name' => 'Szendex',
                'slug' => 'szendex',
                'country_id' => 199,
                'tracking_base_url' => 'https://www.szendex.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            341 => [
                'id' => 465,
                'name' => 'Mail Boxed Etc',
                'slug' => 'mbe',
                'country_id' => 199,
                'tracking_base_url' => 'https://www.mbe.es/es/tracking?c=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            342 => [
                'id' => 466,
                'name' => 'Courier IT',
                'slug' => 'courier-it',
                'country_id' => 197,
                'tracking_base_url' => 'https://www.courierit.co.za/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            343 => [
                'id' => 468,
                'name' => 'Interparcel Au',
                'slug' => 'interparcel-au',
                'country_id' => 15,
                'tracking_base_url' => 'https://au.interparcel.com/tracking/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            344 => [
                'id' => 469,
                'name' => 'Interparcel NZ',
                'slug' => 'interparcel-nz',
                'country_id' => 155,
                'tracking_base_url' => 'https://nz.interparcel.com/tracking/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            345 => [
                'id' => 470,
                'name' => 'Postnet',
                'slug' => 'postnet',
                'country_id' => 197,
                'tracking_base_url' => 'https://www.postnet.co.za/tracker',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            346 => [
                'id' => 473,
                'name' => 'Main Freight',
                'slug' => 'mainfreight',
                'country_id' => 155,
                'tracking_base_url' => 'https://www.mainfreight.com/en-nz/tracking?trackingnumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            347 => [
                'id' => 474,
                'name' => 'Flyt Express',
                'slug' => 'flyt-express',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.flytexpress.com/Home/LogisticsTracking#orderIds',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            348 => [
                'id' => 475,
                'name' => 'Arco Spedizioni',
                'slug' => 'arco-spedizioni',
                'country_id' => 106,
                'tracking_base_url' => 'https://clienti.arcospedizioni.it/#/trackingDetail/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            349 => [
                'id' => 476,
                'name' => 'Allied Express',
                'slug' => 'alliedexpress',
                'country_id' => 15,
                'tracking_base_url' => 'https://neptune.alliedexpress.com.au/iTrack/search.do',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            350 => [
                'id' => 477,
                'name' => 'Bonds Couriers',
                'slug' => 'bondscouriers',
                'country_id' => 15,
                'tracking_base_url' => 'https://bondscouriers.com.au/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            351 => [
                'id' => 479,
                'name' => 'DPD Lithuania',
                'slug' => 'dpd-lt',
                'country_id' => 125,
                'tracking_base_url' => 'https://www.dpdgroup.com/lt/mydpd/my-parcels/incoming?parcelNumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            352 => [
                'id' => 481,
                'name' => 'J&T SA',
                'slug' => 'jt-sa',
                'country_id' => 187,
                'tracking_base_url' => 'https://www.jtexpress-sa.com/trajectoryQuery?waybillNo=%number%&type=0',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            353 => [
                'id' => 482,
                'name' => 'ABX Express',
                'slug' => 'abx-express',
                'country_id' => 131,
                'tracking_base_url' => 'https://www.abxexpress.com.my/tracking',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            354 => [
                'id' => 483,
                'name' => 'PostNord Finland',
                'slug' => 'postnord-finland',
                'country_id' => 73,
                'tracking_base_url' => 'https://www.postnord.fi/tyokalut/lahetysten-seuranta?shipmentId=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            355 => [
                'id' => 485,
                'name' => 'Sendeo',
                'slug' => 'sendeo',
                'country_id' => 219,
                'tracking_base_url' => 'https://sendeo.com.tr/tracking?q=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            356 => [
                'id' => 486,
                'name' => 'Shree Nandan Courier',
                'slug' => 'shree-nandan',
                'country_id' => 100,
                'tracking_base_url' => 'http://www.shreenandancourier.com/TrackingInfo.aspx?cn=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            357 => [
                'id' => 488,
                'name' => 'Iberomail',
                'slug' => 'iberomail',
                'country_id' => 173,
                'tracking_base_url' => 'https://iberomail.com/pt/localizar-encomenda/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            358 => [
                'id' => 489,
                'name' => 'Ltian Exp',
                'slug' => 'ltian-exp',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.ltianexp.com/trajectory',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            359 => [
                'id' => 490,
                'name' => 'YDH',
                'slug' => 'ydh',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.ydhex.com/tools/inquire?number=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            360 => [
                'id' => 491,
                'name' => 'Omniva',
                'slug' => 'omniva',
                'country_id' => 125,
                'tracking_base_url' => 'https://mano.omniva.lt/track/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            361 => [
                'id' => 492,
                'name' => 'YHT',
                'slug' => 'yht',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.eshippinggateway.com/tracking.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            362 => [
                'id' => 496,
                'name' => 'Econt',
                'slug' => 'econt',
                'country_id' => 35,
                'tracking_base_url' => 'https://www.econt.com/en/services/track-shipment',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            363 => [
                'id' => 497,
                'name' => 'M Xpress',
                'slug' => 'mxpress',
                'country_id' => 131,
                'tracking_base_url' => 'https://gold.mxpress2u.net/gold/PublicShipmentTracking.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            364 => [
                'id' => 499,
                'name' => 'HyperSKU',
                'slug' => 'hyper-sku',
                'country_id' => 45,
                'tracking_base_url' => 'https://track.hypersku.com/?set_lang=en&finalNo=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            365 => [
                'id' => 500,
                'name' => 'Smartr Logistics',
                'slug' => 'smartr-logistics',
                'country_id' => 100,
                'tracking_base_url' => 'https://smartr.in/tracking?wb=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            366 => [
                'id' => 502,
                'name' => 'HepsiJet',
                'slug' => 'hepsi-jet',
                'country_id' => 219,
                'tracking_base_url' => 'https://www.hepsijet.com/gonderi-takibi/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            367 => [
                'id' => 503,
                'name' => 'Dt Express Couriers',
                'slug' => 'dt-express-couriers',
                'country_id' => 197,
                'tracking_base_url' => 'https://dtsolutions.pperfect.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            368 => [
                'id' => 504,
                'name' => 'DPD BE',
                'slug' => 'dpd-be',
                'country_id' => 23,
                'tracking_base_url' => 'https://www.dpdgroup.com/be/mydpd/my-parcels/search?lang=en&parcelNumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            369 => [
                'id' => 505,
                'name' => 'Courier Center',
                'slug' => 'courier-center',
                'country_id' => 85,
                'tracking_base_url' => 'https://www.courier.gr/track/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            370 => [
                'id' => 506,
                'name' => 'Flash Express MY',
                'slug' => 'flash-express-my',
                'country_id' => 131,
                'tracking_base_url' => 'https://www.flashexpress.my/tracking/?se=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            371 => [
                'id' => 507,
                'name' => 'Quantium',
                'slug' => 'quantium',
                'country_id' => 192,
                'tracking_base_url' => 'http://track.quantiumsolutions.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            372 => [
                'id' => 508,
                'name' => 'iMile',
                'slug' => 'imile',
                'country_id' => 225,
                'tracking_base_url' => 'https://www.imile.com/track',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            373 => [
                'id' => 509,
                'name' => 'eTower',
                'slug' => 'etower',
                'country_id' => 45,
                'tracking_base_url' => 'http://etowertech.com/home',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            374 => [
                'id' => 510,
                'name' => 'Seino',
                'slug' => 'seino',
                'country_id' => 109,
                'tracking_base_url' => 'https://track.seino.co.jp/cgi-bin/gnpquery.pgm',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            375 => [
                'id' => 511,
                'name' => 'Nova Poshta Global',
                'slug' => 'nova-poshta-global',
                'country_id' => 224,
                'tracking_base_url' => 'https://novaposhtaglobal.ua/en/track/?Tracking_ID=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            376 => [
                'id' => 512,
                'name' => 'Inter Rapidisimo',
                'slug' => 'inter-rapidisimo',
                'country_id' => 48,
                'tracking_base_url' => 'https://interrapidisimo.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            377 => [
                'id' => 513,
                'name' => 'XL Express',
                'slug' => 'xl-express',
                'country_id' => 15,
                'tracking_base_url' => 'https://xleonline.com.au/tracking/xlexpress/view/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            378 => [
                'id' => 514,
                'name' => 'Redx',
                'slug' => 'redx',
                'country_id' => 20,
                'tracking_base_url' => 'https://redx.com.bd/track-global-parcel/?trackingId=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            379 => [
                'id' => 515,
                'name' => 'Pathao',
                'slug' => 'pathao',
                'country_id' => 20,
                'tracking_base_url' => 'https://pathao.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            380 => [
                'id' => 516,
                'name' => 'Paperfly',
                'slug' => 'paperfly',
                'country_id' => 20,
                'tracking_base_url' => 'https://www.paperfly.com.bd/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            381 => [
                'id' => 517,
                'name' => 'Logista Parcel',
                'slug' => 'logista-parcel',
                'country_id' => 199,
                'tracking_base_url' => 'https://www.logistaparcel.com/es/home/track-and-trace/shipment-tracking.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            382 => [
                'id' => 518,
                'name' => 'Instabox',
                'slug' => 'instabox',
                'country_id' => 152,
                'tracking_base_url' => 'https://track.instabox.nl/t/%number%/2312KJ',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            383 => [
                'id' => 519,
                'name' => 'Sundarban Courier',
                'slug' => 'sundarban-courier',
                'country_id' => 20,
                'tracking_base_url' => 'http://103.3.227.172:4040/Default.aspx?Page=SearchByContact',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            384 => [
                'id' => 520,
                'name' => 'Posstore',
                'slug' => 'posstore',
                'country_id' => 131,
                'tracking_base_url' => 'http://47.250.41.212:8085/DNYInterfaceServer/ztserver/tabOrderBill/query?nu=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            385 => [
                'id' => 521,
                'name' => 'Scharff',
                'slug' => 'scharff',
                'country_id' => 169,
                'tracking_base_url' => 'https://wsintegracion.holascharff.com/webpage/trackingweb/Tracking.asp',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            386 => [
                'id' => 522,
                'name' => 'Shalom',
                'slug' => 'shalom',
                'country_id' => 169,
                'tracking_base_url' => 'https://rastrea.shalom.pe/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            387 => [
                'id' => 523,
                'name' => 'Olva courier',
                'slug' => 'olva-courier',
                'country_id' => 169,
                'tracking_base_url' => 'https://tracking.olvaexpress.pe/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            388 => [
                'id' => 524,
                'name' => 'GoPack Peru',
                'slug' => 'gopack-peru',
                'country_id' => 169,
                'tracking_base_url' => 'https://gopack-peru.com/vista/verPedido/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            389 => [
                'id' => 525,
                'name' => 'Az Express',
                'slug' => 'az-express',
                'country_id' => 169,
                'tracking_base_url' => 'http://azexpress.ddns.net/consulta_dni.php',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            390 => [
                'id' => 526,
                'name' => 'Cruz del sur',
                'slug' => 'cruz-del-sur',
                'country_id' => 169,
                'tracking_base_url' => 'https://www.cruzdelsurcargo.com.pe/agenciasbuscatuencomienda',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            391 => [
                'id' => 527,
                'name' => 'Urbano',
                'slug' => 'urbano',
                'country_id' => 169,
                'tracking_base_url' => 'https://www.urbano.com.pe/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            392 => [
                'id' => 528,
                'name' => 'Happy Courier',
                'slug' => 'happy-courier',
                'country_id' => 85,
                'tracking_base_url' => 'https://happycourier.extranet4u.com/el/courier/voucher/Voucher.html?r18p01=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            393 => [
                'id' => 529,
                'name' => 'Flash Express PH',
                'slug' => 'flash-express-ph',
                'country_id' => 170,
                'tracking_base_url' => 'https://www.flashexpress.ph/tracking/?se=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            394 => [
                'id' => 530,
                'name' => 'Nationwide Express',
                'slug' => 'nationwide-express',
                'country_id' => 131,
                'tracking_base_url' => 'http://www.nationwide.com.my/Tracking/Details/N8690523108498',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            395 => [
                'id' => 532,
                'name' => 'Express one',
                'slug' => 'expressone',
                'country_id' => 98,
                'tracking_base_url' => 'https://tracking.expressone.hu/?plc_number=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            396 => [
                'id' => 533,
                'name' => 'Equick',
                'slug' => 'equick',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.equick.cn/en/index.php?m=content&c=index&a=lists&catid=25&code=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            397 => [
                'id' => 534,
                'name' => 'TakeSend',
                'slug' => 'takesend',
                'country_id' => 45,
                'tracking_base_url' => 'http://k5.takesend.com:8180/WebTrack?action=list&language=en',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            398 => [
                'id' => 536,
                'name' => 'GLS Austria',
                'slug' => 'gls-au',
                'country_id' => 16,
                'tracking_base_url' => 'https://gls-group.eu/EU/en/parcel-tracking?match=%number%&amp;postalCode=%postal_code%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            399 => [
                'id' => 537,
                'name' => 'Skynet South Africa',
                'slug' => 'skynet-south-africa',
                'country_id' => 197,
                'tracking_base_url' => 'https://www.skynet.co.za/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            400 => [
                'id' => 538,
                'name' => 'Starken',
                'slug' => 'starken',
                'country_id' => 44,
                'tracking_base_url' => 'https://www.starken.cl/seguimiento',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            401 => [
                'id' => 539,
                'name' => 'ELTA Hellenic',
                'slug' => 'elta-hellenic',
                'country_id' => 85,
                'tracking_base_url' => 'https://elta.gr/en/track?code=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            402 => [
                'id' => 540,
                'name' => 'BEST Express',
                'slug' => 'best-express-th',
                'country_id' => 213,
                'tracking_base_url' => 'https://www.best-inc.co.th/track?bills=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            403 => [
                'id' => 541,
                'name' => 'Blues Express',
                'slug' => 'bluex',
                'country_id' => 44,
                'tracking_base_url' => 'https://www.blue.cl/seguimiento/?n_seguimiento=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            404 => [
                'id' => 542,
                'name' => 'Correos de Mexico',
                'slug' => 'correos-de-mexico',
                'country_id' => 140,
                'tracking_base_url' => 'https://www.correosdemexico.gob.mx/SSLServicios/SeguimientoEnvio/Seguimiento.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            405 => [
                'id' => 543,
                'name' => 'Lafasta',
                'slug' => 'lafasta',
                'country_id' => 225,
                'tracking_base_url' => 'https://c.lafasta.sa.com/Track/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            406 => [
                'id' => 544,
                'name' => 'Ram',
                'slug' => 'ram',
                'country_id' => 197,
                'tracking_base_url' => 'https://www.ram.co.za/Track/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            407 => [
                'id' => 545,
                'name' => 'ETG',
                'slug' => 'etg',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.etg56.com/logistics.html?tab=1',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            408 => [
                'id' => 546,
                'name' => 'GLS Hungary',
                'slug' => 'gls-hungary',
                'country_id' => 98,
                'tracking_base_url' => 'https://gls-group.eu/HU/en/parcel-tracking?match=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            409 => [
                'id' => 547,
                'name' => 'GLS Canada',
                'slug' => 'gls-canada',
                'country_id' => 2,
                'tracking_base_url' => 'https://www.gls-canada.com/en/dicom/tracking',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            410 => [
                'id' => 551,
                'name' => 'Intelcom',
                'slug' => 'intelcom',
                'country_id' => 2,
                'tracking_base_url' => 'https://intelcom.ca/en/track-your-package/?tracking-id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            411 => [
                'id' => 552,
                'name' => 'DExpress',
                'slug' => 'dexpress',
                'country_id' => 189,
                'tracking_base_url' => 'https://www.dexpress.rs/en/track-and-trace/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            412 => [
                'id' => 553,
                'name' => 'GLS Slovakia',
                'slug' => 'gls-slovakia',
                'country_id' => 193,
                'tracking_base_url' => 'https://gls-group.eu/SK/sk/sledovanie-zasielok?match=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            413 => [
                'id' => 554,
                'name' => 'ZTO Express',
                'slug' => 'zto-express',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.zto.com/express/expressCheck.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            414 => [
                'id' => 557,
                'name' => 'GLS Romania',
                'slug' => 'gls-romania',
                'country_id' => 178,
                'tracking_base_url' => 'https://gls-group.com/RO/ro/urmarire-colet.html?match=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            415 => [
                'id' => 558,
                'name' => 'WEL',
                'slug' => 'wel',
                'country_id' => 45,
                'tracking_base_url' => 'http://shgj.rtb56.com/track_query.aspx?type=cp&documentCode=%number%&Submit.x=18&Submit.y=9',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            416 => [
                'id' => 560,
                'name' => 'Exelot',
                'slug' => 'exelot',
                'country_id' => 105,
                'tracking_base_url' => 'https://public.exelot.com/tracking/%number%?lang=en',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            417 => [
                'id' => 561,
                'name' => 'SANA',
                'slug' => 'sana',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.mhafly.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            418 => [
                'id' => 562,
                'name' => 'SDH',
                'slug' => 'sdh',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.sdh-scm.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            419 => [
                'id' => 563,
                'name' => 'Collivery',
                'slug' => 'collivery',
                'country_id' => 197,
                'tracking_base_url' => 'https://collivery.net/tracking?waybill=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            420 => [
                'id' => 564,
                'name' => 'Bosta',
                'slug' => 'bosta',
                'country_id' => 64,
                'tracking_base_url' => 'https://bosta.co/tracking-shipments?shipment-number=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            421 => [
                'id' => 580,
                'name' => 'Uruguay Post',
                'slug' => 'uruguay-post',
                'country_id' => 228,
                'tracking_base_url' => 'https://www.correo.com.uy/home',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            422 => [
                'id' => 581,
                'name' => 'Serpost',
                'slug' => 'serpost',
                'country_id' => 169,
                'tracking_base_url' => 'https://www.serpost.com.pe/Cliente/SegumientoLinea',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            423 => [
                'id' => 582,
                'name' => 'Jamaica Post',
                'slug' => 'jamaica-post',
                'country_id' => 108,
                'tracking_base_url' => 'https://jamaicapost.gov.jm/track-and-trace/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            424 => [
                'id' => 583,
                'name' => 'El Salvador Post',
                'slug' => 'el-salvador-post',
                'country_id' => 65,
                'tracking_base_url' => 'https://www.transparencia.gob.sv/search?utf8=&ft=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            425 => [
                'id' => 584,
                'name' => 'Dominican Post',
                'slug' => 'dominican-post',
                'country_id' => 61,
                'tracking_base_url' => 'https://www.inposdom.gob.do/search?q=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            426 => [
                'id' => 585,
                'name' => 'Cuba Post',
                'slug' => 'cuba-post',
                'country_id' => 54,
                'tracking_base_url' => 'https://www.correos.cu/rastreador-de-envios/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            427 => [
                'id' => 586,
                'name' => 'Bermuda Post',
                'slug' => 'bermuda-post',
                'country_id' => 26,
                'tracking_base_url' => 'https://www.bermudapost.bm/track-your-item/?trackNumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            428 => [
                'id' => 587,
                'name' => 'Barbados Post',
                'slug' => 'barbados-post',
                'country_id' => 21,
                'tracking_base_url' => 'https://bps.gov.bb/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            429 => [
                'id' => 588,
                'name' => 'Aruba Post',
                'slug' => 'aruba-post',
                'country_id' => 14,
                'tracking_base_url' => 'https://cds.postaruba.com/ipswt/IPSWeb_item_events.aspx?itemid=%number%&Submit=Submit',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            430 => [
                'id' => 590,
                'name' => 'AMSEGROUP',
                'slug' => 'amsegroup',
                'country_id' => 15,
                'tracking_base_url' => 'http://eretail.amservices.net.au:8080/parceltracker.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            431 => [
                'id' => 591,
                'name' => 'Beebird Logistics',
                'slug' => 'beebird-logistics',
                'country_id' => 15,
                'tracking_base_url' => 'https://beebird.com.au/tracking/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            432 => [
                'id' => 593,
                'name' => 'SX Express',
                'slug' => 'sx-express',
                'country_id' => 15,
                'tracking_base_url' => 'https://sxexpress.myazstore.com/searchtracking?no=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            433 => [
                'id' => 594,
                'name' => 'Ark express',
                'slug' => 'ark-express',
                'country_id' => 15,
                'tracking_base_url' => 'http://en.arkexpress.com.au/searchOrder?orderNo=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            434 => [
                'id' => 595,
                'name' => 'Chinz Logistics',
                'slug' => 'chinz-logistics',
                'country_id' => 155,
                'tracking_base_url' => 'http://www.chinz56.co.nz/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            435 => [
                'id' => 596,
                'name' => 'EWE Global Express',
                'slug' => 'ewe global express',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.ewe.com.au/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            436 => [
                'id' => 598,
                'name' => 'XDEXPRESS',
                'slug' => 'xdexpress',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.xdexpress.com.au/Express.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            437 => [
                'id' => 599,
                'name' => 'EFSPost',
                'slug' => 'efsPost',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.efspost.com/index/query_track?postnum=%number%&code=pesu',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            438 => [
                'id' => 600,
                'name' => 'Auexpress',
                'slug' => 'euexpress',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.auexpress.com/tracking?OrderId=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            439 => [
                'id' => 601,
                'name' => 'FTD Express',
                'slug' => 'ftd-Express',
                'country_id' => 155,
                'tracking_base_url' => 'https://www.ftd.nz/query/?code=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            440 => [
                'id' => 602,
                'name' => 'PCA',
                'slug' => 'pca',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.pcaexpress.com.au/tracking/?c=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            441 => [
                'id' => 603,
                'name' => 'Fastgo',
                'slug' => 'fastgo',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.fastgo.com.au/WaybillQuery',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            442 => [
                'id' => 604,
                'name' => 'ADSOne',
                'slug' => 'adaone',
                'country_id' => 15,
                'tracking_base_url' => 'https://tracking.icumulus.cloud/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            443 => [
                'id' => 605,
                'name' => 'Shiprocket',
                'slug' => 'shiprocket',
                'country_id' => 100,
                'tracking_base_url' => 'https://shiprocket.co/tracking/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            444 => [
                'id' => 606,
                'name' => 'Pidge',
                'slug' => 'pidge',
                'country_id' => 100,
                'tracking_base_url' => 'https://pidge.in/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            445 => [
                'id' => 607,
                'name' => 'Wanmeng',
                'slug' => 'wanmeng',
                'country_id' => 45,
                'tracking_base_url' => 'https://wms.wmycc.com/tracking.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            446 => [
                'id' => 608,
                'name' => 'ConnectCo',
                'slug' => 'connectco',
                'country_id' => 200,
                'tracking_base_url' => 'https://connectcoapps.lk/tracking/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            447 => [
                'id' => 609,
                'name' => 'BIRD SYSTEM LTD',
                'slug' => 'bird-system-ltd',
                'country_id' => 45,
                'tracking_base_url' => 'http://track.birdsystem.com/?ids=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            448 => [
                'id' => 610,
                'name' => 'U-Speed Express',
                'slug' => 'u-speed-express',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.u-speedex.com/queryTracks?no=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            449 => [
                'id' => 611,
                'name' => 'SPX ID',
                'slug' => 'spx-id',
                'country_id' => 101,
                'tracking_base_url' => 'https://spx.co.id/detail/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            450 => [
                'id' => 612,
                'name' => 'CGS Express',
                'slug' => 'cgs-Express',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.cgs-express.com:8082/trackIndex.htm',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            451 => [
                'id' => 613,
                'name' => 'SCG Express',
                'slug' => 'scg-express',
                'country_id' => 213,
                'tracking_base_url' => 'https://www.scgexpress.co.th/tracking/?fav',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            452 => [
                'id' => 614,
                'name' => 'SPX MY',
                'slug' => 'spx-my',
                'country_id' => 131,
                'tracking_base_url' => 'https://shopeexpress.com.my/detail/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            453 => [
                'id' => 615,
                'name' => 'Morning Express',
                'slug' => 'morning-express',
                'country_id' => 97,
                'tracking_base_url' => 'https://www.mechk.com/guest-order-tracking/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            454 => [
                'id' => 616,
                'name' => 'Asyad Express',
                'slug' => 'asyad-express',
                'country_id' => 163,
                'tracking_base_url' => 'https://www.asyadexpress.om/track-trace',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            455 => [
                'id' => 617,
                'name' => 'SPX VN',
                'slug' => 'spx-vn',
                'country_id' => 233,
                'tracking_base_url' => 'https://spx.vn/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            456 => [
                'id' => 618,
                'name' => 'We World Express',
                'slug' => 'we-world-express',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.weworldexpress.com/wwe/track',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            457 => [
                'id' => 619,
                'name' => 'Nippon Express',
                'slug' => 'Nippon Express',
                'country_id' => 109,
                'tracking_base_url' => 'https://www.nittsu.co.jp/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            458 => [
                'id' => 620,
                'name' => 'Taiwan Pelican Express',
                'slug' => 'taiwan pelican express',
                'country_id' => 210,
                'tracking_base_url' => 'https://www.e-can.com.tw/search_Goods.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            459 => [
                'id' => 621,
                'name' => 'FedEx Mexico',
                'slug' => 'fedex-mexico',
                'country_id' => 140,
                'tracking_base_url' => 'https://www.fedex.com/fedextrack/no-results-found?trknbr=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            460 => [
                'id' => 622,
                'name' => 'DHL Mexico',
                'slug' => 'dhl-mx',
                'country_id' => 140,
                'tracking_base_url' => 'https://www.dhl.com/mx-es/home/rastreo.html?tracking-id=%number%&submit=1',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            461 => [
                'id' => 625,
                'name' => 'Pandu Logistics',
                'slug' => 'pandu-logistics',
                'country_id' => 101,
                'tracking_base_url' => 'https://pandulogistics.com/track/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            462 => [
                'id' => 626,
                'name' => 'RZY Express',
                'slug' => 'rzy-express',
                'country_id' => 192,
                'tracking_base_url' => 'https://rzyexpress.com.sg/tracking.php',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            463 => [
                'id' => 629,
                'name' => 'ACOMMERCE',
                'slug' => 'acommerce',
                'country_id' => 213,
                'tracking_base_url' => 'https://tracking.acommerce.asia/?id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            464 => [
                'id' => 630,
                'name' => 'Viettel Post',
                'slug' => 'viettel-post',
                'country_id' => 233,
                'tracking_base_url' => 'https://en.viettelpost.com.vn/#one2',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            465 => [
                'id' => 631,
                'name' => 'Xend Express',
                'slug' => 'xend-express',
                'country_id' => 170,
                'tracking_base_url' => 'https://xendexpress.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            466 => [
                'id' => 632,
                'name' => 'Uzbekistan Post',
                'slug' => 'uzbekistan-post',
                'country_id' => 229,
                'tracking_base_url' => 'https://pochta.uz/en/2014-06-09-08-50-39/track-trace.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            467 => [
                'id' => 636,
                'name' => 'Emons',
                'slug' => 'emons',
                'country_id' => 82,
                'tracking_base_url' => 'https://www.emons.de/tracking',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            468 => [
                'id' => 637,
                'name' => 'Beexpress',
                'slug' => 'bee-express',
                'country_id' => 213,
                'tracking_base_url' => 'https://www.beexprss.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            469 => [
                'id' => 638,
                'name' => 'Solid Logistcs',
                'slug' => 'solid-logistcs',
                'country_id' => 45,
                'tracking_base_url' => 'https://solidlogistics.id/web.solid/aboutus?c=tracking',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            470 => [
                'id' => 639,
                'name' => 'Flyway Express',
                'slug' => 'flyway-express',
                'country_id' => 45,
                'tracking_base_url' => 'https://flywayexpress.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            471 => [
                'id' => 640,
                'name' => 'QEXPRESS',
                'slug' => 'qexpress',
                'country_id' => 155,
                'tracking_base_url' => 'https://www.qxpress.net/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            472 => [
                'id' => 641,
                'name' => 'Blue Sky Express',
                'slug' => 'blue-sky-express',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.bskyexpress.com/track.php?awb=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            473 => [
                'id' => 642,
                'name' => 'HKD Express',
                'slug' => 'hkd-express',
                'country_id' => 15,
                'tracking_base_url' => 'http://www.hkdexpress.net/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            474 => [
                'id' => 643,
                'name' => 'Cosco Express',
                'slug' => 'cosco-express',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.zy100-express.com/index.php?c=category&id=5&title=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            475 => [
                'id' => 644,
                'name' => 'Cargus',
                'slug' => 'cargus',
                'country_id' => 178,
                'tracking_base_url' => 'https://www.cargus.ro/tracking-romanian/?t=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            476 => [
                'id' => 645,
                'name' => 'Ghana Post',
                'slug' => 'ghana-post',
                'country_id' => 197,
                'tracking_base_url' => 'https://tools.v2.ghanapost.com.gh/toolsv1/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            477 => [
                'id' => 646,
                'name' => 'Pargo',
                'slug' => 'pargo',
                'country_id' => 197,
                'tracking_base_url' => 'https://pargo.co.za/track-trace/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            478 => [
                'id' => 647,
                'name' => 'Roadbull Logistics',
                'slug' => 'roadbull-logistics',
                'country_id' => 197,
                'tracking_base_url' => 'https://cds.roadbull.com/order/track/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            479 => [
                'id' => 648,
                'name' => 'Nigeria Post',
                'slug' => 'nigeria-post',
                'country_id' => 158,
                'tracking_base_url' => 'https://www.nipost.gov.ng/Track_Trace',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            480 => [
                'id' => 649,
                'name' => 'Mauritius Post',
                'slug' => 'mauritius-post',
                'country_id' => 138,
                'tracking_base_url' => 'https://www.mauritiuspost.mu/trackandtrace.php?itemid=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            481 => [
                'id' => 650,
                'name' => 'Correios Cabo Verde',
                'slug' => 'correios-cabo-verde',
                'country_id' => 40,
                'tracking_base_url' => 'https://correios.cv/ferramentas/tracking?tracking-ids=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            482 => [
                'id' => 651,
                'name' => 'Benin Post',
                'slug' => 'benin-post',
                'country_id' => 25,
                'tracking_base_url' => 'https://laposte.bj/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            483 => [
                'id' => 652,
                'name' => 'Bosnia And Herzegovina Post',
                'slug' => 'bosnia-and-herzegovina-post',
                'country_id' => 29,
                'tracking_base_url' => 'https://bhpwebout.posta.ba/trackwebapp/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            484 => [
                'id' => 653,
                'name' => 'Belarus Post',
                'slug' => 'belarus-post',
                'country_id' => 22,
                'tracking_base_url' => 'https://belpost.by/Otsleditotpravleniye?number=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            485 => [
                'id' => 654,
                'name' => 'Albania Post',
                'slug' => 'albania-post',
                'country_id' => 4,
                'tracking_base_url' => 'https://www.postashqiptare.al/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            486 => [
                'id' => 655,
                'name' => 'Zambia Post',
                'slug' => 'zambia post',
                'country_id' => 241,
                'tracking_base_url' => 'http://www.postglobalonline.com/track/zm/track.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            487 => [
                'id' => 656,
                'name' => 'Uganda Post',
                'slug' => 'uganda-post',
                'country_id' => 223,
                'tracking_base_url' => 'http://globaltracktrace.ptc.post/gtt.web/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            488 => [
                'id' => 659,
                'name' => 'Espost',
                'slug' => 'espost',
                'country_id' => 199,
                'tracking_base_url' => 'https://www.espost.es/track',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            489 => [
                'id' => 660,
                'name' => 'Sailpost',
                'slug' => 'sailpost',
                'country_id' => 106,
                'tracking_base_url' => 'https://www.sailpost.it/traccia-il-pacco/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            490 => [
                'id' => 661,
                'name' => 'Cacesa Postal',
                'slug' => 'cacesa-postal',
                'country_id' => 199,
                'tracking_base_url' => 'https://www.cacesa.com/es/seguimiento?busqueda=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            491 => [
                'id' => 663,
                'name' => 'Hua Han Logistics',
                'slug' => 'hua-han-logistics',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.hh-exp.cn/WebTrack/CargoTrack.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            492 => [
                'id' => 665,
                'name' => 'San Marino Post',
                'slug' => 'san-marino-post',
                'country_id' => 185,
                'tracking_base_url' => 'https://www.poste.sm/on-line/home.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            493 => [
                'id' => 668,
                'name' => 'Euasia Express',
                'slug' => 'euasia-express',
                'country_id' => 152,
                'tracking_base_url' => 'http://www.euasia.eu/h1.html?%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            494 => [
                'id' => 669,
                'name' => 'Postal State International',
                'slug' => 'postal-state-international',
                'country_id' => 82,
                'tracking_base_url' => 'http://www.youban.de/CN/track/?expressnum=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            495 => [
                'id' => 670,
                'name' => 'J-NET Express',
                'slug' => 'j-net Express',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.j-net.cn/index.php/page/track.html?number=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            496 => [
                'id' => 673,
                'name' => 'Cosmetics Now',
                'slug' => 'cosmetics-now',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.cosmeticsnow.in/?main_page=account_history_info&track=true&order_id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            497 => [
                'id' => 674,
                'name' => 'Vanuatu Post',
                'slug' => 'vanuatu-post',
                'country_id' => 230,
                'tracking_base_url' => 'https://www.vanuatupost.vu/track-and-trace',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            498 => [
                'id' => 675,
                'name' => 'Tuvalu Post',
                'slug' => 'tuvalu-post',
                'country_id' => 222,
                'tracking_base_url' => 'http://tuvalupost.tv/Track',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            499 => [
                'id' => 676,
                'name' => 'Samoa Post',
                'slug' => 'samoa-post',
                'country_id' => 184,
                'tracking_base_url' => 'https://www.samoapost.ws/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
        ]);
        \DB::table('shipping_providers')->insert([
            0 => [
                'id' => 677,
                'name' => 'Saint Lucia Post',
                'slug' => 'saint-lucia-post',
                'country_id' => 182,
                'tracking_base_url' => 'https://stluciapostal.com/track-and-trace/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            1 => [
                'id' => 678,
                'name' => 'Papua New Guinea Post',
                'slug' => 'papua-new-guinea-post',
                'country_id' => 167,
                'tracking_base_url' => 'https://www.postpng.com.pg/track_trace',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            2 => [
                'id' => 679,
                'name' => 'Parcel Freight Logistics',
                'slug' => 'parcel-freight-logistics',
                'country_id' => 15,
                'tracking_base_url' => 'http://www.pflogistics.com.au/tracking-result',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            3 => [
                'id' => 680,
                'name' => 'DD Express',
                'slug' => 'dd-express',
                'country_id' => 131,
                'tracking_base_url' => 'https://tracking.dd.express/v2/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            4 => [
                'id' => 682,
                'name' => 'Airspeed International',
                'slug' => 'airspeed-international',
                'country_id' => 170,
                'tracking_base_url' => 'https://airspeed.ph/track-cargo/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            5 => [
                'id' => 683,
                'name' => 'Maldives Post',
                'slug' => 'maldives-post',
                'country_id' => 132,
                'tracking_base_url' => 'https://www.maldivespost.com/tracker?tracking_number=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            6 => [
                'id' => 684,
                'name' => 'ZMC EXPRESS',
                'slug' => 'zmc-express',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.zmcexpress.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            7 => [
                'id' => 685,
                'name' => 'ICS Courier',
                'slug' => 'ics-courier',
                'country_id' => 2,
                'tracking_base_url' => 'https://www.icscourier.ca/online-services/parcel-tracking.aspx?trackNums=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            8 => [
                'id' => 686,
                'name' => 'Georgia Post',
                'slug' => 'georgia-post',
                'country_id' => 81,
                'tracking_base_url' => 'https://www.gpost.ge/main',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            9 => [
                'id' => 687,
                'name' => 'UPS Italy',
                'slug' => 'ups-italy',
                'country_id' => 106,
                'tracking_base_url' => 'https://www.ups.com/track?loc=en_IT&requester=QUIC&tracknum=%number%/trackdetails',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            10 => [
                'id' => 688,
                'name' => 'Blexpress',
                'slug' => 'blexpress',
                'country_id' => 45,
                'tracking_base_url' => 'blexpress',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            11 => [
                'id' => 689,
                'name' => 'Biz Courier',
                'slug' => 'biz-courier',
                'country_id' => 85,
                'tracking_base_url' => 'https://trackit.bizcourier.eu/app/en/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            12 => [
                'id' => 690,
                'name' => 'Dhlink',
                'slug' => 'dhlink',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.dhlink.com/trackQuery',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            13 => [
                'id' => 691,
                'name' => 'HHY Express',
                'slug' => 'hhy-express',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.track718.com/en/detail?nums=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            14 => [
                'id' => 692,
                'name' => 'Elog Luxembourg',
                'slug' => 'elog-luxembourg',
                'country_id' => 126,
                'tracking_base_url' => 'https://www.elog-luxembourg.com/tracking?q=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            15 => [
                'id' => 694,
                'name' => 'Kaigenlogistics',
                'slug' => 'kaigenlogistics',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.kaigenlogistics.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            16 => [
                'id' => 695,
                'name' => 'Xin Shu Logistics',
                'slug' => 'xin-shu-logistics',
                'country_id' => 45,
                'tracking_base_url' => 'http://106.52.18.124:8082/trackIndex.htm',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            17 => [
                'id' => 696,
                'name' => 'KOMON EXPRESS',
                'slug' => 'komon-express',
                'country_id' => 45,
                'tracking_base_url' => 'https://t.17track.net/en#nums=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            18 => [
                'id' => 697,
                'name' => 'Yide International',
                'slug' => 'yide-international',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.ydexp.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            19 => [
                'id' => 698,
                'name' => 'Hua Xi',
                'slug' => 'hua-xi',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.huaxiexpress.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            20 => [
                'id' => 699,
                'name' => 'Zhi Teng Logistics',
                'slug' => 'zhi-teng-logistics',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.zhiteng.biz:8888/WebTrack',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            21 => [
                'id' => 701,
                'name' => 'HOTWMS',
                'slug' => 'hotwms',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.hotwms.com/trace.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            22 => [
                'id' => 702,
                'name' => 'HJWL',
                'slug' => 'hjwl',
                'country_id' => 44,
                'tracking_base_url' => 'http://www.hjwl.ltd/login',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            23 => [
                'id' => 703,
                'name' => 'HD Express',
                'slug' => 'hd-express',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.hdc-express.com/#/user/login/redirect=',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            24 => [
                'id' => 705,
                'name' => 'Bridge',
                'slug' => 'bridge',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.bri-ems.com/query',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            25 => [
                'id' => 706,
                'name' => 'Canada Air Express',
                'slug' => 'canada-air-express',
                'country_id' => 45,
                'tracking_base_url' => 'https://air-gtc.com/WaybillLot.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            26 => [
                'id' => 707,
                'name' => 'LONGCPS',
                'slug' => 'longcps',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.longcps.com/select/?num=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            27 => [
                'id' => 708,
                'name' => 'Hui Feng Logistics',
                'slug' => 'hui-feng-logistics',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.huif56.com/chaxun.php?act=search',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            28 => [
                'id' => 710,
                'name' => 'La Huo Express',
                'slug' => 'la-huo-express',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.lahuoex.com/cha/query1.php',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            29 => [
                'id' => 711,
                'name' => 'FT Exprss',
                'slug' => 'ft-exprss',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.101iex.com/select/?num=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            30 => [
                'id' => 712,
                'name' => 'Run Bai Internation',
                'slug' => 'run bai internation',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.runbail.com/dhcx?%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            31 => [
                'id' => 714,
                'name' => 'JIACHEN INTERNATIONAL',
                'slug' => 'jiachen-international',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.jiachenexpress.com/select/?num=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            32 => [
                'id' => 715,
                'name' => 'LD Express',
                'slug' => 'ld-express',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.leda-express.com/queryexpress.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            33 => [
                'id' => 716,
                'name' => 'VALUEWAY',
                'slug' => 'valueway',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.valueway.net/main.html',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            34 => [
                'id' => 718,
                'name' => 'Go Express',
                'slug' => 'go-express',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.goex.co.nz/cgi-bin/GInfo.dll?DispInfo&w=flywayex&nid=3',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            35 => [
                'id' => 722,
                'name' => 'LvSe International',
                'slug' => 'lvse-international',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.ntlsgj.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            36 => [
                'id' => 723,
                'name' => 'Speedaf Express',
                'slug' => 'speedaf-express',
                'country_id' => 45,
                'tracking_base_url' => 'https://speedaf.com/cn-cn/send-parcel',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            37 => [
                'id' => 725,
                'name' => 'YFHEX LOGISTICS',
                'slug' => 'yfhex-logistics',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.yfhex.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            38 => [
                'id' => 726,
                'name' => 'China Post E-commerce',
                'slug' => 'china-post-e-commerce',
                'country_id' => 45,
                'tracking_base_url' => 'http://wuliu.chinapost-cb.com/enquiry/cx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            39 => [
                'id' => 728,
                'name' => 'Xun Tian International',
                'slug' => 'xun-tian-international',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.uniment.net/itdida-flash/uniment/waybill-search-result/xtl',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            40 => [
                'id' => 729,
                'name' => 'Zhongrong Tailong',
                'slug' => 'zhongrong-tailong',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.zrtl.com/search/#num',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            41 => [
                'id' => 731,
                'name' => 'SKR InterNational',
                'slug' => 'skr-international',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.skr56.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            42 => [
                'id' => 732,
                'name' => 'Yi Long Exp',
                'slug' => 'yi-long-exp',
                'country_id' => 45,
                'tracking_base_url' => 'http://open.ylexp.com/ylexp/6/d.htm',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            43 => [
                'id' => 734,
                'name' => 'Cloud mail cross border Express',
                'slug' => 'cloud-mail-cross-border-express',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.hkems.cn/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            44 => [
                'id' => 736,
                'name' => 'Youhai International Express',
                'slug' => 'youhai-international-express',
                'country_id' => 82,
                'tracking_base_url' => 'http://www.uhiexpress.com/Track/Index?trackcodes=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            45 => [
                'id' => 737,
                'name' => 'BJYTSYWL',
                'slug' => 'bjytsywl',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.bjytsywl.com/?c=article&a=wuliuinfo',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            46 => [
                'id' => 738,
                'name' => 'SLICITY',
                'slug' => 'slicity',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.yz-ex.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            47 => [
                'id' => 740,
                'name' => 'Yjs-China',
                'slug' => 'yjs-china',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.yjs-china.com/Home/QueryOrder',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            48 => [
                'id' => 741,
                'name' => 'Yadex',
                'slug' => 'yadex',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.yadex.com.cn/index/waybill?nu=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            49 => [
                'id' => 742,
                'name' => 'Qhxyyg',
                'slug' => 'qhxyyg',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.qhxyyg.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            50 => [
                'id' => 743,
                'name' => 'Armenia Post',
                'slug' => 'armenia-post',
                'country_id' => 13,
                'tracking_base_url' => 'https://www.haypost.am/am/track-trace#%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            51 => [
                'id' => 744,
                'name' => 'Azerbaijan Post',
                'slug' => 'azerbaijan-post',
                'country_id' => 17,
                'tracking_base_url' => 'http://www.azerpost.az/az/tracking',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            52 => [
                'id' => 745,
                'name' => 'Cambodia Post',
                'slug' => 'cambodia-post',
                'country_id' => 38,
                'tracking_base_url' => 'https://www.cambodiapost.com.kh/global-track',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            53 => [
                'id' => 746,
                'name' => 'Namibia Post',
                'slug' => 'namibia-post',
                'country_id' => 149,
                'tracking_base_url' => 'https://www.nampost.com.na/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            54 => [
                'id' => 747,
                'name' => 'Matdespatch',
                'slug' => 'matdespatch',
                'country_id' => 131,
                'tracking_base_url' => 'https://matdespatch-my.delyva.app/customer/strack?trackingNo=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            55 => [
                'id' => 750,
                'name' => 'PostaPlus',
                'slug' => 'postaplus',
                'country_id' => 116,
                'tracking_base_url' => 'https://www.postaplus.com/?trackid=%number%&trackby=awb',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            56 => [
                'id' => 751,
                'name' => 'Royal Shipments',
                'slug' => 'royal-shipments',
                'country_id' => 172,
                'tracking_base_url' => 'https://royalshipments.com/tt/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            57 => [
                'id' => 752,
                'name' => 'Ninja Van Vietnam',
                'slug' => 'ninja-van-vietnam',
                'country_id' => 233,
                'tracking_base_url' => 'https://www.ninjavan.co/en-sg/tracking?id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            58 => [
                'id' => 754,
                'name' => 'Kazakhstan Post',
                'slug' => 'kazakhstan-post',
                'country_id' => 111,
                'tracking_base_url' => 'https://post.kz/services/postal/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            59 => [
                'id' => 755,
                'name' => 'Smart Delivery',
                'slug' => 'smart-delivery',
                'country_id' => 111,
                'tracking_base_url' => 'https://www.smartdelivery.kz/index.php?lang=ru#track',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            60 => [
                'id' => 756,
                'name' => 'Togo Post',
                'slug' => 'togo-post',
                'country_id' => 214,
                'tracking_base_url' => 'https://www.laposte.tg/suivi-envois',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            61 => [
                'id' => 764,
                'name' => 'Pasamar',
                'slug' => 'pasamar',
                'country_id' => 48,
                'tracking_base_url' => 'https://pasamar.com.co/historial-guia/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            62 => [
                'id' => 773,
                'name' => 'FLYSMAN',
                'slug' => 'flysman',
                'country_id' => 44,
                'tracking_base_url' => 'http://www.flysman.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            63 => [
                'id' => 776,
                'name' => 'Kwai Bon',
                'slug' => 'kwai-bon',
                'country_id' => 45,
                'tracking_base_url' => 'http://oms-sz.kwaibon.com:8082/en/trackIndex.htm',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            64 => [
                'id' => 777,
                'name' => 'PTS',
                'slug' => 'pts',
                'country_id' => 219,
                'tracking_base_url' => 'https://wp.pts.net/en/track-your-parcel',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            65 => [
                'id' => 778,
                'name' => 'Sameday',
                'slug' => 'sameday',
                'country_id' => 178,
                'tracking_base_url' => 'https://sameday.ro/?lang=en#awb=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            66 => [
                'id' => 779,
                'name' => 'UniUni',
                'slug' => 'uniuni',
                'country_id' => 2,
                'tracking_base_url' => 'https://www.uniuni.com/tracking/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            67 => [
                'id' => 780,
                'name' => 'Leopard Courier',
                'slug' => 'leopard-courier',
                'country_id' => 164,
                'tracking_base_url' => 'https://www.leopardscourier.com/leopards-tracking',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            68 => [
                'id' => 783,
                'name' => 'FUJIE Express',
                'slug' => 'fujie-express',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.fujexp.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            69 => [
                'id' => 784,
                'name' => 'GTA GSM',
                'slug' => 'gta-gsm',
                'country_id' => 2,
                'tracking_base_url' => 'https://tracking.gtagsm.com/Tracking/Details/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            70 => [
                'id' => 786,
                'name' => 'Sequoia Logistica',
                'slug' => 'sequoia-logistica',
                'country_id' => 32,
                'tracking_base_url' => 'https://rastreio.frenet.com.br/SEQ/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            71 => [
                'id' => 787,
                'name' => 'Geis Poland',
                'slug' => 'geis-poland',
                'country_id' => 172,
                'tracking_base_url' => 'https://www.geis.pl/en/detail-of-cargo?packNumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            72 => [
                'id' => 788,
                'name' => 'YTO Express',
                'slug' => 'yto-express',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.yto.net.cn/tracesimple.html/?orders=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            73 => [
                'id' => 790,
                'name' => 'TAS COURIER',
                'slug' => 'tas-courier',
                'country_id' => 85,
                'tracking_base_url' => 'https://www.tascourier.gr/track?v=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            74 => [
                'id' => 791,
                'name' => 'Anjun',
                'slug' => 'anjun',
                'country_id' => 45,
                'tracking_base_url' => 'https://pu.anjuntrack.com/trackQuery?t=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            75 => [
                'id' => 794,
                'name' => 'Intertown Transport',
                'slug' => 'intertown-transport',
                'country_id' => 197,
                'tracking_base_url' => 'https://www.intertown.co.za/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            76 => [
                'id' => 796,
                'name' => 'CTT Express Spain',
                'slug' => 'ctt-express-spain',
                'country_id' => 199,
                'tracking_base_url' => 'https://www.cttexpress.com/localizador-de-envios/?sc=%number%&amp;button=Localiza+tu+env%C3%ADo',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            77 => [
                'id' => 797,
                'name' => 'GLS Serbia',
                'slug' => 'gls-serbia',
                'country_id' => 189,
                'tracking_base_url' => 'https://gls-group.com/RS/en/parcel-tracking?match=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            78 => [
                'id' => 798,
                'name' => 'Cargo Expreso',
                'slug' => 'cargo-expreso',
                'country_id' => 90,
                'tracking_base_url' => 'https://www.cargoexpreso.com/tracking/?guia=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            79 => [
                'id' => 799,
                'name' => 'Team Global Express',
                'slug' => 'team-global-express',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.myteamge.com/web/guest/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            80 => [
                'id' => 800,
                'name' => 'FleetOptics',
                'slug' => 'fleetoptics',
                'country_id' => 2,
                'tracking_base_url' => 'https://fleetopticsinc.ca/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            81 => [
                'id' => 801,
                'name' => 'Shopee Xpress',
                'slug' => 'shopeexpress',
                'country_id' => 213,
                'tracking_base_url' => 'https://spx.co.th/detail/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            82 => [
                'id' => 803,
                'name' => 'InPost',
                'slug' => 'inpost',
                'country_id' => 106,
                'tracking_base_url' => 'https://inpost.it/trova-il-tuo-pacco?number=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            83 => [
                'id' => 804,
                'name' => 'YDM',
                'slug' => 'ydm',
                'country_id' => 105,
                'tracking_base_url' => 'https://connect.datalogics.co.il/shipping/ydm3/?shipment_id=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            84 => [
                'id' => 805,
                'name' => 'TIMISC',
                'slug' => 'timisc',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.timisc.com/track.htm',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            85 => [
                'id' => 807,
                'name' => 'Mahavir',
                'slug' => 'mahavir',
                'country_id' => 100,
                'tracking_base_url' => 'http://www.shreemahavircourier.com/index.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            86 => [
                'id' => 808,
                'name' => 'DPD Switzerland',
                'slug' => 'dpd-switzerland',
                'country_id' => 208,
                'tracking_base_url' => 'https://tracking.dpd.de/status/de_CH/parcel/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            87 => [
                'id' => 809,
                'name' => 'SFYD Express',
                'slug' => 'sfyd-express',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.sfydexpress.com/track.html?c=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            88 => [
                'id' => 810,
                'name' => 'ED Post',
                'slug' => 'ed-post',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.666post.com/track',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            89 => [
                'id' => 811,
                'name' => 'XYS Logistics',
                'slug' => 'xys-logistics',
                'country_id' => 45,
                'tracking_base_url' => 'http://xyslogistics.com/track.html?c=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            90 => [
                'id' => 812,
                'name' => 'AJEX',
                'slug' => 'ajex',
                'country_id' => 45,
                'tracking_base_url' => 'https://www.aj-ex.com.cn/tracking?tracking_number=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            91 => [
                'id' => 814,
                'name' => 'Road Logistics',
                'slug' => 'roadlogistics',
                'country_id' => 187,
                'tracking_base_url' => 'https://my.road-logistics.com/track',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            92 => [
                'id' => 815,
                'name' => 'Call Courier',
                'slug' => 'call-courier',
                'country_id' => 164,
                'tracking_base_url' => 'https://callcourier.com.pk/tracking/?tc=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            93 => [
                'id' => 816,
                'name' => 'Swyft Logistics',
                'slug' => 'swyftlogistics',
                'country_id' => 164,
                'tracking_base_url' => 'https://parceltracking.swyftlogistics.com/?%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            94 => [
                'id' => 817,
                'name' => 'GLS Czech',
                'slug' => 'gls-czech',
                'country_id' => 56,
                'tracking_base_url' => 'https://gls-group.eu/CZ/cs/sledovani-zasilek/?match=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            95 => [
                'id' => 818,
                'name' => 'EcoScooting',
                'slug' => 'ecoscooting',
                'country_id' => 199,
                'tracking_base_url' => 'https://www.ecoscooting.com/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            96 => [
                'id' => 819,
                'name' => 'JPS',
                'slug' => 'jps',
                'country_id' => 45,
                'tracking_base_url' => 'http://jpsgjwl.com/search_order.aspx?trackNumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            97 => [
                'id' => 820,
                'name' => 'UPS France',
                'slug' => 'ups-france',
                'country_id' => 74,
                'tracking_base_url' => 'https://www.ups.com/track?loc=fr_FR&requester=QUIC&tracknum=%number%/trackdetails',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            98 => [
                'id' => 826,
                'name' => 'Danske Fragtmænd',
                'slug' => 'danske-fragtmænd',
                'country_id' => 58,
                'tracking_base_url' => 'https://trace.fragt.dk/#/trackTrace/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            99 => [
                'id' => 828,
                'name' => 'Sameday Hungary',
                'slug' => 'sameday-hungary',
                'country_id' => 98,
                'tracking_base_url' => 'https://sameday.hu/?lang=en#awb=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            100 => [
                'id' => 832,
                'name' => 'PACKS',
                'slug' => 'packs',
                'country_id' => 152,
                'tracking_base_url' => 'https://www.packs.nl/track-trace/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            101 => [
                'id' => 833,
                'name' => 'Sunson',
                'slug' => 'sunson',
                'country_id' => 45,
                'tracking_base_url' => 'http://111.230.206.59:8082/trackIndex.htm',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            102 => [
                'id' => 834,
                'name' => 'BGY',
                'slug' => 'bgy',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.bgygyl.com/track.aspx',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            103 => [
                'id' => 835,
                'name' => 'Orlen paczka',
                'slug' => 'orlen-paczka',
                'country_id' => 172,
                'tracking_base_url' => 'https://www.orlenpaczka.pl/sledz-paczke/?numer=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            104 => [
                'id' => 836,
                'name' => 'Itella',
                'slug' => 'itella',
                'country_id' => 68,
                'tracking_base_url' => 'https://itella.ee/en/private-customer/parcel-tracking/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            105 => [
                'id' => 839,
                'name' => 'LICCARDI EXPRESS',
                'slug' => 'liccardi-express',
                'country_id' => 106,
                'tracking_base_url' => 'https://my.liccarditrasporti.com/segui',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            106 => [
                'id' => 840,
                'name' => 'BOX NOW',
                'slug' => 'box-now',
                'country_id' => 85,
                'tracking_base_url' => 'https://boxnow.gr/?track=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            107 => [
                'id' => 841,
                'name' => 'Mark Express',
                'slug' => 'mark-express',
                'country_id' => 100,
                'tracking_base_url' => 'https://markexpress.co.in/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            108 => [
                'id' => 842,
                'name' => 'Taxydema',
                'slug' => 'taxydema',
                'country_id' => 85,
                'tracking_base_url' => 'https://taxydema.gr/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            109 => [
                'id' => 843,
                'name' => 'Pullman Cargo',
                'slug' => 'pullman-cargo',
                'country_id' => 44,
                'tracking_base_url' => 'https://www.pullmango.cl/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            110 => [
                'id' => 844,
                'name' => 'Followmont Transport',
                'slug' => 'followmont-transport',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.followmont.com.au/?page=fmt_template&fmt_template=track-trace&track-trace=track-trace-start-unsecured-user',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            111 => [
                'id' => 846,
                'name' => 'Northline',
                'slug' => 'northline',
                'country_id' => 15,
                'tracking_base_url' => 'https://www.northline.com.au/',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            112 => [
                'id' => 847,
                'name' => 'PostNord Sweden',
                'slug' => 'postNord-sweden',
                'country_id' => 207,
                'tracking_base_url' => 'https://www.postnord.se/vara-verktyg/spara-brev-paket-och-pall/?shipmentId=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            113 => [
                'id' => 848,
                'name' => 'Fan Courier',
                'slug' => 'fan-courier',
                'country_id' => 178,
                'tracking_base_url' => 'https://www.fancourier.ro/awb-tracking/?tracking=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            114 => [
                'id' => 849,
                'name' => 'Team Global Express NZ',
                'slug' => 'team-global-express-nz',
                'country_id' => 155,
                'tracking_base_url' => 'https://fasttracker.teamglobalexp.co.nz/fast-tracker.aspx?fasttracker_action=findmostrecent&ConsignmentNumber=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            115 => [
                'id' => 850,
                'name' => 'PostEx',
                'slug' => 'postex',
                'country_id' => 164,
                'tracking_base_url' => 'https://merchant.postex.pk/?cn=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            116 => [
                'id' => 851,
                'name' => 'Jiayou',
                'slug' => 'jiayou',
                'country_id' => 45,
                'tracking_base_url' => 'http://www.jiayouexp.com/inquire.html?key=%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            117 => [
                'id' => 853,
                'name' => 'DPD Estonia',
                'slug' => 'dpd-et',
                'country_id' => 68,
                'tracking_base_url' => 'https://tracking.dpd.de/status/et_EE/parcel/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
            118 => [
                'id' => 855,
                'name' => 'Quiken',
                'slug' => 'quiken',
                'country_id' => 140,
                'tracking_base_url' => 'https://quiken.mx/rastreo/%number%',
                'tracking_url_method' => 'Get',
                'status' => 'Active',
                'created_at' => null,
                'updated_at' => null,
            ],
        ]);

        \DB::statement('SET FOREIGN_KEY_CHECKS=1;');

    }
}
