<?php

namespace Modules\ResetDb\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Artisan;
use Illuminate\Support\Facades\DB;
use Modules\ResetDb\Http\Requests\DbResetRequest;

class ResetDbController extends Controller
{
    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function reset()
    {
        return view('resetdb::reset');
    }

    /**
     * Store a newly created resource in storage.
     * @param Request $request
     * @return Renderable
     */
    public function store(DbResetRequest $request)
    {
        try {
            DB::beginTransaction();

            Artisan::call('app:install --dummydata=false');

            DB::commit();
            $response = $this->messageArray(__('The :x has been successfully completed.', ['x' => __('Database Reset')]), 'success');
        } catch (\Exception $e) {

            DB::rollBack();
            $response = $this->messageArray( 'Fail: ' . $e->getMessage(), 'fail');
        }

        $this->setSessionValue($response);
        return redirect()->back();
    }
}
