@extends('admin.layouts.app')
@section('page_title', __('DB Reset'))
@section('content')
    <div>
        <div class="card min-h-100">
            <div class="card-header">
                <div class="d-flex justify-content-between">
                    <h5>{{ __('Database Reset') }}</h5>
                </div>
            </div>
            <div class="card-body row">
                <div class="col-sm-3"></div>
                <div class="col-sm-6">
                    <div class="mt-5">
                        <form action="{{ route('db.store') }}" class="form-horizontal from-class-id" id="password-form"
                            method="POST" enctype="multipart/form-data">
                            @csrf
                            <div class="form-group">
                                <label class="col-sm-12 text-left col-form-label">
                                    {{ __('To confirm, type "reset" below.') }}</label>
                                <div class="col-sm-12">
                                    <div class="custom-file position-relative">
                                        <input type="text" class="form-control inputFieldDesign" id="confirm"
                                            name="confirm_text" placeholder="{{ __('Type "reset"') }}" required
                                            oninvalid="this.setCustomValidity('{{ __('This field is required.') }}')">
                                        <small id="emailHelp" class="form-text text-muted">It will take some seconds to
                                            reset the database. Please wait until the process is completed.</small>
                                    </div>
                                </div>
                            </div>
                            <div class="alert alert-warning" role="alert">
                                <p style="color:red">
                                    <strong>
                                        {{ __('This action will delete all data from your database. This action cannot be undone') }}!</strong>
                                </p>
                                <p>
                                    <strong>{{ __('Note') }}:</strong>
                                    {{ __('This action will not delete your uploaded files.') }}
                                </p>
                            </div>
                            <div class="alert alert-secondary" role="alert">
                                After reset, you need to use the following credentials to login:
                                <br>
                                <code><strong>Username:</strong> admin@techvill.net</code>
                                <br>
                                <code><strong>Password:</strong> 123456</code>
                            </div>
                            <div class="col-sm-12 px-0 m-l-10 mt-3 pr-0 d-flex justify-content-end">
                                <button class="btn btn-danger" type="submit">{{ __('Reset Database') }}</button>
                            </div>
                        </form>
                    </div>
                </div>
                <div class="col-sm-3"></div>
            </div>
        </div>
    </div>
@endsection

@section('js')
    <script src="{{ asset('public/dist/js/custom/validation.min.js') }}"></script>
@endsection
