<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Route;
use Modules\ResetDb\Http\Controllers\ResetDbController;

Route::prefix('admin/db/')->middleware(['auth', 'locale', 'permission', 'web'])->name('db.')->group(function () {
    Route::get('reset', [ResetDbController::class, 'reset'])->name('reset');
    Route::post('store', [ResetDbController::class, 'store'])->name('store')->middleware(['checkForDemoMode']);
});
