<?php

return [
    'name' => 'Hubtel',

    'alias' => 'hubtel',

    'logo' => 'Modules/Hubtel/Resources/assets/hubtel.jpg',

    // Hubtel addon settings

    'options' => [
        ['label' => __('Settings'), 'type' => 'modal', 'url' => 'hubtel.edit'],
        ['label' => __('Hubtel Documentation'), 'target' => '_blank', 'url' => 'https://developers.hubtel.com/'],
    ],

    /**
     * Hubtel data validation
     */
    'validation' => [
        'rules' => [
            'apiId' => 'required',
            'apiKey' => 'required',
            'merchantId' => 'required',
            'status' => '',
        ],
        'attributes' => [
            'apiId' => __('API ID'),
            'apiKey' => __('API KEY'),
            'merchantId' => __('Merchant Account Number'),
            'status' => __('Status'),
        ],
    ],
    'fields' => [
        'apiId' => [
            'label' => __('API ID'),
            'type' => 'text',
            'required' => true,
        ],
        'apiKey' => [
            'label' => __('API KEY'),
            'type' => 'text',
            'required' => true,
        ],
        'merchantId' => [
            'label' => __('Merchant Account Number'),
            'type' => 'text',
            'required' => true,
        ],
        'instruction' => [
            'label' => __('Instruction'),
            'type' => 'textarea',
        ],
        'status' => [
            'label' => __('Status'),
            'type' => 'select',
            'required' => true,
            'options' => [
                'Active' => 1,
                'Inactive' => 0,
            ],
        ],
    ],

    'store_route' => 'hubtel.store',
];
