<?php

namespace Modules\Hubtel\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Modules\Addons\Entities\Addon;
use Modules\Hubtel\Entities\Hubtel;
use Modules\Hubtel\Entities\HubtelBody;
use Modules\Hubtel\Http\Requests\HubtelRequest;

class HubtelController extends Controller
{
    /**
     * Returns form for the edit modal
     *
     * @param \Illuminate\Http\Request
     * @return JsonResponse
     */
    public function edit(Request $request)
    {
        try {
            $module = Hubtel::first()->data;
        } catch (\Exception $e) {
            $module = null;
        }
        $addon = Addon::findOrFail('hubtel');

        return response()->json(
            [
                'html' => view('gateway::partial.form', compact('module', 'addon'))->render(),
                'status' => true,
            ],
            200
        );
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return mixed
     */
    public function store(HubtelRequest $request)
    {
        $hubtelBody = new HubtelBody($request);
        Hubtel::updateOrCreate(
            ['alias' => 'hubtel'],
            [
                'name' => 'Hubtel',
                'instruction' => $request->instruction,
                'status' => $request->status,
                'image' => 'thumbnail.png',
                'data' => json_encode($hubtelBody),
            ]
        );

        return back()->with(['AddonStatus' => 'success', 'AddonMessage' => __('Hubtel settings updated.')]);
    }
}
