<?php

namespace Modules\Hubtel\Response;

use Modules\Gateway\Contracts\HasDataResponseInterface;
use Modules\Gateway\Response\Response;

class HubtelResponse extends Response implements HasDataResponseInterface
{
    protected $response;

    private $data;

    /**
     * Constructor of the response
     *
     * @param  object  $data (Order data object)
     * @param  object  $response (Payment response)
     */
    public function __construct($data, $response)
    {
        $this->data = $data;
        $this->response = $response;
        $this->updateStatus();

        return $this;
    }

    /**
     * Get Raw Response
     */
    public function getRawResponse(): string
    {
        return json_encode($this->response);
    }

    /**
     * Update Payment Status
     *
     * @return void
     */
    protected function updateStatus()
    {
        $this->setPaymentStatus('pending');
    }

    /**
     * Get Response
     */
    public function getResponse(): string
    {
        return json_encode($this->getSimpleResponse());
    }

    /**
     * Get Simple Response
     *
     * @return array
     */
    private function getSimpleResponse()
    {
        return [
            'amount' => $this->data->total,
            'amount_captured' => $this->data->total,
            'currency' => $this->data->cur,
            'code' => $this->data->code,
        ];
    }

    /**
     * Get Gateway
     */
    public function getGateway(): string
    {
        return 'Hubtel';
    }

    /**
     * Set Payment Status
     *
     * @param  string  $status
     * @return void
     */
    protected function setPaymentStatus($status)
    {
        $this->status = $status;
    }
}
