<?php

namespace Modules\Hubtel\Views;

use Modules\Gateway\Contracts\PaymentViewInterface;
use Modules\Gateway\Services\GatewayHelper;
use Modules\Gateway\Traits\ApiResponse;
use Modules\Hubtel\Entities\Hubtel;

class HubtelView implements PaymentViewInterface
{
    use ApiResponse;

    /**
     * Payment view
     *
     * @param  string  $key
     * @return view|redirectResponse
     */
    public static function paymentView($key)
    {
        $helper = GatewayHelper::getInstance();

        try {
            $hubtel = Hubtel::firstWhere('alias', 'hubtel')->data;

            return view('hubtel::pay', [
                'merchantId' => $hubtel->merchantId,
                'apiId' => $hubtel->apiId,
                'apiKey' => $hubtel->apiKey,
                'instruction' => $hubtel->instruction,
                'purchaseData' => $helper->getPurchaseData($key),
            ]);
        } catch (\Exception $e) {
            return back()->withErrors(['error' => __('This payment gateway is not available at this moment')]);
        }
    }
}
