<?php

return [
    'name' => 'AirtelAfrica',
    'alias' => 'airtelafrica',

    'logo' => 'Modules/AirtelAfrica/Resources/assets/airtel.png',

    // Airtel addon settings

    'options' => [
        ['label' => __('Settings'), 'type' => 'modal', 'url' => 'airtel.africa.edit'],
        ['label' => __('Airtel Africa Documentation'), 'target' => '_blank', 'url' => 'https://developers.airtel.africa/'],
    ],

    /**
     * Airtel data validation
     */
    'validation' => [
        'rules' => [
            'clientId' => 'required',
            'clientSecret' => 'required',
            'sandbox' => 'required',
        ],
        'attributes' => [
            'clientId' => __('Client ID'),
            'clientSecret' => __('Client Secret'),
            'sandbox' => __('Please specify sandbox enabled/disabled.'),
        ],
    ],
    'fields' => [
        'clientId' => [
            'label' => __('Client ID'),
            'type' => 'text',
            'required' => true,
        ],
        'clientSecret' => [
            'label' => __('Client Secret'),
            'type' => 'text',
            'required' => true,
        ],
        'instruction' => [
            'label' => __('Instruction'),
            'type' => 'textarea',
        ],
        'sandbox' => [
            'label' => __('Sandbox'),
            'type' => 'select',
            'required' => true,
            'options' => [
                'Enabled' => 1,
                'Disabled' =>  0,
            ],
        ],
        'status' => [
            'label' => __('Status'),
            'type' => 'select',
            'required' => true,
            'options' => [
                'Active' => 1,
                'Inactive' =>  0,
            ],
        ],
    ],

    'store_route' => 'airtel.africa.store',

];
