<?php

namespace Modules\AirtelAfrica\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Addons\Entities\Addon;
use Modules\AirtelAfrica\Entities\AirtelAfrica;
use Modules\AirtelAfrica\Entities\AirtelBody;
use Modules\AirtelAfrica\Http\Requests\AirtelRequest;

class AirtelAfricaController extends Controller
{
    public function store(AirtelRequest $request)
    {
        $airtelBody = new AirtelBody($request);

        AirtelAfrica::updateOrCreate(
            ['alias' => 'airtelafrica'],
            [
                'name' => 'AirtelAfrica',
                'instruction' => $request->instruction,
                'status' => $request->status,
                'sandbox' => $request->sandbox,
                'image' => 'thumbnail.png',
                'data' => json_encode($airtelBody),
            ]
        );

        return back()->with(['AddonStatus' => 'success', 'AddonMessage' => __('Airtel settings updated.')]);
    }

    /**
     * Returns form for the edit modal
     *
     * @param \Illuminate\Http\Request
     * @return JsonResponse
     */
    public function edit(Request $request)
    {
        try {
            $module = AirtelAfrica::first()->data;
        } catch (\Exception $e) {
            $module = null;
        }
        $addon = Addon::findOrFail('airtelafrica');

        return response()->json(
            [
                'html' => view('gateway::partial.form', compact('module', 'addon'))->render(),
                'status' => true,
            ],
            200
        );
    }
}
