@extends('gateway::layouts.payment')

@section('logo', asset(moduleConfig('airtelafrica.logo')))
@section('gateway', moduleConfig('airtelafrica.name'))

@section('content')
    <div class="straight-line"></div>
    @include('gateway::partial.instruction')
    @if(isset(request()->code))
        <form class="pay-form needs-validation"
              action="{{ route('gateway.complete', withOldQueryIntegrity(['gateway' => moduleConfig('airtelafrica.alias')])) }}" method="post"
              id="payment-form">
            @csrf
            <div>
                <div id="card-element">

                    @php 
                    $countries = \Modules\GeoLocale\Entities\Country::get();
                    @endphp
                    <div class="mb-3">
                        <select class="form-control select2" name="country" required>
                            <option value="">{{ __('Select Country') }}</option>
                            @foreach($countries as $country)
                                <option value="{{ $country->code }}">{{ $country->name }}</option>
                            @endforeach
                        </select>
                    </div>
                    <div class="mb-3">
                        <label for="phone" class="form-label">{{ __('Mobile Number') }}</label>
                        <input type="tel" class="form-control" id="phone" name="phone" required>
                    </div>
                </div>
                <!-- Used to display form errors -->
            </div>
            <button type="submit" class="pay-button sub-btn">{{ __('Pay Airtel') }}</button>
        </form>
    @endif
@endsection
