<?php

namespace Modules\AirtelAfrica\Response;

use Modules\Gateway\Contracts\HasDataResponseInterface;
use Modules\Gateway\Response\Response;

class AirtelResponse extends Response implements HasDataResponseInterface
{
    protected $response;

    private $data;

    public function __construct($data, $airtelResponse)
    {
        $this->data = $data;
        $this->response = $airtelResponse;
        $this->updateStatus();

        return $this;
    }

    public function getRawResponse(): string
    {
        return json_encode($this->response);
    }

    protected function updateStatus()
    {
        if ($this->response['status']['success']) {
            $this->setPaymentStatus('completed');
        } else {
            $this->setPaymentStatus('failed');
        }
    }

    public function getResponse(): string
    {
        return json_encode($this->getSimpleResponse());
    }

    private function getSimpleResponse()
    {
        return [
            'amount' => $this->data['total'],
            'amount_captured' => $this->data['total'],
            'currency' => $this->data['currency_code'],
            'code' => $this->data->code,
        ];
    }

    public function getGateway(): string
    {
        return 'AirtelAfrica';
    }

    protected function setPaymentStatus($status)
    {
        $this->status = $status;
    }
}
