<?php

namespace Modules\AirtelAfrica\Views;

use Modules\AirtelAfrica\Entities\AirtelAfrica;
use Modules\Gateway\Contracts\PaymentViewInterface;
use Modules\Gateway\Services\GatewayHelper;
use Modules\Gateway\Traits\ApiResponse;

class AirtelAfricaView implements PaymentViewInterface
{
    use ApiResponse;

    public static function paymentView($key)
    {
        $helper = GatewayHelper::getInstance();

        try {
            $airtel = AirtelAfrica::firstWhere('alias', 'airtelafrica')->data;

            return view('airtelafrica::pay', [
                'clientId' => $airtel->clientId,
                'instruction' => $airtel->instruction,
                'purchaseData' => $helper->getPurchaseData($key),
            ]);
        } catch (\Exception $e) {
            return back()->withErrors(['error' => __('Purchase data not found.')]);
        }
    }

    public static function paymentResponse($key)
    {
        $helper = GatewayHelper::getInstance();

        $airtel = AirtelAfrica::firstWhere('alias', 'airtelafrica')->data;

        return [
            'clientId' => $airtel->clientId,
            'instruction' => $airtel->instruction,
            'purchaseData' => $helper->getPurchaseData($key),
        ];
    }
}
