<?php

namespace Modules\BulkSmsBd\Http\Controllers;

use App\Models\SmsGateway;
use App\Services\SmsService;
use Illuminate\Routing\Controller;

use Modules\BulkSmsBd\Http\Requests\BulkSmsBdUpdateRequest;
use Illuminate\Foundation\Http\FormRequest;

class BulkSmsBdController extends Controller
{
     /**
     * Constructor
     */
    public function __construct(private SmsService $service)
    {
        //Sms Service
    }

    /**
     * Display the Bulksmsbd configuration view.
     *
     * @return \Illuminate\Contracts\View\View
     */
    public function bulksmsbd()
    {
        return view('bulksmsbd::bulksmsbd-config', [
            'gateway' => SmsGateway::firstWhere('alias', 'bulksmsbd'),
        ]);
    }

    /**
     * Store or update the Bulksmsbd configuration.
     *
     *
     * @return \Illuminate\Http\RedirectResponse
     */
    public function storeBulkSmsBd(BulkSmsBdUpdateRequest $request)
    {
        return $this->storeOrUpdateProvider($request, 'bulksmsbd', 'BulkSmsBd');
    }

    /**
     * Store or update the SMS provider configuration.
     *
     * @param  \App\Services\SmsService  $service
     * @param  string  $providerName
     * @param  string  $displayName
     * @return \Illuminate\Http\RedirectResponse
     */
    private function storeOrUpdateProvider(FormRequest $request, $providerName, $displayName)
    {
        $response = $this->service->store($request->validated(), $providerName, $displayName);

        if ($response) {
            $this->service->setDefaultProvider($providerName, $request->is_default);

            return redirect()->back()->withSuccess(__('The SMS provider successfully saved.'));
        }

        return redirect()->back()->withErrors(__('Failed to save SMS provider.'));
    }
}
