<?php

namespace Modules\BulkSmsBd\Notifications\Channel;

use App\Contract\SmsInterface;
use App\Services\SmsService;

class BulkSmsBdChannel implements SmsInterface
{
    /**
     * Send the given notification.
     */
    public function send($data): void
    {
        $url = "https://bulksmsbd.net/api/smsapi";

        $credential = SmsService::getCredential('bulksmsbd');

        $api_key = $credential['api_key'];
        $senderid = $credential['senderid'];
        $number = $data['to'];
        $message = $data['message'];

        $data = [
            "api_key" => $api_key,
            "senderid" => $senderid,
            "number" => $number,
            "message" => $message
        ];
        
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $data);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
        $response = curl_exec($ch);
        curl_close($ch);

        logger($response);
    }
}
