<?php

namespace Modules\DatabaseBackup\Console;

use Illuminate\Console\Command;
use Illuminate\Support\Facades\Log;
use Modules\DatabaseBackup\Services\DatabaseBackupFailedMailService;

class DatabaseBackupCommand extends Command
{
    /**
     * The name and signature of the console command.
     *
     * @var string
     */
    protected $name = 'martvill:db-backup';

    /**
     * The console command description.
     *
     * @var string
     */
    protected $description = 'Command description.';

    /**
     * Create a new command instance.
     *
     * @return void
     */
    public function __construct()
    {
        parent::__construct();
    }

    /**
     * Execute the console command.
     *
     * @return mixed
     */
    public function handle()
    {
        $successMessage = __('Database backup completed successfully.');
        $errorMessage = __('An error occurred during the database backup');
        if (!moduleConfig('databasebackup.is_database_automated_backup')) {
            return;
        }
        
        try {
            $response = $this->call('backup:run', ['--only-db' => true, '--disable-notifications' => true]);
            if ($response === 1) {
                (new DatabaseBackupFailedMailService)->send(request());
                Log::error($errorMessage);
            } else {
                $this->info($successMessage);
                Log::info($successMessage);
            }
        } catch (\Exception $e) {
            $msg = __('An error occurred during the database backup'). ': ' . $e->getMessage();
            $this->error($msg);
            (new DatabaseBackupFailedMailService)->send(request());
            Log::error($msg);
        }
    }
}
