<?php

namespace Modules\DatabaseBackup\Http\Controllers;

use App\Lib\Env;
use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Modules\DatabaseBackup\Http\Requests\DigitalOceanSettingRequest;
use Modules\DatabaseBackup\Http\Requests\GoogleDriveSettingRequest;

class DigitalOceanSettingController extends Controller
{

    /**
     * Show the form for creating a new resource.
     * @return Renderable
     */
    public function create()
    {
        return view('databasebackup::digital_ocean_setting');
    }

    /**
     * Store a newly created resource in storage.
     * @param DigitalOceanSettingRequest $request
     * @return Renderable
     */
    public function store(DigitalOceanSettingRequest $request)
    {
        try {
            Env::set('DOB_ACCESS_KEY_ID', $request->do_access_key_id);
            Env::set('DOB_SECRET_KEY', $request->do_secret_key);
            Env::set('DOB_DEFAULT_REGION', $request->do_default_region);
            Env::set('DOB_BUCKET', $request->do_bucket);
            Env::set('DOB_ENDPOINT', $request->do_endpoint);
            Env::set('DOB_URL', $request->do_url);
            Env::set('DOB_DIRECTORY', $request->do_directory ?? '');

            $response = $this->messageArray(__('Digital Ocean setting setup successfully'), 'success');
            $this->setSessionValue($response);
            return to_route('digital_ocean_setting.create')->with($response);
        } catch (\Throwable $th) {

            $response = $this->messageArray(__('Digital Ocean setting setup Failed'), 'fail');
            return to_route('digital_ocean_setting.create')->with($response);
        }
    }
}
