<?php

namespace Modules\DatabaseBackup\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class DigitalOceanSettingRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'do_access_key_id' => 'required|string',
            'do_secret_key' => 'required|string',
            'do_default_region' => 'required|string',
            'do_bucket' => 'required|string',
            'do_endpoint' => 'required|string',
            'do_url' => 'required|string',
            'do_directory' => 'nullable|string',
        ];
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
