<?php

namespace Modules\DatabaseBackup\Providers;

use Illuminate\Support\ServiceProvider;
use Illuminate\Console\Scheduling\Schedule;
use Illuminate\Database\Eloquent\Factory;
use Spatie\Backup\BackupServiceProvider;

class DatabaseBackupServiceProvider extends ServiceProvider
{
    /**
     * @var string $moduleName
     */
    protected $moduleName = 'DatabaseBackup';

    /**
     * @var string $moduleNameLower
     */
    protected $moduleNameLower = 'DatabaseBackup';

    /**
     * Boot the application events.
     *
     * @return void
     */
    public function boot()
    {
        $this->app->register(BackupServiceProvider::class);
        
        $this->commands([
            \Modules\DatabaseBackup\Console\DatabaseBackupCommand::class,
        ]);

        $this->app->booted(function () {
            $schedule = $this->app->make(Schedule::class);
            $schedule->command('martvill:db-backup')->{moduleConfig('databasebackup.schedule_type')}();
        });
    }

    /**
     * Register the service provider.
     *
     * @return void
     */
    public function register()
    {
        require_once module_path($this->moduleName, 'vendor/autoload.php');
    }
}
