@extends('admin.layouts.app')
@section('page_title', __('Digital Ocean Settings'))
@section('css')

@endsection

@section('content')
    <!-- Main content -->
    <div class="col-sm-12" id="digital-ocean-settings-container">
        <div class="card">
            <div class="card-body row">
                <div
                    class="col-lg-3 col-12 z-index-10">
                    @include('databasebackup::includes.menu_setting')
                </div>
                <div class="col-lg-9 col-12">
                    <div class="card card-info shadow-none mb-0">
                        <div class="card-header p-t-20 border-bottom">
                            <h5>{{ __('Digital Ocean Setup') }}</h5>
                            <div class="card-header-right">

                            </div>
                        </div>
                        <form action="{{ route('digital_ocean_setting.store') }}" method="POST">
                            @csrf
                            <div class="card-body">
                                <div class="form-group row">
                                    <label class="col-sm-3 control-label require" for="do_access_key_id">
                                        {{ __('DO Access Key ID') }}
                                    </label>

                                    <div class="col-sm-9">
                                        <input type="text" name="do_access_key_id"
                                            value="{{ config('martvill.is_demo') ? 'xxxxxxxxxxxxxxxxx' : config('filesystems.disks.digital-ocean-backup.key') ?? '' }}" id="do_access_key_id"
                                            class="form-control form-height" required
                                            oninvalid="this.setCustomValidity('{{ __('This field is required.') }}')">
                                    </div>
                                </div>
                                
                                <div class="form-group row">
                                    <label class="col-sm-3 control-label require" for="do_secret_key">
                                        {{ __('DO Secret Key') }}
                                    </label>

                                    <div class="col-sm-9">
                                        <input type="text" name="do_secret_key"
                                            value="{{ config('martvill.is_demo') ? 'xxxxxxxxxxxxxxxxx' : config('filesystems.disks.digital-ocean-backup.secret') ?? '' }}" id="do_secret_key"
                                            class="form-control form-height" required
                                            oninvalid="this.setCustomValidity('{{ __('This field is required.') }}')">
                                    </div>
                                </div>
                                
                                <div class="form-group row">
                                    <label class="col-sm-3 control-label require" for="do_default_region">
                                        {{ __('DO Region Name') }}
                                    </label>

                                    <div class="col-sm-9">
                                        <input type="text" name="do_default_region"
                                            value="{{ config('martvill.is_demo') ? 'xxxxxxxxxxxxxxxxx' : config('filesystems.disks.digital-ocean-backup.region') ?? '' }}" id="do_default_region"
                                            class="form-control form-height" required
                                            oninvalid="this.setCustomValidity('{{ __('This field is required.') }}')">
                                    </div>
                                </div>
                                
                                <div class="form-group row">
                                    <label class="col-sm-3 control-label require" for="do_bucket">
                                        {{ __('DO Bucket Name') }}
                                    </label>

                                    <div class="col-sm-9">
                                        <input type="text" name="do_bucket"
                                            value="{{ config('martvill.is_demo') ? 'xxxxxxxxxxxxxxxxx' : config('filesystems.disks.digital-ocean-backup.bucket') ?? '' }}" id="do_bucket"
                                            class="form-control form-height" required
                                            oninvalid="this.setCustomValidity('{{ __('This field is required.') }}')">
                                    </div>
                                </div>
                                
                                <div class="form-group row">
                                    <label class="col-sm-3 control-label require" for="do_endpoint">
                                        {{ __('DO Endpoint') }}
                                    </label>

                                    <div class="col-sm-9">
                                        <input type="text" name="do_endpoint"
                                            value="{{ config('martvill.is_demo') ? 'xxxxxxxxxxxxxxxxx' : config('filesystems.disks.digital-ocean-backup.endpoint') ?? '' }}" id="do_endpoint"
                                            class="form-control form-height" required
                                            oninvalid="this.setCustomValidity('{{ __('This field is required.') }}')">
                                    </div>
                                </div>
                                
                                <div class="form-group row">
                                    <label class="col-sm-3 control-label require" for="do_url">
                                        {{ __('DO URL') }}
                                    </label>

                                    <div class="col-sm-9">
                                        <input type="text" name="do_url"
                                            value="{{ config('martvill.is_demo') ? 'xxxxxxxxxxxxxxxxx' : config('filesystems.disks.digital-ocean-backup.url') ?? '' }}" id="do_url"
                                            class="form-control form-height" required
                                            oninvalid="this.setCustomValidity('{{ __('This field is required.') }}')">
                                    </div>
                                </div>
                                
                                <div class="form-group row">
                                    <label class="col-sm-3 control-label require" for="do_directory">
                                        {{ __('DO Folder') }}
                                    </label>

                                    <div class="col-sm-9">
                                        <input type="text" name="do_directory"
                                            value="{{ config('martvill.is_demo') ? 'xxxxxxxxxxxxxxxxx' : config('filesystems.disks.digital-ocean-backup.root') ?? '' }}" id="do_directory"
                                            class="form-control form-height" required
                                            oninvalid="this.setCustomValidity('{{ __('This field is required.') }}')">
                                    </div>
                                </div>
                            </div>
                            
                            
                            <div class="card-footer p-0">
                                <div class="form-group row">
                                    <label for="btn_save" class="col-sm-3 control-label"></label>
                                    <div class="col-sm-12">
                                        <button type="submit"
                                            class="btn form-submit custom-btn-submit"
                                            id="footer-btn">
                                            {{ __('Save') }}
                                        </button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('js')
<script src="{{ asset('public/dist/js/custom/validation.min.js') }}"></script>
@endsection
