@extends('admin.layouts.app')
@section('page_title', __('Backup List'))
@section('content')
    <!-- Main content -->
    <div class="col-sm-12 list-container hide-row-per-page" id="database-backup-list-container">
        <div class="card">
            <div class="card-header bb-none pb-3">
                <h5>{{ __('Manual Backups') }}</h5>
                <div class="card-header-right">
                    <a  href="{{ route('database.manual.backup.store') }}" class="btn btn-outline-primary custom-btn-small mb-0 collapsed filterbtn me-0"
                        aria-controls="filterPanel"><span class="fas fa-hdd me-1"></span>{{ __('Manual Backup') }}</a>
                    <a  href="{{ route('database.automated.backup') }}" class="btn btn-outline-primary custom-btn-small mb-0 collapsed filterbtn me-0 ms-2"
                        aria-controls="filterPanel"><span class="fas fa-cog neg-transition-scale"></span> {{ __('Setting') }}</a>
                </div>
            </div>
            <div class="card-body p-0">
                <div class="card-block pt-2 px-2">
                    <div class="col-sm-12 form-tabs px-3">
                        @include('admin.layouts.includes.yajra-data-table')
                    </div>
                </div>
            </div>
        </div>
    </div>
    @include('admin.layouts.includes.delete-modal')
@endsection

@section('js')
    <script src="{{ asset('public/dist/js/custom/yajra-export.min.js') }}"></script>
@endsection
