<?php

namespace Modules\DatabaseBackup\Services;

use App\Models\User;
use App\Services\Mail\TechVillageMail;

class DatabaseBackupFailedMailService extends TechVillageMail
{
    /**
     * Send mail to vendor
     *
     * @param  object  $data
     * @return array $response
     */
    public function send($request)
    {
        $email = $this->getTemplate(preference('dflt_lang'), 'database-backup-failed');
        
        if (! $email['status']) {
            return $email;
        }

        // Replacing template variable
        $subject = str_replace('{company_name}', preference('company_name'), $email->subject);
        $user = User::first();
        
        $data = [
            '{logo}' => $this->logo,
            '{company_name}' => preference('company_name'),
            '{user_name}' => $user->name,
        ];

        $message = str_replace(array_keys($data), $data, $email->body);
        
        return $this->email->sendEmail($user->email, $subject, $message, null, preference('company_name'));
    }
}
