<?php

namespace Modules\Leads\Database\Seeders\versions\v_2_6_0;

use Illuminate\Database\Seeder;
use Modules\MenuBuilder\Http\Models\MenuItems;

class MenuItemsTableSeeder extends Seeder
{
    public function run()
    {

        $data = MenuItems::where('label', 'Leads')->where('menu', 1)->first();

        if (empty($data)) {
            $menuId = MenuItems::insertGetId([
                'label' => 'Leads',
                'link' => null,
                'params' => '',
                'is_default' => 0,
                'icon' => 'feather icon-phone',
                'parent' => 0,
                'sort' => 35,
                'class' => null,
                'menu' => 1,
                'depth' => 0,
                'is_custom_menu' => 0,
            ]);

            \DB::table('menu_items')->insert([
                0 => [
                    'label' => 'Leads',
                    'link' => 'leads',
                    'params' => '{"permission":"Modules\\\\Leads\\\\Http\\\\Controllers\\\\LeadsController@index","route_name":["admin.leads.index", "admin.leads.create", "admin.leads.edit"],"menu_level":"2"}',
                    'is_default' => 1,
                    'icon' => null,
                    'parent' => $menuId,
                    'sort' => 1,
                    'class' => null,
                    'menu' => 1,
                    'depth' => 1,
                    'is_custom_menu' => 0,
                ],
                1 => [
                    'label' => 'Settings',
                    'link' => 'leads/settings',
                    'params' => '{"permission":"Modules\\\\Leads\\\\Http\\\\Controllers\\\\LeadStatusController@index","route_name":["admin.leads.settings"],"menu_level":"2"}',
                    'is_default' => 1,
                    'icon' => null,
                    'parent' => $menuId,
                    'sort' => 2,
                    'class' => null,
                    'menu' => 1,
                    'depth' => 1,
                    'is_custom_menu' => 0,
                ],
            ]);
        }
    }
}
