<?php

namespace Modules\Leads\Database\Seeders\versions\v_2_6_0;

use App\Models\Permission;
use App\Models\PermissionRole;
use Illuminate\Database\Seeder;

class PermissionsTableSeeder extends Seeder
{
    public function run()
    {
        $permission = Permission::where('controller_name', 'LeadsController')->first();

        if (empty($permission)) {
            $permissionId = Permission::insertGetId([
                'name' => 'Modules\\Leads\\Http\\Controllers\\LeadsController@index',
                'controller_path' => 'Modules\\Leads\\Http\\Controllers\\LeadsController',
                'controller_name' => 'LeadsController',
                'method_name' => 'index',
            ]);

            PermissionRole::insert([
                'permission_id' => $permissionId,
                'role_id' => 1,
            ]);

            $permissionId = Permission::insertGetId([
                'name' => 'Modules\\Leads\\Http\\Controllers\\LeadsController@create',
                'controller_path' => 'Modules\\Leads\\Http\\Controllers\\LeadsController',
                'controller_name' => 'LeadsController',
                'method_name' => 'create',
            ]);

            PermissionRole::insert([
                'permission_id' => $permissionId,
                'role_id' => 1,
            ]);

            $permissionId = Permission::insertGetId([
                'name' => 'Modules\\Leads\\Http\\Controllers\\LeadsController@store',
                'controller_path' => 'Modules\\Leads\\Http\\Controllers\\LeadsController',
                'controller_name' => 'LeadsController',
                'method_name' => 'store',
            ]);

            PermissionRole::insert([
                'permission_id' => $permissionId,
                'role_id' => 1,
            ]);

            $permissionId = Permission::insertGetId([
                'name' => 'Modules\\Leads\\Http\\Controllers\\LeadsController@edit',
                'controller_path' => 'Modules\\Leads\\Http\\Controllers\\LeadsController',
                'controller_name' => 'LeadsController',
                'method_name' => 'edit',
            ]);

            PermissionRole::insert([
                'permission_id' => $permissionId,
                'role_id' => 1,
            ]);

            $permissionId = Permission::insertGetId([
                'name' => 'Modules\\Leads\\Http\\Controllers\\LeadsController@update',
                'controller_path' => 'Modules\\Leads\\Http\\Controllers\\LeadsController',
                'controller_name' => 'LeadsController',
                'method_name' => 'update',
            ]);

            PermissionRole::insert([
                'permission_id' => $permissionId,
                'role_id' => 1,
            ]);

            $permissionId = Permission::insertGetId([
                'name' => 'Modules\\Leads\\Http\\Controllers\\LeadsController@destroy',
                'controller_path' => 'Modules\\Leads\\Http\\Controllers\\LeadsController',
                'controller_name' => 'LeadsController',
                'method_name' => 'destroy',
            ]);

            PermissionRole::insert([
                'permission_id' => $permissionId,
                'role_id' => 1,
            ]);
        }
    }
}
