<?php

namespace Modules\Leads\Entities;

use App\Traits\ModelTrait;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Model;

class Lead extends Model
{
    use ModelTrait;

    protected $fillable = ['lead_status_id', 'lead_source_id', 'user_id', 'contact_date', 'first_name', 'last_name', 'email', 'phone', 'website', 'company', 'description', 'street', 'city', 'state', 'zip', 'country', 'tags'];

    public function user()
    {
        return $this->belongsTo('App\Models\User', 'user_id');
    }

    public function leadStatus()
    {
        return $this->belongsTo('Modules\Leads\Entities\LeadStatus', 'lead_status_id');
    }

    public function leadSource()
    {
        return $this->belongsTo('Modules\Leads\Entities\leadSource', 'lead_source_id');
    }

    protected function tags(): Attribute
    {
        return Attribute::make(
            get: fn ($value) => json_decode($value, true),
            set: fn ($value) => ! is_null($value) ? json_encode($value) : null,
        );
    }

    public static function store($request)
    {
        if (parent::create($request)) {

            return true;
        }

        return false;
    }

    /**
     * remove
     *
     * @param  null  $id
     * @return array
     */
    public static function remove($id = null)
    {
        $info = parent::find($id);

        if (! empty($info)) {
            $info->delete();

            return ['status' => true, 'msg' => __('The :x has been successfully deleted.', ['x' => __('Lead')])];
        }

        return ['status' => false, 'msg' => __('The :x can not be deleted, please try again.', ['x' => __('Lead')])];
    }

    /**
     * Update
     *
     * @return bool
     */
    public static function leadUpdate($data, $id)
    {
        if (parent::where('id', $id)->update($data)) {

            return true;
        }

        return false;
    }
}
