<?php

namespace Modules\Leads\Entities;

use App\Traits\ModelTrait;
use Illuminate\Database\Eloquent\Model;

class LeadStatus extends Model
{
    use ModelTrait;

    protected $fillable = ['name', 'color', 'status'];

    public static function store($request)
    {
        if (parent::create($request)) {
            self::forgetCache();

            return true;
        }

        return false;
    }

    /**
     * Status remove
     *
     * @param  null  $id
     * @return array
     */
    public static function remove($id = null)
    {
        $info = parent::find($id);

        if (! empty($info)) {
            $info->delete();
            self::forgetCache();

            return ['status' => true, 'msg' => __('The :x has been successfully deleted.', ['x' => __('Status')])];
        }

        return ['status' => false, 'msg' => __('The :x can not be deleted, please try again.', ['x' => __('Status')])];
    }

    /**
     * Status Update
     *
     * @return bool
     */
    public static function statusUpdate($data, $id)
    {
        if (parent::where('id', $id)->update($data)) {
            self::forgetCache();

            return true;
        }

        return false;
    }
}
