<?php

namespace Modules\Leads\Filters;

use App\Filters\Filter;

class LeadFilter extends Filter
{
    /**
     * set the rules of query string
     *
     * @var array
     */
    protected $filterRules = [
        'lead_status_id' => 'required',
        'lead_source_id' => 'required',
        'user_id' => 'required',
    ];

    /**
     * filter source  query string
     *
     * @param  string  $status
     * @return query builder
     */
    public function leadStatusId($value)
    {
        return $this->query->where('lead_status_id', $value);
    }

    /**
     * group filter
     *
     * @return mixed
     */
    public function status($value)
    {
        return $this->query->WhereHas('leadStatus', function ($q) use ($value) {
            $q->whereLike('name', $value);
        });
    }

    /**
     * filter status  query string
     *
     * @param  string  $status
     * @return query builder
     */
    public function leadSourceId($value)
    {
        return $this->query->where('lead_source_id', $value);
    }

    /**
     * filter user  query string
     *
     * @param  string  $status
     * @return query builder
     */
    public function userId($value)
    {
        return $this->query->WhereHas('user', function ($q) use ($value) {
            $q->whereLike('id', $value);
        });
    }

    /**
     * filter by search query string
     *
     * @param  string  $value
     * @return query builder
     */
    public function search($value)
    {
        $value = xss_clean($value['value']);
        if (! empty($value)) {
            return $this->query->where(function ($query) use ($value) {
                $query->WhereLike('first_name', $value)
                    ->orWhereHas('user', function ($q) use ($value) {
                        $q->whereLike('name', $value);
                    })
                    ->orWhereHas('leadStatus', function ($q) use ($value) {
                        $q->whereLike('name', $value);
                    })
                    ->orWhereHas('leadSource', function ($q) use ($value) {
                        $q->whereLike('name', $value);
                    })
                    ->orWhereLike('company', $value);
            });
        }
    }
}
