<?php

namespace Modules\Leads\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Routing\Controller;
use Modules\Leads\Entities\LeadSource;
use Modules\Leads\Http\Requests\LeadSourceRequest;

class LeadSourceController extends Controller
{
    /**
     * Store a newly created resource in storage.
     *
     * @return Renderable
     */
    public function store(LeadSourceRequest $request)
    {
        if (LeadSource::store($request->all())) {
            return redirect()->back()->with('sub_menu', 'source')->withSuccess(__('The :x has been successfully saved.', ['x' => __('Source')]));
        }

        return redirect()->back()->with('sub_menu', 'status')->withErrors(__('Something went wrong, please try again.'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data = LeadSource::getAll()->where('id', $id)->first();

        return response()->json([
            'status' => 1,
            'records' =>  $data,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return Renderable
     */
    public function update(LeadSourceRequest $request, $id)
    {
        $response = LeadSource::sourceUpdate($request->except('_token', '_method'), $id);

        if ($response) {

            return redirect()->back()->with('sub_menu', 'source')->withSuccess(__('The :x has been successfully saved.', ['x' => __('Source')]));
        }

        return redirect()->back()->with('sub_menu', 'status')->withErrors(__('Something went wrong, please try again.'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $status = LeadSource::remove($id);

        if ($status['status']) {
            return redirect()->back()->with('sub_menu', 'source')->withSuccess($status['msg']);
        }

        return redirect()->back()->with('sub_menu', 'rule')->withErrors($status['msg']);
    }
}
