<?php

namespace Modules\Leads\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Routing\Controller;
use Modules\Leads\Entities\LeadSource;
use Modules\Leads\Entities\LeadStatus;
use Modules\Leads\Http\Requests\LeadStatusRequest;

class LeadStatusController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Renderable
     */
    public function index()
    {
        $data['statuses'] = LeadStatus::getAll();
        $data['sources'] = LeadSource::getAll();

        return view('leads::settings.index', $data);
    }

    /**
     * Store a newly created resource in storage.
     *
     * @return Renderable
     */
    public function store(LeadStatusRequest $request)
    {
        if (LeadStatus::store($request->all())) {
            return redirect()->back()->with('sub_menu', 'status')->withSuccess(__('The :x has been successfully saved.', ['x' => __('Status')]));
        }

        return redirect()->back()->with('sub_menu', 'status')->withErrors(__('Something went wrong, please try again.'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data = LeadStatus::getAll()->where('id', $id)->first();

        return response()->json([
            'status' => 1,
            'records' =>  $data,
        ]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return Renderable
     */
    public function update(LeadStatusRequest $request, $id)
    {
        $response = LeadStatus::statusUpdate($request->except('_token', '_method'), $id);

        if ($response) {

            return redirect()->back()->with('sub_menu', 'status')->withSuccess(__('The :x has been successfully saved.', ['x' => __('Status')]));
        }

        return redirect()->back()->with('sub_menu', 'status')->withErrors(__('Something went wrong, please try again.'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $status = LeadStatus::remove($id);

        if ($status['status']) {
            return redirect()->back()->with('sub_menu', 'status')->withSuccess($status['msg']);
        }

        return redirect()->back()->with('sub_menu', 'rule')->withErrors($status['msg']);
    }
}
