<?php

namespace Modules\Leads\Http\Controllers;

use Illuminate\Contracts\Support\Renderable;
use Illuminate\Http\Request;
use Illuminate\Routing\Controller;
use Modules\Leads\DataTables\LeadsDataTable;
use Modules\Leads\Entities\{Lead, LeadSource, LeadStatus};

class LeadsController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return Renderable
     */
    public function index(LeadsDataTable $dataTable)
    {
        $data['sources'] = LeadSource::getAll()->where('status', 'active');
        $data['statuses'] = LeadStatus::getAll()->where('status', 'active');

        return $dataTable->render('leads::index', $data);
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return Renderable
     */
    public function create()
    {
        $data['sources'] = LeadSource::getAll()->where('status', 'active');
        $data['statuses'] = LeadStatus::getAll()->where('status', 'active');

        return view('leads::create', $data);
    }

    /**
     * @return Renderable
     */
    public function store(Request $request)
    {
        if (Lead::store($request->all())) {
            return redirect()->route('admin.leads.index')->withSuccess(__('The :x has been successfully saved.', ['x' => __('Lead')]));
        }

        return redirect()->route('admin.leads.index')->withErrors(__('Something went wrong, please try again.'));
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return Renderable
     */
    public function edit($id)
    {
        $data['lead'] = Lead::find($id);
        $data['sources'] = LeadSource::getAll()->where('status', 'active');
        $data['statuses'] = LeadStatus::getAll()->where('status', 'active');

        if (! empty($data['lead'])) {
            return view('leads::edit', $data);
        }

        return redirect()->back();

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  int  $id
     * @return Renderable
     */
    public function update(Request $request, $id)
    {
        $response = Lead::leadUpdate($request->except('_token', '_method'), $id);

        if ($response) {

            return redirect()->route('admin.leads.index')->withSuccess(__('The :x has been successfully saved.', ['x' => __('Lead')]));
        }

        return redirect()->back()->withErrors(__('Something went wrong, please try again.'));
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return Renderable
     */
    public function destroy($id)
    {
        $status = Lead::remove($id);

        if ($status['status']) {
            return redirect()->route('admin.leads.index')->withSuccess($status['msg']);
        }

        return redirect()->back()->withErrors($status['msg']);
    }
}
