<?php

namespace Modules\Leads\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class LeadSourceRequest extends FormRequest
{
    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        $id = collect(request()->segments())->last();

        if (is_numeric($id)) {
            return [
                'name' => 'required|unique:lead_sources,name,' . $id,
            ];
        } else {
            return [
                'name' => 'required|unique:lead_sources,name',
            ];
        }
    }

    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }
}
