"use strict";

$(document).on( 'init.dt', function () {
    $(".dataTables_length").remove();
    $('#statusDataTable').removeAttr('style');
    $('#statusDataTable_filter').remove();
    $('#sourceDataTable').removeAttr('style');
    $('#sourceDataTable_filter').remove();
});
var formId = 0;
var formType = '';
dataTable('#statusDataTable', [3]);
dataTable('#sourceDataTable', [2]);

$(document).on('click', '.tab-name', function () {
    let tabName = $(this).attr('data-id');
    let tabType = $(this).attr('data-type');
    $('#header_title').text(tabName);

    if (tabType == 'status') {
        $('#add_source').addClass('display-none');
        $('#add_status').removeClass('display-none');
    } else if (tabType == 'source') {
        $('#add_status').addClass('display-none');
        $('#add_source').removeClass('display-none');
    } else {
        $('#add_status').addClass('display-none');
        $('#add_source').addClass('display-none');
    }
});

function dataTable(tableSeclector, target)
{
    $(tableSeclector).DataTable({
        "columnDefs": [{
            "targets": target,
            "orderable": false
        }],
        "language": {
            "url": app_locale_url
        },
        "pageLength": parseInt(row_per_page),
        "order" :  [[ 0, 'asc' ]]
    });
}

$(document).on('click', '#add_status', function () {
    var action = $(this).attr("data-action");
    $('#status_form').attr('action', action);
    formReset();
    $('#status_method').val('post');
});

$(document).on('click', '#add_source', function () {
    var action = $(this).attr("data-action");
    $('#source_form').attr('action', action);
    formReset();
    $('#source_method').val('post');
});

function formReset()
{
    $('#status_form').trigger("reset");
    $('#source_form').trigger("reset");
}

$(document).on('click', '.edit_status', function () {
    var url = $(this).attr("data-url");
    var action = $(this).attr("data-action");
    $('#status_form').attr('action', action);
    var id = $(this).attr("id");
    formReset();
    $('#status_method').val('put');
    $.ajax({
        url: url,
        data: {
            id: id,
            "_token": token
        },
        type: 'get',
        dataType: 'JSON',
        success: function (data) {
            if (data.status == 1) {
                $('#lead_status_name').val(data.records.name);
                $('#lead_status_color').val(data.records.color);
                if (data.records.status == 'active') {
                    $('#lead_status_status').prop("checked", true);
                } else {
                    $('#lead_status_status').prop("checked", false);
                }
            }
        }
    });

});

$(document).on('click', '.edit_source', function () {
    var url = $(this).attr("data-url");
    var action = $(this).attr("data-action");
    $('#source_form').attr('action', action);
    var id = $(this).attr("id");
    formReset();
    $('#source_method').val('put');
    $.ajax({
        url: url,
        data: {
            id: id,
            "_token": token
        },
        type: 'get',
        dataType: 'JSON',
        success: function (data) {
            if (data.status == 1) {
                $('#lead_source_name').val(data.records.name);
                if (data.records.status == 'active') {
                    $('#lead_source_status').prop("checked", true);
                } else {
                    $('#lead_source_status').prop("checked", false);
                }
            }
        }
    });

});

$(document).on('click', '.delete_status', function () {
    formId = $(this).attr('data-id');
    formType = '';

});

$(document).on('click', '.delete_source', function () {
    formId = $(this).attr('data-id');
    formType = $(this).attr('data-type');
});

$('#confirmDeleteSubmitBtn').on('click', function() {
    if (formType == 'source') {
        $('#delete-source-'+formId).submit();
    } else {
        $('#delete-status-'+formId).submit();
    }
})
