@extends('admin.layouts.app')
@section('page_title', __('Create :x', ['x' => __('Lead')]))
@section('css')
    <!-- date range picker css -->
    <link rel="stylesheet" href="{{ asset('public/dist/plugins/bootstrap-daterangepicker/daterangepicker.min.css') }}">
    <!-- select2 css -->
    <link rel="stylesheet" href="{{ asset('public/datta-able/plugins/select2/css/select2.min.css') }}">
@endsection
@section('content')
    <!-- Main content -->
    <div class="col-sm-12" id="lead-add-container">
        <div class="card">
            <div class="card-header">
                <h5> <a href="{{ route('admin.leads.index') }}">{{ __('Leads') }} </a>
                    >>{{ __('Create :x', ['x' => __('Lead')]) }}</h5>
            </div>
            <div class="card-block table-border-style">
                <div class="row form-tabs">
                    <form action="{{ route('admin.leads.store') }}" method="post" class="form-horizontal col-sm-12" enctype="multipart/form-data">
                        @csrf
                        <ul class="nav nav-tabs" id="myTab" role="tablist">
                            <li class="nav-item">
                                <a class="nav-link active text-uppercase font-bold" id="home-tab" data-bs-toggle="tab" href="#home"
                                   role="tab" aria-controls="home"
                                   aria-selected="true">{{ __(':x Information', ['x' => __('Lead')]) }}</a>
                            </li>
                        </ul>
                        <div class="col-sm-12 tab-content form-edit-con" id="myTabContent">
                            <div class="tab-pane fade show active form-con" id="home" role="tabpanel"
                                 aria-labelledby="home-tab">
                                <div class="row">
                                    <div class="col-sm-9">
                                        <div class="form-group row">
                                            <label for="lead_status_id" class="control-label ltr:ps-3 rtl:pe-3">{{ __('Lead Status') }}</label>
                                            <div class="col-sm-12">
                                                <select class="form-control inputFieldDesign select2" name="lead_status_id" id="lead_status_id">
                                                    <option value="">{{ __('Select One') }}</option>
                                                    @foreach($statuses as $status)
                                                        <option value="{{ $status->id }}">{{ $status->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="lead_source_id" class="control-label ltr:ps-3 rtl:pe-3">{{ __('Lead Source') }}</label>
                                            <div class="col-sm-12">
                                                <select class="form-control select2 inputFieldDesign" name="lead_source_id" id="lead_source_id">
                                                        <option value="">{{ __('Select One') }}</option>
                                                    @foreach($sources as $source)
                                                        <option value="{{ $source->id }}">{{ $source->name }}</option>
                                                    @endforeach
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="user_id" class="control-label ltr:ps-3 rtl:pe-3">{{ __('Assigned') }}</label>
                                            <div class="col-sm-12">
                                                <select class="form-control select-user inputFieldDesign" name="user_id" id="user_id">
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="contact_date" class="control-label ltr:ps-3 rtl:pe-3">{{ __('Contact Date') }}
                                            </label>
                                            <div class="col-sm-12">
                                                <input type="text" placeholder="{{ __('Contact Date') }}" class="form-control form-width inputFieldDesign" id="contact_date" name="contact_date">
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="first_name" class="control-label ltr:ps-3 rtl:pe-3">{{ __('First Name') }}
                                            </label>
                                            <div class="col-sm-12">
                                                <input type="text" placeholder="{{ __('First Name') }}" class="form-control form-width inputFieldDesign" id="first_name" name="first_name">
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="last_name" class="control-label ltr:ps-3 rtl:pe-3">{{ __('Last Name') }}
                                            </label>
                                            <div class="col-sm-12">
                                                <input type="text" placeholder="{{ __('Last Name') }}" class="form-control form-width inputFieldDesign" id="last_name" name="last_name">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="email" class="control-label ltr:ps-3 rtl:pe-3">{{ __('Email') }}
                                            </label>
                                            <div class="col-sm-12">
                                                <input type="email" placeholder="{{ __('Email') }}" class="form-control form-width inputFieldDesign" id="email" name="email" data-type-mismatch="{{ __('Enter a valid :x.', ['x' => strtolower(__('Email'))]) }}">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="phone" class="control-label ltr:ps-3 rtl:pe-3">{{ __('Phone') }}
                                            </label>
                                            <div class="col-sm-12">
                                                <input type="text" placeholder="{{ __('Phone') }}" class="form-control form-width inputFieldDesign" id="phone" name="phone">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="website" class="control-label ltr:ps-3 rtl:pe-3">{{ __('Website') }}
                                            </label>
                                            <div class="col-sm-12">
                                                <input type="text" placeholder="{{ __('Website') }}" class="form-control form-width inputFieldDesign" id="website" name="website">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="company" class="control-label ltr:ps-3 rtl:pe-3">{{ __('Company') }}
                                            </label>
                                            <div class="col-sm-12">
                                                <input type="text" placeholder="{{ __('Company') }}" class="form-control form-width inputFieldDesign" id="company" name="company">
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="description" class="control-label ltr:ps-3 rtl:pe-3">{{ __('Description') }}
                                            </label>
                                            <div class="col-sm-12">
                                                <textarea class="form-control form-width inputFieldDesign" placeholder="{{ __('Description') }}" id="description" name="description"></textarea>
                                            </div>
                                        </div>
                                        <div class="form-group row">
                                            <label for="street" class="control-label ltr:ps-3 rtl:pe-3">{{ __('Street') }}
                                            </label>
                                            <div class="col-sm-12">
                                                <input type="text" placeholder="{{ __('Street') }}" class="form-control form-width inputFieldDesign" id="street" name="street">
                                            </div>
                                        </div>

                                        <div class="form-group row address-form">
                                            <label for="country_id" class="control-label ltr:ps-3 rtl:pe-3">{{ __('Country') }}</label>
                                            <div class="col-sm-12 validSelect" id="addressForm">
                                                <select class="form-control inputFieldDesign addressSelect" name="country" id="country">
                                                    <option value="">{{ __('Select One') }}</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="state_id" class="control-label ltr:ps-3 rtl:pe-3">{{ __('State') }}</label>
                                            <div class="col-sm-12 validSelect">
                                                <select class="form-control inputFieldDesign addressSelect" name="state" id="state">
                                                    <option value="">{{ __('Select One') }}</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="state_id" class="control-label ltr:ps-3 rtl:pe-3">{{ __('City') }}</label>
                                            <div class="col-sm-12 validSelect">
                                                <select class="form-control inputFieldDesign addressSelect" name="city" id="city">
                                                    <option value="">{{ __('Select One') }}</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="zip" class="control-label ltr:ps-3 rtl:pe-3">{{ __('Zip') }}</label>
                                            <div class="col-sm-12">
                                                <input type="text" placeholder="{{ __('Zip') }}" class="form-control form-width inputFieldDesign" id="zip" name="zip">
                                            </div>
                                        </div>

                                        <div class="form-group row">
                                            <label for="tags" class="control-label ltr:ps-3 rtl:pe-3">{{ __('Tags') }}</label>
                                            <div class="col-sm-12">
                                                <select class="form-control js-example-tokenizer inputFieldDesign" name="tags[]" multiple>
                                             
                                                </select>
                                            </div>
                                        </div>
                                        
                                    </div>
                                </div>
                            </div>

                            <div class="d-flex btn-align mt-3">
                                <a href="{{ route('admin.leads.index') }}"
                                   class="btn custom-btn-cancel all-cancel-btn">{{ __('Cancel') }}</a>
                                <button class="btn custom-btn-submit" type="submit" id="btnSubmit"><i
                                        class="comment_spinner spinner fa fa-spinner fa-spin custom-btn-small display_none"></i><span
                                        id="spinnerText">{{ __('Create') }}</span></button>
                            </div>
                        </div>
                        <!-- Modal -->
                    </form>
                </div>
            </div>
        </div>
    </div>
@endsection
@section('js')
    <script>
        'use strict';
        let oldCountry = "{!! old('country') ?? 'null' !!}";
        let oldState = "{!! old('state') ?? 'null' !!}";
        let oldCity = "{!! old('city') ?? 'null' !!}";
        var ADMIN_URL = SITE_URL;
        SITE_URL = "{{ route('site.index') }}";
    </script>
    <!-- select2 JS -->
    <script src="{{ asset('public/datta-able/plugins/select2/js/select2.full.min.js') }}"></script>
    <script src="{{ asset('public/dist/js/moment.min.js') }}"></script>
    <script src="{{ asset('public/dist/plugins/bootstrap-daterangepicker/daterangepicker.min.js') }}"></script>
    <script src="{{ asset('Modules/Leads/Resources/assets/js/lead.min.js') }}"></script>
    <script src="{{ asset('/public/dist/js/custom/site/address.min.js') }}"></script>
@endsection
