@extends('admin.layouts.app')
@section('page_title', __('Leads'))
@section('css')
@endsection
@section('content')
    <!-- Main content -->
    <div class="col-sm-12 list-container" id="order-list-container">
        <div class="card">
            <div class="card-header bb-none pb-0">
                <h5>{{ __('Leads') }}</h5>
                <x-backend.group-filters :groups="$groups" :column="'status'" />
                <div class="card-header-right my-2 mx-md-0 mx-sm-4">

                    <x-backend.button.batch-delete />
                    <x-backend.button.add-new href="{{ route('admin.leads.create') }}" />
                    <x-backend.button.filter />
                </div>
            </div>

            <x-backend.datatable.filter-panel>
                <div class="col-md-3">
                    <x-backend.datatable.input-search />
                </div>
               

                <div class="col-md-3">
                    <select class="select2 filter" name="lead_status_id" id="lead_status_id">
                        <option value="">{{ __('All :x', ['x' => __('Status')]) }}</option>
                        @foreach($statuses as $status)
                            <option value="{{ $status->id }}">{{ $status->name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-3">
                    <select class="select2 filter" name="lead_source_id" id="lead_source_id">
                        <option value="">{{ __('All :x', ['x' => __('Source')]) }}</option>
                        @foreach($sources as $source)
                            <option value="{{ $source->id }}">{{ $source->name }}</option>
                        @endforeach
                    </select>
                </div>

                <div class="col-md-3">
                    <select class="select2 filter select-user" name="user_id" id="user_id">
                        <option value="">{{ __('All :x', ['x' => __('Assigned')]) }}</option>
                    </select>
                </div>

            </x-backend.datatable.filter-panel>

            <x-backend.datatable.table-wrapper class="order-list-table need-batch-operation" data-namespace="\Modules\Leads\Entities\Lead" data-column="id">
                @include('admin.layouts.includes.yajra-data-table')
            </x-backend.datatable.table-wrapper>

            @include('admin.layouts.includes.delete-modal')
        </div>
    </div>
@endsection
@section('js')
    <script>
        'use strict';
        var ADMIN_URL = SITE_URL;
    </script>
    <script src="{{ asset('Modules/Leads/Resources/assets/js/lead.min.js') }}"></script>
@endsection
