@extends('admin.layouts.app')
@section('page_title', __('Leads Setting'))

@section('css')
    <link rel="stylesheet" href="{{ asset('public/dist/css/product.min.css') }}">
    <link rel="stylesheet" href="{{ asset('public/dist/plugins/Responsive-2.2.5/css/responsive.dataTables.min.css') }}">
@endsection

@section('content')
    <div class="col-sm-12">
        <div class="card admin-panel-product-setting" id="inventory-setting-container">
            <div class="card-body row">
                <div class="col-lg-3 col-12 z-index-10  ltr:ps-md-3 ltr:pe-0 ltr:ps-0 rtl:pe-md-3 rtl:ps-0 rtl:pe-0"
                     aria-labelledby="navbarDropdown">
                    <div class="card card-info shadow-none">
                        <div class="card-header p-t-20 border-bottom mb-2">
                            <h5>{{ __('Leads Settings') }}</h5>
                        </div>
                        <ul class="nav flex-column nav-pills" id="v-pills-tab" role="tablist" aria-orientation="vertical">

                            <li>
                                <a class="nav-link text-left tab-name {{ session()->has('sub_menu') && session('sub_menu') == 'status' || !session()->has('sub_menu') ? 'active' : '' }}" id="v-pills-lead-status-tab" data-bs-toggle="pill"
                                   href="#v-pills-lead-status" role="tab" aria-controls="v-pills-lead-status"
                                   aria-selected="true" data-type="status" data-id="{{ __('Lead Status') }}">{{ __('Lead Status') }}
                                </a>
                            </li>

                            <li>
                                <a class="nav-link text-left tab-name {{ session()->has('sub_menu') && session('sub_menu') == 'source' ? 'active' : '' }}" id="v-pills-lead-source-tab" data-bs-toggle="pill"
                                   href="#v-pills-lead-source" role="tab" aria-controls="v-pills-lead-source"
                                   aria-selected="true" data-type="source" data-id="{{ __('Lead Source') }}">{{ __('Lead Source') }}
                                </a>
                            </li>
                            
                        </ul>
                    </div>
                </div>
                <div class="col-lg-9 col-12 ltr:ps-0 rtl:pe-0">
                    <div class="card card-info shadow-none mb-0">
                        <div class="card-header p-t-20 border-bottom">
                            <h5 id="header_title">{{ __('Lead Status') }}</h5>

                            <div class="card-header-right">
                                <a href="javascript:void(0)"  id="add_status" data-bs-toggle="modal" data-bs-target="#status-modal" data-action="{{ route('admin.leads.status.store') }}"
                                   class="btn btn-outline-primary custom-btn-small {{ session()->has('sub_menu') && session('sub_menu') == 'status' || !session()->has('sub_menu') ? '' : 'display-none' }}"><span class="fa fa-plus">
                                            &nbsp;</span>{{ __('Add :x', ['x' => __('Status')]) }}</a>
                            </div>
                            
                            <div class="card-header-right">
                                <a href="javascript:void(0)" id="add_source" data-bs-toggle="modal" data-bs-target="#source-modal" data-action="{{ route('admin.leads.source.store') }}" class="btn btn-outline-primary custom-btn-small {{ session()->has('sub_menu') && session('sub_menu') == 'source' ? '' : 'display-none' }}" id="add_source">
                                    <span class="fa fa-plus">&nbsp;</span>
                                    {{ __('Add :x', ['x' => __('Source')]) }}
                                </a>
                            </div>
                            
                        </div>
                        <div class="tab-content shadow-none" id="topNav-v-pills-tabContent">

                            <div class="tab-pane fade parent {{ session()->has('sub_menu') && session('sub_menu') == 'status' || !session()->has('sub_menu') ? 'active show' : '' }}" id="v-pills-lead-status" role="tabpanel" aria-labelledby="v-pills-lead-status-tab">


                                <div class="col-lg-12 ltr:ps-1 ltr:ps-lg-0 rtl:pe-1 rtl:pe-lg-0">
                                    <div class="card-body shadow-none table-border-style p-0">
                                        <div class="row">
                                            <div class="table-responsive">
                                                <table class="table table-bordered table-hover table-main" id="statusDataTable">
                                                    <thead>
                                                    <tr>
                                                        <th class="align-middle">{{ __('Name') }}</th>
                                                        <th class="align-middle">{{ __('Color') }}</th>
                                                        <th class="align-middle">{{ __('Status') }}</th>
                                                        <th></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @foreach ($statuses as $status)
                                                        <tr>
                                                            <td class="align-middle">{{ $status->name }}</td>
                                                            <td class="align-middle">{{ $status->color }}</td>
                                                            <td class="align-middle">{!! statusBadges(ucfirst(($status->status))) !!}</td>
                                                            <td class="text-right align-middle">

                                                                <a title="{{ __('Edit') }}" href="javascript:void(0)"
                                                                   class="action-icon edit_status"
                                                                   data-bs-toggle="modal" data-bs-target="#status-modal"
                                                                   id="{{ $status->id }}" data-url="{{ route('admin.leads.status.edit', $status->id) }}" data-action="{{ route('admin.leads.status.update', $status->id) }}"><i class="feather icon-edit-1 neg-transition-scale-svg "></i>
                                                                </a>
                                                                &nbsp;
                                                                <form method="POST" action="{{ route('admin.leads.status.destroy', $status->id) }}" accept-charset="UTF-8" id="delete-status-{{ $status->id }}" class="display_inline">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <a title="{{ __('Delete') }}"
                                                                       class="action-icon delete_status"
                                                                       data-id="{{ $status->id }}" type="button"
                                                                       data-bs-toggle="modal"
                                                                       data-bs-target="#confirmDelete" data-label="Delete">
                                                                        <i class="feather icon-trash"></i>
                                                                    </a>
                                                                </form>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div id="status-modal" class="modal fade display_none" role="dialog">
                                    <div class="modal-dialog">

                                        <!-- Modal content-->
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title">{{ __('Lead Status') }} &nbsp; </h4>
                                                <a type="button" class="close h5" data-bs-dismiss="modal">×</a>
                                            </div>
                                            <form method="post" id="status_form" class="form-horizontal">
                                                @csrf
                                                <div class="modal-body">
                                                    <input type="hidden" name="_method" value="" id="status_method">
                                                    
                                                    <div class="form-group row">
                                                        <label class="col-sm-3 control-label require" for="inputEmail3">{{ __('Name') }}</label>

                                                        <div class="col-sm-9">
                                                            <input type="text" placeholder="{{ __('Name') }}" value="{{ old('name') }}" class="form-control name inputFieldDesign" name="name" id="lead_status_name" required oninvalid="this.setCustomValidity('{{ __('This field is required.') }}')">
                                                        </div>
                                                    </div>
                                                    
                                                    <div class="form-group row">
                                                        <label class="col-sm-3 control-label require" for="inputEmail3">{{ __('Color') }}</label>

                                                        <div class="col-sm-9">
                                                            <input type="color" value="{{ old('color') }}" class="form-control name inputFieldDesign positive-float-number" name="color" id="lead_status_color" required oninvalid="this.setCustomValidity('{{ __('This field is required.') }}')">
                                                        </div>
                                                    </div>

                                                    <div class="form-group row">
                                                        <label class="col-sm-3 control-label require pr-0" for="status">{{ __('Status') }}</label>
                                                        <div class="col-sm-9">
                                                            <input type="hidden" name="status" value="inactive">
                                                            <div class="switch d-inline m-r-10">
                                                                <input class="is_default" type="checkbox" name="status" value="active" id="lead_status_status" checked>
                                                                <label for="lead_status_status" class="cr"></label>
                                                            </div>
                                                        </div>
                                                    </div>
                                                    
                                                </div>
                                                <div class="modal-footer justify-content-between bg-light-gray">
                                                    <a href="javascript:void(0)" class="py-2 ltr:float-right ltr:me-2 rtl:float-left rtl:ms-2 text-c-red" data-bs-dismiss="modal">{{ __('Cancel') }}</a>
                                                    <button type="submit" class="btn py-2 custom-btn-submit ltr:float-right rtl:float-left">{{ __('Save') }}</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                


                            </div>

                            <div class="tab-pane fade parent {{ session()->has('sub_menu') && session('sub_menu') == 'source' ? 'active show' : '' }}" id="v-pills-lead-source" role="tabpanel" aria-labelledby="v-pills-lead-source-tab">

                                <div class="col-lg-12 ltr:ps-1 ltr:ps-lg-0 rtl:pe-1 rtl:pe-lg-0">
                                    <div class="card-body shadow-none table-border-style p-0">
                                        <div class="row">
                                            <div class="table-responsive">
                                                <table class="table table-bordered table-hover table-main" id="sourceDataTable">
                                                    <thead>
                                                    <tr>
                                                        <th class="align-middle">{{ __('Name') }}</th>
                                                        <th class="align-middle">{{ __('Status') }}</th>
                                                        <th></th>
                                                    </tr>
                                                    </thead>
                                                    <tbody>
                                                    @foreach ($sources as $source)
                                                        <tr>
                                                            <td class="align-middle">{{ $source->name }}</td>
                                                            <td class="align-middle">{!! statusBadges(ucfirst(($source->status))) !!}</td>
                                                            <td class="text-right align-middle">

                                                                <a title="{{ __('Edit') }}" href="javascript:void(0)"
                                                                   class="action-icon edit_source"
                                                                   data-bs-toggle="modal" data-bs-target="#source-modal"
                                                                   id="{{ $source->id }}" data-url="{{ route('admin.leads.source.edit', $source->id) }}" data-action="{{ route('admin.leads.source.update', $source->id) }}"><i class="feather icon-edit-1 neg-transition-scale-svg "></i>
                                                                </a>
                                                                &nbsp;
                                                                <form method="POST" action="{{ route('admin.leads.source.destroy', $source->id) }}" accept-charset="UTF-8" id="delete-source-{{ $source->id }}" class="display_inline">
                                                                    @csrf
                                                                    @method('DELETE')
                                                                    <a title="{{ __('Delete') }}"
                                                                       class="action-icon delete_source"
                                                                       data-id="{{ $source->id }}" type="button"
                                                                       data-bs-toggle="modal"
                                                                       data-type="source"
                                                                       data-bs-target="#confirmDelete" data-label="Delete">
                                                                        <i class="feather icon-trash"></i>
                                                                    </a>
                                                                </form>
                                                            </td>
                                                        </tr>
                                                    @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                        </div>
                                    </div>
                                </div>

                                <div id="source-modal" class="modal fade display_none" role="dialog">
                                    <div class="modal-dialog">

                                        <!-- Modal content-->
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h4 class="modal-title">{{ __('Lead Source') }} &nbsp; </h4>
                                                <a type="button" class="close h5" data-bs-dismiss="modal">×</a>
                                            </div>
                                            <form method="post" id="source_form" class="form-horizontal">
                                                @csrf
                                                <div class="modal-body">
                                                    <input type="hidden" name="_method" value="" id="source_method">

                                                    <div class="form-group row">
                                                        <label class="col-sm-3 control-label require" for="inputEmail3">{{ __('Name') }}</label>

                                                        <div class="col-sm-9">
                                                            <input type="text" placeholder="{{ __('Name') }}" value="{{ old('name') }}" class="form-control name inputFieldDesign" name="name" id="lead_source_name" required oninvalid="this.setCustomValidity('{{ __('This field is required.') }}')">
                                                        </div>
                                                    </div>

                                                    <div class="form-group row">
                                                        <label class="col-sm-3 control-label require pr-0" for="status">{{ __('Status') }}</label>
                                                        <div class="col-sm-9">
                                                            <input type="hidden" name="status" value="inactive">
                                                            <div class="switch d-inline m-r-10">
                                                                <input class="is_default" type="checkbox" name="status" value="active" id="lead_source_status" checked>
                                                                <label for="lead_source_status" class="cr"></label>
                                                            </div>
                                                        </div>
                                                    </div>

                                                </div>
                                                <div class="modal-footer justify-content-between bg-light-gray">
                                                    <a href="javascript:void(0)" class="py-2 ltr:float-right ltr:me-2 rtl:float-left rtl:ms-2 text-c-red" data-bs-dismiss="modal">{{ __('Cancel') }}</a>
                                                    <button type="submit" class="btn py-2 custom-btn-submit ltr:float-right rtl:float-left">{{ __('Save') }}</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                                
                            </div>

                        </div>
                    </div>
                </div>
            </div>
        </div>
        @include('admin.layouts.includes.delete-modal')
    </div>
@endsection
@section('js')
    <script src="{{ asset('public/dist/js/custom/validation.min.js') }}"></script>
    <script src="{{ asset('public/dist/plugins/DataTables-1.10.21/js/jquery.dataTablesCus.min.js') }}"></script>
    <script src="{{ asset('public/dist/plugins/Responsive-2.2.5/js/dataTables.responsive.min.js') }}"></script>
    <script src="{{ asset('Modules/Leads/Resources/assets/js/settings.min.js') }}"></script>
@endsection
