<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::group(['prefix' => 'admin/leads', 'as' => 'admin.', 'namespace' => 'Modules\Leads\Http\Controllers', 'middleware' => ['auth', 'locale', 'permission', 'web']], function () {

    Route::get('/', 'LeadsController@index')->name('leads.index');
    Route::get('/create', 'LeadsController@create')->name('leads.create');
    Route::post('/store', 'LeadsController@store')->name('leads.store');
    Route::get('/{lead}/edit', 'LeadsController@edit')->name('leads.edit');
    Route::put('/{lead}', 'LeadsController@update')->name('leads.update');
    Route::delete('/{lead}', 'LeadsController@destroy')->name('leads.destroy');

    Route::get('/settings', 'LeadStatusController@index')->name('leads.settings');
    Route::post('/status/store', 'LeadStatusController@store')->name('leads.status.store');
    Route::get('/status/{lead}/edit', 'LeadStatusController@edit')->name('leads.status.edit');
    Route::put('/status/{lead}', 'LeadStatusController@update')->name('leads.status.update');
    Route::delete('/status/{lead}', 'LeadStatusController@destroy')->name('leads.status.destroy');

    Route::post('/source/store', 'LeadSourceController@store')->name('leads.source.store');
    Route::get('/source/{lead}/edit', 'LeadSourceController@edit')->name('leads.source.edit');
    Route::put('/source/{lead}', 'LeadSourceController@update')->name('leads.source.update');
    Route::delete('/source/{lead}', 'LeadSourceController@destroy')->name('leads.source.destroy');

});
