<?php

return [
    'name' => 'PayMoney',

    'alias' => 'paymoney',

    'logo' => 'Modules/PayMoney/Resources/assets/paymoney.png',

    //PayMoney addon settings

    'options' => [
        ['label' => __('Settings'), 'type' => 'modal', 'url' => 'paymoney.edit'],
        ['label' => __('PayMoney Documentation'), 'target' => '_blank', 'url' => 'https://docs.paymoney.techvill.net/integration-of-express-merchant-api-in-other-websites/'],
    ],

    'validation' => [
        'rules' => [
            'client_id' => 'required',
            'client_secret' => 'required',
        ],
        'attributes' => [
            'client_id' => __('Client ID'),
            'client_secret' => __('Client Secret'),
        ],
    ],
    'fields' => [
        'client_id' => [
            'label' => __('Client ID'),
            'type' => 'text',
            'required' => true,
        ],
        'client_secret' => [
            'label' => __('Client Secret'),
            'type' => 'text',
            'required' => true,
        ],
        'instruction' => [
            'label' => __('Instruction'),
            'type' => 'textarea',
        ],
        'status' => [
            'label' => __('Status'),
            'type' => 'select',
            'required' => true,
            'options' => [
                'Active' => 1,
                'Inactive' =>  0,
            ],
        ],
    ],

    'store_route' => 'paymoney.store',

    'base_url' => 'https://demo.paymoney.techvill.net/',
];
