<?php

namespace Modules\PayMoney\Http\Controllers;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Modules\Addons\Entities\Addon;
use Modules\PayMoney\Entities\PayMoney;
use Modules\PayMoney\Entities\PayMoneyBody;
use Modules\PayMoney\Http\Requests\PayMoneyRequest;

class PayMoneyController extends Controller
{
    /**
     * Updates or creates a PayMoney credentials or configuration data
     *
     * @param PayMoneyRequest $request The request object containing the data to update or create a PayMoney record.
     *
     * @return \Illuminate\Http\RedirectResponse A redirect response with a success message.
    */
    public function store(PayMoneyRequest $request)
    {
        $payMoneyBody = new PayMoneyBody($request);

        PayMoney::updateOrCreate(
            ['alias' => moduleConfig('paymoney.alias')],
            [
                'name' => moduleConfig('paymoney.name'),
                'instruction' => $request->instruction,
                'status' => $request->status,
                'sandbox' => 0,
                'image' => 'thumbnail.png',
                'data' => json_encode($payMoneyBody),
            ]
        );

        return back()->with(['AddonStatus' => 'success', 'AddonMessage' => __('PayMoney settings updated.')]);
    }

    /**
     * Edit the PayMoney module.
     *
     * @param \Illuminate\Http\Request $request
     * @return \Illuminate\Http\JsonResponse
     *
     * @throws \Illuminate\Database\Eloquent\ModelNotFoundException
    */
    public function edit(Request $request)
    {
        try {
            $module = PayMoney::first()->data;
        } catch (\Exception $e) {
            $module = null;
        }

        $addon = Addon::findOrFail('paymoney');

        return response()->json(
            [
                'html' => view('gateway::partial.form', compact('module', 'addon'))->render(),
                'status' => true,
            ]
        );

    }
}
