<?php

/**
 * @author TechVillage <support@techvill.org>
 *
 * @contributor Md Shahnaouz Razu <[razu.techvill@gmail.com]>
 *
 * @created 15-2-22
 */

namespace Modules\PayMoney\Views;

use Modules\Gateway\Contracts\PaymentViewInterface;
use Modules\Gateway\Facades\GatewayHelper;
use Modules\PayMoney\Entities\PayMoney;

class PayMoneyView implements PaymentViewInterface
{
    public static function paymentView($key)
    {
        $helper = GatewayHelper::getInstance();

        try {
            $paymoney = PayMoney::firstWhere('alias', 'paymoney')->data;

            return view('paymoney::pay', [
                'instruction' => $paymoney->instruction,
                'purchaseData' => $helper->getPurchaseData($key),
            ]);
        } catch (\Exception $e) {
            return back()->withErrors(['error' => __('Purchase data not found.')]);
        }
    }
}
